/*
 * Created on 2004/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGSignificantDifferenceSymbol extends SGDrawingElement
	implements SGISignificantDifferenceSymbolConstants, SGIDrawingElementConstants
{



	/**
	 * 
	 */
	protected float mX;


	/**
	 * 
	 */
	protected float mY;


	/**
	 * 
	 */
	protected float mWidth;


	/**
	 * 
	 */
	protected float mPerpendicularHeight1;


	/**
	 * 
	 */
	protected float mPerpendicularHeight2;


	/**
	 * 
	 */
	protected float mSpace;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	protected boolean mLineVisibleFlag = true;

	
	
	/**
	 * @return mLineVisibleFlag
	 */
	public boolean isLineVisible()
	{
		return mLineVisibleFlag;
	}

	/**
	 * @param lineVisibleFlag mLineVisibleFlag ݒ肵܂B
	 */
	public void setLineVisible( final boolean b )
	{
		mLineVisibleFlag = b;
	}

	
	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol(
		final float x,
		final float y,
		final float w,
		final float hl,
		final float hr )
	{
		super();
		this.setLocation(x,y);
		this.setSize(w,hl,hr);
	}



	/**
	 * 
	 */
	public float getX()
	{
		return this.mX;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mY;
	}

	
	
	/**
	 * 
	 * @return
	 */
	public float getX1()
	{
		return this.getX();
	}
	
	
	/**
	 * 
	 * @return
	 */
	public float getX2()
	{
		return this.getX1() + this.getMagnification()*this.getWidth();
	}
	

	/**
	 * 
	 * @return
	 */
	public float getY1()
	{
		return this.getY() + this.getMagnification()*this.getPerpendicularHeight1();
	}
	

	
	/**
	 * 
	 * @return
	 */
	public float getY2()
	{
		return this.getY() + this.getMagnification()*this.getPerpendicularHeight2();
	}

	

	/**
	 * 
	 */
	public float getWidth()
	{
		return this.mWidth;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight1()
	{
		return this.mPerpendicularHeight1;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight2()
	{
		return this.mPerpendicularHeight2;
	}


	/**
	 * 
	 */
	public float getSpace()
	{
		return this.mSpace;
	}


	/**
	 * 
	 */
	public abstract SGDrawingElementString getStringElement();


	/**
	 * 
	 */
	public String getText()
	{
		return this.getStringElement().getString();
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.getStringElement().getFontSize();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.getStringElement().getFontStyle();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return this.getStringElement().getFontName();
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.getColor(0);
	}




	/**
	 * 
	 */
	public boolean setColor( final ArrayList colorList )
	{
		super.setColor( colorList );
		this.getStringElement().setColor( colorList );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		super.setColor( color );
		this.getStringElement().setColor( color );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		super.addColor( color );
		this.getStringElement().addColor( color );
		return true;
	}




	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}



	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setX( final float x )
	{
		this.mX = x;
		return true;
	}



	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean setY( final float y )
	{
		this.mY = y;
		return true;
	}



	/**
	 * 
	 */
	public boolean setSize( final float w, final float h1, final float h2 )
	{
		this.setWidth(w);
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		this.mWidth = w;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight1( final float h )
	{
		this.mPerpendicularHeight1 = h;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight2( final float h )
	{
		this.mPerpendicularHeight2 = h;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		this.mSpace = space;
		return true;
	}



	/**
	 * 
	 */
	public boolean setText( final String text )
	{
		if( text==null )
		{
			throw new IllegalArgumentException("text==null");
		}
		this.getStringElement().setString( text );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		if( lineWidth < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
		}
		this.mLineWidth = lineWidth;
		return true;
	}



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		if( size < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("size < Float.MIN_VALUE");
		}
		this.getStringElement().setFont( name, style, size );
		return true;
	}


	/**
	 * 
	 * @param name
	 */
	public void setFontName( final String name )
	{
		final int style = this.getFontStyle();
		final float size = this.getFontSize();
		this.setFont( name, style, size );
	}


	/**
	 * 
	 * @param style
	 */
	public void setFontStyle( final int style )
	{
		final String name = this.getFontName();
		final float size = this.getFontSize();
		this.setFont( name, style, size );
	}


	/**
	 * 
	 * @param size
	 */
	public void setFontSize( final float size )
	{
		final String name = this.getFontName();
		final int style = this.getFontStyle();
		this.setFont( name, style, size );
	}
	
	
	/**
	 * 
	 * @return
	 */
	public boolean isFlippingHorizontal()
	{
		return ( this.mWidth < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical()
	{
		return ( this.isFlippingVertical1() & this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical1()
	{
		return ( this.mPerpendicularHeight1 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical2()
	{
		return ( this.mPerpendicularHeight2 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalLeft()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalRight()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1() );
	}



	/**
	 * 
	 * @return
	 */
	public float getLeftHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight1();
		}
		else
		{
			return this.getPerpendicularHeight2();
		}
	}


	/**
	 * 
	 * @return
	 */
	public float getRightHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight2();
		}
		else
		{
			return this.getPerpendicularHeight1();
		}
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setLeftHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight1( h );
		}
		else
		{
			this.setPerpendicularHeight2( h );
		}
		return true;
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setRightHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight2( h );
		}
		else
		{
			this.setPerpendicularHeight1( h );
		}
		return true;
	}


	
	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setNodePointLocation(
		final float x1, final float y1, final float x2, final float y2, final float y )
	{
		final float mag = this.getMagnification();

		// x
		final float w = ( x2 - x1 )/mag;
		this.setX(x1);
		this.setWidth(w);

		// y
		this.setY(y);
		final float h1 = ( y1 - y )/mag;
		final float h2 = ( y2 - y )/mag;
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		
		return true;
	}
	


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SigDiffProperties p = new SigDiffProperties();

		if( this.getProperties(p) == false ) return null;

		return p;
	}



	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;
		
		sp.mSpace = this.mSpace;
		sp.mLineVisible = this.mLineVisibleFlag;
		sp.mLineWidth = this.mLineWidth;
		sp.mText = this.getText();
		sp.mFontName = this.getFontName();
		sp.mFontSize = this.getFontSize();
		sp.mFontStyle = this.getFontStyle();
		
		return true;
	}
	
	

	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;
		
		if( super.setProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;

		this.mSpace = sp.mSpace;
		this.setText( sp.mText );
		this.setFont( sp.mFontName, sp.mFontStyle, sp.mFontSize );
		this.setLineVisible( sp.mLineVisible );
		this.setLineWidth( sp.mLineWidth );

		return true;
	}



	/**
	 * 
	 */
	public static class SigDiffProperties extends SGDrawingElement.DrawingElementProperties
	{
		private float mSpace;
		private float mLineWidth;
		private String mText;
		private String mFontName;
		private float mFontSize;
		private int mFontStyle;
		private boolean mLineVisible;

		public SigDiffProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffProperties ) == false ) return false;

			if( super.equals(obj) == false ) return false;

			SigDiffProperties p = (SigDiffProperties)obj;

			if( p.mSpace != this.mSpace ) return false;
			if( p.mLineWidth != this.mLineWidth ) return false;
			if( p.mText.equals(this.mText) == false ) return false;
			if( p.mFontName.equals(this.mFontName) == false ) return false;
			if( p.mFontSize != this.mFontSize ) return false;
			if( p.mFontStyle != this.mFontStyle ) return false;
			if( p.mLineVisible != this.mLineVisible ) return false;

			return true;
		}


		public Float getSpace()
		{
			return new Float( this.mSpace );
		}

		public Float getLineWidth()
		{
			return new Float( this.mLineWidth );
		}
		
		public String getText()
		{
			return this.mText;
		}
		
		public String getFontName()
		{
			return this.mFontName;
		}
		
		public Float getFontSize()
		{
			return new Float( this.mFontSize );
		}
		
		public Integer getFontStyle()
		{
			return new Integer( this.mFontStyle );
		}
		
		public Boolean getLineVisible()
		{
			return Boolean.valueOf( this.mLineVisible );
		}


		public void setSpace( final float value )
		{
			this.mSpace = value;
		}
		
		public void setLineWidth( final float value )
		{
			if( value<0.0f )
			{
				throw new IllegalArgumentException("value<0.0f");
			}
			this.mLineWidth = value;
		}
		
		public void setText( final String str )
		{
			if( str==null )
			{
				throw new IllegalArgumentException("str==null");
			}
			this.mText = str;
		}
		
		public void setFontName( final String str )
		{
			if( str==null )
			{
				throw new IllegalArgumentException("str==null");
			}
			this.mFontName = str;
		}

		public void setFontSize( final float value )
		{
			if( value<0.0f )
			{
				throw new IllegalArgumentException("value<0.0f");
			}
			this.mFontSize = value;
		}
		
		public void setFontStyle( final int style )
		{
			this.mFontStyle = style;
		}

		public void setLineVisible( final boolean b )
		{
			this.mLineVisible = b;
		}
	}



}

