/*
 * SGAxisPanel.java
 *
 * Created on 2004/06/09, 15:05
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;


/**
 *
 * @author  kuromaru
 */
public class SGAxisPanel extends SGPropertyPanel
	implements ActionListener, SGIDisposable
{

	public static final String MSG_RANGE_ERROR
		= "Axis range is invalid.";

	public static final String MSG_STEP_ERROR
		= "Zero value is set to the step value.";


	// configuration of this axis panel
	private String mConfiguration;


    /** Creates new form SGAxisPanel */
    public SGAxisPanel( String configuration )
    {
    	this.mConfiguration = configuration;
        initComponents();
        this.initProerty();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mScalePanel = new javax.swing.JPanel();
        mTickMarkLabel = new javax.swing.JLabel();
        mAutoTickMarkCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mLinearRadioButton = new javax.swing.JRadioButton();
        mTickMarkVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mTickMarkSeparator = new javax.swing.JSeparator();
        mLogRadioButton = new javax.swing.JRadioButton();
        mMinLabel = new javax.swing.JLabel();
        mMaxLabel = new javax.swing.JLabel();
        mMinValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mMaxValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mBaseLabel = new javax.swing.JLabel();
        mBaseTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mStepTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mStepLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mOuterRadioButton = new javax.swing.JRadioButton();
        mInnerRadioButton = new javax.swing.JRadioButton();
        mExponentLabel = new javax.swing.JLabel();
        mIntegerCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mExponentCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFormatVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFormatLabel = new javax.swing.JLabel();
        mFormatSeparator = new javax.swing.JSeparator();
        mExponentSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTitlePanel = new javax.swing.JPanel();
        mTitleVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mTitleTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mTitleLabel = new javax.swing.JLabel();
        mTitleLeftSpaceLabel = new javax.swing.JLabel();
        mTitleRightSpaceLabel = new javax.swing.JLabel();
        mAxisVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();

        setLayout(new java.awt.GridBagLayout());

        mScalePanel.setLayout(new java.awt.GridBagLayout());

        mScalePanel.setBorder(new javax.swing.border.TitledBorder(null, "Scale", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mScalePanel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mTickMarkLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mTickMarkLabel.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mTickMarkLabel, gridBagConstraints);

        mAutoTickMarkCheckBox.setText("Auto");
        mAutoTickMarkCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 5);
        mScalePanel.add(mAutoTickMarkCheckBox, gridBagConstraints);

        mLinearRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mLinearRadioButton.setText("Linear");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mScalePanel.add(mLinearRadioButton, gridBagConstraints);

        mTickMarkVisibleCheckBox.setText("Visible");
        mTickMarkVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mScalePanel.add(mTickMarkVisibleCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 5);
        mScalePanel.add(mTickMarkSeparator, gridBagConstraints);

        mLogRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mLogRadioButton.setText("Log");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mLogRadioButton, gridBagConstraints);

        mMinLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMinLabel.setText("Min");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mMinLabel, gridBagConstraints);

        mMaxLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMaxLabel.setText("Max");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mMaxLabel, gridBagConstraints);

        mMinValueTextField.setColumns(6);
        mMinValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mMinValueTextField, gridBagConstraints);

        mMaxValueTextField.setColumns(6);
        mMaxValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mMaxValueTextField, gridBagConstraints);

        mBaseLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseLabel.setText("Base");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 5, 5);
        mScalePanel.add(mBaseLabel, gridBagConstraints);

        mBaseTextField.setColumns(6);
        mBaseTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mBaseTextField, gridBagConstraints);

        mStepTextField.setColumns(6);
        mStepTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mStepTextField, gridBagConstraints);

        mStepLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStepLabel.setText("Step");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 5, 5);
        mScalePanel.add(mStepLabel, gridBagConstraints);

        mLeftSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mScalePanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mRightSpaceLabel, gridBagConstraints);

        mOuterRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mOuterRadioButton.setText("Outer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mOuterRadioButton, gridBagConstraints);

        mInnerRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerRadioButton.setText("Inner");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 5, 5);
        mScalePanel.add(mInnerRadioButton, gridBagConstraints);

        mExponentLabel.setFont(new java.awt.Font("Dialog", 1, 14));
        mExponentLabel.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        mScalePanel.add(mExponentLabel, gridBagConstraints);

        mIntegerCheckBox.setText("Integer");
        mIntegerCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mIntegerCheckBox, gridBagConstraints);

        mExponentCheckBox.setText("Exp Part");
        mExponentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mExponentCheckBox, gridBagConstraints);

        mFormatVisibleCheckBox.setText("Visible");
        mFormatVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mFormatVisibleCheckBox, gridBagConstraints);

        mFormatLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormatLabel.setText("Format ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mFormatLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mScalePanel.add(mFormatSeparator, gridBagConstraints);

        mExponentSpinner.setFont(new java.awt.Font("Dialog", 0, 10));
        mExponentSpinner.setPreferredSize(new java.awt.Dimension(40, 20));
        mExponentSpinner.setValue(new Integer(0));
        mExponentSpinner.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mScalePanel.add(mExponentSpinner, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mScalePanel, gridBagConstraints);

        mTitlePanel.setLayout(new java.awt.GridBagLayout());

        mTitlePanel.setBorder(new javax.swing.border.TitledBorder(null, "Title", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mTitlePanel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mTitleVisibleCheckBox.setText("Visible");
        mTitleVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTitlePanel.add(mTitleVisibleCheckBox, gridBagConstraints);

        mTitleTextField.setColumns(8);
        mTitleTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTitlePanel.add(mTitleTextField, gridBagConstraints);

        mTitleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTitleLabel.setText("Label");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTitlePanel.add(mTitleLabel, gridBagConstraints);

        mTitleLeftSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mTitleLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mTitlePanel.add(mTitleLeftSpaceLabel, gridBagConstraints);

        mTitleRightSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mTitleRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        mTitlePanel.add(mTitleRightSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mTitlePanel, gridBagConstraints);

        mAxisVisibleCheckBox.setText("Visible Axis");
        mAxisVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        add(mAxisVisibleCheckBox, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mAutoTickMarkCheckBox;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mAxisVisibleCheckBox;
    private javax.swing.JLabel mBaseLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mBaseTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mExponentCheckBox;
    private javax.swing.JLabel mExponentLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mExponentSpinner;
    private javax.swing.JLabel mFormatLabel;
    private javax.swing.JSeparator mFormatSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mFormatVisibleCheckBox;
    private javax.swing.JRadioButton mInnerRadioButton;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mIntegerCheckBox;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLinearRadioButton;
    private javax.swing.JRadioButton mLogRadioButton;
    private javax.swing.JLabel mMaxLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mMaxValueTextField;
    private javax.swing.JLabel mMinLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mMinValueTextField;
    private javax.swing.JRadioButton mOuterRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JPanel mScalePanel;
    private javax.swing.JLabel mStepLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStepTextField;
    private javax.swing.JLabel mTickMarkLabel;
    private javax.swing.JSeparator mTickMarkSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mTickMarkVisibleCheckBox;
    private javax.swing.JLabel mTitleLabel;
    private javax.swing.JLabel mTitleLeftSpaceLabel;
    private javax.swing.JPanel mTitlePanel;
    private javax.swing.JLabel mTitleRightSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTitleTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mTitleVisibleCheckBox;
    // ϐ錾̏I//GEN-END:variables


	private JRadioButton mScaleNoSelectedRadioButton = new JRadioButton();
	private JRadioButton mDirectionNoSelectedRadioButton = new JRadioButton();

	private SGComponentGroup mTitleComponentGroup = new SGComponentGroup();
	private SGComponentGroup mTickMarkComponentGroup = new SGComponentGroup();
	private SGComponentGroup mScaleTypeComponentGroup = new SGComponentGroup();
	private SGComponentGroup mExponentComponentGroup = new SGComponentGroup();
	private SGComponentGroup mFormatComponentGroup = new SGComponentGroup();
	private SGComponentGroup mAxisVisibleComponentGroup = new SGComponentGroup();


	/**
	 * 
	 */
	public void dispose()
	{
		this.mConfiguration = null;

		this.mScaleNoSelectedRadioButton = null;
		this.mDirectionNoSelectedRadioButton = null;

		this.mTitleComponentGroup.dispose();
		this.mTitleComponentGroup = null;
		this.mTickMarkComponentGroup.dispose();
		this.mTickMarkComponentGroup = null;
		this.mScaleTypeComponentGroup.dispose();
		this.mScaleTypeComponentGroup = null;
		this.mExponentComponentGroup.dispose();
		this.mExponentComponentGroup = null;
		this.mFormatComponentGroup.dispose();
		this.mFormatComponentGroup = null;
		this.mAxisVisibleComponentGroup.dispose();
		this.mAxisVisibleComponentGroup = null;
	}


	/**
	 * 
	 */
	public String getConfiguration()
	{
		return this.mConfiguration;
	}


	/**
	 * 
	 */
	public void setConfiguration( final String str )
	{
		if( str==null )
		{
			throw new IllegalArgumentException("str==null");
		}
		this.mConfiguration = str;
	}


   	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		ArrayList list = new ArrayList();
		list.addAll( this.getNumberTextFieldList() );
		list.add( this.mTitleTextField );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mMinValueTextField );
		list.add( this.mMaxValueTextField );
		list.add( this.mBaseTextField );
		list.add( this.mStepTextField );
		return list;
	}


	/**
	 * 
	 */
	private boolean initProerty()
	{

		// create button groups
		{
			ButtonGroup group = new ButtonGroup();
			group.add( this.mLinearRadioButton );
			group.add( this.mLogRadioButton );
			group.add( this.mScaleNoSelectedRadioButton );
		}
		{
			ButtonGroup group = new ButtonGroup();
			group.add( this.mInnerRadioButton );
			group.add( this.mOuterRadioButton );
			group.add( this.mDirectionNoSelectedRadioButton );
		}


		// add an action listener
		this.mAxisVisibleCheckBox.addActionListener(this);
		this.mTitleVisibleCheckBox.addActionListener(this);
		this.mFormatVisibleCheckBox.addActionListener(this);
		this.mTickMarkVisibleCheckBox.addActionListener(this);
		this.mAutoTickMarkCheckBox.addActionListener(this);
		this.mExponentCheckBox.addActionListener(this);
		this.mLinearRadioButton.addActionListener(this);
		this.mLogRadioButton.addActionListener(this);


		// exponent
		this.mExponentSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -10.0, 10.0, 1.0 ),
			null, 0, 0 );


		// set the name
		String config = this.mConfiguration + "-> ";
		this.mTitleTextField.setDescription( config + "Title-> Label");
		this.mMinValueTextField.setDescription( config + "Scale-> Min");
		this.mMaxValueTextField.setDescription( config + "Scale-> Max");
		this.mStepTextField.setDescription( config + "Tick Mark-> Step");
		this.mBaseTextField.setDescription( config + "Tick Mark-> Base");
		this.mExponentSpinner.setDescription( config + "Format-> Exp Part");


		SGComponentGroupElement[] titleComponents = {
			new SGComponentGroupElement( this.mTitleLabel ),
			new SGComponentGroupElement( this.mTitleTextField )
		};

		SGComponentGroupElement[] scaleLineComponents = {
			new SGComponentGroupElement( this.mInnerRadioButton ),
			new SGComponentGroupElement( this.mOuterRadioButton )
		};

		SGComponentGroupElement[] exponentComponents = {
			new SGComponentGroupElement( this.mExponentLabel ),
			new SGComponentGroupElement( this.mExponentSpinner )
		};

		SGComponentGroupElement[] formatComponents = {
			exponentComponents[0],
			exponentComponents[1],
			new SGComponentGroupElement( this.mIntegerCheckBox ),
			new SGComponentGroupElement( this.mExponentCheckBox )
		};

		SGComponentGroupElement[] scaleTypeComponents = {
			new SGComponentGroupElement( this.mAutoTickMarkCheckBox ),
			new SGComponentGroupElement( this.mStepLabel ),
			new SGComponentGroupElement( this.mStepTextField ),
			new SGComponentGroupElement( this.mBaseLabel ),
			new SGComponentGroupElement( this.mBaseTextField ),
			formatComponents[2]
		};


		SGComponentGroupElement[] axisVisibleComponents = {
			
			// title
			new SGComponentGroupElement( this.mTitleVisibleCheckBox ),
			titleComponents[0],
			titleComponents[1],

			// scale
			new SGComponentGroupElement( this.mMinLabel ),
			new SGComponentGroupElement( this.mMinValueTextField ),
			new SGComponentGroupElement( this.mMaxLabel ),
			new SGComponentGroupElement( this.mMaxValueTextField ),
			new SGComponentGroupElement( this.mLinearRadioButton ),
			new SGComponentGroupElement( this.mLogRadioButton ),

			// tick mark
			new SGComponentGroupElement( this.mTickMarkLabel ),
			scaleTypeComponents[0],
			scaleTypeComponents[1],
			scaleTypeComponents[2],
			scaleTypeComponents[3],
			scaleTypeComponents[4],

			new SGComponentGroupElement( this.mTickMarkVisibleCheckBox ),
			scaleLineComponents[0],
			scaleLineComponents[1],

			// format
			new SGComponentGroupElement( this.mFormatLabel ),
			new SGComponentGroupElement( this.mFormatVisibleCheckBox ),
			formatComponents[0],
			formatComponents[1],
			formatComponents[2],
			formatComponents[3]
		};
		

		this.mTitleComponentGroup.addElement( titleComponents );
		this.mTickMarkComponentGroup.addElement( scaleLineComponents );
		this.mScaleTypeComponentGroup.addElement( scaleTypeComponents );
		this.mExponentComponentGroup.addElement( exponentComponents );
		this.mFormatComponentGroup.addElement( formatComponents );
		this.mAxisVisibleComponentGroup.addElement( axisVisibleComponents );

		
		return true;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		String command = e.getActionCommand();
		Object source = e.getSource();

		if( source.equals( this.mAxisVisibleCheckBox ) )
		{
			this.setAxisVisible( this.mAxisVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mTitleVisibleCheckBox ) )
		{
			this.setTitleVisible( this.mTitleVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mFormatVisibleCheckBox ) )
		{
			this.setFormatVisible( this.mFormatVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mTickMarkVisibleCheckBox ) )
		{
			this.setTickMarkVisible( this.mTickMarkVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mLinearRadioButton ) | source.equals( this.mLogRadioButton ) )
		{
			final boolean b = ( this.getScaleType().intValue() == SGAxis.LINEAR_TYPE );
			this.mScaleTypeComponentGroup.setEnabled(b);
		}
		else if( source.equals( this.mAutoTickMarkCheckBox ) )
		{
			final boolean flag = this.mAutoTickMarkCheckBox.isSelected();
			this.mStepTextField.setEditable(!flag);
			this.mBaseTextField.setEditable(!flag);
		}
		else if( source.equals( this.mExponentCheckBox ) )
		{
			this.setExponentVisible( this.mExponentCheckBox.getSelected() );
		}

	}



	/**
	 * 
	 */
	private boolean setTitleComponentsEnabled( final Boolean visible )
	{
		boolean flag = true;
		if( visible!=null )
		{
			flag = visible.booleanValue();
		}
		
		this.mTitleComponentGroup.setEnabled(flag);
		return true;
	}



	/**
	 * 
	 * @param visible
	 * @return
	 */
	private boolean setExponentComponentEnabled( final Boolean visible )
	{
		boolean flag = true;
		if( visible!=null )
		{
			flag = visible.booleanValue();
		}
		
		this.mExponentComponentGroup.setEnabled(flag);
		return true;
	}



	/**
	 * 
	 * @param visible
	 * @return
	 */
	private boolean setScaleLineComponentsEnabled( final Boolean visible )
	{
		boolean flag = true;
		if( visible!=null )
		{
			flag = visible.booleanValue();
		}
		
		this.mTickMarkComponentGroup.setEnabled(flag);
		return true;
	}



	/**
	 * 
	 */
	public Integer getScaleType()
	{
		Integer type = null;
		if( this.mLinearRadioButton.isSelected() )
		{
			type = new Integer( SGAxis.LINEAR_TYPE );
		}
		else if( this.mLogRadioButton.isSelected() )
		{
			type = new Integer( SGAxis.LOG_TYPE );
		}

		return type;
	}



	/**
	 * 
	 */
	public Number getMinValue()
	{
		final String str = this.mMinValueTextField.getText();
		if( str.length()==0 )
		{
			return null;
		}

		return SGUtilityText.getDouble(str);
	}


	/**
	 * 
	 */
	public Number getMaxValue()
	{
		final String str = this.mMaxValueTextField.getText();
		if( str.length()==0 )
		{
			return null;
		}

		return SGUtilityText.getDouble(str);
	}


	/**
	 * 
	 */
	public Boolean getAutoCalcFlag()
	{
		return this.mAutoTickMarkCheckBox.getSelected();
	}



	/**
	 * 
	 */
	public Number getStepValue()
	{
		String str = this.mStepTextField.getText();
		return SGUtilityText.getDouble( str );
	}


	/**
	 * 
	 */
	public Number getBaseValue()
	{
		String str = this.mBaseTextField.getText();
		return SGUtilityText.getDouble( str );
	}


	/**
	 * 
	 */
	public String getTitleString()
	{
		return this.mTitleTextField.getText();
	}


	/**
	 * 
	 */
	public Boolean isAxisVisible()
	{
		return this.mAxisVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Boolean isTitleVisible()
	{
		return this.mTitleVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Boolean isFormatVisible()
	{
		return this.mFormatVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Boolean isTickMarkVisible()
	{
		return this.mTickMarkVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Boolean getScaleLineDirection()
	{
		Boolean b = null;
		if( this.mInnerRadioButton.isSelected() )
		{
			b = Boolean.TRUE;
		}
		else if( this.mOuterRadioButton.isSelected() )
		{
			b = Boolean.FALSE;
		}
		return b;
	}


	/**
	 * 
	 */
	public Boolean isFormatInteger()
	{
		return this.mIntegerCheckBox.getSelected();
	}



	/**
	 * 
	 */
	public Boolean isExponentVisible()
	{
		return this.mExponentCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Number getExponentValue()
	{
		return this.mExponentSpinner.getNumber();
	}



	/**
	 * 
	 */
	public boolean setTitle( final String str )
	{
		if( str==null )
		{
			this.mTitleTextField.setText("");
			return true;
		}
		this.mTitleTextField.setText( str );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleType( final Integer value )
	{
		if( value==null )
		{
			this.mScaleNoSelectedRadioButton.setSelected( true );
		}
		else
		{
			final int type = value.intValue();
			switch( type )
			{
				case SGAxis.LINEAR_TYPE :
				{
					this.mLinearRadioButton.setSelected(true);
					break;
				}

				case SGAxis.LOG_TYPE :
				{
					this.mLogRadioButton.setSelected(true);
					break;
				}
	
				default :
				{
					throw new IllegalArgumentException("The scale type is illegal.");
				}
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setAxisVisible( final Boolean b )
	{
		this.mAxisVisibleCheckBox.setSelected(b);
		boolean flag = true;
		if( b!=null )
		{
			flag = b.booleanValue();
		}
		
		this.mAxisVisibleComponentGroup.setEnabled(flag);
		return true;
	}



	/**
	 * 
	 */
	public boolean setTitleVisible( final Boolean b )
	{
		this.mTitleVisibleCheckBox.setSelected(b);
		boolean flag = true;
		if( b!=null )
		{
			flag = b.booleanValue();
		}
		this.mTitleComponentGroup.setEnabled( flag );
		
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickMarkVisible( final Boolean visible )
	{
		this.mTickMarkVisibleCheckBox.setSelected(visible);
		boolean flag = true;
		if( visible!=null )
		{
			flag = visible.booleanValue();
		}
		this.mTickMarkComponentGroup.setEnabled(flag);
		return true;
	}


	/**
	 * 
	 */
	public boolean setTickMarkInside( final Boolean value )
	{
		if( value==null )
		{
			this.mDirectionNoSelectedRadioButton.setSelected(true);
		}
		else
		{
			final boolean flag = value.booleanValue();
			if( flag )
			{
				this.mInnerRadioButton.setSelected(true);
			}
			else
			{
				this.mOuterRadioButton.setSelected(true);
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setFormatVisible( final Boolean visible )
	{
		this.mFormatVisibleCheckBox.setSelected(visible);
		boolean flag = true;
		if( visible!=null )
		{
			flag = visible.booleanValue();
		}

		this.mFormatComponentGroup.setEnabled(flag);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFormatInteger( final Boolean b )
	{
		this.mIntegerCheckBox.setSelected(b);
		return true;
	}


	/**
	 * 
	 */
	public boolean setMinValue( final Object value )
	{
		return SGUtility.setValue(this.mMinValueTextField,value);
	}


	/**
	 * 
	 */
	public boolean setMaxValue( final Object value )
	{
		return SGUtility.setValue(this.mMaxValueTextField,value);
	}


	/**
	 * 
	 */
	public boolean setAutoCalcFlag( final Boolean b )
	{
		this.mAutoTickMarkCheckBox.setSelected(b);
		boolean flag = true;
		if( b!=null )
		{
			flag = b.booleanValue();
		}

		this.mBaseTextField.setEditable(!flag);
		this.mStepTextField.setEditable(!flag);
		return true;
	}


	/**
	 * 
	 */
	public boolean setBaseValue( final Object value )
	{
		return SGUtility.setValue( this.mBaseTextField, value );
	}


	/**
	 * 
	 */
	public boolean setStepValue( final Object value )
	{
		return SGUtility.setValue( this.mStepTextField, value );
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setExponentVisible( final Boolean b )
	{
		this.mExponentCheckBox.setSelected(b);
		boolean flag = true;
		if( b!=null )
		{
			flag = b.booleanValue();
		}

		this.mExponentComponentGroup.setEnabled(flag);
		return true;
	}



	/**
	 * 
	 * @param value
	 * @return
	 */
	public boolean setExponentValue( final Object value )
	{
		return SGUtility.setIntValue( this.mExponentSpinner, value );
	}



	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mExponentSpinner );
		return list;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setComponentsProperty( ArrayList list )
	{

		SGIAxisPanelObserver axis0
			= (SGIAxisPanelObserver)list.get(0);

		final boolean axisVisible0 = axis0.isAxisVisible();
		final boolean titleVisible0 = axis0.isTitleVisible();
		final String title0 = axis0.getTitleString();
		final double min0 = axis0.getMinValue();
		final double max0 = axis0.getMaxValue();
		final int scaleType0 = axis0.getScaleType();
		final boolean autoCalc0 = axis0.isCalculateAutomatically();
		final double stepValue0 = axis0.getStepValue();
		final double baselineValue0 = axis0.getBaselineValue();
		final boolean tickMarkVisible0 = axis0.isTickMarksVisible();
		final boolean tickMarkInside0 = axis0.isTickMarksInside();
		final boolean numberVisible0 = axis0.isNumbersVisible();
		final boolean numberInteger0 = axis0.isNumbersInteger();
		final boolean exponentVisible0 = axis0.getExponentFlag();
		final int exponent0 = axis0.getExponentValue();


		Boolean axisVisible = Boolean.valueOf( axisVisible0 );
		Boolean titleVisible = Boolean.valueOf( titleVisible0 );
		String title = title0;
		Double min = new Double( min0 );
		Double max = new Double( max0 );
		Integer scaleType = new Integer( scaleType0 );
		Boolean autoCalc = Boolean.valueOf( autoCalc0 );
		Double stepValue = new Double( stepValue0 );
		Double baselineValue = new Double( baselineValue0 );
		Boolean tickMarkVisible = Boolean.valueOf( tickMarkVisible0 );
		Boolean tickMarkInside = Boolean.valueOf( tickMarkInside0 );
		Boolean numberVisible = Boolean.valueOf( numberVisible0 );
		Boolean numberInteger = Boolean.valueOf( numberInteger0 );
		Boolean exponentVisible = Boolean.valueOf( exponentVisible0 );
		Integer exponent = new Integer( exponent0 );


		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean axisVisible1 = axis1.isAxisVisible();
				if( axisVisible0!=axisVisible1 )
				{
					axisVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean titleVisible1 = axis1.isTitleVisible();
				if( titleVisible0!=titleVisible1 )
				{
					titleVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final String title1 = axis1.getTitleString();
				if( title0.equals(title1) == false )
				{
					title = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final double min1 = axis1.getMinValue();
				if( min0!=min1 )
				{
					min = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final double max1 = axis1.getMaxValue();
				if( max0!=max1 )
				{
					max = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final int scaleType1 = axis1.getScaleType();
				if( scaleType0!=scaleType1 )
				{
					scaleType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean autoCalc1 = axis1.isCalculateAutomatically();
				if( autoCalc0!=autoCalc1 )
				{
					autoCalc = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final double stepValue1 = axis1.getStepValue();
				if( stepValue0!=stepValue1 )
				{
					stepValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final double baselineValue1 = axis1.getBaselineValue();
				if( baselineValue0!=baselineValue1 )
				{
					baselineValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean tickMarkVisible1 = axis1.isTickMarksVisible();
				if( tickMarkVisible0!=tickMarkVisible1 )
				{
					tickMarkVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean tickMarkInside1 = axis1.isTickMarksInside();
				if( tickMarkInside0!=tickMarkInside1 )
				{
					tickMarkInside = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean numberVisible1 = axis1.isNumbersVisible();
				if( numberVisible0!=numberVisible1 )
				{
					numberVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean numberInteger1 = axis1.isNumbersInteger();
				if( numberInteger0!=numberInteger1 )
				{
					numberInteger = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final boolean exponentVisible1 = axis1.getExponentFlag();
				if( exponentVisible0!=exponentVisible1 )
				{
					exponentVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisPanelObserver axis1
					= (SGIAxisPanelObserver)list.get(ii);
				final int exponent1 = axis1.getExponentValue();
				if( exponent0!=exponent1 )
				{
					exponent = null;
					break;
				}
			}

		}


		// set parameters to dialog
		this.setTitleVisible( titleVisible );
		this.setTitle( title );
		this.setMinValue( min );
		this.setMaxValue( max );
		this.setScaleType( scaleType );
		this.setAutoCalcFlag( autoCalc );
		this.setStepValue( stepValue );
		this.setBaseValue( baselineValue );
		this.setTickMarkVisible( tickMarkVisible );
		this.setTickMarkInside( tickMarkInside );
		this.setFormatVisible( numberVisible );
		this.setFormatInteger( numberInteger );
		this.setExponentVisible( exponentVisible );
		this.setExponentValue( exponent );

		// set visible at the end of this method
		this.setAxisVisible( axisVisible );


		return true;
	}



	/**
	 * Set properties to all listeners.
	 * @param l
	 * @return
	 */
	public boolean setPropertiesToListeners( SGIAxisPanelObserver l )
	{

		final Boolean axisVisible = this.isAxisVisible();
		final Boolean titleVisible = this.isTitleVisible();
		final String title = this.getTitleString();
		final Number min = this.getMinValue();
		final Number max = this.getMaxValue();
		final Integer scaleType = this.getScaleType();
		final Boolean autoCalc = this.getAutoCalcFlag();
		final Number baseline = this.getBaseValue();
		final Number step = this.getStepValue();
		final Boolean tickMarkVisible = this.isTickMarkVisible();
		final Boolean tickMarkInside = this.getScaleLineDirection();
		final Boolean numberVisible = this.isFormatVisible();
		final Boolean numberInteger = this.isFormatInteger();
		final Boolean exponentVisible = this.isExponentVisible();
		final Number exponent = this.getExponentValue();


		// check values
		if( l.hasValidAxisRange(min,max,scaleType) == false )
		{
			final String msg = MSG_RANGE_ERROR + ": " + this.mConfiguration;
			this.setInputErrorMessage( msg );
			return false;
		}
		
		if( l.hasValidAxisValues(baseline,step,scaleType) == false )
		{
			final String msg = MSG_STEP_ERROR + ": " + this.mConfiguration;
			this.setInputErrorMessage( msg );
			return false;
		}


		if( axisVisible!=null )
		{
			l.setAxisVisible( axisVisible.booleanValue() );
		}

		if( titleVisible!=null )
		{
			l.setTitleVisible( titleVisible.booleanValue() );
		}
		
		if( title!=null )
		{
			l.setTitle( title );
		}

		if( min!=null )
		{
			l.setMinValue( min.doubleValue() );
		}

		if( max!=null )
		{
			l.setMaxValue( max.doubleValue() );
		}

		if( scaleType!=null )
		{
			l.setScaleType( scaleType.intValue() );
		}
		
		if( autoCalc!=null )
		{
			l.setCalculateAutomatically( autoCalc.booleanValue() );
		}
		
		if( baseline!=null )
		{
			l.setBaselineValue( baseline.doubleValue() );
		}
		
		if( step!=null )
		{
			l.setStepValue( step.doubleValue() );
		}

		if( tickMarkVisible!=null )
		{
			l.setTickMarksVisible( tickMarkVisible.booleanValue() );
		}

		if( tickMarkInside!=null )
		{
			l.setTickMarksInside( tickMarkInside.booleanValue() );
		}
		
		if( numberVisible!=null )
		{
			l.setNumbersVisible( numberVisible.booleanValue() );
		}
		
		if( numberInteger!=null )
		{
			l.setNumbersInteger( numberInteger.booleanValue() );
		}
		
		if( exponentVisible!=null )
		{
			l.setExponentFlag( exponentVisible.booleanValue() );
		}
		
		if( exponent!=null )
		{
			l.setExponentValue( exponent.intValue() );
		}

		return true;
	}



	/**
	 * 
	 */
	protected boolean hasValidInputValues()
	{
		return true;
	}


}

