
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 * 
 *
 */
public interface SGIAxisBreakSymbolDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * 
	 * @return
	 */
	public double getXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getYValue();


	/**
	 * 
	 * @return
	 */
	public float getLength( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getInterval( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getDistortion();


	/**
	 * 
	 * @return
	 */
	public float getAngle();


	/**
	 * 
	 * @return
	 */
	public float getLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public boolean isForHorizontalAxis();


	/**
	 * 
	 * @return
	 */
	public Color getLineColor();


	/**
	 * 
	 * @return
	 */
	public Color getInnerColor();



	/**
	 * 
	 * @param value
	 */
	public void setXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setYValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setLength( final float value, final String unit );


	/**
	 * 
	 * @param value
	 */
	public void setInterval( final float value, final String unit );


	/**
	 * 
	 * @param value
	 */
	public void setLineWidth( final float value, final String unit );


	/**
	 * 
	 * @param angle
	 */
	public void setAngle( final float angle );


	/**
	 * 
	 * @param value
	 */	
	public void setDistortion( final float value );


	/**
	 * 
	 * @param color
	 */
	public void setLineColor( final Color color );


	/**
	 * 
	 * @param color
	 */
	public void setInnerColor( final Color color );


	/**
	 * 
	 * @param flag
	 */
	public void setForHorizontalAxisFlag( final boolean flag );



	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidXValue( final int config, final Number value );

	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidYValue( final int config, final Number value );

}

