
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 * 
 *
 */
public interface SGISignificantDifferenceDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * 
	 * @return
	 */
	public String getText();


	/**
	 * 
	 * @return
	 */
	public double getHorizontalYValue();


	/**
	 * 
	 * @return
	 */
	public double getLeftXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getLeftYValue();


	/**
	 * 
	 * @return
	 */
	public double getRightXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getRightYValue();


	/**
	 * @return 
	 */
	public boolean isLineVisible();


	/**
	 * 
	 * @return
	 */
	public float getSpace( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public String getFontName();


	/**
	 * 
	 * @return
	 */
	public float getFontSize( final String unit );


	/**
	 * 
	 * @return
	 */
	public int getFontStyle();


	/**
	 * 
	 * @return
	 */
	public Color getColor();



	/**
	 * 
	 * @param str
	 * @return
	 */
	public boolean setText( final String str );


	/**
	 * 
	 * @param value
	 */
	public void setHorizontalYValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setLeftXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setLeftYValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setRightXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setRightYValue( final double value );


	/**
	 * 
	 * @param b
	 */
	public void setLineVisible( final boolean b );



	/**
	 * 
	 */
	public boolean setSpace( final float space, final String unit );



	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth, final String unit );



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public void setFontName( final String name );

	public void setFontStyle( final int style );

	public void setFontSize( final float size, final String unit );


	/**
	 * 
	 * @param cl
	 */
	public boolean setColor( final Color cl );



	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidHorizontalYValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidLeftXValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidLeftYValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidRightXValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidRightYValue( final int config, final Number value );


}

