/*
 * SGSignificantDifferenceSymbolDialog.java
 *
 * Created on 2004/06/17, 14:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;



/**
 *
 * @author  kuromaru
 */
public class SGSignificantDifferenceSymbolDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Significant Difference Symbol Properties";

    
    /** Creates new form SGSignificantDifferenceSymbolDialog */
    public SGSignificantDifferenceSymbolDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mLineWidthLabel1 = new javax.swing.JLabel();
        mLineWidthLabel2 = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontNameComboBox = new javax.swing.JComboBox();
        mColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFormLabel = new javax.swing.JLabel();
        mFormSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mSpaceLabel = new javax.swing.JLabel();
        mSpaceSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftXValueLabel = new javax.swing.JLabel();
        mLeftXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLeftYValueLabel = new javax.swing.JLabel();
        mLeftYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightXValueLabel = new javax.swing.JLabel();
        mRightXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightYValueLabel = new javax.swing.JLabel();
        mRightYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mHorizontalYValueLabel = new javax.swing.JLabel();
        mHorizontalYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLineVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFontStyleLabel = new javax.swing.JLabel();
        mTextLabel = new javax.swing.JLabel();
        mTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mFontSizeLabel, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mColorLabel, gridBagConstraints);

        mLineWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel1.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        mPanel.add(mLineWidthLabel1, gridBagConstraints);

        mLineWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLineWidthLabel2, gridBagConstraints);

        mFontSizeSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFontNameComboBox, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mColorButton, gridBagConstraints);

        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 5, 5);
        mPanel.add(mFormSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mSpaceLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLabel.setText("Space");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSpaceLabel, gridBagConstraints);

        mSpaceSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSpaceSpinner, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 5, 5);
        mPanel.add(mLocationSeparator, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mPanel.add(mStringSeparator, gridBagConstraints);

        mLeftXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLeftXValueLabel, gridBagConstraints);

        mLeftXValueTextField.setColumns(6);
        mLeftXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLeftXValueTextField, gridBagConstraints);

        mLeftYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftYValueLabel.setText("Left Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLeftYValueLabel, gridBagConstraints);

        mLeftYValueTextField.setColumns(6);
        mLeftYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLeftYValueTextField, gridBagConstraints);

        mRightXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightXValueLabel.setText("Right X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightXValueLabel, gridBagConstraints);

        mRightXValueTextField.setColumns(6);
        mRightXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightXValueTextField, gridBagConstraints);

        mRightYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightYValueLabel.setText("Right Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightYValueLabel, gridBagConstraints);

        mRightYValueTextField.setColumns(6);
        mRightYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightYValueTextField, gridBagConstraints);

        mHorizontalYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHorizontalYValueLabel.setText("Horizontal Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mHorizontalYValueLabel, gridBagConstraints);

        mHorizontalYValueTextField.setColumns(6);
        mHorizontalYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mHorizontalYValueTextField, gridBagConstraints);

        mLineVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineVisibleCheckBox.setText("Line Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        mPanel.add(mLineVisibleCheckBox, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mFontStyleLabel, gridBagConstraints);

        mTextLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextLabel.setText("Text");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mTextLabel, gridBagConstraints);

        mTextField.setColumns(16);
        mTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mColorButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JLabel mHorizontalYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mHorizontalYValueTextField;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLeftXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mLeftXValueTextField;
    private javax.swing.JLabel mLeftYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mLeftYValueTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mLineVisibleCheckBox;
    private javax.swing.JLabel mLineWidthLabel1;
    private javax.swing.JLabel mLineWidthLabel2;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mRightXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mRightXValueTextField;
    private javax.swing.JLabel mRightYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mRightYValueTextField;
    private javax.swing.JLabel mSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceSpinner;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTextField;
    private javax.swing.JLabel mTextLabel;
    // ϐ錾̏I//GEN-END:variables


//	/**
//	 * 
//	 *
//	 */
//	public void dispose()
//	{
//		if( this.mAxisPanel!=null )
//		{
//			this.mAxisPanel.dispose();
//			this.mAxisPanel = null;
//		}
//		
//		super.dispose();
//	}


    /**
     * 
     */
    public void actionPerformed( ActionEvent e )
    {
    	super.actionPerformed(e);
    	
		Object source = e.getSource();
		String command = e.getActionCommand();

    	if( source.equals( this.mLineVisibleCheckBox ) )
    	{
    		this.setLineComponentEnabled( this.mLineVisibleCheckBox.isSelected() );
    	}
    }

    
    /**
     * 
     * @return
     */
    public String getText()
    {
    	return this.mTextField.getText();
    }

    
	/**
	 * 
	 * @return
	 */
	public Number getLeftXValue()
	{
		return this.getNumber( this.mLeftXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getLeftYValue()
	{
		return this.getNumber( this.mLeftYValueTextField );
	}


	/**
	 * 
	 * @return
	 */
	public Number getRightXValue()
	{
		return this.getNumber( this.mRightXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getRightYValue()
	{
		return this.getNumber( this.mRightYValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getHorizontalYValue()
	{
		return this.getNumber( this.mHorizontalYValueTextField );
	}
	
	
	/**
	 * 
	 * @return
	 */
	public Boolean getLineVisible()
	{
		return this.mLineVisibleCheckBox.getSelected();
	}

	
	/**
	 * 
	 */
	public Number getSpace()
	{
		return this.mSpaceSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}
	
	
	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}
	

	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}
	
	
	/**
	 * 
	 */
	public Color getColor()
	{
		return this.mColorButton.getColor();
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 * @param text
	 * @return
	 */
	public boolean setText( final String text )
	{
		this.mTextField.setText( text );
		return true;
	}
	

	/**
	 * 
	 * @param value
	 */
	public boolean setLeftXValue( final Object obj )
	{
		return this.setValue( this.mLeftXValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setLeftYValue( final Object obj )
	{
		return this.setValue( this.mLeftYValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setRightXValue( final Object obj )
	{
		return this.setValue( this.mRightXValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setRightYValue( final Object obj )
	{
		return this.setValue( this.mRightYValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setHorizontalYValue( final Object obj )
	{
		return this.setValue( this.mHorizontalYValueTextField, obj );
	}

	
	/**
	 * 
	 * @param b
	 */
	public void setLineVisible( final Boolean b )
	{
		this.mLineVisibleCheckBox.setSelected(b);
		if( b!=null )
		{
			this.setLineComponentEnabled(b.booleanValue());
		}
		else
		{
			this.setLineComponentEnabled(true);
		}
	}


	/**
	 * 
	 * @param b
	 */
	private void setLineComponentEnabled( final boolean b )
	{
		this.mLineWidthLabel1.setEnabled(b);
		this.mLineWidthLabel2.setEnabled(b);
		this.mLineWidthSpinner.setEnabled(b);
	}
	
	
	/**
	 * 
	 */
	public boolean setSpace( final Object obj )
	{
		return this.setValue( this.mSpaceSpinner, obj );
	}



	/**
	 * 
	 */
	public boolean setFontSize( final Object obj )
	{
		return this.setValue( this.mFontSizeSpinner, obj );
	}
	
	
	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontStyle( final Integer style )
	{
		String styleName = null;
		if( style!=null )
		{
			styleName = SGUtilityText.getFontStyleName( style.intValue() );
		}
		this.mFontStyleComboBox.setSelectedItem( styleName );

		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		this.mColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}
	
	
	
	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		list.add( this.mTextField );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mLeftXValueTextField );
		list.add( this.mLeftYValueTextField );
		list.add( this.mRightXValueTextField );
		list.add( this.mRightYValueTextField );
		list.add( this.mHorizontalYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mSpaceSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGSignificantDifferenceSymbolDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontNameComboBox.addItem( fontArray[ii] );
			}
	
			final String[] styleNameArray = {
				SGIConstants.FONT_PLAIN,
				SGIConstants.FONT_ITALIC,
				SGIConstants.FONT_BOLD,
				SGIConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}
	
		}
	
		this.pack();

		
		//
		// spinner model
		//

		// spinner
		this.mSpaceSpinner.initProperties(
			new SpinnerNumberModel( 0.1, -1.0, 1.0, 0.05 ),
			cm, 1, 2 );
	
		// font size
		this.mFontSizeSpinner.initProperties(
			getFontSizeSpinnerNumberModel(),
			pt, 1, 2 );
	
		// line width
		this.mLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			pt, 1, 2 );

		
		this.mLineVisibleCheckBox.addActionListener(this);
		

		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;


		// set the name
		this.mHorizontalYValueTextField.setDescription("Location-> HorizontalY");
		this.mLeftXValueTextField.setDescription("Location-> LeftX");
		this.mLeftYValueTextField.setDescription("Location-> LeftY");
		this.mRightXValueTextField.setDescription("Location-> RightX");
		this.mRightYValueTextField.setDescription("Location-> RightY");
		this.mSpaceSpinner.setDescription("Form-> Space");
		this.mLineWidthSpinner.setDescription("Form-> LineWidth");
		this.mTextField.setDescription("String-> Text");
		this.mFontSizeSpinner.setDescription("String-> Size");


		// add as an action listener
		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
		this.mPreviewButton.addActionListener(this);
	
		return true;
	}
	
	
	
	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
		final SGSignificantDifferenceSymbolDialog dg = this;

		ArrayList list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}

		SGISignificantDifferenceDialogObserver sigdiff0
			= (SGISignificantDifferenceDialogObserver)list.get(0);

		final String text0 = sigdiff0.getText();
		final double horizontalYValue0 = sigdiff0.getHorizontalYValue();
		final double leftXValue0 = sigdiff0.getLeftXValue();
		final double leftYValue0 = sigdiff0.getLeftYValue();
		final double rightXValue0 = sigdiff0.getRightXValue();
		final double rightYValue0 = sigdiff0.getRightYValue();
		final boolean lineVisible0 = sigdiff0.isLineVisible();
		final float space0 = sigdiff0.getSpace( cm );
		final float lineWidth0 = sigdiff0.getLineWidth( pt );
		final String fontName0 = sigdiff0.getFontName();
		final float fontSize0 = sigdiff0.getFontSize( pt );
		final int fontStyle0 = sigdiff0.getFontStyle();
		final Color color0 = sigdiff0.getColor();

		String text = text0;
		Double horizontalYValue = new Double( horizontalYValue0 );
		Double leftXValue = new Double( leftXValue0 );
		Double leftYValue = new Double( leftYValue0 );
		Double rightXValue = new Double( rightXValue0 );
		Double rightYValue = new Double( rightYValue0 );
		Boolean lineVisible = Boolean.valueOf( lineVisible0 );
		Float space = new Float( space0 );
		Float lineWidth = new Float( lineWidth0 );
		String fontName = fontName0;
		Float fontSize = new Float( fontSize0 );
		Integer fontStyle = new Integer( fontStyle0 );
		Color color = color0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final String text1 = sigdiff1.getText();
				if( text0.equals(text1) == false )
				{
					text = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final double yValue1 = sigdiff1.getHorizontalYValue();
				if( horizontalYValue0!=yValue1 )
				{
					horizontalYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final double xValue1 = sigdiff1.getLeftXValue();
				if( leftXValue0!=xValue1 )
				{
					leftXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final double yValue1 = sigdiff1.getLeftYValue();
				if( leftYValue0!=yValue1 )
				{
					leftYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final double xValue1 = sigdiff1.getRightXValue();
				if( rightXValue0!=xValue1 )
				{
					rightXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final double yValue1 = sigdiff1.getRightYValue();
				if( rightYValue0!=yValue1 )
				{
					rightYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final boolean lineVisible1 = sigdiff1.isLineVisible();
				if( lineVisible0!=lineVisible1 )
				{
					lineVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final float space1 = sigdiff1.getSpace( cm );
				if( space0!=space1 )
				{
					space = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final float lineWidth1 = sigdiff1.getLineWidth( pt );
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final String fontName1 = sigdiff1.getFontName();
				if( fontName0.equals(fontName1) == false )
				{
					fontName = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);
				final float fontSize1 = sigdiff1.getFontSize( pt );
				if( fontSize0!=fontSize1 )
				{
					fontSize = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);

				final int fontStyle1 = sigdiff1.getFontStyle();
				if( fontStyle0!=fontStyle1 )
				{
					fontStyle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGISignificantDifferenceDialogObserver sigdiff1
					= (SGISignificantDifferenceDialogObserver)list.get(ii);

				final Color color1 = sigdiff1.getColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}
		}


		//
		this.setText( text );
		this.setHorizontalYValue( horizontalYValue );
		this.setLeftXValue( leftXValue );
		this.setLeftYValue( leftYValue );
		this.setRightXValue( rightXValue );
		this.setRightYValue( rightYValue );

		this.setLineVisible( lineVisible );
		this.setSpace( space );
		this.setLineWidth( lineWidth );
		this.setFontName( fontName );
		this.setFontSize( fontSize );
		this.setFontStyle( fontStyle );
		this.setColor( color );

		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGISignificantDifferenceDialogObserver sd
			= (SGISignificantDifferenceDialogObserver)l;


		// get values
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
		final String text = this.getText();
		final Number horizontalY = this.getHorizontalYValue();
		final Number leftX = this.getLeftXValue();
		final Number leftY = this.getLeftYValue();
		final Number rightX = this.getRightXValue();
		final Number rightY = this.getRightYValue();
		final Boolean lineVisible = this.getLineVisible();
		final Number space = this.getSpace();
		final Number lineWidth = this.getLineWidth();
		final Number fontSize = this.getFontSize();
		final String fontName = this.getFontName();
		final int fontStyle = this.getFontStyle();
		final Color cl = this.getColor();


		// check values
		ArrayList list = new ArrayList();
		if( sd.hasValidHorizontalYValue( yConfig, horizontalY ) == false )
		{
			list.add("HorizontalY");
		}
		if( sd.hasValidLeftXValue( xConfig, leftX ) == false )
		{
			list.add("LeftX");
		}
		if( sd.hasValidLeftYValue( yConfig, leftY ) == false )
		{
			list.add("LeftY");
		}
		if( sd.hasValidRightXValue( xConfig, rightX ) == false )
		{
			list.add("RightX");
		}
		if( sd.hasValidRightYValue( yConfig, rightY ) == false )
		{
			list.add("RightY");
		}
		if( list.size()!=0 )
		{
			String msg = ERRMSG_AXIS_VALUE_INVALID + ":\n";
			for( int ii=0; ii<list.size(); ii++ )
			{
				String str = (String)list.get(ii);
				msg += " - " + str + "\n";
			}
			this.setInputErrorMessage(msg);
			return false;
		}


		// set the related axes
		if( xConfig!=-1 )
		{
			sd.setXAxisConfiguration( xConfig );
		}

		if( yConfig!=-1 )
		{
			sd.setYAxisConfiguration( yConfig );
		}
		
		if( text!=null )
		{
			sd.setText( text );
		}
		
		if( horizontalY!=null )
		{
			sd.setHorizontalYValue( horizontalY.doubleValue() );
		}

		if( leftX!=null )
		{
			sd.setLeftXValue( leftX.doubleValue() );
		}

		if( leftY!=null )
		{
			sd.setLeftYValue( leftY.doubleValue() );
		}

		if( rightX!=null )
		{
			sd.setRightXValue( rightX.doubleValue() );
		}

		if( rightY!=null )
		{
			sd.setRightYValue( rightY.doubleValue() );
		}

		if( lineVisible!=null )
		{
			sd.setLineVisible( lineVisible.booleanValue() );
		}

		if( space!=null )
		{
//			sd.setSpace( space.floatValue()/SGIConstants.CM_POINT_RATIO );
			sd.setSpace( space.floatValue(), cm );
		}

		if( lineWidth!=null )
		{
//			sd.setLineWidth( lineWidth.floatValue() );
			sd.setLineWidth( lineWidth.floatValue(), pt );
		}

		if( fontSize!=null )
		{
//			sd.setFontSize( fontSize.floatValue() );
			sd.setFontSize( fontSize.floatValue(), pt );
		}

		if( fontName!=null )
		{
			sd.setFontName( fontName );
		}

		if( fontStyle!=-1 )
		{
			sd.setFontStyle( fontStyle );
		}

		if( cl!=null )
		{
			sd.setColor( cl );
		}


		return true;
	}


	/**
	 * Overrode to check the text field.
	 * @return
	 */
	protected boolean hasValidInputValues()
	{
		if( super.hasValidInputValues() == false )
		{
			return false;
		}

		// 
		if( this.mTextField.hasValidText() == false )
		{
			this.addInputErrorDescription( this.mTextField.getDescription() );
			return false;
		}

		return true;
	}


}

