
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

import org.w3c.dom.Element;

/**
 * 
 */
public class SGTimingLine extends SGElementGroupLine
{
	
	public static final String KEY_VALUE = "Value";

	
	/**
	 * 
	 */
	protected SGAxis mAxis = null;


	/**
	 * 
	 */
	protected double mValue;


	/**
	 * 
	 */
	protected SGAxis mParallelAxis = null;


	/**
	 * 
	 */
	protected double mStartValue;

	
	/**
	 * 
	 */
	protected double mEndValue;
	
	
	/**
	 * 
	 */
	public SGTimingLine()
	{
		super();
	}


	
	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		TimingLineProperties p = new TimingLineProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.getProperties(p) == false )
		{
			return false;
		}

		TimingLineProperties lp = (TimingLineProperties)p;
		lp.setValue( this.mValue );
		lp.axis = this.mAxis;

		return true;
	}

	
	
	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		TimingLineProperties tp = (TimingLineProperties)p;
		Double d = tp.getValue();
		if( d==null )
		{
			return false;
		}
		this.setValue( d.doubleValue() );

		SGAxis axis = tp.axis;
		if( axis==null )
		{
			return false;
		}
		this.setAxis( axis );
		
		
		return true;
	}


	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public SGProperties readProperties( final Element el )
	{
		TimingLineProperties p = new TimingLineProperties();
		if( this.readProperties( el, p ) == false ) return null;
		return p;
	}

	

	/**
	 * 
	 */
	public static class TimingLineProperties extends SGElementGroupLine.LineProperties
	{

//		public static final String[] keys = { KEY_VALUE };

		private double mValue;
		private SGAxis axis;

		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof TimingLineProperties ) == false ) return false;
			if( super.equals(obj) == false ) return false;

			TimingLineProperties p = (TimingLineProperties)obj;
			if( p.mValue!=this.mValue ) return false;
			if( p.axis != this.axis ) return false;

			return true;
		}

		
		public void setValue( final double value )
		{
			this.mValue = value;
		}

		public void setAxis( final SGAxis axis )
		{
			if( axis==null )
			{
				throw new IllegalArgumentException("axis==null");
			}
			this.axis = axis;
		}
		
		public Double getValue()
		{
			return new Double( this.mValue );
		}

		public SGAxis getAxis()
		{
			return this.axis;
		}
	}


	/**
	 * @return mAxis
	 */
	public SGAxis getAxis()
	{
		return mAxis;
	}


	/**
	 * 
	 * @return
	 */
	public SGAxis getParallelAxis()
	{
		return this.mParallelAxis;
	}

	
	/**
	 * @param axis mAxis ݒ肵܂B
	 */
	public void setAxis( final SGAxis axis )
	{
		mAxis = axis;
	}


	/**
	 * 
	 * @param axis
	 */
	public void setParallelAxis( SGAxis axis )
	{
		this.mParallelAxis = axis;
	}


	
	/**
	 * @return mValue
	 */
	public double getValue()
	{
		return mValue;
	}


	/**
	 * 
	 * @return
	 */
	public double getStartValue()
	{
		return this.mStartValue;
	}


	/**
	 * 
	 * @return
	 */
	public double getEndValue()
	{
		return this.mEndValue;
	}

	
	/**
	 * @param value
	 */
	public void setValue( final double value )
	{
		mValue = value;
	}


	/**
	 * @param value
	 */
	public void setStartValue( final double value )
	{
		mStartValue = value;
	}


	/**
	 * @param value
	 */
	public void setEndValue( final double value )
	{
		mEndValue = value;
	}

}

