/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementArrow
extends SGDrawingElement
implements SGIArrowConstants,
SGIDrawingElementConstants {
    protected SGDrawingElementLine mLine = this.getBodyInstance();
    protected SGDrawingElementSymbol mStartHead = this.getHeadInstance();
    protected SGDrawingElementSymbol mEndHead = this.getHeadInstance();
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;

    protected abstract SGDrawingElementLine getBodyInstance();

    protected abstract SGDrawingElementSymbol getHeadInstance();

    public void dispose() {
        super.dispose();
        this.mLine.dispose();
        this.mStartHead.dispose();
        this.mEndHead.dispose();
        this.mLine = null;
        this.mStartHead = null;
        this.mEndHead = null;
    }

    public boolean contains(int n, int n2) {
        boolean bl = this.mLine.contains(n, n2);
        boolean bl2 = this.mStartHead.contains(n, n2);
        boolean bl3 = this.mEndHead.contains(n, n2);
        boolean bl4 = bl | bl2 | bl3;
        return bl4;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.setLineColor(color);
        this.setHeadInnerColor(color);
        this.setHeadLineColor(color);
        return true;
    }

    public boolean setColor(List list) {
        Color color = (Color)list.get(0);
        return this.setColor(color);
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.mLine.setMagnification(f);
        this.mStartHead.setMagnification(f);
        this.mEndHead.setMagnification(f);
        return true;
    }

    public boolean setStart(SGTuple2f sGTuple2f) {
        return this.setTermPoints(sGTuple2f, this.getEnd());
    }

    public boolean setStartX(float f) {
        this.mLine.getStart().setX(f);
        this.mStartHead.setX(f);
        return true;
    }

    public boolean setStartY(float f) {
        this.mLine.getStart().setY(f);
        this.mStartHead.setY(f);
        return true;
    }

    public boolean setEnd(SGTuple2f sGTuple2f) {
        return this.setTermPoints(this.getStart(), sGTuple2f);
    }

    public boolean setEndX(float f) {
        this.mLine.getEnd().setX(f);
        this.mEndHead.setX(f);
        return true;
    }

    public boolean setEndY(float f) {
        this.mLine.getEnd().setY(f);
        this.mEndHead.setY(f);
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mLine.setTermPoints(sGTuple2f, sGTuple2f2);
        this.mStartHead.setLocation(sGTuple2f);
        this.mEndHead.setLocation(sGTuple2f2);
        return true;
    }

    public boolean setTermPoints(float f, float f2, float f3, float f4) {
        return this.setTermPoints(new SGTuple2f(f, f2), new SGTuple2f(f3, f4));
    }

    public float getStartX() {
        return this.mStartHead.getX();
    }

    public float getStartY() {
        return this.mStartHead.getY();
    }

    public float getEndX() {
        return this.mEndHead.getX();
    }

    public float getEndY() {
        return this.mEndHead.getY();
    }

    public SGTuple2f getStart() {
        return new SGTuple2f(this.getStartX(), this.getStartY());
    }

    public SGTuple2f getEnd() {
        return new SGTuple2f(this.getEndX(), this.getEndY());
    }

    public boolean setLineWidth(float f) {
        this.mLine.setLineWidth(f);
        this.mStartHead.setLineWidth(f);
        this.mEndHead.setLineWidth(f);
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setLineType(int n) {
        this.mLine.setLineType(n);
        return true;
    }

    private boolean setLineColor(Color color) {
        this.mLine.setColor(color);
        return true;
    }

    private boolean setLineColor(ArrayList arrayList) {
        this.mLine.setColor(arrayList);
        return true;
    }

    public boolean setHeadSize(float f) {
        this.mStartHead.setSize(f);
        this.mEndHead.setSize(f);
        return true;
    }

    public boolean setHeadSize(float f, String string) {
        return this.setHeadSize((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setHeadOpenAngle(float f) {
        this.mHeadOpenAngle = f;
        return true;
    }

    public boolean setHeadCloseAngle(float f) {
        this.mHeadCloseAngle = f;
        return true;
    }

    private boolean setHeadInnerColor(Color color) {
        this.mStartHead.setColor(color);
        this.mEndHead.setColor(color);
        return true;
    }

    private boolean setHeadInnerColor(ArrayList arrayList) {
        this.mStartHead.setColor(arrayList);
        this.mEndHead.setColor(arrayList);
        return true;
    }

    private boolean setHeadLineColor(Color color) {
        this.mStartHead.setLineColor(color);
        this.mEndHead.setLineColor(color);
        return true;
    }

    public boolean setStartHeadType(int n) {
        this.mStartHead.setType(n);
        return true;
    }

    public boolean setEndHeadType(int n) {
        this.mEndHead.setType(n);
        return true;
    }

    public float getLineWidth() {
        return this.mLine.getLineWidth();
    }

    public int getLineType() {
        return this.mLine.getLineType();
    }

    public float getHeadSize() {
        return this.mStartHead.getSize();
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public float getHeadLineWidth() {
        return this.mStartHead.getLineWidth();
    }

    public int getStartHeadType() {
        return this.mStartHead.getType();
    }

    public int getEndHeadType() {
        return this.mEndHead.getType();
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        if (!this.getProperties(arrowProperties)) {
            return null;
        }
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Float f3 = arrowProperties.getHeadOpenAngle();
        if (f3 == null) {
            return false;
        }
        this.setHeadOpenAngle(f3.floatValue());
        Float f4 = arrowProperties.getHeadCloseAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadCloseAngle(f4.floatValue());
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        return true;
    }

    public static Integer getSymbolTypeFromName(String string) {
        Integer n = SGDrawingElementSymbol.getSymbolTypeFromName(string);
        if (n != null) {
            return n;
        }
        if (string.equals("Arrow Head")) {
            return new Integer(10);
        }
        return null;
    }

    public static String getSymbolTypeName(int n) {
        String string = SGDrawingElementSymbol.getSymbolTypeName(n);
        if (string != null) {
            return string;
        }
        if (n == 10) {
            return "Arrow Head";
        }
        return null;
    }

    public boolean writeProperty(Element element) {
        String string = "cm";
        String string2 = "pt";
        String string3 = SGIConstants.degree;
        element.setAttribute("Width", Float.toString(this.getLineWidth()) + string2);
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.getLineType()));
        element.setAttribute("HeadSize", Float.toString(this.getHeadSize() * 0.035277776f) + string);
        element.setAttribute("StartHeadType", SGDrawingElementArrow.getSymbolTypeName(this.getStartHeadType()));
        element.setAttribute("EndHeadType", SGDrawingElementArrow.getSymbolTypeName(this.getEndHeadType()));
        element.setAttribute("HeadOpenAngle", Double.toString(this.getHeadOpenAngle() / ((float)Math.PI / 180)) + string3);
        element.setAttribute("HeadCloseAngle", Double.toString(this.getHeadCloseAngle() / ((float)Math.PI / 180)) + string3);
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = SGIConstants.degree;
        String string2 = null;
        Number number = null;
        Object var6_5 = null;
        Object var7_6 = null;
        List list = null;
        string2 = element.getAttribute("Width");
        if (string2.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string2);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("HeadSize")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setHeadSize(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("StartHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getSymbolTypeFromName(string2);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setStartHeadType(n)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("EndHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getSymbolTypeFromName(string2);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEndHeadType(n)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("HeadOpenAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string2, string);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setHeadOpenAngle(f2)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("HeadCloseAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string2, string);
            if (number == null) {
                return false;
            }
            float f3 = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setHeadCloseAngle(f3)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string2);
            if (list == null) {
                return false;
            }
            if (!this.setColor(list)) {
                return false;
            }
        }
        return true;
    }

    public static class ArrowProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementLine.LineProperties mLineProperties = new SGDrawingElementLine.LineProperties();
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();
        private int mEndHeadType;
        private double mHeadOpenAngle;
        private double mHeadCloseAngle;

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            if (!this.mLineProperties.equals(arrowProperties.mLineProperties)) {
                return false;
            }
            if (!this.mSymbolProperties.equals(arrowProperties.mSymbolProperties)) {
                return false;
            }
            if (this.mEndHeadType != arrowProperties.mEndHeadType) {
                return false;
            }
            if (this.mHeadOpenAngle != arrowProperties.mHeadOpenAngle) {
                return false;
            }
            return this.mHeadCloseAngle == arrowProperties.mHeadCloseAngle;
        }

        public Float getLineWidth() {
            return this.mLineProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mLineProperties.getLineType();
        }

        public Float getHeadSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getStartHeadType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Integer getEndHeadType() {
            return new Integer(this.mEndHeadType);
        }

        public Float getHeadOpenAngle() {
            return new Float(this.mHeadOpenAngle);
        }

        public Float getHeadCloseAngle() {
            return new Float(this.mHeadCloseAngle);
        }

        public void setLineWidth(float f) {
            this.mLineProperties.setLineWidth(f);
            this.mSymbolProperties.setLineWidth(f);
        }

        public void setLineType(int n) {
            this.mLineProperties.setLineType(n);
        }

        public void setStartHeadType(int n) {
            this.mSymbolProperties.setSymbolType(n);
        }

        public void setEndHeadType(int n) {
            this.mEndHeadType = n;
        }

        public void setHeadSize(float f) {
            this.mSymbolProperties.setSize(f);
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.mLineProperties.setColor(color);
            this.mSymbolProperties.setColor(color);
            this.mSymbolProperties.setLineColor(color);
        }

        public void setColor(List list) {
            super.setColor(list);
            this.mLineProperties.setColor(list);
            this.mSymbolProperties.setColor(list);
            Color color = (Color)list.get(0);
            this.mSymbolProperties.setLineColor(color);
        }

        public void setHeadOpenAngle(float f) {
            this.mHeadOpenAngle = f;
        }

        public void setHeadCloseAngle(float f) {
            this.mHeadCloseAngle = f;
        }
    }
}

