/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDataDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIArrowPanelObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;

public class SGPropertyDialogVXYData
extends SGDataDialog {
    public static final String TITLE = "VXY-Data Properties";
    private JRadioButton mAmplitudeInvariantRadioButton;
    private SGArrowPanel mArrowPanel;
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JPanel mCommonPanel;
    private JRadioButton mDirectionInvariantRadioButton;
    private JLabel mInvariantModeLabel;
    private SGCheckBox mLegendVisibleCheckBox;
    private JLabel mMagnitudePerCMLabel;
    private SGTextField mMagnitudePerCMTextField;
    private SGTextField mNameField;
    private JLabel mNameLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mNoInvariantModeSelectionRadioButton = new JRadioButton();

    public SGPropertyDialogVXYData(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mCommonPanel = new JPanel();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mNameLabel = new JLabel();
        this.mNameField = new SGTextField();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mMagnitudePerCMLabel = new JLabel();
        this.mMagnitudePerCMTextField = new SGTextField();
        this.mDirectionInvariantRadioButton = new JRadioButton();
        this.mAmplitudeInvariantRadioButton = new JRadioButton();
        this.mInvariantModeLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mArrowPanel = new SGArrowPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLegendVisibleCheckBox.setText("Legend Visible");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mNameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mCommonPanel.add((Component)this.mNameLabel, gridBagConstraints);
        this.mNameField.setColumns(16);
        this.mNameField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mNameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.mCommonPanel.add((Component)this.mAxisPanel, gridBagConstraints);
        this.mMagnitudePerCMLabel.setFont(new Font("Dialog", 0, 12));
        this.mMagnitudePerCMLabel.setText("Magnitude per cm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mCommonPanel.add((Component)this.mMagnitudePerCMLabel, gridBagConstraints);
        this.mMagnitudePerCMTextField.setColumns(6);
        this.mMagnitudePerCMTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mMagnitudePerCMTextField, gridBagConstraints);
        this.mDirectionInvariantRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mDirectionInvariantRadioButton.setText("Direction");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mDirectionInvariantRadioButton, gridBagConstraints);
        this.mAmplitudeInvariantRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mAmplitudeInvariantRadioButton.setText("Amplitude");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mAmplitudeInvariantRadioButton, gridBagConstraints);
        this.mInvariantModeLabel.setFont(new Font("Dialog", 0, 12));
        this.mInvariantModeLabel.setText("Invariant Mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.mCommonPanel.add((Component)this.mInvariantModeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mArrowPanel.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mArrowPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mDirectionInvariantRadioButton);
        buttonGroup.add(this.mAmplitudeInvariantRadioButton);
        buttonGroup.add(this.mNoInvariantModeSelectionRadioButton);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mNameField.setDescription("Name");
        this.mMagnitudePerCMTextField.setDescription("Magnitude per cm");
        return true;
    }

    public List getColorSelectionButtonsList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mArrowPanel.getColorSelectionButtonsList());
        return arrayList;
    }

    public List getNumberTextFieldList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mArrowPanel.getSpinnerList());
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        list.add(this.mNameField);
        list.add(this.mMagnitudePerCMTextField);
        return list;
    }

    public boolean addPropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        super.addPropertyDialogObserver(sGIPropertyDialogObserver);
        if (sGIPropertyDialogObserver instanceof SGIArrowPanelObserver) {
            this.mArrowPanel.addObserver((SGIArrowPanelObserver)((Object)sGIPropertyDialogObserver));
        }
        return true;
    }

    public boolean removePropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        super.removePropertyDialogObserver(sGIPropertyDialogObserver);
        if (sGIPropertyDialogObserver instanceof SGIArrowPanelObserver) {
            this.mArrowPanel.removeObserver((SGIArrowPanelObserver)((Object)sGIPropertyDialogObserver));
        }
        return true;
    }

    public boolean removeAllPropertyDialogObserver() {
        super.removeAllPropertyDialogObserver();
        this.mArrowPanel.removeAllObserver();
        return true;
    }

    public String getDataName() {
        return this.mNameField.getText();
    }

    public boolean setDataName(String string) {
        this.mNameField.setText(string);
        return true;
    }

    public Boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public void setLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        String string = this.getDataNameFromObservers();
        this.setDataName(string);
        Boolean bl = this.getLegendVisibleFromObservers();
        this.setLegendVisible(bl);
        Float f = this.getScalingFactorFromObservers();
        this.setMagnitudePerCM(f);
        Boolean bl2 = this.getInvarianceFromObservers();
        this.setDirectionInvariant(bl2);
        return this.mArrowPanel.setComponentsProperty();
    }

    public boolean setMagnitudePerCM(Object object) {
        return this.setValue(this.mMagnitudePerCMTextField, object);
    }

    public Number getMagnitudePerCM() {
        return this.getNumber(this.mMagnitudePerCMTextField);
    }

    private Float getScalingFactorFromObservers() {
        Object object;
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGIVXYDataDialogObserver)list.get(i);
            arrayList.add(new Float(object.getMagnitudePerCM()));
        }
        Float f = (Float)arrayList.get(0);
        object = f;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                Float f2 = (Float)arrayList.get(i);
                if (f.equals(f2)) continue;
                object = null;
                break;
            }
        }
        return object;
    }

    public Boolean isDirectionInvariant() {
        if (this.mDirectionInvariantRadioButton.isSelected()) {
            return Boolean.TRUE;
        }
        if (this.mAmplitudeInvariantRadioButton.isSelected()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean setDirectionInvariant(Object object) {
        if (object == null) {
            this.mNoInvariantModeSelectionRadioButton.setSelected(true);
            return false;
        }
        Boolean bl = (Boolean)object;
        if (bl.booleanValue()) {
            this.mDirectionInvariantRadioButton.setSelected(true);
        } else {
            this.mAmplitudeInvariantRadioButton.setSelected(true);
        }
        return true;
    }

    private Boolean getInvarianceFromObservers() {
        Object object;
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGIVXYDataDialogObserver)list.get(i);
            arrayList.add(object.isDirectionInvariant());
        }
        Boolean bl = (Boolean)arrayList.get(0);
        object = bl;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                Boolean bl2 = (Boolean)arrayList.get(i);
                if (bl.equals(bl2)) continue;
                object = null;
                break;
            }
        }
        return object;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Boolean bl;
        Number number;
        Boolean bl2;
        String string;
        SGIVXYDataDialogObserver sGIVXYDataDialogObserver = (SGIVXYDataDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisConfiguration();
        int n2 = this.mAxisPanel.getYAxisConfiguration();
        if (n != -1) {
            sGIVXYDataDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIVXYDataDialogObserver.setYAxisLocation(n2);
        }
        if ((string = this.getDataName()) != null) {
            sGIVXYDataDialogObserver.setName(string);
        }
        if ((bl2 = this.getLegendVisible()) != null) {
            sGIVXYDataDialogObserver.setVisibleInLegend(bl2);
        }
        if ((number = this.getMagnitudePerCM()) != null) {
            sGIVXYDataDialogObserver.setMagnitudePerCM(number.floatValue());
        }
        if ((bl = this.isDirectionInvariant()) != null) {
            sGIVXYDataDialogObserver.setDirectionInvariant(bl);
        }
        if (!this.mArrowPanel.setPropertiesToListeners(sGIVXYDataDialogObserver)) {
            String string2 = this.mArrowPanel.getInputErrorMessage();
            if (string2 != null) {
                this.setInputErrorMessage(string2);
            }
            return false;
        }
        return true;
    }
}

