
package jp.riken.brain.ni.samuraigraph.data;

/**
 * An interface for vector-type XY data.
 */
public interface SGIVXYTypeData extends SGITwoDimensionalData
{

	/**
	 * Returns a copy of x array.
	 * @return x-value array
	 */
	public double[] getXCoordinateArray();


	/**
	 * Returns a copy of y array.
	 * @return y-value array
	 */
	public double[] getYCoordinateArray();


	/**
	 * Returns a copy of magnitude array.
	 * @return magnitude array
	 */
	public double[] getMagnitudeArray();


	/**
	 * Returns a copy of angle array.
	 * @return angle array
	 */
	public double[] getAngleArray();


	/**
	 * 
	 * @return
	 */
	public double[] getXComponentArray();


	/**
	 * 
	 * @return
	 */
	public double[] getYComponentArray();

	/**
	 * 
	 * @return
	 */
	public boolean isPolar();

}

