
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Font;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;

/**
 * Constants for significant difference symbols.
 */
public interface SGISignificantDifferenceSymbolConstants
	extends SGIDrawingElementConstants
{

	/**
	 * 
	 */
	public static final int BODY = 0;
	public static final int HORIZONTAL_MIDDLE = 1;
	public static final int LEFT_MIDDLE = 2;
	public static final int RIGHT_MIDDLE = 3;
	public static final int LEFT_TERM = 4;
	public static final int LEFT_JOINT = 5;
	public static final int RIGHT_TERM = 6;
	public static final int RIGHT_JOINT = 7;
	public static final int ON_STRING = 8;


	public static final String SIGDIFF_SPACE_UNIT = cm;
	public static final double SIGDIFF_SPACE_MIN = -1.0;
	public static final double SIGDIFF_SPACE_MAX = 1.0;

	
	/**
	 * 
	 */
	public static final String TAG_NAME_SIGDIFF_SYMBOL
		= "SignificantDifferenceSymbol";


	public static final String KEY_LEFT_X_VALUE = "LeftX";
	public static final String KEY_LEFT_Y_VALUE = "LeftY";
	public static final String KEY_RIGHT_X_VALUE = "RightX";
	public static final String KEY_RIGHT_Y_VALUE = "RightY";
	public static final String KEY_HORIZONTAL_Y_VALUE = "HorizontalY";

	public static final String KEY_LINE_VISIBLE = "LineVisible";
	public static final String KEY_LINE_WIDTH = "LineWidth";
	public static final String KEY_SPACE = "Space";



	//
	// Default Values
	//

	// Width
	public static final float DEFAULT_SIGDIFF_SYMBOL_WIDTH = 1.0f;

	// Left Height
	public static final float DEFAULT_SIGDIFF_SYMBOL_LEFT_HEIGHT = 1.0f;

	// Right Height
	public static final float DEFAULT_SIGDIFF_SYMBOL_RIGHT_HEIGHT = 1.0f;

	// Line Width
	public static final float DEFAULT_SIGDIFF_SYMBOL_LINE_WIDTH = 1.0f;

	// Space
	public static final float DEFAULT_SIGDIFF_SYMBOL_SPACE = 0.20f;

	// Horizontal Axis
	public static final String DEFAULT_SIGDIFF_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String DEFAULT_SIGDIFF_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;


	// Font
	public static final String DEFAULT_SIGDIFF_SYMBOL_FONT_NAME = "Serif";
	public static final int DEFAULT_SIGDIFF_SYMBOL_FONT_STYLE = Font.PLAIN;
	public static final float DEFAULT_SIGDIFF_SYMBOL_FONT_SIZE = 24.0f;

	// Color
	public static final Color DEFAULT_SIGDIFF_SYMBOL_COLOR = Color.BLACK;

	
}

