
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISingleAxisHolder;

/**
 * An observer of the property dialog for timing lines.
 *
 */
public interface SGITimingLineDialogObserver
	extends SGIPropertyDialogObserver, SGISingleAxisHolder
{

	public double getValue();

	public float getLineWidth( final String unit );
	
	public int getLineType();
	
	public Color getColor();

	public void setValue( final double value );

	public boolean setLineWidth( final float width, final String unit );

	public boolean setLineType( final int type );
	
	public boolean setColor( final Color cl );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidValue( final int config, final Number value );

}

