/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGISXYGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGraphElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGSXYGraphElement
extends SGGraphElement
implements SGISXYGraphElement,
SGISXYDataConstants {
    protected boolean createDataDialog() {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = new SGPropertyDialogSXYData(this.mDialogOwner, true);
        this.mDialog = sGPropertyDialogSXYData;
        return true;
    }

    public String getClassDescription() {
        return "SXY Graph";
    }

    public boolean addData(SGData sGData, String string) {
        if (!(sGData instanceof SGISXYTypeData) & !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        return super.addData(sGData, string);
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!(sGData instanceof SGISXYTypeData) & !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        return super.addData(sGData, string, sGProperties);
    }

    protected SGGraphElement.ElementGroupSetInGraph createGroupSet(SGData sGData, String string) {
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return null;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGISXYTypeData) {
            elementGroupSetInGraph = this.createSingleGroupSet((SGISXYTypeData)((Object)sGData), sGAxis5, sGAxis6, string);
        } else if (sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGISXYTypeMultipleData)((Object)sGData), sGAxis5, sGAxis6, string);
        } else {
            return null;
        }
        return elementGroupSetInGraph;
    }

    private SGGraphElement.ElementGroupSetForMultipleData createMultipleGroupSet(SGISXYTypeMultipleData sGISXYTypeMultipleData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        elementGroupSetForMultipleDataInSXYGraph.setName(string);
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(sGAxis);
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(sGAxis2);
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGISXYTypeDataArray[i], sGAxis, sGAxis2);
            elementGroupSetInSXYGraph.setName(string);
            elementGroupSetInSXYGraph.initPropertiesHistory();
            elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList.add(elementGroupSetInSXYGraph);
        }
        return elementGroupSetForMultipleDataInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createSingleGroupSet(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGISXYTypeData, sGAxis, sGAxis2);
        elementGroupSetInSXYGraph.setName(string);
        return elementGroupSetInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createGroupSetSXYInstance(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2) {
        ElementGroupTickLabels elementGroupTickLabels;
        ElementGroupErrorBar elementGroupErrorBar;
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        elementGroupSetInSXYGraph.setXAxis(sGAxis);
        elementGroupSetInSXYGraph.setYAxis(sGAxis2);
        int n = sGISXYTypeData.getPointsNumber();
        elementGroupSetInSXYGraph.initPointsArray(n);
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return null;
        }
        double[] dArray = sGISXYTypeData.getXValueArray();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = Math.abs(dArray[i + 1] - dArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        ElementGroupBar elementGroupBar = (ElementGroupBar)elementGroupSetInSXYGraph.getBarGroup();
        elementGroupBar.setWidthValue(d);
        if (sGISXYTypeData.isErrorValueHolding() && !(elementGroupErrorBar = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return null;
        }
        if (sGISXYTypeData.isStringArrayHolding() && !(elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.updateDrawingElementsLocation((SGData)((Object)sGISXYTypeData))) {
            return null;
        }
        elementGroupSetInSXYGraph.setMagnification(this.getMagnification());
        return elementGroupSetInSXYGraph;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        SGElementGroupSet sGElementGroupSet;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        List list = this.mChildList;
        for (n = 0; n < list.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)list.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)((Object)sGElementGroupSet);
            iElementGroupSetInSXYGraph.paintDataString(graphics2D);
        }
        if (bl) {
            SGUtilityForFigureElementJava2D.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < list.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.ElementGroupSetInGraph)list.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            ((SGGraphElement.ElementGroupSetInGraph)sGElementGroupSet).setClipFlag(bl);
            sGElementGroupSet.paintGraphics2D(graphics2D);
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mChildList.get(i);
            Rectangle2D rectangle2D = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).getTickLabelsBoundingBox(sGData = this.getData(elementGroupSetInGraph));
            if (rectangle2D == null) {
                return false;
            }
            if (rectangle2D.getWidth() < Double.MIN_VALUE || rectangle2D.getHeight() < Double.MIN_VALUE) continue;
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected SGGraphElement.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGISXYTypeData) {
            elementGroupSetInGraph = new ElementGroupSetInSXYGraph();
        } else if (sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        }
        return elementGroupSetInGraph;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!(sGData instanceof SGISXYTypeData) & !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.addToList(elementGroupSetInGraph);
        int n = this.setDataProperties(element, elementGroupSetInGraph, sGData);
        if (n == 1) {
            return false;
        }
        this.createDataDialog();
        return true;
    }

    protected int setDataProperties(Element element, SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph, SGData sGData) {
        SGISXYTypeMultipleData sGISXYTypeMultipleData;
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph;
        SGISXYTypeData sGISXYTypeData;
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph;
        if (super.setDataProperties(element, elementGroupSetInGraph, sGData) == 1) {
            return 1;
        }
        if (sGData instanceof SGISXYTypeData ? this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)elementGroupSetInGraph, sGISXYTypeData = (SGISXYTypeData)((Object)sGData)) == 1 : sGData instanceof SGISXYTypeMultipleData && this.setPropertyOfElementGroupSetForMultipleDataInSXYGraph(element, elementGroupSetForMultipleDataInSXYGraph = (ElementGroupSetForMultipleDataInSXYGraph)elementGroupSetInGraph, sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)sGData)) == 1) {
            return 1;
        }
        return 0;
    }

    private int setPropertyOfElementGroupSetForMultipleDataInSXYGraph(Element element, ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph, SGISXYTypeMultipleData sGISXYTypeMultipleData) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        int n = this.setDataProperties(element, elementGroupSetInSXYGraph, (SGData)((Object)sGISXYTypeDataArray[0]));
        if (n == 1) {
            return n;
        }
        SGProperties sGProperties = elementGroupSetInSXYGraph.getProperties();
        SGProperties sGProperties2 = elementGroupSetInSXYGraph.getWholeProperties();
        ArrayList<ElementGroupSetInSXYGraph> arrayList = new ArrayList<ElementGroupSetInSXYGraph>();
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph2 = new ElementGroupSetInSXYGraph();
            if (!elementGroupSetInSXYGraph2.setProperties(sGProperties)) {
                return 1;
            }
            int n2 = sGISXYTypeDataArray[i].getPointsNumber();
            elementGroupSetInSXYGraph2.initPointsArray(n2);
            elementGroupSetInSXYGraph2.updateDrawingElementsLocation((SGData)((Object)sGISXYTypeDataArray[i]));
            elementGroupSetInSXYGraph2.addDrawingElementGroup(2);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(0);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(1);
            if (!elementGroupSetInSXYGraph2.setWholeProperties(sGProperties2)) {
                return 1;
            }
            elementGroupSetInSXYGraph2.initPropertiesHistory();
            arrayList.add(elementGroupSetInSXYGraph2);
        }
        elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList = new ArrayList(arrayList);
        elementGroupSetForMultipleDataInSXYGraph.setName(elementGroupSetInSXYGraph.getName());
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(elementGroupSetInSXYGraph.getXAxis());
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(elementGroupSetInSXYGraph.getYAxis());
        elementGroupSetForMultipleDataInSXYGraph.setZAxis(elementGroupSetInSXYGraph.getZAxis());
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInSXYGraph(Element element, ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGISXYTypeData sGISXYTypeData) {
        Object object;
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        Object var6_5 = null;
        int n = sGISXYTypeData.getPointsNumber();
        elementGroupSetInSXYGraph.initPointsArray(n);
        SGElementGroupSXY sGElementGroupSXY = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getBarGroup();
        if (!sGElementGroupSXY.readProperty(element2)) {
            return 1;
        }
        ElementGroupBar elementGroupBar = (ElementGroupBar)sGElementGroupSXY;
        float f = elementGroupBar.getRectangleWidth();
        if (f != 0.0f) {
            object = elementGroupSetInSXYGraph.getXAxis();
            double d = ((SGAxis)object).getMaxValue();
            double d2 = ((SGAxis)object).getMinValue();
            float f2 = f / this.mGraphRectWidth;
            double d3 = (d - d2) * (double)f2;
            d3 = this.getNumberInRangeOrder(d3, (SGAxis)object);
            elementGroupBar.setWidthValue(d3);
        }
        if ((nodeList = element.getElementsByTagName("ErrorBar")).getLength() == 1) {
            if (sGISXYTypeData.isErrorValueHolding()) {
                Element element3;
                object = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData);
                if (!((ElementGroupErrorBar)object).readProperty(element3 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                    return 1;
                }
                ((SGElementGroupErrorBar)object).setLocation(((ElementGroupErrorBar)object).mStartArray, ((ElementGroupErrorBar)object).mEndArray);
            }
        } else if (nodeList.getLength() == 0) {
            if (sGISXYTypeData.isErrorValueHolding() && !((SGElementGroupErrorBar)(object = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData))).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        if ((nodeList = element.getElementsByTagName("Line")).getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return 1;
        }
        object = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getLineGroup();
        if (!sGElementGroupSXY.readProperty((Element)object)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getSymbolGroup();
        if (!sGElementGroupSXY.readProperty(element4)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("TickLabels");
        if (nodeList.getLength() == 1) {
            if (sGISXYTypeData.isStringArrayHolding()) {
                Element element5;
                ElementGroupTickLabels elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData);
                if (!elementGroupTickLabels.readProperty(element5 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!elementGroupTickLabels.setPropertiesOfDrawingElements()) {
                    return 1;
                }
                elementGroupTickLabels.setLocation(elementGroupTickLabels.mPointsArray);
            }
        } else if (nodeList.getLength() == 0) {
            ElementGroupTickLabels elementGroupTickLabels;
            if (sGISXYTypeData.isStringArrayHolding() && !(elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        elementGroupSetInSXYGraph.initPropertiesHistory();
        return 0;
    }

    public void setMode(int n) {
        super.setMode(n);
        this.updateAllDrawingElementsLocation();
    }

    private ElementGroupSetInSXYGraph getSXYGroupSet(int n) {
        return (ElementGroupSetInSXYGraph)this.getGroupSet(n);
    }

    public boolean setLineVisibleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setLineVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setLineWidthDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setLineTypeDirectly(int n, int n2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setLineType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setLineColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolVisibleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolTypeDirectly(int n, int n2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolSizeDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolLineWidthDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolInnerColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolInnerColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setSymbolLineColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setSymbolLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarVisibleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarBaselineDirectly(int n, double d) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarBaselineValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarWidthDirectly(int n, double d) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarWidthValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarEdgeLineWidthDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarEdgeLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarInnerColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarInnerColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setBarLineColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setBarEdgeLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarVisibleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarSymbolTypeDirectly(int n, int n2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarHeadType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarSymbolSizeDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarHeadSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarStyleDirectly(int n, int n2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarStyle(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarLineWidthDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setErrorBarColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getErrorBarGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setErrorBarColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelVisibleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelFontNameDirectly(int n, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelFontName(string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelFontStyleDirectly(int n, int n2) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelFontStyle(n2)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelFontSizeDirectly(int n, float f, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelFontSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelFontColorDirectly(int n, Color color) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public boolean setTickLabelAngleDirectly(int n, boolean bl) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getSXYGroupSet(n);
        if (elementGroupSetInSXYGraph == null) {
            return false;
        }
        if (elementGroupSetInSXYGraph.getTickLabelGroup() == null) {
            return false;
        }
        if (!this.setDirectlyBefore(elementGroupSetInSXYGraph)) {
            return false;
        }
        if (!elementGroupSetInSXYGraph.setTickLabelHorizontal(bl)) {
            return false;
        }
        return this.setDirectlyAfter(elementGroupSetInSXYGraph);
    }

    public static class TickLabelStringElement
    extends SGDrawingElementString2DExtended {
        protected TickLabelStringElement() {
        }
    }

    class ElementGroupTickLabels
    extends SGElementGroupTickLabel
    implements SGGraphElement.IElementGroupInGraph {
        protected SGGraphElement.ElementGroupSetInGraph mGroupSet = null;
        private SGTuple2f[] mPointsArray = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupTickLabels(SGISXYTypeData sGISXYTypeData) {
            int n = sGISXYTypeData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
            }
            this.mPointsArray = sGTuple2fArray;
            String[] stringArray = sGISXYTypeData.getStringArray();
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < n; ++i) {
                SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElementArray[i];
                sGDrawingElementString.setString(stringArray[i]);
            }
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setFontSize(16.0f, "pt");
            this.setFontName("Serif");
            this.setFontStyle(0);
            this.setAngle("Horizontal");
            this.setColor(SGISXYDataConstants.DEFAULT_TICK_LABEL_FONT_COLOR);
            return true;
        }

        protected SGDrawingElement getDrawingElementInstance() {
            return new TickLabelStringElement();
        }

        public void dispose() {
            super.dispose();
            this.mPointsArray = null;
        }

        private boolean drawStringBounds(SGDrawingElementString2DExtended sGDrawingElementString2DExtended, Graphics2D graphics2D) {
            Color color = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getElementBounds();
            graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean calcTickLabelLocation(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGTuple2f[] sGTuple2fArray) {
            TickLabelStringElement tickLabelStringElement;
            int n;
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            int n2 = SGSXYGraphElement.this.mAxisElement.getLocationInPlane(sGAxis);
            float f5 = this.getAngle();
            float f6 = SGSXYGraphElement.this.mAxisElement.getSpaceAxisLineAndNumber() * this.mMagnification;
            int n3 = sGISXYTypeData.getPointsNumber();
            float f7 = 0.0f;
            float f8 = 0.0f;
            for (n = 0; n < n3; ++n) {
                tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[n];
                float f9 = tickLabelStringElement.getAscent();
                float f10 = tickLabelStringElement.getDescent();
                if (f9 > f7) {
                    f7 = f9;
                }
                if (!(f10 > f8)) continue;
                f8 = f10;
            }
            for (n = 0; n < n3; ++n) {
                tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[n];
                double d = sGISXYTypeData.getXValue(n);
                float f11 = SGSXYGraphElement.this.calcLocation(d, sGAxis, true);
                Rectangle2D rectangle2D = tickLabelStringElement.getElementBounds();
                float f12 = (float)rectangle2D.getWidth();
                float f13 = (float)rectangle2D.getHeight();
                Rectangle2D rectangle2D2 = tickLabelStringElement.getStringRect();
                float f14 = (float)rectangle2D2.getWidth();
                float f15 = (float)rectangle2D2.getHeight();
                float f16 = 0.0f;
                float f17 = 0.0f;
                float f18 = 0.0f;
                if (f5 == 0.0f) {
                    f16 = f11 - 0.5f * f12;
                } else {
                    if (f5 != 0.5235988f) throw new Error();
                    if (n2 == 0) {
                        f16 = f11 - f14 * (float)Math.cos(f5);
                    } else {
                        if (n2 != 1) throw new Error();
                        f16 = f11 - f15 * (float)Math.sin(f5);
                    }
                }
                if (n2 == 0) {
                    if (f5 == 0.0f) {
                        f18 = f7 - tickLabelStringElement.getAscent();
                    }
                    f18 += f2 + f4 + f6;
                } else {
                    if (n2 != 1) throw new Error();
                    if (f5 == 0.0f) {
                        f18 = -f8 + tickLabelStringElement.getDescent();
                    }
                    f18 += f2 - f6 - f13;
                }
                tickLabelStringElement.setLocation(f16, f18);
                float f19 = (float)tickLabelStringElement.getElementBounds().getY();
                f17 = f18 + (f18 - f19);
                sGTuple2fArray[n].setValues(f16, f17);
            }
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            super.setLocation(sGTuple2fArray);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)SGSXYGraphElement.this.getData(elementGroupSetInSXYGraph));
            if (sGISXYTypeData != null) {
                double[] dArray = sGISXYTypeData.getXValueArray();
                for (int i = 0; i < sGTuple2fArray.length; ++i) {
                    TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                    tickLabelStringElement.setVisible(sGAxis.insideRange(dArray[i]));
                }
            }
            return true;
        }

        public String getTagName() {
            return "TickLabels";
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGSXYGraphElement.this.readProperty(this, element);
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar
    implements SGGraphElement.IElementGroupInGraph {
        protected SGGraphElement.ElementGroupSetInGraph mGroupSet = null;
        private SGTuple2f[] mStartArray = null;
        private SGTuple2f[] mEndArray = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupErrorBar(SGISXYTypeData sGISXYTypeData) {
            int n = sGISXYTypeData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
                sGTuple2fArray2[i] = new SGTuple2f();
            }
            this.mStartArray = sGTuple2fArray;
            this.mEndArray = sGTuple2fArray2;
            if (!this.init()) {
                throw new Error();
            }
        }

        public void dispose() {
            super.dispose();
            this.mStartArray = null;
            this.mEndArray = null;
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f, "pt");
            this.setHeadSize(0.25f, "cm");
            this.setHeadType(8);
            this.setErrorBarStyle(1);
            this.setColor(SGISXYDataConstants.DEFAULT_ERROR_BAR_COLOR);
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            if ((double)f < 0.25) {
                return false;
            }
            if ((double)f > 6.0) {
                return false;
            }
            return super.setLineWidth(f, string);
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGSXYGraphElement.this.readProperty(this, element);
        }

        private boolean calcErrorBarLocation(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
            int n = sGISXYTypeData.getPointsNumber();
            double[] dArray = sGISXYTypeData.getXValueArray();
            double[] dArray2 = sGISXYTypeData.getYValueArray();
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n];
            SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2dArray[i] = new SGTuple2d();
                sGTuple2dArray2[i] = new SGTuple2d();
                sGTuple2dArray[i].x = dArray[i];
                sGTuple2dArray2[i].x = dArray[i];
            }
            if (this.mErrorBarStyle == 1) {
                double[] dArray3 = sGISXYTypeData.getUpperErrorValueArray();
                double[] dArray4 = sGISXYTypeData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray4[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray3[i];
                }
            } else if (this.mErrorBarStyle == 2) {
                double[] dArray5 = sGISXYTypeData.getUpperErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray5[i];
                }
            } else if (this.mErrorBarStyle == 3) {
                double[] dArray6 = sGISXYTypeData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray6[i];
                    sGTuple2dArray2[i].y = dArray2[i];
                }
            } else {
                throw new Error();
            }
            SGSXYGraphElement.this.calcLocationOfPairs(sGTuple2dArray, sGTuple2dArray2, sGAxis, sGAxis2, sGTuple2fArray, sGTuple2fArray2);
            return true;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements SGGraphElement.IElementGroupInGraph {
        protected SGGraphElement.ElementGroupSetInGraph mGroupSet = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setType(1);
            this.setSize(0.3f, "cm");
            this.setColor(SGISXYDataConstants.DEFAULT_SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f, "pt");
            this.setLineColor(SGISXYDataConstants.DEFAULT_SYMBOL_LINE_COLOR);
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            if ((double)f < 0.25) {
                return false;
            }
            if ((double)f > 6.0) {
                return false;
            }
            return super.setLineWidth(f, string);
        }

        public boolean setSize(float f, String string) {
            if ((double)f < 0.05) {
                return false;
            }
            if ((double)f > 2.0) {
                return false;
            }
            return super.setSize(f, string);
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGSXYGraphElement.this.readProperty(this, element);
        }

        private boolean drawRectangle(Shape shape, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = (int)rectangle2D.getX();
            int n2 = (int)rectangle2D.getY();
            int n3 = (int)rectangle2D.getWidth();
            int n4 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n, n2, n3, n4);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects || elementGroupSetInSXYGraph.isBarVisible()) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[n3];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
            SGSXYGraphElement.this.drawAnchorsOnRectangle(sGDrawingElementSymbol2D.getElementBounds(), graphics2D);
            return true;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements SGGraphElement.IElementGroupInGraph {
        protected SGGraphElement.ElementGroupSetInGraph mGroupSet = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupBar() {
            this.init();
        }

        private void init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setColor(SGISXYDataConstants.DEFAULT_BAR_COLOR);
            this.setEdgeLineWidth(0.5f, "pt");
            this.setEdgeLineColor(SGISXYDataConstants.DEFAULT_BAR_EDGE_LINE_COLOR);
        }

        public boolean initDrawingElement(int n) {
            super.initDrawingElement(n);
            this.setHorizontal(false);
            return true;
        }

        protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
            super.initDrawingElement(sGTuple2fArray);
            this.setHorizontal(false);
            return true;
        }

        public boolean setEdgeLineWidth(float f, String string) {
            if ((double)f < 0.25) {
                return false;
            }
            if ((double)f > 6.0) {
                return false;
            }
            return super.setEdgeLineWidth(f, string);
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGSXYGraphElement.this.readProperty(this, element);
        }

        private float getBaselineLocation(double d) {
            SGAxis sGAxis = ((ElementGroupSetInSXYGraph)this.mGroupSet).getYAxis();
            return SGSXYGraphElement.this.calcLocation(d, sGAxis, false);
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            float f = this.getBaselineLocation(this.getBaselineValue());
            boolean bl = true;
            if (Float.isInfinite(f) | Float.isNaN(f)) {
                bl = false;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            double d = sGAxis.getMinValue();
            double d2 = sGAxis.getMaxValue();
            float f2 = SGSXYGraphElement.this.mGraphRectWidth * (float)(this.getWidthValue() / (d2 - d));
            this.setRectangleWidth(f2);
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                float f3 = sGTuple2fArray[i].x;
                float f4 = sGTuple2fArray[i].y;
                if (Float.isInfinite(f4) | Float.isNaN(f4) | !bl) {
                    sGDrawingElementBar2D.setVisible(false);
                    continue;
                }
                float f5 = f - f4;
                sGDrawingElementBar2D.setVisible(true);
                sGDrawingElementBar2D.setBounds(f3, f4, f2, f5);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[n3];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
            SGSXYGraphElement.this.drawAnchorsOnRectangle(sGDrawingElementBar2D.getElementBounds(), graphics2D);
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements SGGraphElement.IElementGroupInGraph {
        protected SGGraphElement.ElementGroupSetInGraph mGroupSet = null;
        private boolean mFocusedFlag = false;

        public boolean setElementGroupSet(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
            this.mGroupSet = elementGroupSetInGraph;
            return true;
        }

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f, "pt");
            this.setLineType(1);
            this.setColor(SGISXYDataConstants.DEFAULT_LINE_COLOR);
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            if ((double)f < 0.25) {
                return false;
            }
            if ((double)f > 6.0) {
                return false;
            }
            return super.setLineWidth(f, string);
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGSXYGraphElement.this.readProperty(this, element);
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            int n = SGSXYGraphElement.this.getMode();
            if (n == 0) {
                this.mMode = 0;
            } else if (n == 1) {
                this.mMode = 1;
            }
            return this.setLocation(sGTuple2fArray, false);
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            if (this.isFocused() && SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects && !elementGroupSetInSXYGraph.isSymbolVisible() && !elementGroupSetInSXYGraph.isBarVisible()) {
                ArrayList arrayList = this.mConnectedPathList;
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                    int n2 = 0;
                    ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                    PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                    float[] fArray = new float[6];
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        pathIterator.currentSegment(fArray);
                        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                        ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                        ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                        arrayList2.add(float_2);
                        pathIterator.next();
                        ++n2;
                    }
                    if (n2 <= 8) {
                        for (n = 0; n < n2; ++n) {
                            Point2D point2D = (Point2D)arrayList2.get(n);
                            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                        }
                        continue;
                    }
                    n = n2 / 8;
                    int n3 = 0;
                    do {
                        Point2D point2D = (Point2D)arrayList2.get(n3);
                        SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                    } while ((n3 += n) < n2);
                }
            }
            return true;
        }
    }

    class ElementGroupSetInSXYGraph
    extends SGGraphElement.ElementGroupSetInGraph
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;
        private SGTuple2f[] mPointsArray = null;

        protected ElementGroupSetInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public void dispose() {
            super.dispose();
            this.mPointsArray = null;
        }

        public String getClassDescription() {
            return "";
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getXAxisLocation() {
            return SGSXYGraphElement.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        public int getYAxisLocation() {
            return SGSXYGraphElement.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        public ArrayList getLineGroupList() {
            return this.getLineGroups();
        }

        public ArrayList getSymbolGroupList() {
            return this.getSymbolGroups();
        }

        public ArrayList getBarGroupList() {
            return this.getBarGroups();
        }

        public ArrayList getErrorBarGroupList() {
            return this.getErrorBarGroups();
        }

        public ArrayList getTickLabelGroupList() {
            return this.getTickLabelGroups();
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return this.getLineGroup().getLineWidth(string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return this.getLineGroup().setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return this.getSymbolGroup().getSize(string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return this.getSymbolGroup().getLineWidth(string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f, String string) {
            double d = SGUtilityText.convert(f, string, "cm");
            if (d < 0.05) {
                return false;
            }
            if (d > 2.0) {
                return false;
            }
            return this.getSymbolGroup().setSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return this.getSymbolGroup().setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolInnerColor(Color color) {
            return this.getSymbolGroup().setColor(color);
        }

        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return this.getBarGroup().getEdgeLineWidth(string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        public boolean setBarWidthValue(double d) {
            return this.getBarGroup().setWidthValue(d);
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return this.getBarGroup().setEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setBarInnerColor(Color color) {
            return this.getBarGroup().setColor(color);
        }

        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBarBaselineValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return this.getErrorBarGroup().getHeadSize(string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return this.getErrorBarGroup().getLineWidth(string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            return this.getErrorBarGroup().setHeadType(n);
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            double d = SGUtilityText.convert(f, string, "cm");
            if (d < 0.05) {
                return false;
            }
            if (d > 2.0) {
                return false;
            }
            return this.getErrorBarGroup().setHeadSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return this.getErrorBarGroup().setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarStyle(int n) {
            return this.getErrorBarGroup().setErrorBarStyle(n);
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return this.getTickLabelGroup().getFontSize(string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 8.0) {
                return false;
            }
            if (d > 96.0) {
                return false;
            }
            return this.getTickLabelGroup().setFontSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            float f = bl ? 0.0f : 0.5235988f;
            return this.getTickLabelGroup().setAngle(f);
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (n == 0) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                return false;
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        private boolean checkGroupType(SGElementGroup sGElementGroup) {
            Class<?> clazz = sGElementGroup.getClass();
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                Class<?> clazz2 = sGElementGroup2.getClass();
                if (!clazz.equals(clazz2)) continue;
                return false;
            }
            return true;
        }

        private ElementGroupErrorBar createErrorBars(SGISXYTypeData sGISXYTypeData) {
            ElementGroupErrorBar elementGroupErrorBar = new ElementGroupErrorBar(sGISXYTypeData);
            this.mDrawingElementGroupList.add(elementGroupErrorBar);
            elementGroupErrorBar.mGroupSet = this;
            return elementGroupErrorBar;
        }

        private ElementGroupTickLabels createTickLabels(SGISXYTypeData sGISXYTypeData) {
            ElementGroupTickLabels elementGroupTickLabels = new ElementGroupTickLabels(sGISXYTypeData);
            this.mDrawingElementGroupList.add(elementGroupTickLabels);
            elementGroupTickLabels.mGroupSet = this;
            return elementGroupTickLabels;
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            SGIVisible sGIVisible;
            int n;
            ArrayList<SGElementGroupErrorBar> arrayList2 = new ArrayList<SGElementGroupErrorBar>();
            for (n = 0; n < arrayList.size(); ++n) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(n);
                sGIVisible = null;
                if (sGDrawingElement instanceof SGDrawingElementErrorBar) {
                    sGIVisible = this.getErrorBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementLine) {
                    sGIVisible = this.getLineGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                    sGIVisible = this.getSymbolGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                    sGIVisible = this.getBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementString) {
                    sGIVisible = this.getTickLabelGroup();
                }
                if (sGIVisible == null) continue;
                arrayList2.add((SGElementGroupErrorBar)sGIVisible);
            }
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGProperties sGProperties;
                sGIVisible = (SGDrawingElement)arrayList.get(i);
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = ((SGDrawingElement)sGIVisible).getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement.getProperties())) {
                    n = 1;
                }
                sGElementGroup.setProperty((SGDrawingElement)sGIVisible);
            }
            return n != 0;
        }

        private void initPointsArray(int n) {
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
            }
            this.mPointsArray = sGTuple2fArray;
        }

        public boolean updateDrawingElementsLocation(SGIData sGIData) {
            if (!(sGIData instanceof SGISXYTypeData)) {
                return false;
            }
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)sGIData;
            int n = sGISXYTypeData.getPointsNumber();
            if (!SGSXYGraphElement.this.calcLocationOfPoints(sGISXYTypeData.getXValueArray(), sGISXYTypeData.getYValueArray(), this.getXAxis(), this.getYAxis(), this.mPointsArray)) {
                return false;
            }
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGTuple2f[] sGTuple2fArray;
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupErrorBar)sGElementGroup).mStartArray;
                    SGTuple2f[] sGTuple2fArray2 = ((ElementGroupErrorBar)sGElementGroup).mEndArray;
                    if (!((ElementGroupErrorBar)sGElementGroup).calcErrorBarLocation(sGISXYTypeData, this.getXAxis(), this.getYAxis(), sGTuple2fArray, sGTuple2fArray2)) {
                        return false;
                    }
                    if (((SGElementGroupErrorBar)sGElementGroup).setLocation(sGTuple2fArray, sGTuple2fArray2)) continue;
                    return false;
                }
                if (sGElementGroup2 instanceof SGElementGroupTickLabel) {
                    sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupTickLabels)sGElementGroup).mPointsArray;
                    if (!((ElementGroupTickLabels)sGElementGroup).calcTickLabelLocation(sGISXYTypeData, this.getXAxis(), sGTuple2fArray)) {
                        return false;
                    }
                    if (((ElementGroupTickLabels)sGElementGroup).setLocation(sGTuple2fArray)) continue;
                    return false;
                }
                if (!(sGElementGroup2 instanceof SGElementGroupLine | sGElementGroup2 instanceof SGElementGroupSymbol | sGElementGroup2 instanceof SGElementGroupBar) || ((SGElementGroupSXY)(sGElementGroup = (SGElementGroupSXY)sGElementGroup2)).setLocation(this.mPointsArray)) continue;
                return false;
            }
            return true;
        }

        protected boolean createDrawingElements() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupSXY) {
                    sGElementGroup = (SGElementGroupSXY)sGElementGroup2;
                    ((SGElementGroupSXY)sGElementGroup).setLocation(this.mPointsArray);
                    continue;
                }
                if (sGElementGroup2 instanceof ElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    ((SGElementGroupErrorBar)sGElementGroup).setLocation(((ElementGroupErrorBar)sGElementGroup).mStartArray, ((ElementGroupErrorBar)sGElementGroup).mEndArray);
                    continue;
                }
                if (!(sGElementGroup2 instanceof ElementGroupTickLabels)) continue;
                sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                ((ElementGroupTickLabels)sGElementGroup).setLocation(((ElementGroupTickLabels)sGElementGroup).mPointsArray);
            }
            return true;
        }

        private boolean addElementGroup(SGElementGroupSXY sGElementGroupSXY) {
            SGGraphElement.IElementGroupInGraph iElementGroupInGraph = (SGGraphElement.IElementGroupInGraph)((Object)sGElementGroupSXY);
            iElementGroupInGraph.setElementGroupSet(this);
            if (!sGElementGroupSXY.initDrawingElement(this.mPointsArray)) {
                throw new Error();
            }
            if (!sGElementGroupSXY.setPropertiesOfDrawingElements()) {
                return false;
            }
            this.mDrawingElementGroupList.add(sGElementGroupSXY);
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGIData sGIData) {
            if (!(sGIData instanceof SGISXYTypeData)) {
                return null;
            }
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)sGIData;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            ArrayList arrayList2 = this.getTickLabelGroups();
            if (arrayList2.size() == 0) {
                return new Rectangle2D.Float();
            }
            ElementGroupTickLabels elementGroupTickLabels = (ElementGroupTickLabels)arrayList2.get(0);
            if (!elementGroupTickLabels.isVisible()) {
                return new Rectangle2D.Float();
            }
            ArrayList<SGDrawingElement> arrayList3 = new ArrayList<SGDrawingElement>();
            SGDrawingElement[] sGDrawingElementArray = elementGroupTickLabels.getDrawingElementArray();
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (!sGDrawingElementArray[i].isVisible()) continue;
                arrayList3.add(sGDrawingElementArray[i]);
            }
            Rectangle2D rectangle2D = SGUtilityJava2D.getBoundingBox(arrayList3);
            if (rectangle2D == null) {
                return new Rectangle2D.Float();
            }
            arrayList.add(rectangle2D);
            Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
            if (rectangle2D2 == null) {
                new Rectangle2D.Float();
            }
            return rectangle2D2;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            SGElementGroup sGElementGroup;
            ArrayList arrayList;
            ElementGroupBar elementGroupBar;
            Rectangle2D rectangle2D = null;
            if (!this.getClipFlag()) {
                rectangle2D = SGSXYGraphElement.this.getGraphRect();
            }
            if ((elementGroupBar = SGSXYGraphElement.this.getGroupBar(this)) != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D, rectangle2D);
            }
            if ((arrayList = this.getErrorBarGroups()).size() != 0 && (sGElementGroup = (ElementGroupErrorBar)arrayList.get(0)) != null && sGElementGroup.isVisible()) {
                ((SGElementGroupErrorBar)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((sGElementGroup = SGSXYGraphElement.this.getGroupLine(this)) != null && sGElementGroup.isVisible()) {
                ((ElementGroupLine)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupSymbol = SGSXYGraphElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D, rectangle2D);
            }
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            ElementGroupTickLabels elementGroupTickLabels;
            ArrayList arrayList = this.getTickLabelGroups();
            if (arrayList.size() != 0 && (elementGroupTickLabels = (ElementGroupTickLabels)arrayList.get(0)) != null && elementGroupTickLabels.isVisible()) {
                elementGroupTickLabels.paintElement(graphics2D);
            }
            return true;
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            return this.setXAxis(this.getAxis(n));
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            return this.setYAxis(this.getAxis(n));
        }

        private SGAxis getAxis(int n) {
            return SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            String string = SGSXYGraphElement.this.mAxisElement.getLocationName(this.getXAxis());
            String string2 = SGSXYGraphElement.this.mAxisElement.getLocationName(this.getYAxis());
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            return true;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }
    }

    class ElementGroupSetForMultipleDataInSXYGraph
    extends SGGraphElement.ElementGroupSetForMultipleData
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;

        protected ElementGroupSetForMultipleDataInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getClassDescription() {
            return "";
        }

        protected boolean createDrawingElements() {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.createDrawingElements()) continue;
                return false;
            }
            return true;
        }

        public boolean updateDrawingElementsLocation(SGIData sGIData) {
            if (!(sGIData instanceof SGISXYTypeMultipleData)) {
                return false;
            }
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)sGIData;
            SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.updateDrawingElementsLocation((SGData)((Object)sGISXYTypeDataArray[i]))) continue;
                return false;
            }
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGIData sGIData) {
            if (!(sGIData instanceof SGISXYTypeMultipleData)) {
                return null;
            }
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)sGIData;
            SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                Rectangle2D rectangle2D = iElementGroupSetInSXYGraph.getTickLabelsBoundingBox((SGData)((Object)sGISXYTypeDataArray[i]));
                if (rectangle2D == null) {
                    return null;
                }
                arrayList.add(rectangle2D);
            }
            Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
            return rectangle2D;
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                iElementGroupSetInSXYGraph.paintDataString(graphics2D);
            }
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.setXAxis(this.getAxis(n));
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.setYAxis(this.getAxis(n));
            return true;
        }

        private SGAxis getAxis(int n) {
            return SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
        }

        public boolean setXAxis(SGAxis sGAxis) {
            super.setXAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setXAxis(sGAxis);
            }
            return true;
        }

        public boolean setYAxis(SGAxis sGAxis) {
            super.setYAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setYAxis(sGAxis);
            }
            return true;
        }

        public double getSamplingRate() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
            return sGSXYSamplingData.getSamplingRate();
        }

        public SGProperties getWholeProperties() {
            SGElementGroupSet.WholeProperties wholeProperties;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            if (!elementGroupSetInSXYGraph.getWholeProperties(wholeProperties = new SGElementGroupSet.WholeProperties())) {
                return null;
            }
            return wholeProperties;
        }

        public boolean setWholeProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.WholeProperties)) {
                return false;
            }
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)sGProperties;
            if (!this.setProperties(wholeProperties.getElementGroupSetProperties())) {
                return false;
            }
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList.get(i);
                if (elementGroupSetInSXYGraph.setWholeProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            ArrayList arrayList = elementGroupSetInSXYGraph.getElementGroupList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                Element element2 = sGElementGroup.createElement(document);
                if (element2 == null) {
                    return null;
                }
                element.appendChild(element2);
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)SGSXYGraphElement.this.getData(this));
            if (!super.writeProperty(element)) {
                return false;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            String string = SGSXYGraphElement.this.mAxisElement.getLocationName(elementGroupSetInSXYGraph.getXAxis());
            String string2 = SGSXYGraphElement.this.mAxisElement.getLocationName(elementGroupSetInSXYGraph.getYAxis());
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            if (sGISXYTypeMultipleData instanceof SGSXYSamplingData) {
                double d = this.getSamplingRate();
                element.setAttribute("SamplingRate", Double.toString(d));
            }
            return true;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setVisible(bl);
            }
            return true;
        }

        public boolean setLineWidth(float f) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineWidth(f);
            }
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            ArrayList arrayList = this.getLineGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineWidth(f2);
            }
            return true;
        }

        public boolean setLineType(int n) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineType(n);
            }
            return true;
        }

        public boolean setLineColor(Color color) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setColor(color);
            }
            return true;
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setVisible(bl);
            }
            return true;
        }

        public boolean setSymbolType(int n) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setType(n);
            }
            return true;
        }

        public boolean setSymbolSize(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setSize(f);
            }
            return true;
        }

        public boolean setSymbolSize(float f, String string) {
            ArrayList arrayList = this.getSymbolGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setSize(f2);
            }
            return true;
        }

        public boolean setSymbolLineWidth(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineWidth(f);
            }
            return true;
        }

        public boolean setSymbolLineWidth(float f, String string) {
            ArrayList arrayList = this.getSymbolGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineWidth(f2);
            }
            return true;
        }

        public boolean setSymbolInnerColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setColor(color);
            }
            return true;
        }

        public boolean setSymbolLineColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineColor(color);
            }
            return true;
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setVisible(bl);
            }
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setBaselineValue(d);
            }
            return true;
        }

        public boolean setBarWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setRectangleWidth(f);
            }
            return true;
        }

        public boolean setBarWidthValue(double d) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setWidthValue(d);
            }
            return true;
        }

        public boolean setBarEdgeLineWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineWidth(f);
            }
            return true;
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            ArrayList arrayList = this.getBarGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineWidth(f2);
            }
            return true;
        }

        public boolean setBarInnerColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setColor(color);
            }
            return true;
        }

        public boolean setBarEdgeLineColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineColor(color);
            }
            return true;
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            return this.getFirst().hasValidBaselineValue(n, number);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            return true;
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            return true;
        }

        public boolean setErrorBarColor(Color color) {
            return true;
        }

        public boolean setErrorBarLineWidth(float f) {
            return true;
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            return true;
        }

        public boolean setErrorBarStyle(int n) {
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return true;
        }

        public boolean setTickLabelFontStyle(int n) {
            return true;
        }

        public boolean setTickLabelFontSize(float f) {
            return true;
        }

        public boolean setTickLabelFontSize(float f, String string) {
            return true;
        }

        public boolean setTickLabelColor(Color color) {
            return true;
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getLineGroups());
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getSymbolGroups());
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getBarGroups());
            }
            return arrayList;
        }

        public ArrayList getErrorBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getErrorBarGroups());
            }
            return arrayList;
        }

        public ArrayList getTickLabelGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getTickLabelGroups());
            }
            return arrayList;
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        private ElementGroupSetInSXYGraph getFirst() {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            return elementGroupSetInSXYGraph;
        }

        public int getXAxisLocation() {
            return this.getFirst().getXAxisLocation();
        }

        public int getYAxisLocation() {
            return this.getFirst().getYAxisLocation();
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            boolean bl = false;
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                boolean bl2 = elementGroupSetInSXYGraph.synchronizeDrawingElement(arrayList);
                if (!bl2) continue;
                bl = true;
            }
            return bl;
        }
    }

    protected static interface IElementGroupSetInSXYGraph {
        public Rectangle2D getTickLabelsBoundingBox(SGIData var1);

        public boolean paintDataString(Graphics2D var1);
    }
}

