/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGProxySettingDialog;

class SGProxyManager
implements ActionListener,
SGIPreferencesConstants {
    private boolean mDirectAccessFlag = true;
    private String mProxyHostName = null;
    private int mProxyPortNumber = -1;

    public SGProxyManager() {
        this.setProxyOnStartUp();
    }

    private boolean setProxyOnStartUp() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        boolean bl = preferences.getBoolean("Direct Access", true);
        String string = preferences.get("Proxy Host Name", "");
        int n = preferences.getInt("Proxy Port Number", -1);
        this.mDirectAccessFlag = bl;
        if (!string.equals("")) {
            this.mProxyHostName = string;
        }
        if (n != -1) {
            this.mProxyPortNumber = n;
        }
        return true;
    }

    public boolean isDirectAccess() {
        return this.mDirectAccessFlag;
    }

    public void setDirectAccess(boolean bl) {
        this.mDirectAccessFlag = bl;
    }

    public String getProxyHostName() {
        return this.mProxyHostName;
    }

    public int getProxyPortNumber() {
        return this.mProxyPortNumber;
    }

    public void setProxyHostName(String string) {
        this.mProxyHostName = string;
    }

    public void setProxyPortNumber(int n) {
        this.mProxyPortNumber = n;
    }

    public boolean showProxySettingDialog(Frame frame) {
        SGProxySettingDialog sGProxySettingDialog = new SGProxySettingDialog(frame, true);
        sGProxySettingDialog.addActionListener(this);
        sGProxySettingDialog.setCenter(frame);
        sGProxySettingDialog.setDirectAccess(this.mDirectAccessFlag);
        sGProxySettingDialog.setHostName(this.mProxyHostName);
        sGProxySettingDialog.setPortNumber(this.mProxyPortNumber);
        sGProxySettingDialog.setVisible(true);
        sGProxySettingDialog.dispose();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGProxySettingDialog sGProxySettingDialog = (SGProxySettingDialog)object;
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.mDirectAccessFlag = sGProxySettingDialog.isDirectAccess();
            this.mProxyHostName = sGProxySettingDialog.getHostName();
            this.mProxyPortNumber = sGProxySettingDialog.getPortNumber();
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            preferences.putBoolean("Direct Access", this.mDirectAccessFlag);
            preferences.put("Proxy Host Name", this.mProxyHostName);
            preferences.putInt("Proxy Port Number", this.mProxyPortNumber);
        }
    }
}

