/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public abstract class SGPropertyDialog
extends SGDialog
implements ChangeListener,
SGIDrawingElementConstants {
    protected List mPropertyDialogObserverList = new ArrayList();
    private Icon mColorSelectionButtonEmphasisIcon = null;
    protected SGColorDialog mColorDialog = null;
    protected SGColorSelectionButton mFocusedColorSetButton = null;
    private String mInputErrorMessage = "";
    private final ArrayList mInputErrorComponentNameList = new ArrayList();
    protected static final String DEFAULT_INPUT_ERROR_MESSAGE = "The input value is illegal.";
    public static final String ERRMSG_AXIS_VALUE_INVALID = "Axis value is invalid.";

    public SGPropertyDialog() {
    }

    public SGPropertyDialog(Dialog dialog) {
        super(dialog);
    }

    public SGPropertyDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string) {
        super(dialog, string);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
    }

    public SGPropertyDialog(Frame frame) {
        super(frame);
    }

    public SGPropertyDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public SGPropertyDialog(Frame frame, String string) {
        super(frame, string);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
    }

    protected boolean initialize() {
        JButton jButton;
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        List list = this.getColorSelectionButtonsList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof SGColorSelectionButton)) continue;
            jButton = (JButton)e;
            jButton.addActionListener(this);
        }
        List list2 = this.getTextFieldComponentsList();
        for (int i = 0; i < list2.size(); ++i) {
            jButton = list2.get(i);
            if (!(jButton instanceof JTextComponent)) continue;
            JTextField jTextField = (JTextField)((Object)jButton);
            jTextField.addActionListener(this);
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        this.mColorDialog = null;
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    protected String getString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("res", Locale.JAPAN);
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public SGColorDialog getColorDialog() {
        return this.mColorDialog;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mFocusedColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getColorChooser().getColor();
            this.mFocusedColorSetButton.setColor(color);
            this.mColorDialog.getColorChooser().getSelectionModel().setSelectedColor(null);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.mColorDialog.setVisible(false);
        }
    }

    public abstract List getColorSelectionButtonsList();

    public abstract List getTextFieldComponentsList();

    public abstract List getNumberTextFieldList();

    public abstract List getSpinnerList();

    protected List getFormattedTextFieldsListFromSpinners() {
        ArrayList<JFormattedTextField> arrayList = new ArrayList<JFormattedTextField>();
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            arrayList.add(sGSpinner.getFormattedTextField());
        }
        return arrayList;
    }

    public boolean setColorButtonBorder(JButton jButton, boolean bl) {
        List list = this.getColorSelectionButtonsList();
        for (int i = 0; i < list.size(); ++i) {
            JComponent jComponent = (JComponent)list.get(i);
            if (jComponent.equals(jButton) && bl) {
                MatteBorder matteBorder = new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
                jButton.setBorder(matteBorder);
                continue;
            }
            jComponent.setBorder(new LineBorder(Color.BLACK, 1));
        }
        return true;
    }

    public boolean setColorButtonBorder(boolean bl) {
        this.setColorButtonBorder(this.mFocusedColorSetButton, bl);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (this.getColorSelectionButtonsList().contains(object2)) {
            this.mFocusedColorSetButton = object = (SGColorSelectionButton)object2;
            this.setColorButtonBorder(true);
            this.mColorDialog.setVisible(true);
        }
        object = this.getTextFieldComponentsList();
        if (string.equals("OK") || object.contains(object2)) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals("Preview")) {
            this.onPreviewed();
        }
    }

    public static SpinnerNumberModel getLineWidthSpinnerNumberModel() {
        return new SpinnerNumberModel(0.25, 0.25, 6.0, 0.25);
    }

    public static SpinnerNumberModel getFontSizeSpinnerNumberModel() {
        return new SpinnerNumberModel(8.0, 8.0, 96.0, 1.0);
    }

    public boolean addPropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        this.mPropertyDialogObserverList.add(sGIPropertyDialogObserver);
        return true;
    }

    public boolean removePropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        return this.mPropertyDialogObserverList.remove(sGIPropertyDialogObserver);
    }

    public boolean removeAllPropertyDialogObserver() {
        this.mPropertyDialogObserverList.clear();
        return true;
    }

    private boolean onOK() {
        if (!this.commit()) {
            return false;
        }
        this.setCloseOption(0);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    private boolean onCanceled() {
        if (!this.cancel()) {
            return false;
        }
        this.setCloseOption(1);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    private boolean onPreviewed() {
        return this.preview();
    }

    protected void clearAllSpinners() {
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            sGSpinner.clearTemporaryValues();
        }
    }

    protected boolean commit() {
        if (!this.checkInputValues()) {
            return false;
        }
        List list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)list.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                String string = this.getInputErrorMessage();
                String string2 = string != null ? string : DEFAULT_INPUT_ERROR_MESSAGE;
                SGUtility.showIllegalInputErrorMessageDialog(this, string2);
                return false;
            }
            if (sGIPropertyDialogObserver.commit()) continue;
            return false;
        }
        this.setVisible(false);
        return true;
    }

    protected boolean cancel() {
        List list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)list.get(i);
            if (sGIPropertyDialogObserver.cancel()) continue;
            return false;
        }
        return true;
    }

    protected boolean preview() {
        if (!this.checkInputValues()) {
            return false;
        }
        List list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)list.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                String string = this.getInputErrorMessage();
                String string2 = string != null ? string : DEFAULT_INPUT_ERROR_MESSAGE;
                SGUtility.showIllegalInputErrorMessageDialog(this, string2);
                return false;
            }
            if (sGIPropertyDialogObserver.preview()) continue;
            return false;
        }
        return true;
    }

    private boolean checkInputValues() {
        if (!this.hasValidInputValues()) {
            String string = this.getInputErrorMessage();
            SGUtility.showIllegalInputErrorMessageDialog(this, string);
            return false;
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        this.mInputErrorComponentNameList.clear();
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            if (sGSpinner.hasValidValue()) continue;
            this.addInputErrorDescription(sGSpinner.getDescription());
            bl = false;
        }
        List list2 = this.getNumberTextFieldList();
        for (int i = 0; i < list2.size(); ++i) {
            SGTextField sGTextField = (SGTextField)list2.get(i);
            if (this.getNumber(sGTextField) != null || sGTextField.isIndeterminate()) continue;
            this.addInputErrorDescription(sGTextField.getDescription());
            bl = false;
        }
        return bl;
    }

    protected String getInputErrorMessage() {
        if (this.mInputErrorComponentNameList.size() != 0) {
            String string = "The input values are illegal in the following components:\n";
            ArrayList arrayList = this.mInputErrorComponentNameList;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                string = string + " - " + string2 + "\n";
            }
            return string;
        }
        return this.mInputErrorMessage;
    }

    protected boolean addInputErrorDescription(String string) {
        this.mInputErrorComponentNameList.add(string);
        return true;
    }

    protected boolean setInputErrorMessage(String string) {
        this.mInputErrorMessage = string;
        return true;
    }

    public abstract boolean setPropertiesToListeners(SGIPropertyDialogObserver var1);

    public abstract boolean setDialogProperty();

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }

    protected boolean setValue(SGTextField sGTextField, Object object) {
        return SGUtility.setValue(sGTextField, object);
    }

    protected boolean setValue(SGSpinner sGSpinner, Object object) {
        return SGUtility.setValue(sGSpinner, object);
    }
}

