/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;

public class SGDrawingElementString2DExtended
extends SGDrawingElementString2D {
    private final float SCRIPT_FONTFACTOR = 1.4f;
    private ArrayList mBaseElementList = new ArrayList();
    private ArrayList mSubscriptElementList = new ArrayList();
    private ArrayList mSuperscriptElementList = new ArrayList();

    public SGDrawingElementString2DExtended() {
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string) {
        super(string);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f) {
        super(string, string2, n, f);
        this.createStringElements();
    }

    public SGDrawingElementString2DExtended(String string, String string2, int n, float f, float f2, float f3) {
        super(string, string2, n, f, f2, f3);
        this.createStringElements();
    }

    public void dispose() {
        super.dispose();
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.dispose();
        }
        this.mBaseElementList.clear();
        this.mSuperscriptElementList.clear();
        this.mSubscriptElementList.clear();
        this.mBaseElementList = null;
        this.mSuperscriptElementList = null;
        this.mSubscriptElementList = null;
    }

    public boolean containsSuperscripts() {
        return this.mString.indexOf("^") != -1;
    }

    public boolean containsSubscripts() {
        return this.mString.indexOf("_") != -1;
    }

    public boolean containsSubscriptsOrSuperscripts() {
        return this.containsSubscripts() | this.containsSuperscripts();
    }

    protected ArrayList getAllStringElement() {
        ArrayList arrayList = new ArrayList();
        if (this.mBaseElementList != null) {
            arrayList.addAll(this.mBaseElementList);
        }
        if (this.mSubscriptElementList != null) {
            arrayList.addAll(this.mSubscriptElementList);
        }
        if (this.mSuperscriptElementList != null) {
            arrayList.addAll(this.mSuperscriptElementList);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e != null) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setMagnification(f);
        }
        this.updateLocation();
        return true;
    }

    public boolean setColor(ArrayList arrayList) {
        super.setColor(arrayList);
        ArrayList arrayList2 = this.getAllStringElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList2.get(i);
            sGDrawingElementString.setColor(arrayList);
        }
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.setColor(color);
        }
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)arrayList.get(i);
            sGDrawingElementString.addColor(color);
        }
        return true;
    }

    public boolean setLocation(float f, float f2) {
        float f3 = f - this.getX();
        float f4 = f2 - this.getY();
        super.setLocation(f, f2);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.translate(f3, f4);
        }
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        if (this.mBaseElementList == null) {
            return true;
        }
        Font font = new Font(string, n, (int)f);
        Font font2 = new Font(string, n, (int)(f / 1.4f));
        ArrayList arrayList = this.mBaseElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setFont(font);
        }
        ArrayList arrayList2 = this.mSubscriptElementList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)arrayList2.get(i);
            if (sGDrawingElementString2DExtended == null) continue;
            sGDrawingElementString2DExtended.setFont(font2);
        }
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)arrayList3.get(i);
            if (sGDrawingElementString2DExtended == null) continue;
            sGDrawingElementString2DExtended.setFont(font2);
        }
        this.updateLocation();
        return true;
    }

    public boolean setString(String string) {
        super.setString(string);
        this.createStringElements();
        this.updateLocation();
        return true;
    }

    public boolean setAngle(float f) {
        super.setAngle(f);
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setAngle(f);
        }
        this.updateLocation();
        return true;
    }

    private boolean createStringElementsDirectly() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D(this.mString);
        this.mBaseElementList.add(sGDrawingElementString2D);
        this.mSubscriptElementList.add(null);
        this.mSuperscriptElementList.add(null);
        this.setPropertiesToAllStringElements();
        return true;
    }

    private boolean createStringElements() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        this.mBaseElementList.clear();
        this.mSubscriptElementList.clear();
        this.mSuperscriptElementList.clear();
        if (!this.containsSubscriptsOrSuperscripts()) {
            return this.createStringElementsDirectly();
        }
        String string = this.getString();
        if (!SGUtilityText.getSubscriptAndSuperscriptInfo(string, arrayList3 = new ArrayList(), arrayList2 = new ArrayList(), arrayList = new ArrayList())) {
            return this.createStringElementsDirectly();
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            Object object;
            String string2 = (String)arrayList3.get(i);
            Object object2 = new SGDrawingElementString2D(string2);
            this.mBaseElementList.add(object2);
            string2 = arrayList.get(i);
            if (string2 != null) {
                object2 = string2;
                object = new SGDrawingElementString2DExtended((String)object2);
                this.mSubscriptElementList.add(object);
            } else {
                this.mSubscriptElementList.add(null);
            }
            object2 = arrayList2.get(i);
            if (object2 != null) {
                object = (String)object2;
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended((String)object);
                this.mSuperscriptElementList.add(sGDrawingElementString2DExtended);
                continue;
            }
            this.mSuperscriptElementList.add(null);
        }
        this.setPropertiesToAllStringElements();
        return true;
    }

    private boolean setPropertiesToAllStringElements() {
        float f = this.getMagnification();
        List list = this.getColorList();
        float f2 = this.getFontSize();
        String string = this.getFontName();
        int n = this.getFontStyle();
        float f3 = this.getAngle();
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended;
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.setMagnification(f);
            sGDrawingElementString2D.setColor(list);
            sGDrawingElementString2D.setFont(string, n, f2);
            sGDrawingElementString2D.setAngle(f3);
            sGDrawingElementString2D = (SGDrawingElementString2DExtended)arrayList2.get(i);
            if (sGDrawingElementString2D != null) {
                this.setSubAndSuper((SGDrawingElementString2DExtended)sGDrawingElementString2D, f, string, n, f2, f3, list);
            }
            if ((sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)arrayList3.get(i)) == null) continue;
            this.setSubAndSuper(sGDrawingElementString2DExtended, f, string, n, f2, f3, list);
        }
        return true;
    }

    private void setSubAndSuper(SGDrawingElementString2DExtended sGDrawingElementString2DExtended, float f, String string, int n, float f2, float f3, List list) {
        sGDrawingElementString2DExtended.setMagnification(f);
        sGDrawingElementString2DExtended.setColor(list);
        sGDrawingElementString2DExtended.setFont(string, n, f2 / 1.4f);
        sGDrawingElementString2DExtended.setAngle(f3);
        sGDrawingElementString2DExtended.setPropertiesToAllStringElements();
    }

    protected float getAscent() {
        float f = this.getBaseVisualY();
        float f2 = this.getLeading() / 2.0f;
        float f3 = this.getBaseStrikethroughOffset();
        float f4 = -f + f3;
        float f5 = 0.0f;
        float f6 = 0.0f;
        ArrayList arrayList = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e == null) continue;
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e;
            Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getStringRect();
            float f7 = (float)(-rectangle2D.getHeight()) + f4 - f2;
            f6 = f6 < f7 ? f6 : f7;
        }
        f5 = -f - f6;
        return f5;
    }

    protected float getDescent() {
        float f = this.getAscent();
        float f2 = (float)this.getStringRect().getHeight() - f;
        return f2;
    }

    protected float getLeading() {
        float f = 0.0f;
        ArrayList arrayList = this.mBaseElementList;
        if (arrayList.size() != 0) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(0);
            f = sGDrawingElementString2D.getLeading();
        }
        return f;
    }

    private float getBaseVisualY() {
        float f = 0.0f;
        ArrayList arrayList = this.mBaseElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            float f2 = (float)sGDrawingElementString2D.getStringRect().getY();
            f = f < -f2 ? -f2 : f;
        }
        return -f;
    }

    private float getBaseStrikethroughOffset() {
        float f = 0.0f;
        ArrayList arrayList = this.mBaseElementList;
        if (arrayList.size() != 0) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(0);
            f = sGDrawingElementString2D.getStrikethroughOffset();
        }
        return f;
    }

    public Rectangle2D getStringRect() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = this.getBaseVisualY();
        float f7 = this.getBaseStrikethroughOffset();
        float f8 = -f6 + f7;
        float f9 = this.getLeading() / 2.0f;
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
            float f10 = (float)rectangle2D.getY();
            float f11 = (float)rectangle2D.getX();
            f += (float)rectangle2D.getWidth() + f11;
            float f12 = -f6 + f10 + (float)rectangle2D.getHeight();
            float f13 = f2 = f2 < f12 ? f12 : f2;
            if (i == 0) {
                f5 = (float)rectangle2D.getX();
            }
            sGDrawingElementString2D = arrayList3.get(i);
            float f14 = 0.0f;
            if (sGDrawingElementString2D != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
                Rectangle2D rectangle2D2 = sGDrawingElementString2DExtended.getStringRect();
                f12 = (float)rectangle2D2.getX();
                float f15 = (float)(-rectangle2D2.getHeight()) + f8 - f9;
                f3 = f3 < f15 ? f3 : f15;
                f14 += (float)rectangle2D2.getWidth() + f12;
            }
            Object e = arrayList2.get(i);
            f11 = 0.0f;
            if (e != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e;
                Rectangle2D rectangle2D3 = sGDrawingElementString2DExtended.getStringRect();
                float f16 = (float)rectangle2D3.getX();
                float f17 = (float)rectangle2D3.getHeight() + f8 + f9;
                f4 = f4 > f17 ? f4 : f17;
                f11 += (float)rectangle2D3.getWidth() + f16;
            }
            if (sGDrawingElementString2D == null && e == null) continue;
            f += Math.max(f14, f11);
        }
        f4 = f4 > f2 ? f4 - f2 : 0.0f;
        f2 = f2 - f3 + f4;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f5, -(-f6 - f3), f, f2);
        return float_;
    }

    public Rectangle2D getElementBounds() {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getAllStringElement();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList2.get(i);
            arrayList.add(sGDrawingElementString2D.getElementBounds());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    protected boolean updateStringRect() {
        super.updateStringRect();
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.updateStringRect();
        }
        return true;
    }

    protected boolean updateLocation() {
        float f = this.getAngle();
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = this.getX();
        float f5 = this.getY();
        float f6 = this.getAscent();
        float f7 = this.getBaseStrikethroughOffset();
        float f8 = f6 + f7;
        float f9 = this.getLeading() / 2.0f;
        ArrayList arrayList = this.mBaseElementList;
        ArrayList arrayList2 = this.mSubscriptElementList;
        ArrayList arrayList3 = this.mSuperscriptElementList;
        float f10 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            Rectangle2D rectangle2D = sGDrawingElementString2D.getStringRect();
            float f11 = (float)rectangle2D.getX();
            float f12 = f6 + (float)rectangle2D.getY();
            sGDrawingElementString2D.setLocation(f4 + f10 * f2 + f12 * f3, f5 - f10 * f3 + f12 * f2);
            f10 += (float)rectangle2D.getWidth() + f11;
            sGDrawingElementString2D = arrayList3.get(i);
            float f13 = 0.0f;
            if (sGDrawingElementString2D != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)sGDrawingElementString2D;
                Rectangle2D rectangle2D2 = sGDrawingElementString2DExtended.getStringRect();
                float f14 = (float)rectangle2D2.getX();
                float f15 = (float)(-rectangle2D2.getHeight()) + f8 - f9;
                sGDrawingElementString2DExtended.setLocation(f4 + f10 * f2 + f15 * f3, f5 - f10 * f3 + f15 * f2);
                sGDrawingElementString2DExtended.updateLocation();
                f13 += (float)rectangle2D2.getWidth() + f14;
            }
            Object e = arrayList2.get(i);
            f12 = 0.0f;
            if (e != null) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)e;
                Rectangle2D rectangle2D3 = sGDrawingElementString2DExtended.getStringRect();
                float f16 = (float)rectangle2D3.getX();
                float f17 = f8 + f9;
                sGDrawingElementString2DExtended.setLocation(f4 + f10 * f2 + f17 * f3, f5 - f10 * f3 + f17 * f2);
                sGDrawingElementString2DExtended.updateLocation();
                f12 += (float)rectangle2D3.getWidth() + f16;
            }
            if (!(sGDrawingElementString2D != null | e != null)) continue;
            f10 += Math.max(f13, f12);
        }
        return true;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        ArrayList arrayList = this.getAllStringElement();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingElementString2D sGDrawingElementString2D = (SGDrawingElementString2D)arrayList.get(i);
            sGDrawingElementString2D.paintElement(graphics2D);
        }
    }
}

