/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupSymbol
extends SGElementGroupSXY
implements SGISymbolConstants,
SGIElementGroupConstants {
    protected float mSymbolSize;
    protected int mSymbolType;
    protected double mAngle;
    protected Color mLineColor;
    protected float mLineWidth;

    public void dispose() {
        super.dispose();
        this.mLineColor = null;
    }

    public float getSize() {
        return this.mSymbolSize;
    }

    public float getSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getSize(), string);
    }

    public int getType() {
        return this.mSymbolType;
    }

    public double getAngle() {
        return this.mAngle;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean setSize(float f) {
        this.mSymbolSize = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
            }
        }
        return true;
    }

    public boolean setSize(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setSize((float)d);
    }

    public boolean setType(int n) {
        this.mSymbolType = n;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setType(this.mSymbolType);
            }
        }
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
            }
        }
        return true;
    }

    public boolean setLineColor(String string) {
        Color color = SGUtilityText.getColor(string);
        if (color == null) {
            return false;
        }
        return this.setLineColor(color);
    }

    public boolean setLineColor(String string, String string2, String string3) {
        Color color = SGUtilityText.getColor(string, string2, string3);
        if (color == null) {
            return false;
        }
        return this.setLineColor(color);
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
                sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementSymbol sGDrawingElementSymbol = (SGDrawingElementSymbol)this.getDrawingElementInstance();
        sGDrawingElementSymbol.setVisible(this.isVisible());
        sGDrawingElementSymbol.setSize(this.getSize());
        sGDrawingElementSymbol.setType(this.getType());
        sGDrawingElementSymbol.setColor(this.getColorList());
        sGDrawingElementSymbol.setLineColor(this.getLineColor());
        sGDrawingElementSymbol.setLineWidth(this.getLineWidth());
        return sGDrawingElementSymbol;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementSymbol)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementSymbol sGDrawingElementSymbol = (SGDrawingElementSymbol)sGDrawingElement;
        this.setType(sGDrawingElementSymbol.getType());
        this.setSize(sGDrawingElementSymbol.getSize());
        this.setLineWidth(sGDrawingElementSymbol.getLineWidth());
        this.setLineColor(sGDrawingElementSymbol.getLineColor());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                if (!sGDrawingElementSymbol2D.isVisible()) continue;
                sGDrawingElementSymbol2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Symbol";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Size", Float.toString(this.mSymbolSize * 0.035277776f) + "cm");
        element.setAttribute("Type", SGDrawingElementSymbol.getSymbolTypeName(this.mSymbolType));
        element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        Serializable serializable;
        String string = null;
        Number number = null;
        Color color = null;
        Object var5_5 = null;
        List list = null;
        string = element.getAttribute("Size");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setSize(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementSymbol.getSymbolTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerColor")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            serializable = (Color)list.get(0);
            if (!this.setColor((Color)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineWidth")).length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            serializable = color;
            if (!this.setLineColor((Color)serializable)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement getDrawingElementInstance() {
        return new SGDrawingElementSymbol2D();
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        this.initDrawingElement(n);
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < n; ++i) {
            ((SGDrawingElementSymbol)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementSymbol2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementSymbol2D.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
            sGDrawingElementSymbol2D.setMagnification(this.mMagnification);
            sGDrawingElementSymbol2D.setColor(this.mColorList);
            sGDrawingElementSymbol2D.setSize(this.mSymbolSize);
            sGDrawingElementSymbol2D.setType(this.mSymbolType);
            sGDrawingElementSymbol2D.setLineWidth(this.mLineWidth);
            sGDrawingElementSymbol2D.setLineColor(this.mLineColor);
        }
        return true;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        Float f = symbolProperties.getSize();
        if (f == null) {
            return false;
        }
        this.setSize(f.floatValue());
        Integer n = symbolProperties.getSymbolType();
        if (n == null) {
            return false;
        }
        this.setType(n);
        Float f2 = symbolProperties.getLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setLineWidth(f2.floatValue());
        Color color = symbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.setLineColor(color);
        return true;
    }

    public static class SymbolProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            return this.mSymbolProperties.equals(symbolProperties.mSymbolProperties);
        }

        public Float getSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getSymbolType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Float getLineWidth() {
            return this.mSymbolProperties.getLineWidth();
        }

        public Color getLineColor() {
            return this.mSymbolProperties.getLineColor();
        }

        public void setSize(float f) {
            this.mSymbolProperties.setSize(f);
        }

        public void setSymbolType(int n) {
            this.mSymbolProperties.setSymbolType(n);
        }

        public void setLineWidth(float f) {
            this.mSymbolProperties.setLineWidth(f);
        }

        public void setLineColor(Color color) {
            this.mSymbolProperties.setLineColor(color);
        }
    }
}

