/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGITwoDimensionalData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILegendConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIVXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDataDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILegendDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogVXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGLegendElement
extends SGFigureElement
implements SGILegendElement,
SGIStringConstants,
CaretListener,
ActionListener,
SGILegendConstants,
SGIFigureDrawingElementConstants,
SGIMovable,
SGISelectable,
SGILegendDialogObserver {
    private SGIGraphElement mGraphElement = null;
    private SGIAxisElement mAxisElement = null;
    private ArrayList mLegendList = new ArrayList();
    private SGAxis mXAxis = null;
    private SGAxis mYAxis = null;
    private float mLegendX = 0.0f;
    private float mLegendY = 0.0f;
    private float mLegendWidth = 0.0f;
    private float mLegendHeight = 0.0f;
    private float mFontSize;
    private int mFontStyle;
    private String mFontName;
    private Color mFontColor;
    private float mSymbolSpan;
    private float mFrameLineWidth;
    private Color mFrameLineColor;
    private Color mBackgroundColor;
    private boolean mLegendVisibleFlag = true;
    private boolean mFrameVisibleFlag = true;
    private boolean mLegendTransparentFlag = true;
    private SGProperties mTemporaryProperties = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGLegendDialog mLegendDialog;
    private SGPropertyDialogSXYData mSXYDataDialog;
    private SGPropertyDialogVXYData mVXYDataDialog;
    private JTextField mTextField = new JTextField();
    public static final String MENUCMD_HIDE = "Hide";
    private boolean mStartFlag = true;
    private boolean mSelectedFlag = false;
    private static final float MARGIN_HORIZONTAL = 6.0f;
    private static final float MARGIN_VERTICAL = 6.0f;
    private static final float marginTop = 6.0f;
    private static final float marginBottom = 6.0f;
    private static final float marginLeft = 6.0f;
    private static final float marginRight = 6.0f;
    private static final float spaceDataAndString = 6.0f;
    private static final float spaceLegend = 6.0f;
    private ElementGroupSetInLegend mFocusedGroup = null;
    private Point mLegendLocation = null;

    public SGLegendElement() {
        this.initEditField();
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setLegendVisible(true);
        this.setFontName("Serif");
        this.setFontSize(16.0f, "pt");
        this.setFontStyle(0);
        this.setFontColor(SGILegendConstants.DEFAULT_LEGEND_FONT_COLOR);
        this.setFrameVisible(true);
        this.setFrameLineWidth(0.5f, "pt");
        this.setFrameLineColor(SGILegendConstants.DEFAULT_LEGEND_FRAME_COLOR);
        this.setBackgroundColor(SGILegendConstants.DEFAULT_LEGEND_BACKGROUND_COLOR);
        this.setBackgroundTransparent(false);
        this.setSymbolSpan(2.0f, "cm");
        this.createPopupMenu();
        return true;
    }

    public void dispose() {
        super.dispose();
        this.mLegendDialog.dispose();
        this.mLegendDialog = null;
        this.mAxisElement = null;
        this.mFocusedGroup = null;
        this.mGraphElement = null;
        if (this.mSXYDataDialog != null) {
            this.mSXYDataDialog.dispose();
            this.mSXYDataDialog = null;
        }
        if (this.mVXYDataDialog != null) {
            this.mVXYDataDialog.dispose();
            this.mVXYDataDialog = null;
        }
        this.mTextField = null;
        this.mPopupMenu = null;
        this.mBackgroundColor = null;
        this.mFontName = null;
        this.mFrameLineColor = null;
        this.mLegendList.clear();
        this.mLegendList = null;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Legend --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_HIDE);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return true;
    }

    public String toString() {
        return new String("SGLegendElement");
    }

    public String getClassDescription() {
        return "Legend";
    }

    public boolean addData(SGData sGData, String string) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        if (!super.addData(sGData, string)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        this.updateAllDrawingElements();
        this.updateAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        if (!super.addData(sGData, string, sGProperties)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        if (!elementGroupSetInLegend.setWholeProperties(sGProperties)) {
            return false;
        }
        this.updateAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    private ElementGroupSetInLegend createGroupSet(SGData sGData, String string) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.createLegendElement(sGData, string);
        if (elementGroupSetInLegend == null) {
            return null;
        }
        elementGroupSetInLegend.setMagnification(this.mMagnification);
        this.mLegendList.add(elementGroupSetInLegend);
        return elementGroupSetInLegend;
    }

    private void onStartup(SGData sGData) {
        float f = this.getGraphRectX() + this.getGraphRectWidth() - this.mMagnification * this.getLegendWidth();
        float f2 = this.getGraphRectY();
        this.setLegendLocation(f, f2);
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        this.mXAxis = sGAxis;
        this.mYAxis = sGAxis2;
        this.createDataDialog(sGData);
        this.updateAllDrawingElements();
        this.mStartFlag = false;
    }

    private void createDataDialog(SGData sGData) {
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            if (this.mSXYDataDialog == null) {
                this.mSXYDataDialog = new SGPropertyDialogSXYData(this.mDialogOwner, true);
            }
        } else if (sGData instanceof SGIVXYTypeData && this.mVXYDataDialog == null) {
            this.mVXYDataDialog = new SGPropertyDialogVXYData(this.mDialogOwner, true);
        }
    }

    private SGPropertyDialog showDataDialog(ElementGroupSetInLegend elementGroupSetInLegend) {
        SGDataDialog sGDataDialog = null;
        if (elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            sGDataDialog = this.mSXYDataDialog;
        } else if (elementGroupSetInLegend instanceof ElementGroupSetInLegendVXY) {
            sGDataDialog = this.mVXYDataDialog;
        }
        sGDataDialog.setLocation(this.mDialogOwner.getLocation());
        sGDataDialog.addPropertyDialogObserver(elementGroupSetInLegend);
        sGDataDialog.setDialogProperty();
        sGDataDialog.setColorButtonBorder(true);
        elementGroupSetInLegend.prepare();
        sGDataDialog.setVisible(true);
        sGDataDialog.removeAllPropertyDialogObserver();
        this.notifyToRoot();
        return sGDataDialog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ElementGroupSetInLegend createLegendElement(SGData sGData, String string) {
        ElementGroupSetInLegend elementGroupSetInLegend = null;
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInLegend = new ElementGroupSetInLegendSXY();
        } else {
            if (!(sGData instanceof SGIVXYTypeData)) return null;
            elementGroupSetInLegend = new ElementGroupSetInLegendVXY();
        }
        elementGroupSetInLegend.setName(string);
        if (!(sGData instanceof SGITwoDimensionalData)) return null;
        Object object = this.mAxisElement;
        SGAxis sGAxis = object.getAxisInPlane(0);
        Object object2 = object.getAxisInPlane(1);
        Object object3 = object.getAxisInPlane(2);
        SGAxis sGAxis2 = object.getAxisInPlane(3);
        Object object4 = null;
        SGAxis sGAxis3 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            object4 = sGAxis;
            sGAxis3 = object3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            object4 = object2;
            sGAxis3 = object3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            object4 = sGAxis;
            sGAxis3 = sGAxis2;
        } else {
            if (!"Left-Bottom".equals("Right-Top")) return null;
            object4 = object2;
            sGAxis3 = sGAxis2;
        }
        elementGroupSetInLegend.setXAxis((SGAxis)object4);
        elementGroupSetInLegend.setYAxis(sGAxis3);
        object = this.mGraphElement.getDrawingElementList(sGData);
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                object2 = (SGDrawingElement)((ArrayList)object).get(i);
                if (object2 instanceof SGDrawingElementErrorBar) {
                    elementGroupSetInLegend.addDrawingElementGroup(4);
                    continue;
                }
                if (object2 instanceof SGDrawingElementLine) {
                    elementGroupSetInLegend.addDrawingElementGroup(0);
                    continue;
                }
                if (object2 instanceof SGDrawingElementRectangle) {
                    elementGroupSetInLegend.addDrawingElementGroup(2);
                    object3 = (ElementGroupBar)elementGroupSetInLegend.getBarGroup();
                    sGAxis2 = elementGroupSetInLegend.getXAxis();
                    object4 = null;
                    if (sGData instanceof SGISXYTypeData) {
                        object4 = ((SGISXYTypeData)((Object)sGData)).getXValueArray();
                    } else if (sGData instanceof SGISXYTypeMultipleData) {
                        object4 = ((SGISXYTypeMultipleData)((Object)sGData)).getXValueArray();
                    }
                    double d = Double.MAX_VALUE;
                    for (int j = 0; j < ((Object)object4).length - 1; ++j) {
                        double d2 = Math.abs((double)(object4[j + 1] - object4[j]));
                        if (!(d2 < d)) continue;
                        d = d2;
                    }
                    d = this.getNumberInRangeOrder(d, sGAxis2);
                    ((SGElementGroupBar)object3).setWidthValue(d);
                    continue;
                }
                if (object2 instanceof SGDrawingElementSymbol) {
                    elementGroupSetInLegend.addDrawingElementGroup(1);
                    continue;
                }
                if (!(object2 instanceof SGDrawingElementString)) throw new Error();
                elementGroupSetInLegend.addDrawingElementGroup(5);
            }
        } else {
            if (!(sGData instanceof SGIVXYTypeData)) throw new Error("This data-type is not defined.");
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                object2 = (SGDrawingElement)((ArrayList)object).get(i);
                if (!(object2 instanceof SGDrawingElementArrow)) {
                    throw new Error();
                }
                elementGroupSetInLegend.addDrawingElementGroup(3);
            }
            ElementGroupSetInLegendVXY elementGroupSetInLegendVXY = (ElementGroupSetInLegendVXY)elementGroupSetInLegend;
            object2 = (SGIVXYTypeData)((Object)sGData);
            float f = SGUtilityForFigureElement.getInitialMagnitudePerCM((SGIVXYTypeData)object2, this);
            elementGroupSetInLegendVXY.setMagnitudePerCM(f);
            elementGroupSetInLegendVXY.setDirectionInvariant(object2.isPolar());
        }
        boolean bl = this.mGraphElement.getVisibleInLegendFlag(sGData);
        elementGroupSetInLegend.setVisibleInLegend(bl);
        elementGroupSetInLegend.initPropertiesHistory();
        return elementGroupSetInLegend;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        return this.getLegendData(sGData).getDrawingElementList();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        if (this.isSelected()) {
            arrayList.add(this);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mName;
        }
        return null;
    }

    public boolean isDataVisible(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        return elementGroupSetInLegend.isVisible();
    }

    protected ElementGroupSetInLegend getLegendData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        ArrayList arrayList2 = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
            boolean bl = sGElementGroup.isVisible();
            arrayList.add(new Boolean(bl));
        }
        return arrayList;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getXAxis();
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getYAxis();
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mZAxis;
        }
        return null;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public float getLegendX() {
        return this.mGraphRectX + this.mLegendX * this.mMagnification;
    }

    public float getLegendY() {
        return this.mGraphRectY + this.mLegendY * this.mMagnification;
    }

    public float getLegendWidth() {
        return this.mLegendWidth;
    }

    public float getLegendHeight() {
        return this.mLegendHeight;
    }

    public Point2D getLegendLocation() {
        Point2D.Float float_ = new Point2D.Float(this.getLegendX(), this.getLegendY());
        return float_;
    }

    public boolean setLegendLocation(float f, float f2) {
        this.mLegendX = (f - this.mGraphRectX) / this.mMagnification;
        this.mLegendY = (f2 - this.mGraphRectY) / this.mMagnification;
        return true;
    }

    public boolean setXValue(double d) {
        float f;
        SGAxis sGAxis = this.mXAxis;
        double d2 = this.calcValue(this.getComponent().getX(), sGAxis, true);
        if (d == (d2 = this.getNumberInRangeOrder(d2, sGAxis))) {
            f = this.mLegendX;
        } else {
            float f2 = this.calcLocation(d, sGAxis, true);
            f = (f2 - this.mGraphRectX) / this.mMagnification;
        }
        this.mLegendX = f;
        this.updateAllDrawingElements();
        return true;
    }

    public boolean setYValue(double d) {
        float f;
        SGAxis sGAxis = this.mYAxis;
        double d2 = this.calcValue(this.getComponent().getY(), sGAxis, false);
        if (d == (d2 = this.getNumberInRangeOrder(d2, sGAxis))) {
            f = this.mLegendY;
        } else {
            float f2 = this.calcLocation(d, sGAxis, false);
            f = (f2 - this.mGraphRectY) / this.mMagnification;
        }
        this.mLegendY = f;
        this.updateAllDrawingElements();
        return true;
    }

    public boolean hasValidXAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mXAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getXValue();
        return sGAxis.isValidValue(d);
    }

    public boolean hasValidYAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mYAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getYValue();
        return sGAxis.isValidValue(d);
    }

    public void translate(float f, float f2) {
        this.setLegendLocation(this.getLegendX() + f, this.getLegendY() + f2);
        this.updateAllDrawingElements();
    }

    public double getXValue() {
        SGAxis sGAxis = this.mXAxis;
        double d = this.calcValue(this.getLegendX(), sGAxis, true);
        if (d == Double.NaN) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    public double getYValue() {
        SGAxis sGAxis = this.mYAxis;
        double d = this.calcValue(this.getLegendY(), sGAxis, false);
        if (d == Double.NaN) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    private boolean initEditField() {
        this.mTextField.setVisible(false);
        this.mTextField.addActionListener(this);
        this.mTextField.addCaretListener(this);
        return true;
    }

    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mTextField);
    }

    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        if (this.mTextField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedGroup();
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    private boolean createDialog() {
        SGLegendDialog sGLegendDialog;
        this.mLegendDialog = sGLegendDialog = new SGLegendDialog(this.mDialogOwner, true);
        return true;
    }

    protected SGProperties getCommonProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.x = this.mLegendX;
        legendCommonProperties.y = this.mLegendY;
        legendCommonProperties.visible = this.isLegendVisible();
        legendCommonProperties.frameLineVisible = this.isFrameLineVisible();
        legendCommonProperties.frameLineWidth = this.getFrameLineWidth();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isBackgroundTransparent();
        legendCommonProperties.fontName = this.getFontName();
        legendCommonProperties.fontSize = this.getFontSize();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getStringColor();
        legendCommonProperties.symbolSpan = this.getSymbolSpan();
        legendCommonProperties.xAxis = this.mXAxis;
        legendCommonProperties.yAxis = this.mYAxis;
        return legendCommonProperties;
    }

    public SGProperties getDataProperties(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getWholeProperties();
        }
        return null;
    }

    public SGProperties getProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties = (LegendCommonProperties)this.getCommonProperties();
        return legendCommonProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        LegendCommonProperties legendCommonProperties = (LegendCommonProperties)sGProperties;
        return this.setCommonProperties(legendCommonProperties);
    }

    protected SGData getData(int n) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData = (SGData)this.mDataList.get(i);
            if (sGData.hashCode() != n) continue;
            return sGData;
        }
        return null;
    }

    private boolean setCommonProperties(LegendCommonProperties legendCommonProperties) {
        this.mLegendX = legendCommonProperties.x;
        this.mLegendY = legendCommonProperties.y;
        this.setLegendVisible(legendCommonProperties.visible);
        this.setFrameVisible(legendCommonProperties.frameLineVisible);
        this.setFrameLineWidth(legendCommonProperties.frameLineWidth);
        this.setFrameLineColor(legendCommonProperties.frameLineColor);
        this.setBackgroundColor(legendCommonProperties.backgroundColor);
        this.setBackgroundTransparent(legendCommonProperties.transparent);
        this.setFontName(legendCommonProperties.fontName);
        this.setFontSize(legendCommonProperties.fontSize);
        this.setFontStyle(legendCommonProperties.fontStyle);
        this.setFontColor(legendCommonProperties.stringColor);
        this.setSymbolSpan(legendCommonProperties.symbolSpan);
        this.mXAxis = legendCommonProperties.xAxis;
        this.mYAxis = legendCommonProperties.yAxis;
        return true;
    }

    private boolean updateAllDrawingElements() {
        int n;
        float f;
        float f2;
        int n2;
        int n3;
        float f3 = this.mMagnification;
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        int n4 = arrayList.size();
        ElementGroupSetInLegend[] elementGroupSetInLegendArray = new ElementGroupSetInLegend[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3] = (ElementGroupSetInLegend)arrayList.get(n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3].createStringElement();
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n4];
        for (int i = 0; i < n4; ++i) {
            rectangle2DArray[i] = elementGroupSetInLegendArray[i].getStringBounds();
        }
        float[] fArray = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = (float)rectangle2DArray[i].getHeight();
        }
        float f4 = 0.0f;
        for (int i = 0; i < n4; ++i) {
            float f5 = (float)rectangle2DArray[i].getWidth();
            if (!(f5 > f4)) continue;
            f4 = f5;
        }
        float f6 = this.getSymbolSpan();
        for (int i = 0; i < n4; ++i) {
            float f7 = elementGroupSetInLegendArray[i].getMaxDataElementWidth() / f3;
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        float f8 = f6 + f4 / f3 + 6.0f;
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = elementGroupSetInLegendArray[i].getMaxDataElementHeight();
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray2[i] = (float)Math.max(dArray[i], (double)fArray[i]);
        }
        Rectangle2D[] rectangle2DArray2 = new Rectangle2D[n4];
        float f9 = this.getLegendY() + f3 * 6.0f;
        float f10 = this.getLegendX() + f3 * 6.0f;
        float f11 = f3 * f8;
        for (n2 = 0; n2 < n4; ++n2) {
            float f12 = f9;
            f2 = fArray2[n2];
            rectangle2DArray2[n2] = new Rectangle2D.Float(f10, f12, f11, f2);
            f9 += f2 + f3 * 6.0f;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            elementGroupSetInLegendArray[n2].setRect(rectangle2DArray2[n2]);
        }
        float f13 = f3 * f6;
        for (int i = 0; i < n4; ++i) {
            f2 = (float)rectangle2DArray2[i].getX();
            float f14 = (float)rectangle2DArray2[i].getY();
            f = (float)elementGroupSetInLegendArray[i].getMaxDataElementHeight();
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f14, f13, f);
            elementGroupSetInLegendArray[i].setDrawingElementBounds(float_);
        }
        float f15 = 0.0f;
        for (n = 0; n < n4; ++n) {
            f15 += fArray2[n] / f3;
        }
        f15 += (float)(n4 - 1) * 6.0f;
        for (n = 0; n < n4; ++n) {
            elementGroupSetInLegendArray[n].createDrawingElement();
        }
        float f16 = this.getLegendX() + f3 * (6.0f + f6 + 6.0f);
        for (int i = 0; i < n4; ++i) {
            f = (float)rectangle2DArray2[i].getY() - 0.5f * fArray[i] + 0.5f * fArray2[i] + (float)rectangle2DArray[i].getY();
            elementGroupSetInLegendArray[i].getStringElement().setLocation(f16, f);
        }
        this.mLegendWidth = 6.0f + f8 + 6.0f;
        this.mLegendHeight = 6.0f + f15 + 6.0f;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (!this.terminateEditField()) {
            return false;
        }
        return this.updateAllDrawingElements();
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isLegendVisible()) {
            Cloneable cloneable;
            if (!this.mLegendTransparentFlag) {
                cloneable = this.getLegendRect();
                graphics2D.setPaint(this.getBackgroundColor());
                graphics2D.fill((Shape)((Object)cloneable));
            }
            cloneable = this.getVisibleTotallyLegendList();
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)((ArrayList)cloneable).get(i);
                elementGroupSetInLegend.paintGraphics2D(graphics2D);
            }
            if (this.mFrameVisibleFlag & ((ArrayList)cloneable).size() != 0) {
                this.drawLegendFrameLines(graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundAllObjects & ((ArrayList)cloneable).size() != 0) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject(arrayList, graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundFocusedObjects & this.isSelected()) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList, graphics2D);
            }
        }
    }

    private void updateSymbolsVisibleAroundFocusedObjects() {
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        this.setSymbolsVisibleAroundFocusedObjects(arrayList.size() != 0);
    }

    private ArrayList getAnchorPointList() {
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        Rectangle2D rectangle2D = this.getLegendRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
        Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
        Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
        arrayList.add(float_);
        arrayList.add(float_2);
        arrayList.add(float_3);
        arrayList.add(float_4);
        return arrayList;
    }

    private void drawLegendFrameLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        if (arrayList.size() == 0) {
            return;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth, 0, 0));
        graphics2D.draw(this.getLegendRect());
    }

    public boolean contains(int n, int n2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mLegendWidth, this.mLegendHeight);
        return float_.contains(n, n2);
    }

    public boolean removeData(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        this.mLegendList.remove(elementGroupSetInLegend);
        return super.removeData(sGData);
    }

    protected boolean removeGraph(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mLegendList.get(i))) continue;
            this.mLegendList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIAxisElement)) {
            if (sGIFigureElement instanceof SGIGraphElement) {
                SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
                bl = this.synchronizeToGraphElement(sGIGraphElement, string);
            } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement || sGIFigureElement instanceof SGIShapeElement)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIGraphElement sGIGraphElement, String string) {
        SGIDisposable sGIDisposable;
        SGIDisposable sGIDisposable2;
        SGData sGData;
        int n;
        List list = sGIGraphElement.getDataList();
        if (list.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGIDisposable> arrayList = new ArrayList<SGIDisposable>();
        ArrayList<SGProperties> arrayList2 = new ArrayList<SGProperties>();
        block0: for (n = 0; n < list.size(); ++n) {
            sGData = (SGData)list.get(n);
            for (int i = this.mDataList.size() - 1; i >= 0; --i) {
                SGData sGData2 = (SGData)this.mDataList.get(i);
                if (!sGData.equals(sGData2)) continue;
                sGIDisposable2 = (SGData)this.mDataList.remove(i);
                arrayList.add(sGIDisposable2);
                sGIDisposable = (SGElementGroupSet)this.mLegendList.remove(i);
                arrayList2.add((SGProperties)sGIDisposable);
                continue block0;
            }
        }
        this.mDataList = arrayList;
        this.mLegendList = arrayList2;
        for (n = arrayList.size() - 1; n >= 0; --n) {
            sGData = (SGData)arrayList.get(n);
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(n);
            boolean bl = false;
            sGIDisposable2 = sGIGraphElement.getDataProperties(sGData);
            if (!sGIDisposable2.equals(sGIDisposable = elementGroupSetInLegend.getWholeProperties()) & !string.equals("Notify the change on undo")) {
                bl = true;
            }
            if (elementGroupSetInLegend.setWholeProperties((SGProperties)sGIDisposable2)) continue;
            return false;
        }
        this.updateAllDrawingElements();
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    public boolean zoom(float f) {
        if (!super.zoom(f)) {
            return false;
        }
        if (!this.terminateEditField()) {
            return false;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            elementGroupSetInLegend.zoom(f);
        }
        this.updateAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        Rectangle2D rectangle2D2 = this.getLegendRect();
        if (rectangle2D2.getWidth() < Double.MIN_VALUE || rectangle2D2.getHeight() < Double.MIN_VALUE) {
            return true;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D);
        if (this.isLegendVisible()) {
            arrayList.add(rectangle2D2);
        }
        Rectangle2D rectangle2D3 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!this.isLegendVisible()) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        Rectangle2D rectangle2D = this.getLegendRect();
        if (rectangle2D.contains(n, n2)) {
            ArrayList arrayList = this.getVisibleTotallyLegendList();
            if (n3 == 1) {
                this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                        Rectangle2D rectangle2D2 = elementGroupSetInLegend.getStringElement().getElementBounds();
                        if (!rectangle2D2.contains(n, n2) || !SwingUtilities.isLeftMouseButton(mouseEvent) || !this.isSelected()) continue;
                        this.showEditField(elementGroupSetInLegend);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.mPopupMenu.show(this.getComponent(), n, n2);
                }
            } else if (n3 == 2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                    ArrayList arrayList2 = elementGroupSetInLegend.getElementGroupList();
                    for (int j = arrayList2.size() - 1; j >= 0; --j) {
                        SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(j);
                        if (!sGElementGroup.isVisible()) continue;
                        SGDrawingElement[] sGDrawingElementArray = sGElementGroup.getDrawingElementArray();
                        for (int k = 0; k < sGDrawingElementArray.length; ++k) {
                            boolean bl;
                            if (!sGDrawingElementArray[k].isVisible() || !(bl = sGDrawingElementArray[k].contains(n, n2)) || !SwingUtilities.isLeftMouseButton(mouseEvent) || n3 != 2) continue;
                            elementGroupSetInLegend.onMouseClicked(mouseEvent);
                            this.showDataDialog(elementGroupSetInLegend);
                            return true;
                        }
                    }
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.setPropertiesOfSelectedObjects();
                }
            }
            return true;
        }
        return false;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mLegendDialog;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public float getFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
    }

    public float getFrameLineWidth() {
        return this.mFrameLineWidth;
    }

    public float getFrameLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFrameLineWidth(), string);
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Color getStringColor() {
        return this.mFontColor;
    }

    public float getSymbolSpan() {
        return this.mSymbolSpan;
    }

    public float getSymbolSpan(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getSymbolSpan(), string);
    }

    public boolean setSymbolSpan(float f) {
        this.mSymbolSpan = f;
        return true;
    }

    public boolean setSymbolSpan(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.5) {
            return false;
        }
        if (d > 6.0) {
            return false;
        }
        this.setSymbolSpan((float)SGUtilityText.convertToPoint(f, string));
        return true;
    }

    private boolean showEditField(ElementGroupSetInLegend elementGroupSetInLegend) {
        this.mFocusedGroup = elementGroupSetInLegend;
        JTextField jTextField = this.mTextField;
        Rectangle2D rectangle2D = elementGroupSetInLegend.getStringElement().getElementBounds();
        float f = this.getMagnification() * this.getFontSize();
        int n = (int)(rectangle2D.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D.getWidth() + (double)f);
        int n4 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)f);
        jTextField.setFont(font);
        jTextField.setForeground(this.mFontColor);
        jTextField.setText(elementGroupSetInLegend.getName());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean isMoved() {
        boolean bl = (int)this.mLegendX == (int)this.mLegendLocation.getX();
        boolean bl2 = (int)this.mLegendY == (int)this.mLegendLocation.getY();
        boolean bl3 = !bl || !bl2;
        return bl3;
    }

    private boolean terminateEditField() {
        this.commitEdit();
        this.hideEditField();
        this.clearFocusedGroup();
        this.repaint();
        return true;
    }

    private boolean commitEdit() {
        char c;
        String string = this.mTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        if (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\u3000')) {
            return false;
        }
        String string2 = this.mFocusedGroup.getName();
        String string3 = string;
        this.mFocusedGroup.setName(string3);
        this.updateAllDrawingElements();
        if (!string2.equals(string3)) {
            this.mFocusedGroup.setChanged(true);
        }
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mTextField.setText("");
        this.mTextField.setVisible(false);
        return true;
    }

    private boolean clearFocusedGroup() {
        this.mFocusedGroup = null;
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (!this.isLegendVisible()) {
            return false;
        }
        if (this.mTextField.isVisible()) {
            this.terminateEditField();
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.mLegendLocation = new Point((int)this.mLegendX, (int)this.mLegendY);
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            return true;
        }
        this.clearFocusedGroup();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (this.isSelected()) {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            this.translate(n, n2);
            this.mPressedPoint = mouseEvent.getPoint();
            if (!this.updateAllDrawingElements()) {
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (this.mLegendLocation != null && this.isMoved()) {
            this.mChangedFlag = true;
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getPoint())) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        SGProperties sGProperties;
        SGProperties sGProperties2;
        if (this.isSelected() && (sGProperties2 = this.mTemporaryProperties) != null && !(sGProperties = this.getProperties()).equals(sGProperties2)) {
            this.setChanged(true);
        }
        return true;
    }

    public Rectangle2D getLegendRect() {
        float f = this.mMagnification;
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), f * this.mLegendWidth, f * this.mLegendHeight);
        return float_;
    }

    public boolean isResizable(double d, double d2) {
        Rectangle2D rectangle2D = this.getLegendRect();
        return !(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mTextField.getText();
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mTextField.getWidth()) {
            this.mTextField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.getFontSize())), this.mTextField.getHeight());
        }
    }

    public boolean onDrawingElement(int n, int n2) {
        if (this.isLegendVisible() && this.getLegendRect().contains(n, n2)) {
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    public boolean setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
        return true;
    }

    public int getXAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mXAxis);
    }

    public int getYAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mYAxis);
    }

    public boolean setXAxisLocation(int n) {
        if (n != 0 & n != 1) {
            return false;
        }
        this.mXAxis = this.getAxis(n);
        return true;
    }

    public boolean setYAxisLocation(int n) {
        if (n != 2 & n != 3) {
            return false;
        }
        this.mYAxis = this.getAxis(n);
        return true;
    }

    private SGAxis getAxis(int n) {
        return this.mAxisElement.getAxisInPlane(n);
    }

    public void setVisible(boolean bl) {
        this.mLegendVisibleFlag = bl;
    }

    public boolean setLegendVisible(boolean bl) {
        this.setVisible(bl);
        return true;
    }

    public boolean setBackgroundTransparent(boolean bl) {
        this.mLegendTransparentFlag = bl;
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
        return true;
    }

    public boolean setFrameLineWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "pt");
        if (d < 0.25) {
            return false;
        }
        if (d > 6.0) {
            return false;
        }
        return this.setFrameLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setFontSize(float f) {
        this.setFont(this.getFontName(), this.getFontStyle(), f);
        return true;
    }

    public boolean setFontSize(float f, String string) {
        double d = SGUtilityText.convert(f, string, "pt");
        if (d < 8.0) {
            return false;
        }
        if (d > 96.0) {
            return false;
        }
        return this.setFontSize((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFontStyle(int n) {
        this.setFont(this.getFontName(), n, this.getFontSize());
        return true;
    }

    public boolean setFontColor(Color color) {
        this.mFontColor = color;
        return true;
    }

    public boolean setFontName(String string) {
        this.setFont(string, this.getFontStyle(), this.getFontSize());
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.updateAllDrawingElements();
        return true;
    }

    private SGData getData(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = this.mLegendList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend2 = (ElementGroupSetInLegend)arrayList.get(i);
            if (!elementGroupSetInLegend2.equals(elementGroupSetInLegend)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean isVisible() {
        int n;
        int n2 = this.mLegendVisibleFlag;
        int n3 = 0;
        ArrayList arrayList = this.mLegendList;
        for (n = 0; n < arrayList.size(); ++n) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(n);
            boolean bl = elementGroupSetInLegend.isVisibleTotally();
            if (!bl) continue;
            n3 = 1;
            break;
        }
        n = n2 & n3;
        return n != 0;
    }

    public boolean isLegendVisible() {
        return this.isVisible();
    }

    public boolean isFrameLineVisible() {
        return this.mFrameVisibleFlag;
    }

    public boolean isBackgroundTransparent() {
        return this.mLegendTransparentFlag;
    }

    public Rectangle2D getRectOfGroup(SGElementGroup sGElementGroup) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(j);
                if (!sGElementGroup2.equals(sGElementGroup)) continue;
                return elementGroupSetInLegend.mDataRect;
            }
        }
        return null;
    }

    public Rectangle2D getRectOfGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInLegend)) continue;
            return elementGroupSetInLegend.mDataRect;
        }
        return null;
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    private ElementGroupErrorBar getGroupErrorBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupErrorBar)) continue;
            return (ElementGroupErrorBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupArrow getGroupArrow(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupArrow)) continue;
            return (ElementGroupArrow)sGElementGroup;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mTextField)) {
            this.terminateEditField();
            return;
        }
        if (string.equals(MENUCMD_HIDE)) {
            this.setLegendVisible(false);
            this.repaint();
            this.setChanged(true);
            this.notifyToRoot();
            return;
        }
        if (string.equals("Property")) {
            this.setPropertiesOfSelectedObjects();
        }
    }

    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.updateAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.updateAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean preview() {
        this.updateAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.updateAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.updateAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    protected ArrayList getVisibleLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisible()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ArrayList getVisibleTotallyLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisibleTotally()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ElementGroupSetInLegend getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mLegendList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.mLegendList.add(elementGroupSetInLegend);
        int n = this.setProperty(element, elementGroupSetInLegend);
        if (n == 1) {
            return false;
        }
        this.updateAllDrawingElements();
        this.mStartFlag = false;
        this.createDataDialog(sGData);
        return true;
    }

    protected ElementGroupSetInLegend getGroupSetNewInstance(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = null;
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInLegend = new ElementGroupSetInLegendSXY();
        } else if (sGData instanceof SGIVXYTypeData) {
            elementGroupSetInLegend = new ElementGroupSetInLegendVXY();
        }
        return elementGroupSetInLegend;
    }

    private int setProperty(Element element, ElementGroupSetInLegend elementGroupSetInLegend) {
        SGData sGData = this.getData(elementGroupSetInLegend);
        int n = 1;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInLegend.setName(string2);
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        elementGroupSetInLegend.setVisibleInLegend(bl);
        if (sGData instanceof SGITwoDimensionalData) {
            n = this.setPropertyOfElementGroupSetInLegendForTwoDimensionalData(element, elementGroupSetInLegend, sGData);
        }
        return 0;
    }

    private int setPropertyOfElementGroupSetInLegendForTwoDimensionalData(Element element, ElementGroupSetInLegend elementGroupSetInLegend, SGData sGData) {
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        String string = null;
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        SGAxis sGAxis = sGIAxisElement.getAxis(string);
        if (sGAxis == null) {
            return 1;
        }
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        SGAxis sGAxis2 = sGIAxisElement.getAxis(string);
        if (sGAxis2 == null) {
            return 1;
        }
        elementGroupSetInLegend.setXAxis(sGAxis);
        elementGroupSetInLegend.setYAxis(sGAxis2);
        int n = 1;
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            n = this.setPropertyOfElementGroupSetInLegendSXY(element, elementGroupSetInLegendSXY, sGData);
        } else if (sGData instanceof SGIVXYTypeData) {
            ElementGroupSetInLegendVXY elementGroupSetInLegendVXY = (ElementGroupSetInLegendVXY)elementGroupSetInLegend;
            n = this.setPropertyOfElementGroupSetInLegendVXY(element, elementGroupSetInLegendVXY, sGData);
        }
        return n;
    }

    private int setPropertyOfElementGroupSetInLegendSXY(Element element, ElementGroupSetInLegendSXY elementGroupSetInLegendSXY, SGData sGData) {
        Object object;
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        Object var6_5 = null;
        SGElementGroupSXY sGElementGroupSXY = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getBarGroup();
        if (!sGElementGroupSXY.readProperty(element2)) {
            return 1;
        }
        ElementGroupBar elementGroupBar = (ElementGroupBar)sGElementGroupSXY;
        float f = elementGroupBar.getRectangleWidth();
        if (f != 0.0f) {
            float f2 = f / this.mGraphRectWidth;
            object = elementGroupSetInLegendSXY.getXAxis();
            double d = ((SGAxis)object).getMaxValue();
            double d2 = ((SGAxis)object).getMinValue();
            double d3 = (d - d2) * (double)f2;
            d3 = this.getNumberInRangeOrder(d3, (SGAxis)object);
            elementGroupBar.setWidthValue(d3);
        }
        if (sGData instanceof SGISXYTypeData) {
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            nodeList = element.getElementsByTagName("ErrorBar");
            if (nodeList.getLength() == 1) {
                if (sGISXYTypeData.isErrorValueHolding()) {
                    Element element3;
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(4)) {
                        return 1;
                    }
                    object = (ElementGroupErrorBar)elementGroupSetInLegendSXY.getErrorBarGroup();
                    if (!((ElementGroupErrorBar)object).readProperty(element3 = (Element)nodeList.item(0))) {
                        return 1;
                    }
                    if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else if (nodeList.getLength() == 0) {
                if (sGISXYTypeData.isErrorValueHolding()) {
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(4)) {
                        return 1;
                    }
                    object = (ElementGroupErrorBar)elementGroupSetInLegendSXY.getErrorBarGroup();
                    if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else {
                return 1;
            }
        }
        if ((nodeList = element.getElementsByTagName("Line")).getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(0)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getLineGroup();
        if (!sGElementGroupSXY.readProperty(element4)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(1)) {
            return 1;
        }
        object = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getSymbolGroup();
        if (!sGElementGroupSXY.readProperty((Element)object)) {
            return 1;
        }
        if (sGData instanceof SGISXYTypeData) {
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            nodeList = element.getElementsByTagName("TickLabels");
            if (nodeList.getLength() == 1) {
                if (sGISXYTypeData.isStringArrayHolding()) {
                    Element element5;
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(5)) {
                        return 1;
                    }
                    ElementGroupTickLabels elementGroupTickLabels = (ElementGroupTickLabels)elementGroupSetInLegendSXY.getTickLabelGroup();
                    if (!elementGroupTickLabels.readProperty(element5 = (Element)nodeList.item(0))) {
                        return 1;
                    }
                    if (!elementGroupTickLabels.setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else if (nodeList.getLength() == 0) {
                if (sGISXYTypeData.isStringArrayHolding()) {
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(5)) {
                        return 1;
                    }
                    ElementGroupTickLabels elementGroupTickLabels = (ElementGroupTickLabels)elementGroupSetInLegendSXY.getTickLabelGroup();
                    if (!elementGroupTickLabels.setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else {
                return 1;
            }
        }
        elementGroupSetInLegendSXY.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInLegendVXY(Element element, ElementGroupSetInLegendVXY elementGroupSetInLegendVXY, SGData sGData) {
        String string = null;
        Float f = null;
        SGElementGroupArrow sGElementGroupArrow = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Arrow");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendVXY.addDrawingElementGroup(3)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupArrow = elementGroupSetInLegendVXY.getArrowGroup();
        if (!((SGElementGroup)sGElementGroupArrow).readProperty(element2)) {
            return 1;
        }
        string = element.getAttribute("MagnitudePerCM");
        if (string.length() != 0) {
            f = SGUtilityText.getFloat(string);
            if (f == null) {
                return 1;
            }
            float f2 = ((Number)f).floatValue();
            elementGroupSetInLegendVXY.setMagnitudePerCM(f2);
        }
        elementGroupSetInLegendVXY.initPropertiesHistory();
        return 0;
    }

    public String getTagName() {
        return "Legend";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("LegendVisible", Boolean.toString(this.mLegendVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getLocationName(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getLocationName(this.mYAxis));
        element.setAttribute("XValue", Double.toString(this.getXValue()));
        element.setAttribute("YValue", Double.toString(this.getYValue()));
        element.setAttribute("FrameVisible", Boolean.toString(this.mFrameVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(this.mFrameLineWidth) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute("BackgroundTransparent", Boolean.toString(this.mLegendTransparentFlag));
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontSize", Float.toString(this.mFontSize) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mFontColor));
        element.setAttribute("SymbolSpan", Float.toString(this.mSymbolSpan * 0.035277776f) + "cm");
        return true;
    }

    public Element createElement(Document document) {
        return this.createThisElement(document);
    }

    public boolean readProperty(Element element) {
        float f;
        String string;
        SGAxis sGAxis;
        String string2 = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string2 = element.getAttribute("LegendVisible");
        if (string2.length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return false;
            }
            if (!this.setLegendVisible(bl)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("XAxisPosition")).length() != 0) {
            this.mXAxis = sGAxis = this.mAxisElement.getAxis(string2);
        }
        if ((string2 = element.getAttribute("YAxisPosition")).length() != 0) {
            this.mYAxis = sGAxis = this.mAxisElement.getAxis(string2);
        }
        if ((string2 = element.getAttribute("XValue")).length() != 0) {
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.mXAxis.isValidValue(d)) {
                return false;
            }
            if (!this.setXValue(d)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("YValue")).length() != 0) {
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            if (!this.setYValue(d)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return false;
            }
            if (!this.setFrameVisible(bl)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameLineWidth")).length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            if (!this.setFrameLineWidth(number.floatValue(), stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameLineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string2);
            if (color == null) {
                return false;
            }
            if (!this.setFrameLineColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("BackgroundColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string2);
            if (color == null) {
                return false;
            }
            if (!this.setBackgroundColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("BackgroundTransparent")).length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return false;
            }
            if (!this.setBackgroundTransparent(bl)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FontName")).length() != 0 && !this.setFontName(string = string2)) {
            return false;
        }
        string2 = element.getAttribute("FontSize");
        if (string2.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FontStyle")).length() != 0) {
            int n = SGUtilityText.getFontStyle(string2);
            if (n == -1) {
                return false;
            }
            if (!this.setFontStyle(n)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("StringColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string2);
            if (color == null) {
                return false;
            }
            if (!this.setFontColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("SymbolSpan")).length() != 0) {
            number = SGUtilityText.getLengthInPoint(string2);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
        } else {
            number = new Float(2.0f);
            f = number.floatValue();
        }
        return this.setSymbolSpan(f);
    }

    private boolean setDirectlyBefore() {
        return this.prepare();
    }

    private boolean setDirectlyAfter() {
        this.commit();
        this.updateAllDrawingElements();
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    public boolean setAxisXDirectly(int n) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setXAxisLocation(n)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setAxisYDirectly(int n) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setYAxisLocation(n)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setXValueDirectly(double d) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setXValue(d)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setYValueDirectly(double d) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setYValue(d)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setLegendVisibleDirectly(boolean bl) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setLegendVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFontNameDirectly(String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFontName(string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFontStyleDirectly(int n) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFontStyle(n)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFontSizeDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFontSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFontColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFontColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFrameVisibleDirectly(boolean bl) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFrameVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFrameLineWidthDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFrameLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFrameColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFrameLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setBackgroundTransparentDirectly(boolean bl) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setBackgroundTransparent(bl)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setBackgroundColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setBackgroundColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setSymbolSpanDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setSymbolSpan(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    private boolean readProperty(SGElementGroup sGElementGroup, Element element) {
        String string = element.getAttribute("Visible");
        if (string.length() != 0) {
            Boolean bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            sGElementGroup.setVisible(bl);
        }
        return true;
    }

    public static class LegendCommonProperties
    extends SGProperties {
        float x;
        float y;
        boolean visible;
        boolean frameLineVisible;
        float frameLineWidth;
        Color frameLineColor;
        String fontName;
        float fontSize;
        int fontStyle;
        Color stringColor;
        Color backgroundColor;
        boolean transparent;
        float symbolSpan;
        SGAxis xAxis;
        SGAxis yAxis;

        public void dispose() {
            this.frameLineColor = null;
            this.fontName = null;
            this.stringColor = null;
            this.stringColor = null;
            this.xAxis = null;
            this.yAxis = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LegendCommonProperties)) {
                return false;
            }
            LegendCommonProperties legendCommonProperties = (LegendCommonProperties)object;
            if (legendCommonProperties.x != this.x) {
                return false;
            }
            if (legendCommonProperties.y != this.y) {
                return false;
            }
            if (legendCommonProperties.visible != this.visible) {
                return false;
            }
            if (legendCommonProperties.frameLineVisible != this.frameLineVisible) {
                return false;
            }
            if (legendCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!legendCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!legendCommonProperties.fontName.equals(this.fontName)) {
                return false;
            }
            if (legendCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (legendCommonProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!legendCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (!legendCommonProperties.backgroundColor.equals(this.backgroundColor)) {
                return false;
            }
            if (legendCommonProperties.transparent != this.transparent) {
                return false;
            }
            if (legendCommonProperties.symbolSpan != this.symbolSpan) {
                return false;
            }
            if (!legendCommonProperties.xAxis.equals(this.xAxis)) {
                return false;
            }
            return legendCommonProperties.yAxis.equals(this.yAxis);
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("visible=" + this.visible + ", ");
            string = string + new String("frameLineVisible=" + this.frameLineVisible + ", ");
            string = string + new String("frameLineWidth=" + this.frameLineWidth + ", ");
            string = string + new String("frameLineColor=" + this.frameLineColor + ", ");
            string = string + new String("fontName=" + this.fontName + ", ");
            string = string + new String("fontSize=" + this.fontSize + ", ");
            string = string + new String("fontStyle=" + this.fontStyle + ", ");
            string = string + new String("stringColor=" + this.stringColor + ", ");
            string = string + new String("innerColor=" + this.backgroundColor + ", ");
            string = string + new String("transparent=" + this.transparent + ", ");
            string = string + new String("]");
            return string;
        }
    }

    class ElementGroupTickLabels
    extends SGElementGroupTickLabel
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        ElementGroupTickLabels() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setFontName("Serif");
            this.setFontStyle(0);
            this.setFontSize(16.0f, "pt");
            this.setAngle("Horizontal");
            this.setColor(SGISXYDataConstants.DEFAULT_TICK_LABEL_FONT_COLOR);
            return true;
        }

        protected SGDrawingElement getDrawingElementInstance() {
            return new SGDrawingElementString2DExtended();
        }

        public boolean createDrawingElementInLegend() {
            return true;
        }

        public float getPreferredWidth() {
            return 0.0f;
        }

        public float getPreferredHeight() {
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 0;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private static final float DEFAULT_ERROR_BAR_HEIGHT = 10.0f;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        ElementGroupErrorBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f, "pt");
            this.setHeadSize(0.25f, "cm");
            this.setHeadType(8);
            this.setLineWidth(1.0f, "pt");
            this.setErrorBarStyle(1);
            this.setColor(SGISXYDataConstants.DEFAULT_ERROR_BAR_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * this.getHeadSize();
        }

        public float getPreferredHeight() {
            float f;
            float f2;
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            SGElementGroupSymbol sGElementGroupSymbol = elementGroupSetInLegendSXY.getSymbolGroup();
            SGElementGroupBar sGElementGroupBar = elementGroupSetInLegendSXY.getBarGroup();
            float f3 = 0.0f;
            if (sGElementGroupSymbol.isVisible() | sGElementGroupBar.isVisible()) {
                f2 = sGElementGroupSymbol.isVisible() ? ((ILegendElement)((Object)sGElementGroupSymbol)).getPreferredHeight() : 0.0f;
                f = sGElementGroupBar.isVisible() ? ((ILegendElement)((Object)sGElementGroupBar)).getPreferredHeight() : 0.0f;
                f3 = f2 > f ? f2 : f;
            } else {
                f3 = 10.0f;
            }
            f2 = this.getMagnification();
            f = 1.2f * f2 * f3;
            float f4 = f2 * this.getHeadSize();
            return f + 2.0f * f4;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            float f;
            SGTuple2f sGTuple2f = new SGTuple2f();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f2 = this.getMagnification();
            float f3 = f2 * SGLegendElement.this.getSymbolSpan();
            sGTuple2f.x = f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            sGTuple2f2.x = f;
            float f4 = f2 * this.getHeadSize();
            float f5 = (float)rectangle2D.getY() + 0.5f * f4;
            float f6 = (float)rectangle2D2.getHeight() - f4;
            int n = this.getErrorBarStyle();
            switch (n) {
                case 1: {
                    sGTuple2f.y = f5 + f6;
                    sGTuple2f2.y = f5;
                    break;
                }
                case 3: {
                    sGTuple2f.y = f5 + f6;
                    sGTuple2f2.y = f5 + 0.5f * f6;
                    break;
                }
                case 2: {
                    sGTuple2f.y = f5 + 0.5f * f6;
                    sGTuple2f2.y = f5;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2});
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupArrow
    extends SGElementGroupArrow
    implements ILegendElement,
    SGIVXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();
        private SGDrawingElementString2DExtended mMagnitudeString = new SGDrawingElementString2DExtended();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        protected ElementGroupArrow() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setLineWidth(1.5f, "pt");
            this.setLineType(1);
            this.setColor(SGIVXYDataConstants.DEFAULT_COLOR);
            this.setStartHeadType(-1);
            this.setEndHeadType(10);
            this.setHeadSize(0.4f, "cm");
            this.setHeadOpenAngle(0.5235988f);
            this.setHeadCloseAngle(1.0471976f);
            this.mMagnitudeString.setFontName("Serif");
            this.mMagnitudeString.setFontStyle(0);
            this.mMagnitudeString.setFontSize(16.0f, "pt");
            this.mMagnitudeString.setColor(SGILegendConstants.DEFAULT_LEGEND_FONT_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGLegendElement.this.getSymbolSpan();
        }

        private Rectangle2D getDataElementBounds() {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray != null) {
                if (sGDrawingElementArray.length == 0) {
                    return new Rectangle2D.Float();
                }
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementArrow2D.getElementBounds();
                return rectangle2D;
            }
            return new Rectangle2D.Float();
        }

        public float getPreferredHeight() {
            float f = 1.2f * (float)this.getDataElementBounds().getHeight();
            float f2 = (float)this.mMagnitudeString.getElementBounds().getHeight();
            float f3 = f + 2.0f * f2;
            return f3;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = this.getMagnification() * this.getHeadSize();
            int n = this.getStartHeadType();
            int n2 = this.getEndHeadType();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D2.getWidth();
            float f5 = (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = f2;
            if (this.doShiftX(n)) {
                sGTuple2f.x += f;
            }
            sGTuple2f.y = f3 + 0.5f * f5;
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = f2 + f4;
            if (this.doShiftX(n2)) {
                sGTuple2f2.x -= f;
            }
            sGTuple2f2.y = sGTuple2f.y;
            if (!this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2})) {
                return false;
            }
            this.updateMagnitudeString();
            return true;
        }

        private boolean doShiftX(int n) {
            boolean bl = n != 10 & n != 8 & n != -1;
            return bl;
        }

        private boolean updateMagnitudeString() {
            ElementGroupSetInLegendVXY elementGroupSetInLegendVXY = (ElementGroupSetInLegendVXY)this.mGroupSet;
            float f = elementGroupSetInLegendVXY.getMagnitudePerCM();
            float f2 = SGLegendElement.this.getSymbolSpan("cm");
            float f3 = f * f2;
            float f4 = (float)SGUtilityNumber.getNumberInNumberOrder(f3, f3, 3);
            this.mMagnitudeString.setString(Float.toString(f4));
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            Rectangle2D rectangle2D3 = this.mMagnitudeString.getElementBounds();
            Rectangle2D rectangle2D4 = this.getDataElementBounds();
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)(rectangle2D.getX() + 0.5 * (rectangle2D2.getWidth() - rectangle2D3.getWidth()));
            sGTuple2f.y = (float)(rectangle2D4.getY() + rectangle2D4.getHeight()) + 2.0f;
            this.mMagnitudeString.setLocation(sGTuple2f);
            return true;
        }

        public boolean zoom(float f) {
            super.zoom(f);
            this.mMagnitudeString.zoom(f);
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            this.mMagnitudeString.paint(graphics2D, rectangle2D);
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setType(1);
            this.setSize(0.3f, "cm");
            this.setColor(SGISXYDataConstants.DEFAULT_SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f, "pt");
            this.setLineColor(SGISXYDataConstants.DEFAULT_SYMBOL_LINE_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getDataElementSize();
        }

        public float getPreferredHeight() {
            return 1.2f * this.getDataElementSize();
        }

        private float getDataElementSize() {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray != null) {
                if (sGDrawingElementArray.length == 0) {
                    return 0.0f;
                }
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds().getBounds2D();
                return (float)rectangle2D.getHeight();
            }
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            float f2 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
            return this.setLocation(new SGTuple2f[]{sGTuple2f});
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        protected ElementGroupBar() {
            this.init();
        }

        private void init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setColor(SGISXYDataConstants.DEFAULT_BAR_COLOR);
            this.setEdgeLineWidth(0.5f, "pt");
            this.setEdgeLineColor(SGISXYDataConstants.DEFAULT_BAR_EDGE_LINE_COLOR);
        }

        public float getPreferredWidth() {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            Rectangle2D rectangle2D = elementGroupSetInLegendSXY.mDrawingString.getElementBounds();
            return (float)rectangle2D.getHeight();
        }

        public float getPreferredHeight() {
            return this.getPreferredWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            float f;
            float f2 = f = this.getPreferredWidth();
            this.setRectangleWidth(f2);
            this.setRectangleHeight(f);
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f3 = (float)rectangle2D.getX() + 0.5f * ((float)rectangle2D2.getWidth() - f2);
            float f4 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f(f3, f4);
            this.setLocation(new SGTuple2f[]{sGTuple2f});
            return true;
        }

        public boolean initDrawingElement(int n) {
            super.initDrawingElement(n);
            this.setHorizontal(true);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                throw new IllegalArgumentException();
            }
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                sGDrawingElementBar2D.setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
            }
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f, "pt");
            this.setLineType(1);
            this.setColor(SGISXYDataConstants.DEFAULT_LINE_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGLegendElement.this.getSymbolSpan();
        }

        public float getPreferredHeight() {
            return this.getMagnification() * this.getLineWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 2;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D2.getWidth();
            sGTuple2f2.y = sGTuple2f.y;
            return this.setLocation(new SGTuple2f[]{sGTuple2f, sGTuple2f2});
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGLegendElement.this.readProperty(this, element);
        }
    }

    class ElementGroupSetInLegendVXY
    extends ElementGroupSetInLegend
    implements SGIVXYDataDialogObserver,
    SGIVXYDataConstants {
        private float mMagnitudePerCM = 1.0f;
        private boolean mDirectionFixedFlag;

        protected ElementGroupSetInLegendVXY() {
        }

        public float getMagnitudePerCM() {
            return this.mMagnitudePerCM;
        }

        public boolean setMagnitudePerCM(float f) {
            this.mMagnitudePerCM = f;
            return true;
        }

        public boolean isDirectionInvariant() {
            return this.mDirectionFixedFlag;
        }

        public boolean setDirectionInvariant(boolean bl) {
            this.mDirectionFixedFlag = bl;
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            ElementGroupArrow elementGroupArrow = null;
            if (n != 3) {
                throw new Error();
            }
            elementGroupArrow = new ElementGroupArrow();
            this.addDrawingElementGroup(elementGroupArrow);
            return true;
        }

        boolean synchronizeDrawingElements(ArrayList arrayList) {
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                ArrayList arrayList2 = null;
                if (sGDrawingElement instanceof SGDrawingElementArrow) {
                    arrayList2 = this.getArrowGroups();
                }
                if (arrayList2 == null) continue;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SGProperties sGProperties;
                    SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(j);
                    SGDrawingElement sGDrawingElement2 = sGElementGroup.getDrawingElement();
                    SGProperties sGProperties2 = sGDrawingElement.getProperties();
                    if (!sGProperties2.equals(sGProperties = sGDrawingElement2.getProperties())) {
                        bl = true;
                    }
                    sGElementGroup.setProperty(sGDrawingElement);
                }
            }
            return bl;
        }

        void paintSymbol(Graphics2D graphics2D) {
            ElementGroupArrow elementGroupArrow = SGLegendElement.this.getGroupArrow(this);
            if (elementGroupArrow != null && elementGroupArrow.isVisible()) {
                elementGroupArrow.paintElement(graphics2D);
            }
        }

        boolean onMouseClicked(MouseEvent mouseEvent) {
            return true;
        }

        public int getXAxisLocation() {
            return SGLegendElement.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        public int getYAxisLocation() {
            return SGLegendElement.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        public float getLineWidth(String string) {
            return this.getArrowGroup().getLineWidth(string);
        }

        public int getLineType() {
            return this.getArrowGroup().getLineType();
        }

        public Color getColor() {
            return this.getArrowGroup().getColor();
        }

        public float getHeadSize(String string) {
            return this.getArrowGroup().getHeadSize(string);
        }

        public float getHeadOpenAngle() {
            return this.getArrowGroup().getHeadOpenAngle();
        }

        public float getHeadCloseAngle() {
            return this.getArrowGroup().getHeadCloseAngle();
        }

        public int getStartHeadType() {
            return this.getArrowGroup().getStartHeadType();
        }

        public int getEndHeadType() {
            return this.getArrowGroup().getEndHeadType();
        }

        public boolean setXAxisLocation(int n) {
            this.mXAxis = this.getAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            this.mYAxis = this.getAxis(n);
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            return this.getArrowGroup().setLineWidth(f, string);
        }

        public boolean setLineType(int n) {
            return this.getArrowGroup().setLineType(n);
        }

        public boolean setColor(Color color) {
            return this.getArrowGroup().setColor(color);
        }

        public boolean setHeadSize(float f, String string) {
            return this.getArrowGroup().setHeadSize(f, string);
        }

        public boolean setHeadOpenAngle(float f) {
            return this.getArrowGroup().setHeadOpenAngle(f);
        }

        public boolean setHeadCloseAngle(float f) {
            return this.getArrowGroup().setHeadCloseAngle(f);
        }

        public boolean setStartHeadType(int n) {
            return this.getArrowGroup().setStartHeadType(n);
        }

        public boolean setEndHeadType(int n) {
            return this.getArrowGroup().setEndHeadType(n);
        }

        public boolean hasValidAngle(Number number, Number number2) {
            float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
            float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
            return f < f2;
        }

        public SGProperties getProperties() {
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = new SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties();
            if (!this.getProperties(elementGroupSetInVXYGraphProperties)) {
                return null;
            }
            return elementGroupSetInVXYGraphProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)sGProperties;
            elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor = this.getMagnitudePerCM();
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInFigureElement.ElementGroupSetInVXYGraphProperties)sGProperties;
            this.setMagnitudePerCM(elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor);
            return true;
        }
    }

    class ElementGroupSetInLegendSXY
    extends ElementGroupSetInLegend
    implements SGISXYDataDialogObserver,
    SGISXYDataConstants {
        private int mSelectedTabIndex = -1;

        protected ElementGroupSetInLegendSXY() {
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        void paintSymbol(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            ElementGroupErrorBar elementGroupErrorBar;
            ElementGroupBar elementGroupBar = SGLegendElement.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((elementGroupErrorBar = SGLegendElement.this.getGroupErrorBar(this)) != null && elementGroupErrorBar.isVisible()) {
                elementGroupErrorBar.paintElement(graphics2D);
            }
            if ((elementGroupLine = SGLegendElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGLegendElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f) {
            return this.getLineGroup().setLineWidth(f);
        }

        public boolean setLineWidth(float f, String string) {
            return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f) {
            return this.getSymbolGroup().setSize(f);
        }

        public boolean setSymbolSize(float f, String string) {
            return this.setSymbolSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolLineWidth(float f) {
            return this.getSymbolGroup().setLineWidth(f);
        }

        public boolean setSymbolLineWidth(float f, String string) {
            return this.setSymbolLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolInnerColor(Color color) {
            return this.getSymbolGroup().setColor(color);
        }

        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        public boolean setBarWidthValue(double d) {
            return this.getBarGroup().setWidthValue(d);
        }

        public boolean setBarEdgeLineWidth(float f) {
            return this.getBarGroup().setEdgeLineWidth(f);
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            return this.setBarEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setBarInnerColor(Color color) {
            return this.getBarGroup().setColor(color);
        }

        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGLegendElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBarBaselineValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            this.getErrorBarGroup().setHeadType(n);
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            this.getErrorBarGroup().setHeadSize(f);
            return true;
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            return this.setErrorBarHeadSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f) {
            this.getErrorBarGroup().setLineWidth(f);
            return true;
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            return this.setErrorBarLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarStyle(int n) {
            this.getErrorBarGroup().setErrorBarStyle(n);
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f) {
            return this.getTickLabelGroup().setFontSize(f);
        }

        public boolean setTickLabelFontSize(float f, String string) {
            return this.setTickLabelFontSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            float f = bl ? 0.0f : 0.5235988f;
            return this.getTickLabelGroup().setAngle(f);
        }

        boolean onMouseClicked(MouseEvent mouseEvent) {
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroup sGElementGroup = null;
            if (n == 0) {
                sGElementGroup = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroup = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (n == 3) {
                sGElementGroup = new ElementGroupArrow();
            } else if (n == 4) {
                sGElementGroup = new ElementGroupErrorBar();
            } else if (n == 5) {
                sGElementGroup = new ElementGroupTickLabels();
            } else {
                throw new Error();
            }
            this.addDrawingElementGroup(sGElementGroup);
            return true;
        }

        public int getXAxisLocation() {
            return SGLegendElement.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        public int getYAxisLocation() {
            return SGLegendElement.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        public boolean setXAxisLocation(int n) {
            this.mXAxis = this.getAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            this.mYAxis = this.getAxis(n);
            return true;
        }

        boolean synchronizeDrawingElements(ArrayList arrayList) {
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                ArrayList arrayList2 = null;
                if (sGDrawingElement instanceof SGDrawingElementErrorBar) {
                    arrayList2 = this.getErrorBarGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementLine) {
                    arrayList2 = this.getLineGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                    arrayList2 = this.getSymbolGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                    arrayList2 = this.getBarGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementString) {
                    arrayList2 = this.getTickLabelGroups();
                }
                if (arrayList2 == null) continue;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SGProperties sGProperties;
                    SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(j);
                    SGDrawingElement sGDrawingElement2 = sGElementGroup.getDrawingElement();
                    SGProperties sGProperties2 = sGDrawingElement.getProperties();
                    if (!sGProperties2.equals(sGProperties = sGDrawingElement2.getProperties())) {
                        bl = true;
                    }
                    sGElementGroup.setProperty(sGDrawingElement);
                }
            }
            return bl;
        }
    }

    abstract class ElementGroupSetInLegend
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIUndoable,
    SGIDataPropertyDialogObserver {
        protected Rectangle2D mDataRect = null;
        protected SGDrawingElementString2DExtended mDrawingString = null;
        protected SGProperties mTemporaryProperties = null;
        protected SGDataDialog mDialog = null;

        protected ElementGroupSetInLegend() {
        }

        private boolean isVisibleTotally() {
            return this.isVisible() & this.isVisibleInLegend();
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        private boolean createStringElement() {
            String string = this.mName;
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGLegendElement.this.mFontName, SGLegendElement.this.mFontStyle, SGLegendElement.this.mFontSize);
            sGDrawingElementString2DExtended.setColor(SGLegendElement.this.mFontColor);
            sGDrawingElementString2DExtended.setMagnification(this.getMagnification());
            this.mDrawingString = sGDrawingElementString2DExtended;
            return true;
        }

        private boolean paintString(Graphics2D graphics2D) {
            if (this.mDrawingString != null) {
                this.mDrawingString.paintElement(graphics2D);
            }
            return true;
        }

        private SGDrawingElementString2DExtended getStringElement() {
            return this.mDrawingString;
        }

        private Rectangle2D getStringBounds() {
            if (this.mDrawingString == null) {
                return null;
            }
            Rectangle2D rectangle2D = this.getStringElement().getElementBounds();
            float f = this.getStringElement().getAscent();
            float f2 = (float)rectangle2D.getHeight();
            float f3 = f2 - f;
            float f4 = this.getStringElement().getStrikethroughOffset();
            float f5 = f + f4;
            float f6 = f2 - f5;
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (f6 > f5) {
                f8 = f7 = f6 - f5;
            } else {
                f7 = f5 - f6;
            }
            rectangle2D.setRect(0.0, f8, rectangle2D.getWidth(), rectangle2D.getHeight() + (double)f7);
            return rectangle2D;
        }

        private Rectangle2D getRect() {
            return this.mDataRect;
        }

        private void setRect(Rectangle2D rectangle2D) {
            this.mDataRect = rectangle2D;
        }

        public float getMaxDataElementWidth() {
            float f = 0.0f;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                float f2 = iLegendElement.getPreferredWidth();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public double getMaxDataElementHeight() {
            double d = 0.0;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement;
                double d2;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible() || !((d2 = (double)(iLegendElement = (ILegendElement)arrayList.get(i)).getPreferredHeight()) > d)) continue;
                d = d2;
            }
            return d;
        }

        void setDrawingElementBounds(Rectangle2D rectangle2D) {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible()) continue;
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                iLegendElement.setDataElementBounds(rectangle2D);
            }
        }

        private boolean createDrawingElement() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible()) continue;
                ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
                iLegendElement.createDrawingElementInLegend();
            }
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            graphics2D.setPaint(SGLegendElement.this.mFontColor);
            this.paintString(graphics2D);
            this.paintSymbol(graphics2D);
        }

        abstract void paintSymbol(Graphics2D var1);

        abstract boolean onMouseClicked(MouseEvent var1);

        boolean addDrawingElementGroup(SGElementGroup sGElementGroup) {
            ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
            iLegendElement.setElementGroupSet(this);
            sGElementGroup.initDrawingElement(iLegendElement.getNumberOfPoints());
            if (!sGElementGroup.setPropertiesOfDrawingElements()) {
                return false;
            }
            sGElementGroup.setMagnification(this.getMagnification());
            this.mDrawingElementGroupList.add(sGElementGroup);
            return true;
        }

        abstract boolean synchronizeDrawingElements(ArrayList var1);

        protected SGAxis getAxis(int n) {
            return SGLegendElement.this.mAxisElement.getAxisInPlane(n);
        }

        public SGPropertyDialog getPropertyDialog() {
            return this.mDialog;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public boolean commit() {
            SGLegendElement.this.updateSymbolsVisibleAroundFocusedObjects();
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            if (!SGLegendElement.this.updateAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!SGLegendElement.this.updateAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            SGLegendElement.this.updateSymbolsVisibleAroundFocusedObjects();
            if (!SGLegendElement.this.updateAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public String getTagName() {
            return "";
        }

        public boolean writeProperty(Element element) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            SGLegendElement.this.updateAllDrawingElements();
            SGLegendElement.this.notifyChange();
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIAxisElement sGIAxisElement = SGLegendElement.this.mAxisElement;
            elementGroupSetPropertiesInFigureElement.xAxis = sGIAxisElement.getLocationInCube(this.getXAxis());
            elementGroupSetPropertiesInFigureElement.yAxis = sGIAxisElement.getLocationInCube(this.getYAxis());
            elementGroupSetPropertiesInFigureElement.zAxis = sGIAxisElement.getLocationInCube(this.getZAxis());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIAxisElement sGIAxisElement = SGLegendElement.this.mAxisElement;
            this.setXAxis(sGIAxisElement.getAxisInCube(elementGroupSetPropertiesInFigureElement.xAxis));
            this.setYAxis(sGIAxisElement.getAxisInCube(elementGroupSetPropertiesInFigureElement.yAxis));
            this.setZAxis(sGIAxisElement.getAxisInCube(elementGroupSetPropertiesInFigureElement.zAxis));
            return true;
        }

        public boolean setMementoBackward() {
            if (!super.setMementoBackward()) {
                return false;
            }
            SGLegendElement.this.updateAllDrawingElements();
            SGLegendElement.this.notifyChangeOnUndo();
            return true;
        }

        public boolean setMementoForward() {
            if (!super.setMementoForward()) {
                return false;
            }
            SGLegendElement.this.updateAllDrawingElements();
            SGLegendElement.this.notifyChangeOnUndo();
            return true;
        }

        public void notifyToRoot() {
            SGLegendElement.this.notifyToRoot();
        }
    }

    private static interface ILegendElement {
        public float getPreferredWidth();

        public float getPreferredHeight();

        public void setDataElementBounds(Rectangle2D var1);

        public boolean createDrawingElementInLegend();

        public int getNumberOfPoints();

        public boolean setElementGroupSet(ElementGroupSetInLegend var1);
    }
}

