
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;

/**
 * A class which controlls available components.
 *
 */
public class SGComponentGroup implements SGIDisposable
{
	// A flag whether this group is enabled.
	private boolean mEnableFlag = true;

	// The list of SGComponentGroupElement objects.
	private ArrayList mElementList = new ArrayList();

	/**
	 * The default constructor.
	 *
	 */
	public SGComponentGroup()
	{
		super();
	}

	/**
	 * Add a SGComponentGroupElement object.
	 * This object is also set to the given SGComponentGroupElement object.
	 * @param el - a SGComponentGroupElement object to be set
	 */
	public void addElement( SGComponentGroupElement el )
	{
		this.mElementList.add(el);
		el.addComponentGroup( this );
	}

	/**
	 * Add SGComponentGroupElement objects.
	 * This object is also set to the given SGComponentGroupElement objects.
	 * @param array - an array of SGComponentGroupElement objects to be set
	 */
	public void addElement( SGComponentGroupElement[] array )
	{
		for( int ii=0; ii<array.length; ii++ )
		{
			this.addElement( array[ii] );
		}
	}

	/**
	 * Set enabled components to be set.
	 * @param b - enabled flag
	 */
	public void setEnabled( final boolean b )
	{
		this.mEnableFlag = b;

		ArrayList list = this.mElementList;
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGComponentGroupElement el = (SGComponentGroupElement)list.get(ii);
			el.setEnabled(b);
		}
	}

	/**
	 * Returns the enabled flag.
	 * @return - enabled flag
	 */
	public boolean isEnabled()
	{
		return this.mEnableFlag;
	}


	/**
	 * 
	 *
	 */
	public void dispose()
	{
		ArrayList list = this.mElementList;
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGComponentGroupElement el = (SGComponentGroupElement)list.get(ii);
			el.dispose();
		}
		this.mElementList.clear();
		this.mElementList = null;
		list = null;
	}

}

