
package jp.riken.brain.ni.samuraigraph.base;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.filechooser.FileFilter;

/**
 * The file filter class to handle files with given file extensions.
 *
 */
public class SGExtensionFileFilter extends FileFilter
{

	/**
	 * The description of the file format.
	 */
	private String mDescription = "";


	/**
	 * The list of file extension.
	 */
	private List mExtensionsList = new ArrayList();


	/**
	 * Add an file extension.
	 * @param extension
	 */
	public void addExtension( String extension )
	{
		if ( !extension.startsWith(".") )
		{
			extension = "." + extension;
			this.mExtensionsList.add( extension.toLowerCase() );
		}
	}


	/**
	 * Set the description of the file format.
	 * @param d
	 */
	public void setDescription( String d )
	{
		this.mDescription = d;
	}


	/**
	 * The description of this filter.
	 */
	public String getDescription()
	{
		String sufx = "";
		int ii;
		for(ii=0; ii<mExtensionsList.size(); ii++)
		{
			if(ii!=0)
				  sufx += ", ";
			sufx += "*" + (String)mExtensionsList.get(ii);
		}
		if(ii==0)
			sufx = "*.*";
		return this.mDescription + " (" + sufx + ")";
	}


	/**
	 * The list of file extensions.
	 * @return
	 */
	public List getExtensionList()
	{
		return new ArrayList( this.mExtensionsList );
	}


	/**
	 * Whether the given file is accepted by this filter.
	 */
	public boolean accept( File file )
	{
		if( file.isDirectory() )
		{
			return true;
		}

		String name = file.getName().toLowerCase();

		// check if the file name ends with any of the extensions
		for( int ii=0; ii<mExtensionsList.size(); ii++ )
		{
			if( name.endsWith( (String)mExtensionsList.get(ii) ) )
			{
				return true;
			}
		}

		return false;
	}
   
}


