
package jp.riken.brain.ni.samuraigraph.base;

/**
 * An interface of the grid element.
 */
public interface SGIGridElement
	extends SGIFigureElement, SGIGridDialogObserver
{

	/**
	 * Set the SGIAxisElement object.
	 * @param el - an SGIAxisElement object
	 */
	public void setAxisElement( SGIAxisElement el );


	/**
	 * Returns whether the grid is visible.
	 * @return  visible flag
	 * @uml.property  name="gridVisible"
	 */
	public boolean isGridVisible();


	/**
	 * Set visible the grid.
	 * @param b  visible flag
	 * @uml.property  name="gridVisible"
	 */
	public boolean setGridVisible( final boolean b );


	/**
	 * @uml.property  name="lineWidth"
	 */
	public float getLineWidth();


	/**
	 * @param width
	 * @return
	 * @uml.property  name="lineWidth"
	 */
	public boolean setLineWidth( final float width );



	/**
	 * 
	 */
	public static final String TAG_NAME_GRID_ELEMENT = "Grid";


	public static final String KEY_GRID_VISIBLE = "GridVisible";
	public static final String KEY_BASELINE_VALUE_X = "BaselineValueX";
	public static final String KEY_BASELINE_VALUE_Y = "BaselineValueY";
	public static final String KEY_STEP_VALUE_X = "StepValueX";
	public static final String KEY_STEP_VALUE_Y = "StepValueY";
	public static final String KEY_AUTO_CALC = "AutomaticCalculationOfTick";
	public static final String KEY_GRID_COLOR = "Color";

}

