
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

/**
 * An object to manage shape objects.
 * 
 */
public interface SGIShapeElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public static final String TAG_NAME_SHAPE = "Shape";


	public static final int RECTANGLE = 0;
	public static final int ELLIPSE = 1;
	public static final int ARROW = 2;
	public static final int LINE = 3;


	/**
	 * 
	 * @param element
	 */
	public void setAxisElement( final SGIAxisElement element );
	
	
	/**
	 * 
	 * @param type
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean addShape( final int type, final int x, final int y );



	// common
	public boolean setAxisXDirectly( final int id, final int value );
	public boolean setAxisYDirectly( final int id, final int value );

	// rectangular shape
	public boolean setRectangleLeftXValueDirectly( final int id, final double value );
	public boolean setRectangleRightXValueDirectly( final int id, final double value );
	public boolean setRectangleTopYValueDirectly( final int id, final double value );
	public boolean setRectangleBottomYValueDirectly( final int id, final double value );
	public boolean setRectangleEdgeLineWidthDirectly( final int id, final float value, final String unit );
	public boolean setRectangleEdgeLineTypeDirectly( final int id, final int value );
	public boolean setRectangleEdgeLineColorDirectly( final int id, final Color value );
	public boolean setRectangleBackgroundColorDirectly( final int id, final Color value );
	public boolean setRectangleBackgroundTransparentDirectly( final int id, final boolean value );


	// arrow
	public boolean setArrowStartXValueDirectly( final int id, final double value );
	public boolean setArrowStartYValueDirectly( final int id, final double value );
	public boolean setArrowEndXValueDirectly( final int id, final double value );
	public boolean setArrowEndYValueDirectly( final int id, final double value );
	public boolean setArrowLineWidthDirectly( final int id, final float value, final String unit );
	public boolean setArrowLineTypeDirectly( final int id, final int value );
	public boolean setArrowHeadSizeDirectly( final int id, final float value, final String unit );
	public boolean setArrowColorDirectly( final int id, final Color value );
	public boolean setArrowStartTypeDirectly( final int id, final int value );
	public boolean setArrowEndTypeDirectly( final int id, final int value );
	public boolean setArrowOpenAngleDirectly( final int id, final float value );
	public boolean setArrowCloseAngleDirectly( final int id, final float value );

}

