
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

/**
 * The status bar.
 */
public class SGStatusBar extends JPanel 
	implements SGIConstants
{

	private ProgressPanel mProgressPanel;
	private MessagePanel mMessagePanel;
	private PositionPanel mPositionPanal;
	
	private static final int STATUS_BAR_WIDTH = 18;

	/**
	 * 
	 */
	public SGStatusBar( SGDrawingWindow wnd )
	{
		super();
		
		// background
		this.setVisible(true);
		this.setOpaque(true);
		this.setBackground( wnd.getBackground() );
		
		boolean isMacOSX = false;
//		boolean isWin32 = false;
		String laf = SGUtility.getLookAndFeelID();
		if( LAF_AQUA.equals(laf) )
		{
			isMacOSX = true;
		}
//		else if( LAF_WINDOWS.equals(laf)){
//			isWin32 = true;
//		}

		this.setBorder(new EmptyBorder(0,0,0,(isMacOSX ? 18 : 0)));
		
		// size
		this.setSize( 0, STATUS_BAR_WIDTH );
		
		// inner
		ProgressPanel progPanel = new ProgressPanel( wnd );
		MessagePanel msgPanel = new MessagePanel();
		PositionPanel posPanel = new PositionPanel();
		
		this.setLayout( new java.awt.GridBagLayout() );
		
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new Insets(2,0,0,2);
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 1.0;
		this.add( progPanel, gridBagConstraints );
		
		gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new Insets(2,0,0,2);
		this.add( msgPanel, gridBagConstraints );
		
		gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new Insets(2,0,0,0);
		this.add( posPanel, gridBagConstraints );
		
		// set to attribute
		this.mProgressPanel = progPanel;
		this.mMessagePanel = msgPanel;
		this.mPositionPanal = posPanel;
		
	}
	
	
	// set progress value
	public void setProgressValue( final float ratio )
	{
		this.mProgressPanel.setProgressValue( ratio );
	}

	// initialize the progress value
//	public void initProgressValue()
//	{
//		this.mProgressPanel.initProgressValue();
//	}
//	
	// start progress timer
	public boolean startProgress()
	{
	    return this.mProgressPanel.startProgress();
	}
	
	// end progress timer
	public boolean endProgress()
	{
	    return this.mProgressPanel.endProgress();
	}

	// draw mouse position
	public void drawPosition( final float x, final float y )
	{
		final DecimalFormat df = new DecimalFormat("0.0");
		final String strPos = df.format(x) + " : " + df.format(y);
		this.mPositionPanal.setText( strPos );
		this.repaint();
	}

	// display the message
	public void setMessage( final String str )
	{
		this.mMessagePanel.setText( str );
		this.repaint();
	}
		
	// A panel to display a message.
	private static class MessagePanel extends StatusPanel
	{
		private MessagePanel()
		{
			super();
			this.setPreferredSize( new Dimension( 100, SGStatusBar.STATUS_BAR_WIDTH ) );
		}
	}

	// A panel to draw progress bar.
	/**
	 * @author  okumura
	 */
	private static class ProgressPanel extends StatusPanel
	{
		private SGProgressBar mProgressBar = new SGProgressBar();
		private Timer timer;
		private float mCurrentValue = 0.0f;
		private boolean mEndFlag = true;
		private SGDrawingWindow mWnd = null;
		
		private ProgressPanel( final SGDrawingWindow wnd )
		{
			super();
			
			mWnd = wnd;
			
			// size
			this.setPreferredSize( new Dimension( 0, SGStatusBar.STATUS_BAR_WIDTH ) );
			// this.setBorder( new EmptyBorder(0,0,0,0) );
			
			// add the progress bar
			this.setLayout( new BorderLayout() );
			this.add( this.mProgressBar, BorderLayout.CENTER );
			
			timer = new Timer(200, new ActionListener() {
			   public void actionPerformed( ActionEvent e ){
//			       System.out.println( "currentValue : " + mCurrentValue );
			       mProgressBar.setProgressValue( mCurrentValue );
			       if ( mEndFlag )
			       {
//			           System.out.println( "End timer" );
			           timer.stop();
			           mWnd.setCursor( null );
			           mProgressBar.initProgressValue();
			       }
			   }
			});
		}
		
		/**
		 * 
		 */
		public boolean startProgress()
		{
//		    System.out.println( "Start timer" );
		    if( mEndFlag == false ) // running now
		        return false;
		    mEndFlag = false;
		    mCurrentValue = 0.0f;
		    mWnd.setCursor( Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR) );
		    timer.start();
		    return true;
		}
		
		public boolean endProgress()
		{
		    if( mEndFlag == true ) // already stoped
		        return false;
		    mEndFlag = true;
		    return true;
		}
		
		private void setProgressValue( final float ratio )
		{
//		    System.out.println( "Set Value : " + ratio);
		    mCurrentValue = ratio;
		}
	}
		
	// A panel to display mouse position.
	private static class PositionPanel extends StatusPanel
	{
		private PositionPanel()
		{
			super();

			// size
			this.setPreferredSize( new Dimension( 100, SGStatusBar.STATUS_BAR_WIDTH ) );

			// string
			this.mString = "0.0 : 0.0";
		}
	}
		
	// The super class of the panels in the status bar.
	private static class StatusPanel extends JPanel
	{
		protected String mString = "";
		private static final int FONT_SIZE = 12;

		private StatusPanel()
		{
			super();

			// border
//			this.setBorder( new SoftBevelBorder( SoftBevelBorder.LOWERED ) );
			this.setBorder( new EtchedBorder( EtchedBorder.LOWERED ) );

			// font
			this.setFont( new Font( "Serif", Font.PLAIN, FONT_SIZE ) );
		}

		public void paintComponent( Graphics g )
		{
			super.paintComponent(g);

			Graphics2D g2d = (Graphics2D)g;
			final int size = FONT_SIZE;
			g2d.drawString( this.mString, size/2, size + 1 );
		}

		protected void setText( final String str )
		{
			this.mString = str;
		}
	}

}








