
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

/**
 * @author   kuromaru
 */
public class SGTwoAxesSelectionPanel extends SGAxisSelectionPanel
{

	// The radio button with no selection.
	private JToggleButton mHorizontalNoAxisSelectionButton = new JToggleButton();
	private JToggleButton mPerpendicularNoAxisSelectionButton = new JToggleButton();

    
    /**
     * The default constructor.
     */
    public SGTwoAxesSelectionPanel()
    {
    	super();
		this.initProperty();
    }
    
 
	// initialization
	private void initProperty()
	{
		// add to ButtonGroups
		ButtonGroup hbg = new ButtonGroup();
		hbg.add( this.mTopButton );
		hbg.add( this.mBottomButton );
		hbg.add( this.mHorizontalNoAxisSelectionButton );

		ButtonGroup pbg = new ButtonGroup();
		pbg.add( this.mLeftButton );
		pbg.add( this.mRightButton );
		pbg.add( this.mPerpendicularNoAxisSelectionButton );


		// add to controllers
		this.mHorizontalController.add( this.mBottomLine );
		this.mHorizontalController.add( this.mTopLine );
		this.mPerpendicularController.add( this.mLeftLine );
		this.mPerpendicularController.add( this.mRightLine );
	}


	private SGExclusiveAccessController mHorizontalController = new SGExclusiveAccessController();
	private SGExclusiveAccessController mPerpendicularController = new SGExclusiveAccessController();


	protected void updateImage()
	{
		this.mAxisImagePanel.setTopSelected( this.isTopSelected() );
		this.mAxisImagePanel.setBottomSelected( this.isBottomSelected() );
		this.mAxisImagePanel.setLeftSelected( this.isLeftSelected() );
		this.mAxisImagePanel.setRightSelected( this.isRightSelected() );
		this.repaint();
	}


	protected void updateButtons()
	{
		final boolean top = this.isTopSelected();
		final boolean bottom = this.isBottomSelected();
		final boolean left = this.isLeftSelected();
		final boolean right = this.isRightSelected();

		if( top | bottom )
		{
			this.mTopButton.setSelected( top );
			this.mBottomButton.setSelected( bottom );
		}
		else
		{
			this.mHorizontalNoAxisSelectionButton.setSelected(true);
		}

		if( left | right )
		{
			this.mLeftButton.setSelected( left );
			this.mRightButton.setSelected( right );
		}
		else
		{
			this.mPerpendicularNoAxisSelectionButton.setSelected(true);
		}
	}


	/**
	 * 
	 * @return
	 */
	public int getXAxisConfiguration()
	{
		int config = -1;

		// set the related axes
		if( this.mHorizontalNoAxisSelectionButton.isSelected() == false )
		{
			if( this.isBottomSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_1;
			}
			else if( this.isTopSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_2;
			}
		}

		return config;		
	}


	/**
	 * 
	 * @return
	 */
	public int getYAxisConfiguration()
	{
		int config = -1;

		// set the related axes
		if( this.mPerpendicularNoAxisSelectionButton.isSelected() == false )
		{
			if( this.isLeftSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_1;
			}
			else if( this.isRightSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_2;
			}
		}

		return config;		
	}



	/**
	 * 
	 * @param holderList
	 * @return
	 */
	public boolean setSelected( List holderList )
	{
		final int num = holderList.size();
		if( num==0 )
		{
			return false;
		}
		
		List xAxisList = new ArrayList( num );
		List yAxisList = new ArrayList( num );
		
		for( int ii=0; ii<num; ii++ )
		{
			SGITwoAxesHolder l
				= (SGITwoAxesHolder)holderList.get(ii);
			xAxisList.add( new Integer( l.getXAxisLocation() ) );
			yAxisList.add( new Integer( l.getYAxisLocation() ) );
		}

		Integer xAxis0 = (Integer)xAxisList.get(0);
		Integer yAxis0 = (Integer)yAxisList.get(0);
		Integer xAxis = xAxis0;
		Integer yAxis = yAxis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer xAxis1 = (Integer)xAxisList.get(ii);
				if( xAxis0.equals(xAxis1)==false )
				{
					xAxis = null;
					break;
				}
			}
			for( int ii=1; ii<num; ii++ )
			{
				Integer yAxis1 = (Integer)yAxisList.get(ii);
				if( yAxis0.equals(yAxis1)==false )
				{
					yAxis = null;
					break;
				}
			}
		}


		// set selected button
		this.clearAll();
		if( xAxis!=null )
		{
			this.setHorizontalAxis( xAxis.intValue() );
		}
		if( yAxis!=null )
		{
			this.setPerpendicularAxis( yAxis.intValue() );
		}

		// update components and image
		this.updateButtons();
		this.updateImage();

		return true;
	}



	// set selected buttons
	private boolean setHorizontalAxis( final int config )
	{

		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				this.setBottomSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				this.setTopSelected(true);
				break;
			}

			default :
			{
				throw new IllegalArgumentException("");
			}
		}

		return true;
	}


	// set selected buttons
	private boolean setPerpendicularAxis( final int config )
	{
		switch( config )
		{
			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				this.setLeftSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				this.setRightSelected(true);
				break;
			}
						
			default :
			{
				throw new IllegalArgumentException("");
			}
		}

		return true;
	}


	/**
	 * Set the given line to be selected.
	 */
	protected void selectLine( Line l )
	{
		if( this.mHorizontalController.contains(l) )
		{
			this.mHorizontalController.select(l);
		}
		else if( this.mPerpendicularController.contains(l) )
		{
			this.mPerpendicularController.select(l);
		}
	}

}

