package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString.StringProperties;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;



/**
 * A class managing labels.
 */
public class SGStringElement extends SGFigureElement
	implements SGIStringElement, SGIStringConstants, CaretListener, ActionListener
{

	
	/**
	 * 
	 */
	private SGIAxisElement mAxisElement = null;

	
	/**
	 * 
	 */
	private LabelElement mEditedLabelElement = null;
	
	
	/**
	 * 
	 */
	private int mFocusedX = 0;


	/**
	 * 
	 */
	private int mFocusedY = 0;



	/**
	 * 
	 */
	private float mFrameLineWidth = 1.0f;



	/**
	 * 
	 */
	private JTextField mEditField = null;



	/**
	 * 
	 */
	public static final int BOUNDARY_LINE_WIDTH = 6;

	


	/**
	 * RXgN^
	 */
	public SGStringElement()
	{
		super();
		this.initEditField();
	}


	public void dispose()
	{
		super.dispose();
		this.mDialog.dispose();
		this.mDialog = null;
		this.mAxisElement = null;
	}


	/**
	 * 
	 * @return
	 */
	public String toString()
	{
		return new String("SGStringElement");
	}


	/**
	 * 
	 * @return
	 */
	public String getClassDescription()
	{
		return "Labels";
	}


	/**
	 * 
	 */
	private boolean initEditField()
	{
		this.mEditField = new JTextField(10);
		JTextField tf = this.mEditField;

//		this.getComponent().setLayout(null);
//		this.getComponent().add(tf);
		tf.setVisible(false);
		tf.addActionListener(this);
		tf.addCaretListener(this);

		return true;
	}

	public void setComponent( JComponent com )
	{
		super.setComponent(com);
		com.add(this.mEditField);
	}


	/**
	 * 
	 * @param element
	 */
	public void setAxisElement( final SGIAxisElement element )
	{
		this.mAxisElement = element;
	}

	
	
	/**
	 * Ŏw肳ꂽ_ɃeLXgtB[hoāA
	 * ǉ鏈s
	 */
	public boolean addString( final int x, final int y )
	{

		// 
		if( this.getGraphRect().contains( x, y ) == false )
		{
			return false;
		}


		// O
		this.clearFocusedObjects();

		this.mFocusedX = x;
		this.mFocusedY = y;

		JTextField tf = this.mEditField;

		tf.setVisible(true);

		final String fontName = DEFAULT_LABEL_FONT_NAME;
		final int fontStyle = DEFAULT_LABEL_FONT_STYLE;
		final float fontSize = DEFAULT_LABEL_FONT_SIZE;
		Font font = new Font(
			fontName,
			fontStyle,
			(int)(this.mMagnification*fontSize) );
		tf.setFont( font );

		final String str = "   ";
		final Rectangle2D stringRect = font.getStringBounds(
			str, new FontRenderContext( null, false, false ) );

		final int lx = this.mFocusedX - this.mEditField.getInsets().left;
		final int ly = this.mFocusedY - (int)(this.mMagnification*fontSize/2.0f);
		final int width = (int)( stringRect.getWidth() + this.mMagnification*fontSize );
		final int height = (int)( stringRect.getHeight() + this.mMagnification*fontSize );

		tf.setLocation( lx, ly );
		tf.setSize( width, height );
		tf.setText("");
		tf.requestFocus();

		this.repaint();

		return true;

	}


	/**
	 * 
	 * @param x
	 * @param y
	 * @param str
	 * @return
	 */
	public boolean addString( final int x, final int y, final String str )
	{
		final LabelElement es = new LabelElement( str );
		es.setMagnification( this.mMagnification );
		SGAxis xAxis = mAxisElement.getAxis( DEFAULT_LABEL_HORIZONTAL_AXIS );
		SGAxis yAxis = mAxisElement.getAxis( DEFAULT_LABEL_PERPENDICULAR_AXIS );
		es.mXAxis = xAxis;
		es.mYAxis = yAxis;
		es.setLocation( x, y );

		this.addToList(es);

		// initialize history
		es.initPropertiesHistory();

		this.setChanged(true);

		this.notifyToRoot();

		return true;
	}


	/**
	 * 
	 */
	public void paintGraphics( Graphics g, boolean clip )
	{
		final Graphics2D g2d = (Graphics2D)g;

		ArrayList list = this.getVisibleChildList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			final LabelElement el = (LabelElement)list.get(ii);

			// draw string
			el.paintElement(g2d);

//			// draw bounding box
//			if( el.mFrameFlag )
//			{
//				el.drawBoundingBox( g2d );
//			}
		}

		// draw symbols around all objects
		if( this.mSymbolsVisibleFlagAroundAllObjects )
		{
			for( int ii=0; ii<list.size(); ii++ )
			{
				LabelElement el = (LabelElement)list.get(ii);
				ArrayList pList = el.getAnchorPointList();
				SGUtilityForFigureElementJava2D.drawAnchorAsChildObject( pList, g2d );
			}
		}

		// draw symbols around focused objects
		if( this.mSymbolsVisibleFlagAroundFocusedObjects )
		{
			ArrayList fList = new ArrayList();
			this.getFocusedObjectsList( fList );
			for( int ii=0; ii<fList.size(); ii++ )
			{
				LabelElement el = (LabelElement)fList.get(ii);
				ArrayList pList = el.getAnchorPointList();
				SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject( pList, g2d );
			}
		}

		
		// eLXgtB[h̋E`
		JTextField tf = this.mEditField;
		if( tf.isVisible() )
		{
			g2d.setPaint( Color.GRAY );
			g2d.setStroke( new BasicStroke( BOUNDARY_LINE_WIDTH ) );
			g2d.draw( tf.getBounds() );
			g2d.setStroke( new BasicStroke(2) );
			tf.repaint();
		}

	}



	/**
	 * B
	 */
	public boolean synchronize( final SGIFigureElement element, final String msg )
	{

		boolean flag = true;
		if( element instanceof SGIGraphElement )
		{
			
		}
		else if( element instanceof SGIStringElement )
		{
			
		}
		else if( element instanceof SGILegendElement )
		{
			
		}
		else if( element instanceof SGIAxisElement )
		{
			SGIAxisElement aElement = (SGIAxisElement)element;
			flag = this.synchronizedToAxisElement( aElement, msg );
		}
		else if( element instanceof SGIAxisBreakElement )
		{
			
		}
		else if( element instanceof SGISignificantDifferenceElement )
		{
			
		}
		else if( element instanceof SGITimingLineElement )
		{
			
		}
		else if( element instanceof SGIGridElement )
		{

		}
		else if( element instanceof SGIShapeElement )
		{

		}
		else
		{
			flag = element.synchronizeArgument( this, msg );
		}


		return flag;
	}


	
	private boolean synchronizedToAxisElement( final SGIAxisElement element, final String msg )
	{
/*		
		ArrayList list = this.getVisibleStringElementList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			ElementString el = (ElementString)list.get(ii);
			el.setAxisValue();
		}
*/
		return true;
	}
	
	
	

	/**
	 * Synchronize the element given by the argument.
	 * @param element An object to be synchronized.
	 */
	public boolean synchronizeArgument( final SGIFigureElement element, final String msg )
	{
	    // this shouldn't happen
	    throw new Error();
	}



	/**
	 * Y[
	 */
	public boolean zoom( final float ratio )
	{
		
		if( this.terminateEditField() == false )
		{
			return false;
		}
		
		if( super.zoom(ratio) == false )
		{
			return false;
		}

		List list = this.mChildList;
		for( int ii=0; ii<list.size(); ii++ )
		{
			final LabelElement element = (LabelElement)list.get(ii);
			element.zoom(ratio);
		}

		return true;
	}




	/**
	 * 
	 */
	public boolean setGraphRect(
		final float x, final float y, final float w, final float h )
	{
		if( super.setGraphRect(x,y,w,h) == false )
		{
			return false;
		}

		if( this.mEditField.isVisible() )
		{
			if( this.terminateEditField() == false )
			{
				return false;
			}
		}

		List list = this.mChildList;
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement el = (LabelElement)list.get(ii);
			el.updateLocation();
		}

		return true;
	}





	/**
	 * 
	 */
	public boolean getMarginAroundGraphRect(
		SGTuple2f topAndBottom, SGTuple2f leftAndRight )
	{

		//
		if( super.getMarginAroundGraphRect( topAndBottom, leftAndRight ) == false )
		{
			return false;
		}


		Rectangle2D graphRect = this.getGraphRect();

		ArrayList sList = this.getVisibleChildList();
		ArrayList rectList = new ArrayList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			LabelElement el = (LabelElement)sList.get(ii);
			rectList.add( el.getElementBounds() );
		}

		if( rectList.size()==0 )
		{
			return true;
		}


		Rectangle2D sRect = SGUtility.createUnion(rectList);

		ArrayList list = new ArrayList();
		list.add( graphRect );
		list.add( sRect );

		Rectangle2D uniRect = SGUtility.createUnion(list);

//System.out.println(graphRect);
//System.out.println(lRect);
//System.out.println(uniRect);		

		final float top = (float)( graphRect.getY() - uniRect.getY() );
		final float bottom = (float)( ( uniRect.getY() + uniRect.getHeight() )
			- ( graphRect.getY() + graphRect.getHeight() ) );
		final float left = (float)( graphRect.getX() - uniRect.getX() );
		final float right = (float)( ( uniRect.getX() + uniRect.getWidth() )
			- ( graphRect.getX() + graphRect.getWidth() ) );

		topAndBottom.x += top;
		topAndBottom.y += bottom;
		leftAndRight.x += left;
		leftAndRight.y += right;

//System.out.println(topAndBottom+"  "+leftAndRight);

//System.out.println();

		return true;
	}




	/**
	 * 
	 */
	public boolean onMouseClicked( final MouseEvent e )
	{

		final int x = e.getX();
		final int y = e.getY();
		final int mod = e.getModifiers();
		final int cnt = e.getClickCount();
		final boolean onEdgeFlag = this.onEdge(x,y);
		final boolean ctrl  = (mod & InputEvent.CTRL_MASK)!=0;
		final boolean shift = (mod & InputEvent.SHIFT_MASK)!=0;

		ArrayList list = this.getVisibleChildList();
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			final LabelElement el = (LabelElement)list.get(ii);

			if( onEdgeFlag && el.equals( this.mEditedLabelElement ) )
			{
				if( SwingUtilities.isLeftMouseButton(e) & cnt==2 )
				{
					this.setPropertiesOfSelectedObjects();
					this.hideEditField();
				}
				return true;
			}

			if( el.contains(x,y) )
			{
				if( SwingUtilities.isLeftMouseButton(e) )
				{
					if( cnt==1 )
					{
						if( el.isSelected() & !ctrl & !shift )
						{
							this.mEditedLabelElement = el;
							this.mFocusedX = (int)el.getX();
							this.mFocusedY = (int)el.getY();
							this.showEditField( el );
						}
						else
						{
							this.updateFocusedObjectsList(el,e);
						}
					}
				}
				else if( SwingUtilities.isRightMouseButton(e) & cnt==1 )
				{
					this.updateFocusedObjectsList(el,e);
					el.getPopupMenu().show( this.getComponent(), x, y );
				}

				return true;
			}

		}

		return false;

	}



	/**
	 * 
	 */
	private boolean terminateEditField()
	{

		if( this.mEditedLabelElement==null )
		{
			if( this.addStringElementFromTextField() == false )
			{
				return false;
			}
		}
		else
		{
			if( this.commitEdit() == false )
			{
				return false;
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	private boolean commitEdit()
	{
		String before = this.mEditedLabelElement.getString();
		String after = this.mEditField.getText();
		if( SGUtilityText.isValidString(after) )
		{
			this.mEditedLabelElement.setString( after );
			if( before.equals(after) == false )
			{
				this.mEditedLabelElement.setChanged(true);
				this.notifyToRoot();
			}
		}

		this.mEditedLabelElement = null;
		this.hideEditField();
		this.repaint();
		
		return true;
	}



	/**
	 * 
	 */
	private boolean hideEditField()
	{
		this.mEditField.setText("");
		this.mEditField.setVisible(false);

		return true;
	}



	/**
	 * 
	 * @return
	 */
/*	public boolean clearFocusedObjects()
	{
		if( super.clearFocusedObjects() == false )
		{
			return false;
		}
		
		// 
		if( this.mEditField.isVisible() )
		{
			this.terminateEditField();
		}

		this.mEditedLabelElement = null;
		return true;
	}
*/



	/**
	 * 
	 */
	private boolean showEditField( final LabelElement el )
	{
		final JTextField tf = this.mEditField;

		final Rectangle2D rect = el.getElementBounds();
		final Rectangle2D sRect = el.getStringRect();

		final float fontSize = el.getMagnification()*el.getFontSize();

		final int x = (int)( rect.getX() - tf.getInsets().left );
		final int y = (int)( rect.getY() - fontSize/2.0f );
		final int w = (int)( sRect.getWidth() + fontSize );
		final int h = (int)( sRect.getHeight() + fontSize );

		tf.setLocation( x, y );
		tf.setSize( w, h );
		tf.setFont( new Font( el.getFontName(), el.getFontStyle(), (int)fontSize ) );
		tf.setForeground( el.getColor(0) );
		tf.setText( el.getString() );

		// show the text field
		tf.setVisible(true);
		tf.requestFocus();
		tf.setCaretPosition(0);

		return true;

	}


	
	/**
	 * 
	 * @param e
	 */
	public boolean onMousePressed( final MouseEvent e )
	{
		final int x = e.getX();
		final int y = e.getY();

		ArrayList fList = this.getFocusedObjectsList();
		ArrayList list = this.getVisibleChildList();
		boolean flag = false;
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			final LabelElement el = (LabelElement)list.get(ii);
			if( el.contains(x,y) )
			{
				el.mFrameFlag = true;
				if( fList.contains(el) )
				{
					this.mPressedPoint = e.getPoint();
					el.mTemporaryProperties = el.getProperties();
					this.mDraggableFlag = true;
				}
				flag = true;
				break;
			}
		}


		// if the mouse is pressed on the label
		if( flag )
		{
			this.setMouseCursor( Cursor.MOVE_CURSOR );
		}
		// otherwise
		else
		{
			final boolean onEdgeFlag = this.onEdge(x,y);
			
			// if the mouse is on the edge of the text field
			if( this.mEditedLabelElement!=null && onEdgeFlag )
			{
				flag = true;
			}
			else
			{
				// hide the edit field
				if( this.mEditField.isVisible() )
				{
					this.terminateEditField();
				}
				else
				{
//					this.clearFocusedObjects();
				}
			}
			
		}
		
		return flag;
	}



	/**
	 * 
	 * @param e
	 */
	public boolean onMouseDragged( final MouseEvent e )
	{

		if( this.mPressedPoint==null )
		{
			return false;
		}
		if( this.mDraggableFlag == false)
		{
			return false;
		}
		this.hideEditField();

		// translate label all selected elements
		final int dx = e.getX() - this.mPressedPoint.x;
		final int dy = e.getY() - this.mPressedPoint.y;

		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement el = (LabelElement)list.get(ii);
			el.translate(dx,dy);
		}

		// update the temporary object
		this.mPressedPoint = e.getPoint();
		
		return true;
	}


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseReleased( final MouseEvent e )
	{

		ArrayList list = this.getFocusedObjectsList();
		boolean contained = false;
		boolean changed = false;
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement el = (LabelElement)list.get(ii);
/*			
			SGProperties temp = el.mTemporaryProperties;
			SGProperties p = el.getProperties();
			if( p.equals(temp)==false )
			{
				el.setChanged(true);
				changed = true;
			}
*/
			Rectangle2D rect = el.getElementBounds();
			contained |= rect.contains( e.getPoint() );
		}

		if( contained )
		{
			setMouseCursor( Cursor.HAND_CURSOR );
		}
		else
		{
			setMouseCursor( Cursor.DEFAULT_CURSOR );
		}
/*
		if( changed )
		{
			this.notifyToRoot();
		}
*/
		this.mDraggableFlag = false;
		return true;
	}

	
	
	/**
	 * 
	 * @return
	 */
	public boolean setTemporaryPropertiesOfFocusedObjects()
	{
		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement el = (LabelElement)list.get(ii);
			el.mTemporaryProperties = el.getProperties();
		}
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setChangedFocusedObjects()
	{
		ArrayList list = this.getFocusedObjectsList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement el = (LabelElement)list.get(ii);
			SGProperties temp = el.mTemporaryProperties;
			if( temp!=null )
			{
				SGProperties p = el.getProperties();
				if( p.equals(temp)==false )
				{
					el.setChanged(true);
				}
			}
		}
		return true;
	}

	
	
	/**
	 * 
	 */
	public boolean onEdge( final int x, final int y )
	{
		if( this.mEditField.isVisible()==false )
		{
			return false;
		}

		final int bWidth = BOUNDARY_LINE_WIDTH;
		final Rectangle rect = this.mEditField.getBounds();
		final int xx = rect.x - bWidth;
		final int yy = rect.y - bWidth;
		final int ww = rect.width + 2*bWidth;
		final int hh = rect.height + 2*bWidth;
		final Rectangle rectNew = new Rectangle( xx, yy, ww, hh );

		final boolean flagShape =  rect.contains( x, y );
		final boolean flagRectNew = rectNew.contains( x, y );

		final boolean flag = (!flagShape)&(flagRectNew);
		
		return flag;
	}



	/**
	 * 
	 * @param e
	 */
	public boolean onDrawingElement( final int x, final int y )
	{
		ArrayList list = this.getVisibleChildList();
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			final LabelElement el = (LabelElement)list.get(ii);
			final boolean flag = el.contains(x,y);
//			el.mFrameFlag = flag;
			if( flag )
			{
				this.setMouseCursor( Cursor.HAND_CURSOR );
				return true;
			}
		}

		return false;
	}




	/**
	 * 
	 */
	public void actionPerformed(final ActionEvent e)
	{

		final Object source = e.getSource();

		if( source.equals( this.mEditField ) )
		{
			this.terminateEditField();
		}

	}



	/**
	 * 
	 */
	public void caretUpdate( final CaretEvent e )
	{

		JTextField tf = this.mEditField;
		final String str = tf.getText();

		float fontSize;
		Font font = null;

		// edit
		if( this.mEditedLabelElement != null )
		{
			LabelElement el = this.mEditedLabelElement;
			fontSize = el.getFontSize();
			font = new Font(
				el.getFontName(),
				el.getFontStyle(),
				(int)(el.getMagnification()*fontSize) );
		}
		// add
		else
		{
			fontSize = DEFAULT_LABEL_FONT_SIZE;
			font = new Font(
				DEFAULT_LABEL_FONT_NAME,
				DEFAULT_LABEL_FONT_STYLE,
				(int)(this.mMagnification*fontSize) );
		}

		Rectangle2D stringRect = font.getStringBounds(
			str, new FontRenderContext( null, false, false ) );


		final double width = stringRect.getWidth();
		if( width > tf.getWidth() )
		{
			tf.setSize(
				(int)( stringRect.getWidth() + this.mMagnification*fontSize ),
				tf.getHeight()
			);
		}

		this.repaint();
	}



	/**
	 * 
	 */
	private boolean addStringElementFromTextField()
	{
		final String str = this.mEditField.getText();
		if( SGUtilityText.isValidString(str) )
		{
			this.addString( this.mFocusedX, this.mFocusedY, str );
		}

		this.hideEditField();
		this.repaint();

		return true;
	}



	/**
	 * 
	 */
	private boolean removeString( final LabelElement string )
	{
		List list = this.mChildList;
		for( int ii=list.size()-1; ii>=0; ii-- )
		{
			final LabelElement el = (LabelElement)list.get(ii);
			if( el.equals(string) )
			{
				list.remove(string);
				return true;
			}
		}

		return false;
	}



	/**
	 * 
	 * @param el
	 * @return
	 */
	private boolean hideLabel( final LabelElement el )
	{
		return this.hideObject(el);
	}



	/**
	 * 
	 * @return
	 */
	public String getTagName()
	{
		return TAG_NAME_STRING_ELEMENT;
	}

	
	/**
	 * 
	 */
	public Element createElement( final Document document )
	{
		Element el = this.createThisElement( document );
		if( el==null )
		{
			return null;
		}

		ArrayList list = this.getVisibleChildList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			LabelElement label = (LabelElement)list.get(ii);
			Element elLabel =  label.createElement( document );
			if( elLabel==null )
			{
				return null;
			}
			el.appendChild( elLabel );
		}
		return el;
	}

	
	
	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		return true;
	}

	
	
	
	/**
	 * 
	 */
	public boolean readProperty( final Element element )
	{

		NodeList nList = element.getElementsByTagName( SGIStringConstants.TAG_NAME_LABEL );
		for( int ii=0; ii<nList.getLength(); ii++ )
		{
			Node node = nList.item(ii);
			if( node instanceof Element )
			{
				Element el = (Element)node;
				LabelElement label = new LabelElement();
				if( label.readProperty(el) == false )
				{
					return false;
				}
				label.initPropertiesHistory();
				this.addToList( label );
			}
		}
		
		return true;
	}



	
	/**
	 * 
	 */
	public boolean setMementoBackward()
	{
		boolean flag = super.setMementoBackward();
		if( !flag )
		{
			return false;
		}

		this.clearFocusedObjects();
		this.notifyChangeOnUndo();

		return true;
	}



	/**
	 * 
	 */
	public boolean setMementoForward()
	{
		boolean flag = super.setMementoForward();
		if( !flag )
		{
			return false;
		}

		this.clearFocusedObjects();
		this.notifyChangeOnUndo();

		return true;
	}

	
	
	/**
	 *
	 */
	private SGStringElementDialog mDialog = null;
	
	
	/**
	 * 
	 */
	private boolean createDialog()
	{
	
		final SGStringElementDialog dg = new SGStringElementDialog( mDialogOwner, true );
	
		this.mDialog = dg;
	
		return true;
	}
	
	/**
	 * 
	 * @return
	 */
	public boolean setDialogOwner( final Frame frame )
	{
		super.setDialogOwner(frame);
		this.createDialog();
		return true;
	}



	/**
	 * Create copies of the focused objects.
	 * @return
	 */
	public boolean duplicateFocusedObjects()
	{
		final int ox = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_X );
		final int oy = (int)( this.mMagnification*OFFSET_DUPLICATED_OBJECT_Y );
		ArrayList cList = this.duplicateObjects();
		for( int ii=0; ii<cList.size(); ii++ )
		{
			// duplicate
			LabelElement el = (LabelElement)cList.get(ii);
			
			// translate 
			el.translate( ox, oy );

			// set selected
			el.setSelected(true);

			// add to the list
			this.addToList(el);

			// initialize history
			el.initPropertiesHistory();
		}

		if( cList.size()!=0 )
		{
			this.setChanged(true);
		}
		
//		this.repaint();

		return true;
	}



	/**
	 * Paste the objects.
	 * @param list of the objects to be pasted
	 * @return true:succeeded, false:failed
	 */
	public boolean paste( ArrayList list )
	{
		final float mag = this.getMagnification();
		final int ox = (int)( mag*OFFSET_DUPLICATED_OBJECT_X );
		final int oy = (int)( mag*OFFSET_DUPLICATED_OBJECT_Y );

		int cnt = 0;
		for( int ii=0; ii<list.size(); ii++ )
		{
			Object obj = list.get(ii);
			if( obj instanceof LabelElement )
			{
				LabelElement label = (LabelElement)obj;

				// translate the instance to be pasted
				label.translate( ox, oy );

				SGProperties p = label.getProperties();
				
				LabelElement el = new LabelElement();
				el.setMagnification(mag);
				el.setProperties(p);

				el.mXAxis = this.mAxisElement.getAxisInCube( label.mTempXAxis );
				el.mYAxis = this.mAxisElement.getAxisInCube( label.mTempYAxis );

				// add to the list
				this.addToList(el);

				// initialize history
				el.initPropertiesHistory();

				cnt++;
			}
		}

		if( cnt!=0 )
		{
			this.setChanged(true);
		}

//		this.repaint();

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public ArrayList getPropertyDialogObserverList()
	{
		return this.getFocusedObjectsList();
	}



	/**
	 * 
	 */
	protected Set getAvailableChildSet()
	{
		Set set = new HashSet();
		List mList = this.getMementoList();
		for( int ii=0; ii<mList.size(); ii++ )
		{
			StringElementProperties p = (StringElementProperties)mList.get(ii);
			set.addAll( p.visibleStringElementList );
		}

		return set;		
	}


	//
	private LabelElement getLabel( final int id )
	{
		LabelElement el = (LabelElement)this.getChildObject(id);
		if( el == null ) return null;
		if( el.isVisible() == false ) return null;
		return el;
	}


	public boolean setAxisXDirectly( final int id, final int value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setXAxisLocation(value) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setAxisYDirectly( final int id, final int value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setYAxisLocation(value) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setTextDirectly( final int id , final String value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setString( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setLocationXDirectly( final int id, final double value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setXValue( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setLocationYDirectly( final int id, final double value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setYValue( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setFontNameDirectly( final int id, final String value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setFontName( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setFontStyleDirectly( final int id, final int value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setFontStyle( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setFontSizeDirectly( final int id, final float value, final String unit )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setFontSize( value, unit ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setFontColorDirectly( final int id, final Color value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setColor( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}

	public boolean setAngleDirectly( final int id, final float value )
	{
		LabelElement el = this.getLabel(id);
		if( el==null ) return false;
		if( this.setDirectlyBefore(el) == false ) return false;
		if( el.setAngle( value ) == false ) return false;
		if( this.setDirectlyAfter(el) == false ) return false;
		return true;
	}


	private boolean setDirectlyBefore( LabelElement el )
	{
		return el.prepare();
	}


	private boolean setDirectlyAfter( LabelElement el )
	{
		if( el.commit() == false )
		{
			return false;
		}
		this.notifyChange();
		this.notifyToRoot();
		this.repaint();
		return true;
	}


	/**
	 * @author  okumura
	 */
	class LabelElement extends SGDrawingElementString2DExtended
		implements ActionListener,
			SGIUndoable, SGISelectable, SGIMovable, SGICopiable,
			SGILabelDialogObserver, SGINode, SGIDisposable,
			ChildObject
	{

		/**
		 * 
		 */
		private int mID;


		public int getID()
		{
			return this.mID;
		}

		public boolean setID( final int id )
		{
			this.mID = id;
			return true;
		}



		/**
		 * 
		 */
		public void dispose()
		{
			super.dispose();

			this.mPopupMenu = null;
			this.mTemporaryProperties = null;

			this.mUndoManager.dispose();
			this.mUndoManager = null;

			this.mXAxis = null;
			this.mYAxis = null;
		}


		/**
		 * Flag whether this object is focused.
		 */
		private boolean mSelectedFlag = false;


		/**
		 * Get the flag as a focused object.
		 * @return whether this object is focused.
		 */
		public boolean isSelected()
		{
			return this.mSelectedFlag;
		}


		/**
		 * Set the flag as a focused object.
		 * @param b focused
		 */
		public void setSelected( final boolean b )
		{
			this.mSelectedFlag = b;
		}


		/**
		 * 
		 */
		private SGAxis mXAxis = null;
		
		
		/**
		 * 
		 */
		private SGAxis mYAxis = null;

		
		/**
		 *
		 */
		private JPopupMenu mPopupMenu = new JPopupMenu();



		/**
		 * 
		 */
		private boolean mFrameFlag = false;



		/**
		 * 
		 */
		private SGProperties mTemporaryProperties = null;


		/**
		 * 
		 */
		LabelElement()
		{
			super();
			this.init();
		}


		/**
		 * 
		 */
		LabelElement( final String str )
		{
			super(str);
			this.init();
		}


		/**
		 * 
		 */
		private boolean init()
		{
			this.setFontSize( DEFAULT_LABEL_FONT_SIZE, FONT_SIZE_UNIT );
			this.setFontName( DEFAULT_LABEL_FONT_NAME );
			this.setFontStyle( DEFAULT_LABEL_FONT_STYLE );
			this.setAngle( DEFAULT_LABEL_ANGLE );
			this.setColor( DEFAULT_LABEL_FONT_COLOR );

			this.createPopupMenu();

			return true;
		}



		public void finalize()
		{
//			System.out.println("finalize:"+this);
		}


		/**
		 * 
		 * @return
		 */
		public String getClassDescription()
		{
			return "";
		}


		/**
		 * 
		 * @return
		 */
		public String getInstanceDescription()
		{
			String xAxis = SGStringElement.this.mAxisElement.getLocationName( this.mXAxis );
			String yAxis = SGStringElement.this.mAxisElement.getLocationName( this.mYAxis );

			String str = "";
			str += this.mID + ": " + this.getString() + ", ";
			str += xAxis + ", " + yAxis + ", ";
			str += "X=" + this.getXValue() + ", Y=" + this.getYValue();
			return str;
		}


		/**
		 * 
		 */
		public Object copy()
		{
			LabelElement el = new LabelElement();
			el.setMagnification( this.mMagnification );
			el.setProperties( this.getProperties() );
			el.setLocation( this.getX(), this.getY() );
			el.mTempXAxis = mAxisElement.getLocationInCube( this.mXAxis );
			el.mTempYAxis = mAxisElement.getLocationInCube( this.mYAxis );
			return el;
		}


		private int mTempXAxis = -1;
		private int mTempYAxis = -1;


		/**
		 * 
		 */
		LabelElement( final LabelElement element )
		{
			super(element);

			this.mX = element.mX;
			this.mY = element.mY;
			this.mMagnification = element.mMagnification;

			this.updateLocation();

			this.createPopupMenu();
		}

		
		
		/**
		 * 
		 * @return
		 */
		public double getXValue()
		{
			SGAxis axis = this.mXAxis;
			double value = calcValue( this.getX(), axis, true );
			value = getNumberInRangeOrder( value, axis );
			return value;
		}

		
		/**
		 * 
		 * @return
		 */
		public double getYValue()
		{
			SGAxis axis = this.mYAxis;
			double value = calcValue( this.getY(), axis, false );
			value = getNumberInRangeOrder( value, axis );
			return value;
		}

		
		/**
		 * 
		 * @param value
		 */
		public boolean setXValue( final double value )
		{
			SGAxis axis = this.mXAxis;
			
			// current values gotten from the position of legend
			double currentValue = calcValue( this.getX(), axis, true );
			currentValue = getNumberInRangeOrder( currentValue, axis );


			// if values from the dialog is diffrent from the current values,
			// set the values from the dialog

			float x;
			if( value==currentValue )
			{
				x = this.mX;
			}
			else
			{
				final float x_ = calcLocation( value, axis, true );
				x = ( x_ - mGraphRectX )/this.mMagnification;
			}

			this.mX = x;

			this.updateLocation();

			return true;
		}


		/**
		 * 
		 * @param value
		 */
		public boolean setYValue( final double value )
		{
			SGAxis axis = this.mYAxis;
			
			// current values gotten from the position of legend
			double currentValue = calcValue( this.getY(), axis, false );
			currentValue = getNumberInRangeOrder( currentValue, axis );


			// if values from the dialog is diffrent from the current values,
			// set the values from the dialog

			float y;
			if( value==currentValue )
			{
				y = this.mY;
			}
			else
			{
				final float y_ = calcLocation( value, axis, false );
				y = ( y_ - mGraphRectY )/this.mMagnification;
			}

			this.mY = y;

			this.updateLocation();
			
			return true;
		}



		/**
		 * 
		 * @param config
		 * @param value
		 * @return
		 */
		public boolean hasValidXValue( final int config, final Number value )
		{
			final SGAxis axis = (config==-1) ? this.mXAxis : mAxisElement.getAxisInPlane( config );
			final double v = (value!=null) ? value.doubleValue() : this.getXValue();
			return axis.isValidValue(v);
		}

		/**
		 * 
		 * @param config
		 * @param value
		 * @return
		 */
		public boolean hasValidYValue( final int config, final Number value )
		{
			final SGAxis axis = (config==-1) ? this.mYAxis : mAxisElement.getAxisInPlane( config );
			final double v = (value!=null) ? value.doubleValue() : this.getYValue();
			return axis.isValidValue(v);
		}


		
		/**
		 * 
		 */
		public int getXAxisLocation()
		{
			return SGStringElement.this.mAxisElement.getLocationInPlane( this.mXAxis );
		}


		/**
		 * 
		 */
		public int getYAxisLocation()
		{
			return SGStringElement.this.mAxisElement.getLocationInPlane( this.mYAxis );
		}



		/**
		 * 
		 */
		public boolean setXAxisLocation( final int config )
		{
			if( config!=SGIAxisElement.AXIS_HORIZONTAL_1
				& config!=SGIAxisElement.AXIS_HORIZONTAL_2 )
			{
				return false;
			}
			this.mXAxis = this.getAxis(config);
			return true;
		}

		/**
		 * 
		 */
		public boolean setYAxisLocation( final int config )
		{
			if( config!=SGIAxisElement.AXIS_PERPENDICULAR_1
				& config!=SGIAxisElement.AXIS_PERPENDICULAR_2 )
			{
				return false;
			}
			this.mYAxis = this.getAxis(config);
			return true;
		}

		private SGAxis getAxis( final int config )
		{
			return mAxisElement.getAxisInPlane( config );
		}
		

		/**
		 * 
		 */
		public boolean setString( final String text )
		{
			if( text==null ) return false;
			if( text.length()==0 ) return false;
			return super.setString( text );
		}


		/**
		 * 
		 */
		public boolean setFontSize( final float size, final String unit )
		{
			final double conv = SGUtilityText.convert( size, unit, FONT_SIZE_UNIT );
			if( conv < FONT_SIZE_MIN_VALUE ) return false;
			if( conv > FONT_SIZE_MAX_VALUE ) return false;

			return this.setFontSize( (float)SGUtilityText.convertToPoint( size, unit ) );
		}

		
		/**
		 * 
		 * @param color
		 */
		public boolean setStringColor( final Color color )
		{
			return this.setColor( color );
		}


		/**
		 * 
		 */
		public Color getStringColor()
		{
			return this.getColor(0);
		}


		/**
		 * 
		 */
		public float getFontSize( final String unit )
		{
			return (float)SGUtilityText.convertFromPoint( this.getFontSize(), unit );
		}


		/**
		 * 
		 */
		public boolean setAngle( final float angle )
		{
			if( angle < STRING_ANGLE_MIN ) return false;
			if( angle > STRING_ANGLE_MAX ) return false;
			
			return super.setAngle( angle );
		}


		/**
		 * 
		 */
		public boolean prepare()
		{
			this.mTemporaryProperties = this.getProperties();
			return true;
		}

		
		/**
		 * 
		 * @param g2d
		 */
		private void drawBoundingBox( final Graphics2D g2d )
		{
			g2d.setStroke( new BasicStroke(1) );
			g2d.setPaint( Color.BLACK );
			g2d.draw( this.getElementBounds() );
		}



		/**
		 * 
		 * @return
		 */
		private ArrayList getAnchorPointList()
		{
			ArrayList list = new ArrayList();

			Rectangle2D rect = this.getElementBounds();
			final float x = (float)rect.getX();
			final float y = (float)rect.getY();
			final float w = (float)rect.getWidth();
			final float h = (float)rect.getHeight();
			
			Point2D nw = new Point2D.Float(x,y);
			Point2D sw = new Point2D.Float(x,y+h);
			Point2D ne = new Point2D.Float(x+w,y);
			Point2D se = new Point2D.Float(x+w,y+h);

			list.add( nw );
			list.add( sw );
			list.add( ne );
			list.add( se );

			return list;
		}


		
		/**
		 * 
		 */
		private boolean createPopupMenu()
		{
			JPopupMenu p = this.mPopupMenu;
			p.setBounds( 0, 0, 100, 100 );

			p.add( new JLabel( "  -- Label --" ) );
			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_MOVE_TO_FRONT );
			SGUtility.addItem( p, this, MENUCMD_MOVE_TO_BACK );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_CUT );
			SGUtility.addItem( p, this, MENUCMD_COPY );
			SGUtility.addItem( p, this, MENUCMD_PASTE );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_DELETE );
			SGUtility.addItem( p, this, MENUCMD_DUPLICATE );

			p.addSeparator();

			SGUtility.addItem( p, this, MENUCMD_PROPERTY );

			return true;
		}


		/**
		 * 
		 */
		private JPopupMenu getPopupMenu()
		{
			return mPopupMenu;
		}



		/**
		 * 
		 * @return
		 */
		public String getTagName()
		{
			return SGIStringConstants.TAG_NAME_LABEL;
		}
		

		/**
		 * 
		 * @param document
		 * @return
		 */
		public Element createElement( final Document document )
		{
			Element el = document.createElement( this.getTagName() );
			if( this.writeProperty(el) == false )
			{
				return null;
			}
			return el;
		}
		
		
		/**
		 * 
		 * @param el
		 * @return
		 */
		public boolean writeProperty( final Element el )
		{
			if( super.writeProperty(el) == false )
			{
				return false;
			}

			el.setAttribute( KEY_X_AXIS_POSITION, mAxisElement.getLocationName( this.mXAxis ) );
			el.setAttribute( KEY_Y_AXIS_POSITION, mAxisElement.getLocationName( this.mYAxis ) );
			el.setAttribute( KEY_X_VALUE, Double.toString( this.getXValue() ) );
			el.setAttribute( KEY_Y_VALUE, Double.toString( this.getYValue() ) );

			return true;
		}
		
		

		/**
		 * 
		 */
		public boolean readProperty( final Element el )
		{
			if( super.readProperty(el) == false )
			{
				return false;
			}
			
			String str = null;
			Number num = null;
			Color cl = null;
			Boolean b = null;
			ArrayList list = null;


			// axes
			str = el.getAttribute( KEY_X_AXIS_POSITION );
			if( str.length()!=0 )
			{
				SGAxis xAxis = mAxisElement.getAxis(str);
				if( xAxis==null )
				{
					return false;
				}
				this.mXAxis = xAxis;
			}
			
			str = el.getAttribute( KEY_Y_AXIS_POSITION );
			if( str.length()!=0 )
			{
				SGAxis yAxis = mAxisElement.getAxis(str);
				if( yAxis==null )
				{
					return false;
				}
				this.mYAxis = yAxis;
			}

			
			// x value
			str = el.getAttribute( KEY_X_VALUE );
			if( str.length()!=0 )
			{
				num = SGUtilityText.getDouble(str);
				if( num==null )
				{
					return false;
				}
				final double xValue = num.doubleValue();
				if( this.mXAxis.isValidValue( xValue ) == false )
				{
					return false;
				}
				if( this.setXValue( xValue ) == false )
				{
					return false;
				}
			}


			// y value
			str = el.getAttribute( KEY_Y_VALUE );
			if( str.length()!=0 )
			{
				num = SGUtilityText.getDouble(str);
				if( num==null )
				{
					return false;
				}
				final double yValue = num.doubleValue();
				if( this.mYAxis.isValidValue( yValue ) == false )
				{
					return false;
				}
				if( this.setYValue( yValue ) == false )
				{
					return false;
				}
			}
			
			return true;
		}

		
		
		/**
		 * 
		 */
		public SGTuple2f getLocation()
		{
			final float x = this.mMagnification*this.mX + mGraphRectX;
			final float y = this.mMagnification*this.mY + mGraphRectY;
			return new SGTuple2f(x,y);
		}


		/**
		 * 
		 */
		public boolean setLocation( final float x, final float y)
		{
			final float dx = x - this.getX();
			final float dy = y - this.getY();

			this.mX = ( x - mGraphRectX )/this.mMagnification;
			this.mY = ( y - mGraphRectY )/this.mMagnification;

			ArrayList list = this.getAllStringElement();
			for( int ii=0; ii<list.size(); ii++ )
			{
				SGDrawingElementString2D el
					= (SGDrawingElementString2D)list.get(ii);
				el.translate( dx, dy );
			}

			return true;
		}


		/**
		 * 
		 */
		public SGProperties getProperties()
		{
			LabelProperties p = new LabelProperties();
			if( this.getProperties(p) == false )
			{
				return null;
			}
			return p;
		}


		/**
		 * 
		 */
		public boolean getProperties( SGProperties p )
		{
			if( ( p instanceof LabelProperties ) == false ) return false;

			if( super.getProperties(p) == false ) return false;

			LabelProperties lp = (LabelProperties)p;

			lp.setX( this.mX );
			lp.setY( this.mY );
			lp.setXAxis( this.mXAxis );
			lp.setYAxis( this.mYAxis );
			lp.setText( this.mString );

			return true;
		}



		/**
		 * 
		 */
		public boolean setProperties( SGProperties p )
		{
			if( ( p instanceof LabelProperties ) == false ) return false;

			if( super.setProperties(p) == false ) return false;

			LabelProperties lp = (LabelProperties)p;

			this.mX = lp.getX().floatValue();
			this.mY = lp.getY().floatValue();
			this.mXAxis = lp.getXAxis();
			this.mYAxis = lp.getYAxis();
			this.setString( lp.getText() );
			
			return true;
		}

		
		
		/**
		 * 
		 */
		public boolean isChanged()
		{
			return this.mUndoManager.isChanged();
		}

		
		public void setChanged( final boolean b )
		{
			this.mUndoManager.setChanged(b);
		}

		public boolean isChangedRoot()
		{
			return this.isChanged();
		}


		/**
		 * 
		 */
		public void actionPerformed( final ActionEvent e )
		{

			final String command = e.getActionCommand();
			final Object source = e.getSource();

			if( command.equals( MENUCMD_PROPERTY ) )
			{
				SGStringElement.this.setPropertiesOfSelectedObjects();
			}
			else if(
				command.equals( MENUCMD_COPY )
				| command.equals( MENUCMD_CUT )
				| command.equals( MENUCMD_PASTE )
				| command.equals( MENUCMD_DELETE )
				| command.equals( MENUCMD_DUPLICATE )
				| command.equals( MENUCMD_MOVE_TO_FRONT )
				| command.equals( MENUCMD_MOVE_TO_BACK )
			)
			{
				notifyToListener( command );
			}

		}



		/**
		 * 
		 */
		public boolean commit()
		{
			// _CAOoOŃvpeBύXĂꍇ̂݁A
			// XV

			SGProperties pTemp = this.mTemporaryProperties;
			SGProperties pPresent = this.getProperties();
			if( pTemp.equals(pPresent) == false )
			{
				this.mUndoManager.setChanged(true);
			}
			repaint();

			this.mTemporaryProperties = null;
			this.mFrameFlag = false;

			notifyChange();

			return true;
		}


		/**
		 * 
		 */
		public boolean preview()
		{
			repaint();
			notifyChange();
			return true;
		}


		/**
		 * 
		 */
		public boolean cancel()
		{
			if( this.setProperties( this.mTemporaryProperties ) == false )
			{
				return false;
			}
			this.mTemporaryProperties = null;

			repaint();
			notifyChange();

			return true;
		}


		/**
		 * Returns a property dialog.
		 * @return property dialog
		 */
		public SGPropertyDialog getPropertyDialog()
		{
			return SGStringElement.this.mDialog;
		}


		/**
		 * Returns a list of child nodes.
		 * @return a list of chid nodes
		 */
		public ArrayList getChildNodes()
		{
			return new ArrayList();
		}



		//
		private SGUndoManager mUndoManager = new SGUndoManager(this);


		/**
		 * 
		 * @return
		 */
		public SGProperties getMemento()
		{
			return this.getProperties();
		}


		/**
		 * 
		 * @param p
		 * @return
		 */
		public boolean setMemento( SGProperties p )
		{
			return this.setProperties(p);
		}


		/**
		 * 
		 * @return
		 */
		public boolean isUndoable()
		{
			return this.mUndoManager.isUndoable();
		}

	
		/**
		 * 
		 * @return
		 */
		public boolean isRedoable()
		{
			return this.mUndoManager.isRedoable();
		}


		/**
		 * 
		 */
		public boolean initPropertiesHistory()
		{
			return this.mUndoManager.initPropertiesHistory();
		}


		/**
		 * AhDs
		 */
		public boolean setMementoBackward()
		{
			return this.mUndoManager.setMementoBackward();
		}


		/**
		 * hDs
		 */
		public boolean setMementoForward()
		{
			return this.mUndoManager.setMementoForward();
		}



		/**
		 * AhD˗
		 */
		public boolean undo()
		{
			return this.setMementoBackward();
		}

	
	
		/**
		 * hD˗
		 */
		public boolean redo()
		{
			return this.setMementoForward();
		}



		/**
		 * ̍XV̎sBAhDΏۂ̑삪sꂽƂɁA^ɌĂ΂B
		 */
		public boolean updateHistory()
		{
			return this.mUndoManager.updateHistory();
		}


		/**
		 * 
		 */
		public void initUndoBuffer()
		{
			this.mUndoManager.initUndoBuffer();
		}


		/**
		 * 
		 *
		 */
		public void notifyToRoot()
		{
			SGStringElement.this.notifyToRoot();
		}

	}

	
	
	
	/**
	 * @author  okumura
	 */
	public static class LabelProperties extends StringProperties
	{
		
		private float mX = 0.0f;
		private float mY = 0.0f;
		private String mText = null;
		private SGAxis mXAxis = null;
		private SGAxis mYAxis = null;

		/**
		 * 
		 *
		 */
		public LabelProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof LabelProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			LabelProperties p = (LabelProperties)obj;
			
			if( this.mX!=p.mX ) return false;
			if( this.mY!=p.mY ) return false;
			if( this.mText.equals(p.mText) == false ) return false;
			if( p.mXAxis.equals(this.mXAxis) == false ) return false;
			if( p.mYAxis.equals(this.mYAxis) == false ) return false;

			return true;
		}


		public Float getX()
		{
			return new Float( this.mX );
		}

		public Float getY()
		{
			return new Float( this.mY );
		}

		public String getText()
		{
			return this.mText;
		}


		public SGAxis getXAxis()
		{
			return this.mXAxis;
		}
		
		public SGAxis getYAxis()
		{
			return this.mYAxis;
		}


		public void setX( final float x )
		{
			this.mX = x;
		}

		public void setY( final float y )
		{
			this.mY = y;
		}

		
		public void setText( final String text )
		{
			if( text==null )
			{
				throw new IllegalArgumentException("text==null");
			}
			this.mText = text;
		}


		public void setXAxis( SGAxis axis )
		{
			if( axis==null )
			{
				throw new IllegalArgumentException("axis==null");
			}
			this.mXAxis = axis;
		}

		public void setYAxis( SGAxis axis )
		{
			if( axis==null )
			{
				throw new IllegalArgumentException("axis==null");
			}
			this.mYAxis = axis;
		}

	}


	
		
	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		StringElementProperties p = new StringElementProperties();
		p.visibleStringElementList = this.getVisibleChildList();
		return p;
	}



	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{

		if( ( p instanceof StringElementProperties ) == false )
		{
			return false;
		}

		StringElementProperties sp = (StringElementProperties)p;

		this.setVisibleChildList( sp.visibleStringElementList );

		return true;

	}



	/**
	 * 
	 */
	public static class StringElementProperties extends SGProperties
	{
		ArrayList visibleStringElementList = new ArrayList();

		public StringElementProperties()
		{
			super();
		}

		public void dispose()
		{
			this.visibleStringElementList.clear();
			this.visibleStringElementList = null;
		}

		public boolean equals( final Object obj )
		{

			if( ( obj instanceof StringElementProperties ) == false )
			{
				return false;
			}

			StringElementProperties p = (StringElementProperties)obj;
			
			if( p.visibleStringElementList.equals(this.visibleStringElementList) == false )
			{
				return false;
			}

			return true;

		}

	}



}


