#!/bin/sh
LOGFILE=/tmp/samurai-graph-$$.log

# set directory
CURRENT_PATH=`pwd`
SCRIPT_PATH=`dirname $0`
CONTRIB_PATH=$SCRIPT_PATH/../..
TOOLS_PATH=$SCRIPT_PATH/../../../tools

# function for getting absolute directory
get_absolute_dir() {
    current_dir=`pwd`
    cd "$1"
    absolute_dir=`pwd`
    cd $current_dir
    echo "$absolute_dir"
}

# set absolute directory
SCRIPT_PATH=`get_absolute_dir $SCRIPT_PATH`
CONTRIB_PATH=`get_absolute_dir $CONTRIB_PATH`
TOOLS_PATH=`get_absolute_dir $TOOLS_PATH`

# set done file
DONEFILE=$CONTRIB_PATH/_build_foxtrot_done

# build depend jar files
# class path
CLASSPATH=
export CLASSPATH

# ant command
ANT=$TOOLS_PATH/ant.sh

# build functions
build_foxtrot () {
  cd $SCRIPT_PATH
  if [ ! -f $DONEFILE ]; then
    echo -n "[foxtrot] creating foxtrot.jar ... "
    $ANT > $LOGFILE 2>&1
    if [ $? != 0 ]; then
      echo error
      cat $LOGFILE
      rm -f $LOGFILE
      exit 1
    else
      echo "done"
    fi
    touch $DONEFILE
    rm -f $LOGFILE
  fi
  cd $CURRENT_PATH
}

clean_foxtrot () {
  cd $SCRIPT_PATH
  rm -f $DONEFILE
  echo -n "[foxtrot] deleting jar files ..."
  $ANT clean > $LOGFILE 2>&1
  if [ $? != 0 ]; then
    echo error
    cat $LOGFILE
    rm -f $LOGFILE
    exit 1
  else
    rm -f $LOGFILE
    echo done
  fi
  cd $CURRENT_PATH
}


case "$1" in
rebuild)
  clean_foxtrot
  build_foxtrot
  ;;
build)
  build_foxtrot
  ;;
clean)
  clean_foxtrot
  ;;
*)
  echo "Usage: ${0##*/}: { build | rebuild | clean }" 2>&1
  exit 65
  ;;
esac

exit 0
