#!/bin/sh
LOGFILE=/tmp/samurai-graph-$$.log

# set directory
CURRENT_PATH=`pwd`
SCRIPT_PATH=`dirname $0`
CONTRIB_PATH=$SCRIPT_PATH/..
TOOLS_PATH=$SCRIPT_PATH/../../tools
FREEHEP_PATH=$SCRIPT_PATH
FREEHEP_TOOLS_PATH=$SCRIPT_PATH/tools

# function for getting absolute directory
get_absolute_dir() {
    current_dir=`pwd`
    cd "$1"
    absolute_dir=`pwd`
    cd $current_dir
    echo "$absolute_dir"
}

# set absolute directory
SCRIPT_PATH=`get_absolute_dir $SCRIPT_PATH`
CONTRIB_PATH=`get_absolute_dir $CONTRIB_PATH`
TOOLS_PATH=`get_absolute_dir $TOOLS_PATH`
FREEHEP_PATH=`get_absolute_dir $FREEHEP_PATH`
FREEHEP_TOOLS_PATH=`get_absolute_dir $FREEHEP_TOOLS_PATH`

# set done file
DONEFILE=$CONTRIB_PATH/_build_vectorgraphics_done

# build depend jar files
FREEHEP_BUILDTOOLS_JAR=$FREEHEP_TOOLS_PATH/freehep-buildtools.jar
JNLP_JAR=$TOOLS_PATH/jnlp.jar

# class path
CLASSPATH=$FREEHEP_BUILDTOOLS_JAR:$JNLP_JAR
export CLASSPATH

# ant command
ANT=$TOOLS_PATH/ant.sh

JARFILES="base graphics2d graphicsio graphicsio-cgm graphicsio-emf graphicsio-gif graphicsio-java graphicsio-pdf graphicsio-ppm graphicsio-ps graphicsio-svg graphicsio-swf"

build_vectorgraphics () {
  cd $FREEHEP_PATH
  if [ ! -f $DONEFILE ]; then
    for i in $JARFILES; do \
      echo -n "[vectorgraphics] creating freehep-$i.jar ... "
      $ANT -Djar=$i > $LOGFILE 2>&1
      if [ $? != 0 ]; then
        echo error
        cat $LOGFILE
        rm -f $LOGFILE
        exit 1
      else
        echo done
      fi
    done
    touch $DONEFILE
    rm -f $LOGFILE
  fi
  cd $CURRENT_PATH
}

clean_vectorgraphics () {
  cd $FREEHEP_PATH
  rm -f $DONEFILE
  echo -n "[vectorgraphics] deleting jar files ..."
  $ANT veryclean > $LOGFILE 2>&1
  if [ $? != 0 ]; then
    echo error
    cat $LOGFILE
    rm -f $LOGFILE
    exit 1
  else
    rm -f lib/freehep-version.txt
    rm -f $LOGFILE
    echo done
  fi
  cd $CURRENT_PATH
}

case "$1" in
rebuild)
  clean_vectorgraphics
  build_vectorgraphics
  ;;
build)
  build_vectorgraphics
  ;;
clean)
  clean_vectorgraphics
  ;;
*)
  echo "Usage: ${0##*/}: { build | rebuild | clean }" 2>&1
  exit 65
  ;;
esac

exit 0
