/*
 * 쐬: 2005/08/25
 *
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;


public class SGApplicationProperties implements SGIApplicationConstants
{
	// version string
	private String mVersion = "-1.-1.-1";
	private int mMajorVersion = -1;
	private int mMinorVersion = -1;
	private int mMicroVersion = -1;
	
	private boolean mStatus = false;
	
	public SGApplicationProperties()
	{
	    mStatus = loadProperties();
	}
	
	public boolean getStatus()
	{
	    return mStatus;
	}
	
	/**
	 * get version string
	 * @return version
	 */
	public String getVersionString()
	{
	    return mVersion;
	}
	
	/**
	 * get major version
	 * @return major version
	 */
	public int getMajorVersion()
	{
	    return mMajorVersion;
	}
	
	/**
	 * get minor version
	 * @return minor version
	 */
	public int getMinorVersion()
	{
	    return mMinorVersion;
	}
	
	/**
	 * ger micro version
	 * @return micro version
	 */
	public int getMicroVersion()
	{
	    return mMicroVersion;
	}
	
	private boolean loadProperties()
	{
		try {
			Properties prop = new Properties();
			InputStream is = ClassLoader.getSystemResourceAsStream( APPLICATION_RESOURCE_DIRECTORY + "/" + APPLICATION_PROPERTY_FILENAME );
			prop.load( is );
			is.close();
			
			// version number
			String version = prop.getProperty( VERSION_PROPERTY_NAME );
			if( version == null ){
				return false;
			}
			// set version
			mVersion = version;
			StringTokenizer st = new StringTokenizer(version, ".");
			if (st.countTokens() != 3){
			    return false;
			}
			int major = Integer.valueOf(st.nextToken()).intValue();
			mMajorVersion = major;
			int minor = Integer.valueOf(st.nextToken()).intValue();
			mMinorVersion = minor;
			int micro = Integer.valueOf(st.nextToken()).intValue();
			mMicroVersion = micro;
		} catch (Exception e)
		{
			return false;
		}
		return true;
	}
}