
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JProgressBar;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;


/**
 * A dialog to display the progress of downloading.
 *
 */
public class SGProgressMonitorDialog extends SGDialog implements Runnable
{

	public static final String TITLE = "Downloading";


	/** Creates new form SGProgressMonitorDialog */
	public SGProgressMonitorDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /** Creates new form SGProgressMonitorDialog */
    public SGProgressMonitorDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
		this.initProperty();
    }

	/** Creates new form SGProgressMonitorDialog */
	public SGProgressMonitorDialog(java.awt.Dialog parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		this.initProperty();
	}

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mButtonPanel = new javax.swing.JPanel();
        mCancelButton = new javax.swing.JButton();
        mProgressBar = new javax.swing.JProgressBar();
        mLabel = new javax.swing.JLabel();
        mMessageLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mPanel.setLayout(new java.awt.GridBagLayout());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(9, 6, 4, 6);
        mPanel.add(mButtonPanel, gridBagConstraints);

        mProgressBar.setPreferredSize(new java.awt.Dimension(150, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        mPanel.add(mProgressBar, gridBagConstraints);

        mLabel.setText("                       ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 10, 10);
        mPanel.add(mLabel, gridBagConstraints);

        mMessageLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMessageLabel.setText("Downloading Now...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 10, 0, 0);
        mPanel.add(mMessageLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    protected javax.swing.JPanel mButtonPanel;
    protected javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mLabel;
    private javax.swing.JLabel mMessageLabel;
    protected javax.swing.JPanel mPanel;
    private javax.swing.JProgressBar mProgressBar;
    // ϐ錾̏I//GEN-END:variables


	private boolean mCanceledFlag = false;


	private boolean initProperty()
	{
		this.setTitle(TITLE);
		this.mCancelButton.addActionListener(this);
		return true;
	}


	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		Object source = e.getSource();
		String command = e.getActionCommand();
		
		if( command.equals( SGDialog.CANCEL_BUTTON_TEXT ) )
		{
			this.onCanceled();
		}
	}


	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
		super.windowClosing(e);
		this.onCanceled();
	}


	/**
	 * 
	 *
	 */
	private boolean onCanceled()
	{
		this.mCanceledFlag = true;
		this.setVisible(false);
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public JProgressBar getProgressBar()
	{
		return this.mProgressBar;
	}


	/**
	 * 
	 * @param text
	 */
	public void setLabel( String text )
	{
		this.mLabel.setText(text);
	}


	/**
	 * 
	 */
	public void setVisible( boolean b )
	{
		if(b)
		{
			this.mCanceledFlag = false;
		}
		super.setVisible(b);
	}


	/**
	 * 
	 * @return
	 */
	public boolean isCanceled()
	{
		return this.mCanceledFlag;
	}



	/**
	 * 
	 */
	private InputStream mInputStream = null;


	/**
	 * 
	 * @param in
	 */
	public void setInputStream( InputStream in )
	{
		this.mInputStream = in;
	}


	/**
	 * 
	 */
	private OutputStream mOutputStream = null;


	/**
	 * 
	 * @param in
	 */
	public void setOutputStream( OutputStream out )
	{
		this.mOutputStream = out;
	}


	/**
	 * 
	 */
	private int mInputSize = 0;
	
	
	/**
	 * 
	 * @param size
	 */
	public void setInputSize( int size )
	{
		this.mInputSize = size;
	}



	/**
	 * 
	 */
	public void run()
	{
		final int bufferLength = 1024;
		byte[] buffer = new byte[bufferLength];
		int len = 0;
		int dl = 0;

		InputStream in = this.mInputStream;
		OutputStream out = this.mOutputStream;
		final int size = this.mInputSize;
		JProgressBar bar = this.mProgressBar;

		try
		{
			// read from input stream
			while( (len=in.read(buffer,0,bufferLength))!=-1 )
			{
				// write
				out.write( buffer, 0, len );

				// set value
				dl += len;
				bar.setValue(dl);

				// set string
				float ratio = 100.0f*dl/size;
				String note = new Integer( (int)ratio ).toString() + "%";
				bar.setString(note);

				// if download is canceled, break the loop
				if( this.isCanceled() )
				{
					break;
				}
			}
		}
		catch( IOException ex )
		{
			return;
		}
		finally
		{
			// set invisible this dialog
			this.setVisible( false );
		}

	}


}
