
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

import javax.swing.JButton;

/**
 * A button used for the selection of the color.
 */
public class SGColorSelectionButton extends JButton
{

	// a flag whether the color is set to this button
	private boolean mColorSetFlag = true;


	/**
	 * Creates a button.
	 */
	public SGColorSelectionButton()
	{
		super();
	}


	/**
	 * Returns the background color if the color is "set" to this button.
	 * @return Color object is the color is "set", otherwise null.
	 */
	public Color getColor()
	{
		return this.mColorSetFlag ? this.getBackground() : null;
	}


	/**
	 * If the color is set with this method, the color is "set" to this button.
	 * @param cl - color to be set to this button
	 */
	public void setColor( Color cl )
	{
		// if given object is not null, the color is "set"
		this.mColorSetFlag = (cl!=null);

		// set as the background color
		this.setBackground( cl );
	}


}

