
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;


/**
 * The class of the file chooser.
 */
public class SGFileChooser extends JFileChooser
{

	// Title of the confirmation dialog.
	private static final String TITLE_CONFIRM_OVERWRITE
		= "Overwrite Confirmation";
	
	
	// Message in the confirmation dialog.
	private static final String MSG_CONFIRM_OVERWRITE
		= "The file you have selected already exists.\n" + "Overwrite it?";


	/**
	 *
	 */
	public SGFileChooser()
	{
		super();
	}
	

	/**
	 * 
	 * @param currentDirectory
	 */
	public SGFileChooser( File currentDirectory )
	{
		super( currentDirectory );
	}
	
	
	/**
	 * 
	 * @param currentDirectoryPath
	 */
	public SGFileChooser( String currentDirectoryPath )
	{
		super( currentDirectoryPath );
	}

	
	
	/**
	 * Overridden to show confirmation dialog when the file already exists. 
	 */
	public void approveSelection()
	{
		// get the selected file
		File file = this.getSelectedFile();

		if( file!=null )
		{
			//
			// check the file extension
			//

			FileFilter ff = this.getFileFilter();
			if( ff instanceof SGExtensionFileFilter )
			{
				SGExtensionFileFilter eff = (SGExtensionFileFilter)ff;
				List eList = eff.getExtensionList(); // list of extensions

				String path = file.getAbsolutePath(); // path set to the file chooser
				final int index = path.lastIndexOf('.');

				String base = null;
				if( index==-1 )
				{
					base = path;
				}
				else
				{
					boolean exists = false;
					String last = path.substring(index).toLowerCase();
					for( int ii=0; ii<eList.size(); ii++ )
					{
						String e = ((String)eList.get(ii)).toLowerCase();
						if( e.equals( last ) )
						{
							exists = true;
							break;
						}
					}
					if( !exists )
					{
						base = path;
					}
				}

				if( base!=null )
				{
					String first = (String)eList.get(0);
					String pathNew = base + first;
					file = new File( pathNew );

					// set the new file
					this.setSelectedFile(file);
				}
			}


			// if selected file already exists
			if( this.getSelectedFile().exists()
				&& this.getDialogType()==JFileChooser.SAVE_DIALOG )
			{
				// beep
				Toolkit.getDefaultToolkit().beep();

				// show confirmation dialog
				int ret = JOptionPane.showConfirmDialog(
					this,
					MSG_CONFIRM_OVERWRITE,
					TITLE_CONFIRM_OVERWRITE,
					JOptionPane.YES_NO_OPTION
				);
		        if( ret == JOptionPane.YES_OPTION )
		        {
		        	super.approveSelection();
		        }
			}
	        else
	        {
	        	super.approveSelection();
	        }
		}
	}



	/**
	 * Overridden not to select directories.
	 * @param f - file to be set
	 */
	public void setSelectedFile( File f )
	{
		if( f!=null && f.isDirectory() )
		{
			return;
		}
		super.setSelectedFile(f);
	}


	/**
	 * 
	 */
	public int showDialog( Component parent, String approveButtonText )
	{
		File old = this.getSelectedFile();
		final int ret = super.showDialog( parent, approveButtonText );
		switch( ret )
		{
			// selected
			case JFileChooser.APPROVE_OPTION :
			{
				break;
			}

			// canceled
			case JFileChooser.CANCEL_OPTION :
			{
				this.setSelectedFile(old);
				break;
			}

			// error
			case JFileChooser.ERROR_OPTION :
			{
				this.setSelectedFile(old);
				break;
			}
		}

		return ret;
	}

}

