
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Font;

import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

/**
 * Constants for axes.
 */
public interface SGIAxisConstants extends SGIConstants
{

	public static final String AXIS_TICK_LENGTH_UNIT = cm;
	public static final double AXIS_TICK_LENGTH_MIN = 0.0;
	public static final double AXIS_TICK_LENGTH_MAX = 0.50;


	public static final int AXIS_EXPONENT_MIN = -10;
	public static final int AXIS_EXPONENT_MAX = 10;



	//
	// Default values
	//

	//
	// Axis Line
	//
	
	// Axis width
	public static final float DEFAULT_AXIS_LINE_WIDTH = 1.5f;

	// Scale width
	public static final float DEFAULT_TICK_MARK_LINE_WIDTH = 1.5f;

	// Scale length
	public static final float DEFAULT_TICK_MARK_LENGTH = 0.25f;

	// Color
	public static final Color DEFAULT_LINE_COLOR = Color.BLACK;



	//
	// Frame
	//

	// Visible
	public static final boolean DEFAULT_FRAME_LINE_VISIBLE = false;

	// Width
	public static final float DEFAULT_FRAME_LINE_WIDTH = 1.5f;

	// Color
	public static final Color DEFAULT_FRAME_LINE_COLOR = Color.BLACK;



	//
	// Font
	//

	public static final String DEFAULT_FONT_NAME = "Serif";
	public static final int DEFAULT_FONT_STYLE = Font.PLAIN;
	public static final float DEFAULT_FONT_SIZE = 16.0f;
	public static final Color DEFAULT_FONT_COLOR = Color.BLACK;



	//
	// Visible Axis
	//

	public static final boolean DEFAULT_BOTTOM_AXIS_VISIBLE = true;
	public static final boolean DEFAULT_TOP_AXIS_VISIBLE = false;
	public static final boolean DEFAULT_LEFT_AXIS_VISIBLE = true;
	public static final boolean DEFAULT_RIGHT_AXIS_VISIBLE = false;



	//
	// Title
	//

	public static final String DEFAULT_BOTTOM_AXIS_TITLE = "X Label";
	public static final String DEFAULT_TOP_AXIS_TITLE = "X Label";
	public static final String DEFAULT_LEFT_AXIS_TITLE = "Y Label";
	public static final String DEFAULT_RIGHT_AXIS_TITLE = "Y Label";


	//
	// Scale
	//

	// Number
	public static final boolean DEFAULT_NUMBER_VISIBLE = true;
	public static final boolean DEFAULT_NUMBER_INTEGER = false;

	// Scale Line
	public static final boolean DEFAULT_SCALE_LINE_VISIBLE = true;
	public static final boolean DEFAULT_SCALE_LINE_INNER = true;



}

