
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;

/**
 *
 */
public class SGDrawingElementRectangle2D extends SGDrawingElementRectangle
	implements SGIDrawingElementJava2D
{

	/**
	 * 
	 */
	public SGDrawingElementRectangle2D()
	{
		super();
	}


	/**
	 * 
	 */
	public Rectangle2D getElementBounds()
	{
		final float mag = this.getMagnification();
		final float x = this.getX();
		final float y = this.getY();
		final float w = mag*this.getWidth();
		final float h = mag*this.getHeight();

		final float ww = Math.abs(w);
		final float hh = Math.abs(h);
		final float xx = w>0.0f ? x : x-ww;
		final float yy = h>0.0f ? y : y-hh;

		Rectangle2D rect = new Rectangle2D.Float(xx,yy,ww,hh);

		return rect;
	}


	/**
	 * 
	 */
	public boolean contains(final int x, final int y)
	{
		return this.getRectShape().contains(x,y);
	}

	/**
	 * 
	 * @return
	 */
	protected Shape getRectShape()
	{
		return this.getElementBounds();
	}
	
	/**
	 * 
	 * @param g2d
	 */
	public void paintElement( final Graphics2D g2d )
	{
		if( this.isVisible() == false )
		{
			return;
		}

		final Shape sh = this.getRectShape();
		if( !this.isTransparent() )
		{
			g2d.setPaint( this.getColor(0) );
			g2d.fill(sh);
		}

		final float width
			= this.getMagnification()*this.getEdgeLineWidth();
		Stroke stroke = SGUtilityJava2D.getBasicStroke(
			this.getEdgeLineType(), width, this.getStrokeCap(),
			this.getStrokeJoin(), this.getStrokeMiterLimit(),
			this.getStrokeDashPhase() );
		g2d.setStroke(stroke);
		g2d.setPaint( this.getEdgeLineColor() );
		g2d.draw(sh);
	}


	/**
	 * 
	 */
	public void paint( final Graphics2D g2d, final Rectangle2D clipRect )
	{
		this.paintElement(g2d);
	}


}

