
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.List;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;

import org.w3c.dom.Element;


/**
 * 
 */
public abstract class SGElementGroupRectangle extends SGElementGroupSXY
	implements SGIRectangleConstants
{


	/**
	 * 
	 */
	protected float mRectangleWidth;


	/**
	 * 
	 */
	protected float mRectangleHeight;


	/**
	 * 
	 */
	protected float mEdgeLineWidth;


	/**
	 * 
	 */
	protected Color mEdgeLineColor;



	/**
	 *
	 */
	public SGElementGroupRectangle()
	{
		super();
	}


	/**
	 * 
	 */
	public void dispose()
	{
		super.dispose();

		this.mEdgeLineColor = null;
	}


	/**
	 * 
	 */
	public float getRectangleWidth()
	{
		return this.mRectangleWidth;
	}


	/**
	 * 
	 * @param unit
	 * @return
	 */
	public float getRectangleWidth( final String unit )
	{
		return (float)SGUtilityText.convertFromPoint( this.getRectangleWidth(), unit );
	}


	/**
	 * 
	 */
	public float getRectangleHeight()
	{
		return this.mRectangleHeight;
	}


	/**
	 * 
	 * @param unit
	 * @return
	 */
	public float getRectangleHeight( final String unit )
	{
		return (float)SGUtilityText.convertFromPoint( this.getRectangleHeight(), unit );
	}


	/**
	 * 
	 */
	public float getEdgeLineWidth()
	{
		return this.mEdgeLineWidth;
	}
	
	
	/**
	 * 
	 * @param unit
	 * @return
	 */
	public float getEdgeLineWidth( final String unit )
	{
		return (float)SGUtilityText.convertFromPoint( this.getEdgeLineWidth(), unit );
	}


	/**
	 * 
	 */
	public Color getEdgeLineColor()
	{
		return this.mEdgeLineColor;
	}



	/**
	 * 
	 * @param value
	 * @return
	 */
	public boolean setRectangleWidth( final float value )
	{
		if( this.mDrawingElementArray==null )
		{
			return true;
		}
		
		this.mRectangleWidth = value;

		SGDrawingElement[] array = this.mDrawingElementArray;
		for( int ii=0; ii<array.length; ii++ )
		{
			SGDrawingElementBar2D bar = (SGDrawingElementBar2D)array[ii];
			bar.setWidth(value);
		}

		return true;
	}


	/**
	 * 
	 * @param width
	 * @param unit
	 * @return
	 */
	public boolean setRectangleWidth( final float width, final String unit )
	{
		final double w = SGUtilityText.convertToPoint( width, unit );
		if( this.setRectangleWidth( (float)w ) == false )
		{
			return false;
		}

		return true;
	}


	/**
	 * 
	 * @param value
	 * @return
	 */
	public boolean setRectangleHeight( final float value )
	{
		if( this.mDrawingElementArray==null )
		{
			return true;
		}
		
		this.mRectangleHeight = value;

		SGDrawingElement[] array = this.mDrawingElementArray;
		for( int ii=0; ii<array.length; ii++ )
		{
			SGDrawingElementBar2D bar = (SGDrawingElementBar2D)array[ii];
			bar.setHeight(value);
		}

		return true;
	}


	/**
	 * 
	 * @param height
	 * @param unit
	 * @return
	 */
	public boolean setRectangleHeight( final float height, final String unit )
	{
		final double h = SGUtilityText.convertToPoint( height, unit );
		if( this.setRectangleHeight( (float)h ) == false )
		{
			return false;
		}

		return true;
	}


	/**
	 *
	 */
	public boolean setEdgeLineWidth( final float width )
	{
		this.mEdgeLineWidth = width;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementBar2D el = (SGDrawingElementBar2D)this.mDrawingElementArray[ii];
				el.setEdgeLineWidth( this.mEdgeLineWidth );
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setEdgeLineWidth( final float width, final String unit )
	{
		final double lw = SGUtilityText.convertToPoint( width, unit );
		if( this.setEdgeLineWidth( (float)lw ) == false )
		{
			return false;
		}

		return true;
	}


	/**
	 *
	 */
	public boolean setEdgeLineColor( final Color color )
	{
		this.mEdgeLineColor = color;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementBar2D el = (SGDrawingElementBar2D)this.mDrawingElementArray[ii];
				el.setEdgeLineColor( this.mEdgeLineColor );
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public boolean setEdgeLineColor( final String value )
	{
		final Color cl = SGUtilityText.getColor(value);
		if( cl==null )
		{
			return false;
		}
		return this.setEdgeLineColor(cl);
	}


	/**
	 * 
	 * @param r
	 * @param g
	 * @param b
	 * @return
	 */
	public boolean setEdgeLineColor( final String r, final String g, final String b )
	{
		final Color cl = SGUtilityText.getColor(r,g,b);
		if( cl==null )
		{
			return false;
		}
		return this.setEdgeLineColor(cl);
	}


	/**
	 * 
	 */
	public SGDrawingElement getDrawingElement()
	{
		SGDrawingElementRectangle rect
			= (SGDrawingElementRectangle)this.createDrawingElementInstance();
		rect.setWidth( this.getRectangleWidth() );
		rect.setHeight( this.getRectangleHeight() );
		rect.setVisible( this.isVisible() );
		rect.setEdgeLineWidth( this.getEdgeLineWidth() );
		rect.setEdgeLineColor( this.getEdgeLineColor() );
		rect.setColorList( this.getColorList() );

		return rect;
	}


	/**
	 * 
	 * @return
	 */
	protected SGDrawingElement createDrawingElementInstance()
	{
		return new SGDrawingElementRectangle2D();
	}


	/**
	 * 
	 * @return
	 */
	protected boolean initDrawingElement( final SGTuple2f[] array )
	{
		final int num = array.length;
		if( this.initDrawingElement(num) == false )
		{
			return false;
		}

		SGDrawingElement[] bArray = this.mDrawingElementArray;
		for( int ii=0; ii<bArray.length; ii++ )
		{
			((SGDrawingElementRectangle)bArray[ii]).setLocation( array[ii].x, array[ii].y );
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementRectangle) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementRectangle rect = (SGDrawingElementRectangle)element;
		this.setRectangleWidth( rect.getWidth() );
		this.setRectangleHeight( rect.getHeight() );
		this.setEdgeLineWidth( rect.getEdgeLineWidth() );
		this.setEdgeLineColor( rect.getEdgeLineColor() );

		return true;
	}


	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		final float ratio = SGIConstants.CM_POINT_RATIO;

		el.setAttribute( KEY_RECTANGLE_WIDTH, Float.toString( this.mRectangleWidth*ratio ) + SGIConstants.cm );
		el.setAttribute( KEY_RECTANGLE_HEIGHT, Float.toString( this.mRectangleHeight*ratio ) + SGIConstants.cm );
		el.setAttribute( KEY_EDGE_LINE_WIDTH, Float.toString( this.mEdgeLineWidth ) + SGIConstants.pt );
		el.setAttribute( KEY_COLOR_LIST, SGUtilityText.getColorListString( this.mColorList ) );
		el.setAttribute( KEY_EDGE_LINE_COLOR, SGUtilityText.getColorString( this.mEdgeLineColor ) );

		return true;
	}


	/**
	 * 
	 * @param el
	 * @return
	 */
	public boolean readProperty( final Element el )
	{
		final float ratio = SGIConstants.CM_POINT_RATIO;

		String str = null;
		Number num = null;
		Color cl = null;
		Boolean b = null;
		List list = null;

		// width of the bar
		str = el.getAttribute( KEY_RECTANGLE_WIDTH );
		if( str.length()!=0 )
		{
			// The attribute of width-value is added from version 0.9.1
			// This code is for the old versions.

			str = el.getAttribute( KEY_RECTANGLE_WIDTH );
			if( str.length()==0 )
			{
				return false;
			}
			StringBuffer uWidth = new StringBuffer();
			num = SGUtilityText.getNumber( str, uWidth );
			if( num==null )
			{
				return false;
			}

			if( this.setRectangleWidth( num.floatValue(), uWidth.toString() ) == false )
			{
				return false;
			}
		}


		// inner color list
		str = el.getAttribute( KEY_COLOR_LIST );
		if( str.length()!=0 )
		{
			list = SGUtilityText.getColorList(str);
			if( list==null )
			{
				return false;
			}
			if( list.size()<1 )
			{
				return false;
			}
			if( this.setColorList( list ) == false )
			{
				return false;
			}
		}


		// edge line width
		str = el.getAttribute( KEY_EDGE_LINE_WIDTH );
		if( str.length()!=0 )
		{
			StringBuffer uEdgeLineWidth = new StringBuffer();
			num = SGUtilityText.getNumber( str, uEdgeLineWidth );
			if( num==null )
			{
				return false;
			}
			final float edgeLineWidth = num.floatValue();
			if( this.setEdgeLineWidth( edgeLineWidth, uEdgeLineWidth.toString() ) == false )
			{
				return false;
			}
		}


		// edge line color
		str = el.getAttribute( KEY_EDGE_LINE_COLOR );
		if( str.length()!=0 )
		{
			cl = SGUtilityText.getColorFromString(str);
			if( cl==null )
			{
				return false;
			}
			final Color edgeLineColor = cl;
			if( this.setEdgeLineColor( edgeLineColor ) == false )
			{
				return false;
			}
		}

		return true;
	}



}
