
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;

/**
 * A dialog to set the properties of labels.
 */
public class SGStringElementDialog extends SGPropertyDialog
	implements SGIStringConstants
{

	/**
	 * 
	 */
	public static final String TITLE = "Label Properties";


    /** Creates new form SGStringElementDialog */
    public SGStringElementDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTextPanel = new javax.swing.JPanel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mTextAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTextColorLabel = new javax.swing.JLabel();
        mTextAngleLabel = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFontNameComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mFontStyleLabel = new javax.swing.JLabel();
        mTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mTextLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mTextPanel.setLayout(new java.awt.GridBagLayout());

        mTextPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mTextPanel.add(mFontSizeLabel, gridBagConstraints);

        mTextAngleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextAngleSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mTextAngleSpinner, gridBagConstraints);

        mTextColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextColorLabel, gridBagConstraints);

        mTextAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextAngleLabel, gridBagConstraints);

        mFontSizeSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mFontSizeSpinner, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mColorButton, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontNameComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        mTextPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTextPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 0, 0);
        mTextPanel.add(mStringSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mYValueTextField, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 4, 0, 0);
        mTextPanel.add(mLocationSeparator, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mTextPanel.add(mFontStyleLabel, gridBagConstraints);

        mTextField.setColumns(16);
        mTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mTextField, gridBagConstraints);

        mTextLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextLabel.setText("Text");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 5, 5);
        mTextPanel.add(mTextLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTextPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mColorButton;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JLabel mTextAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mTextAngleSpinner;
    private javax.swing.JLabel mTextColorLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTextField;
    private javax.swing.JLabel mTextLabel;
    private javax.swing.JPanel mTextPanel;
    private javax.swing.JLabel mXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mYValueTextField;
    // ϐ錾̏I//GEN-END:variables


//	/**
//	 * 
//	 *
//	 */
//	public void dispose()
//	{
//		if( this.mAxisPanel!=null )
//		{
//			this.mAxisPanel.dispose();
//			this.mAxisPanel = null;
//		}
//		
//		super.dispose();
//	}


	public static final double STRING_ANGLE_STEP = 1.0;


	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGStringElementDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontNameComboBox.addItem( fontArray[ii] );
			}

			final String[] styleNameArray = {
				FONT_PLAIN,
				FONT_ITALIC,
				FONT_BOLD,
				FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}

		}

		this.pack();


		//
		// spinner model
		//

		// font size
		this.mFontSizeSpinner.initProperties(
			getFontSizeSpinnerNumberModel(),
			FONT_SIZE_UNIT, 1, 2 );


		// angle
		this.mTextAngleSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, STRING_ANGLE_MIN, STRING_ANGLE_MAX, STRING_ANGLE_STEP ),
			degree, 1, 2 );

		{
			this.mOKButton.addActionListener(this);
			this.mCancelButton.addActionListener(this);
			this.mPreviewButton.addActionListener(this);
		}
		

		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;


		// set the name
		this.mTextField.setDescription("Text");
		this.mXValueTextField.setDescription("Location-> X");
		this.mYValueTextField.setDescription("Location-> Y");
		this.mFontSizeSpinner.setDescription("String-> Size");
		this.mTextAngleSpinner.setDescription("String-> Angle");

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public String getText()
	{
		return this.mTextField.getText();
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}

	
	
   	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public Color getTextColor()
	{
		return this.mColorButton.getColor();
	}


	/**
	 * 
	 */
	public Number getAngle()
	{
		return this.mTextAngleSpinner.getNumber();
	}


	/**
	 * 
	 * @param str
	 * @return
	 */
	public boolean setText( final String str )
	{
		this.mTextField.setText( str );
		return true;
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setFontSize( final Object obj )
	{
		return this.setValue( this.mFontSizeSpinner, obj );
	}

	
	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final Integer style )
	{
		String styleName = null;
		if( style!=null )
		{
			styleName = SGUtilityText.getFontStyleName( style.intValue() );
		}
		this.mFontStyleComboBox.setSelectedItem( styleName );

		return true;
	}


	/**
	 * 
	 */
	public boolean setTextColor( final Color cl )
	{
		this.mColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setAngle( final Object obj )
	{
		return this.setValue( this.mTextAngleSpinner, obj );
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		return this.setValue( this.mXValueTextField, obj );
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		return this.setValue( this.mYValueTextField, obj );
	}

	

	/**
	 * 
	 */
	public List getColorSelectionButtonsList()
	{
		final List list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		list.add( this.mTextField );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public List getNumberTextFieldList()
	{
		final List list = new ArrayList();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public List getSpinnerList()
	{
		List list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mTextAngleSpinner );
		return list;
	}


	

	/**
	 * Set properties to all listeners.
	 * @param l
	 * @return
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGILabelDialogObserver label = (SGILabelDialogObserver)l;

		// get values
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
		final String text = this.getText();
		final Number xValue = this.getXValue();
		final Number yValue = this.getYValue();
		final Number fontSize = this.getFontSize();
		final String fontName = this.getFontName();
		final int fontStyle = this.getFontStyle();
		final Number angle = this.getAngle();
		final Color cl = this.getTextColor();


		// check values
		ArrayList list = new ArrayList();
		if( label.hasValidXValue( xConfig, xValue ) == false )
		{
			list.add("X");
		}
		if( label.hasValidYValue( yConfig, yValue ) == false )
		{
			list.add("Y");
		}
		if( list.size()!=0 )
		{
			String msg = ERRMSG_AXIS_VALUE_INVALID + ":\n";
			for( int ii=0; ii<list.size(); ii++ )
			{
				String str = (String)list.get(ii);
				msg += " - " + str + "\n";
			}
			this.setInputErrorMessage(msg);
			return false;
		}


		// set the related axes
		if( xConfig!=-1 )
		{
			label.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			label.setYAxisLocation( yConfig );
		}


		// text
		if( text!=null )
		{
			label.setString( text );
		}


		// x value
		if( xValue!=null )
		{
			label.setXValue( xValue.doubleValue() );
		}


		// y value
		if( yValue!=null )
		{
			label.setYValue( yValue.doubleValue() );
		}


		// font size
		if( fontSize!=null )
		{
			label.setFontSize( fontSize.floatValue(), pt );
		}


		// font name
		if( fontName!=null )
		{
			label.setFontName( fontName );
		}


		// font style
		if( fontStyle!=-1 )
		{
			label.setFontStyle( fontStyle );
		}


		// angle
		if( angle!=null )
		{
			label.setAngle( angle.floatValue()*RADIAN_DEGREE_RATIO );
		}


		// color
		if( cl!=null )
		{
			label.setStringColor( cl );
		}

		
		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
		final SGStringElementDialog dg = this;

		List list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}


		SGILabelDialogObserver label0
			= (SGILabelDialogObserver)list.get(0);

		final String str0 = label0.getString();
		final double xValue0 = label0.getXValue();
		final double yValue0 = label0.getYValue();
		final String fontName0 = label0.getFontName();
		final float fontSize0 = label0.getFontSize( pt );
		final int fontStyle0 = label0.getFontStyle();
		final float angle0 = label0.getAngle();
		final Color color0 = label0.getStringColor();

		String str = new String( str0 );
		Double xValue = new Double( xValue0 );
		Double yValue = new Double( yValue0 );
		String fontName = new String( fontName0 );
		Float fontSize = new Float( fontSize0 );
		Integer fontStyle = new Integer( fontStyle0 );
		Float angle = new Float( angle0 );
		Color color = color0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final String str1 = label1.getString();
				if( str0.equals(str1) == false )
				{
					str = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final double xValue1 = label1.getXValue();
				if( xValue0!=xValue1 )
				{
					xValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final double yValue1 = label1.getYValue();
				if( yValue0!=yValue1 )
				{
					yValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final String fontName1 = label1.getFontName();
				if( fontName0.equals(fontName1) == false )
				{
					fontName = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final float fontSize1 = label1.getFontSize( pt );
				if( fontSize0!=fontSize1 )
				{
					fontSize = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final int fontStyle1 = label1.getFontStyle();
				if( fontStyle0!=fontStyle1 )
				{
					fontStyle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final float angle1 = label1.getAngle();
				if( angle0!=angle1 )
				{
					angle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILabelDialogObserver label1
					= (SGILabelDialogObserver)list.get(ii);
				final Color color1 = label1.getStringColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}
		}


		//
		this.setText( str );
		this.setXValue( xValue );
		this.setYValue( yValue );
		this.setFontName( fontName );
		this.setFontSize( fontSize );
		this.setFontStyle( fontStyle );
		
		if( angle!=null )
		{
			angle = new Float( angle.floatValue()/RADIAN_DEGREE_RATIO );
		}
		this.setAngle( angle );
		this.setTextColor( color );


		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * Overrode to check the text field.
	 * @return
	 */
	protected boolean hasValidInputValues()
	{
		if( super.hasValidInputValues() == false )
		{
			return false;
		}

		// 
		if( this.mTextField.hasValidText() == false )
		{
			this.addInputErrorDescription( this.mTextField.getDescription() );
			return false;
		}

		return true;
	}


}

