;--------------
; Java Launcher
;--------------
SetCompressor /SOLID lzma
 
; generic 
Name    "Samurai Graph"
Caption "Samurai Graph"
Icon    "resources/samurai-graph.ico"
OutFile "samurai-graph.exe"
 
SilentInstall silent
AutoCloseWindow true
ShowInstDetails nevershow

!define BASENAME    "samurai-graph"
!define JARFILE     "${BASENAME}.jar"
!define INIFILE     "${BASENAME}.ini"
!define DEFAULT_JAVAVM "javaw.exe"
!define JAVAVM_STR  "javavm"
!define VMARGS_STR  "vmargs"

!define MES_JavaUrl "http://www.java.com/"
!define MES_JreNotFound "The Java Runtime Environment was not detected. $\r$\rPlease download Java software from Java download page$\r${MES_JavaUrl}"

;;
;; main
;;
Section ""
  ReadINIStr $R0 "$EXEDIR\${INIFILE}" ${BASENAME} ${JAVAVM_STR}
  ClearErrors
  Push $R0
  Call CheckJava
  Pop $R0
  Call GetParameters
  Pop $R1
  ReadINIStr $R2 "$EXEDIR\${INIFILE}" ${BASENAME} ${VMARGS_STR}
  ClearErrors
  StrCpy $0 '"$R0" $R2 -jar "$EXEDIR\${JARFILE}" $R1'
;  SetOutPath $EXEDIR
  Exec $0
SectionEnd

; GetParameters
; input, none
; output, top of stack (replaces, with e.g. whatever)
; modifies no other variables.
Function GetParameters
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
  StrCpy $R1 '"'
  Goto loop
  StrCpy $R1 " "
  
 loop:
  IntOp $R2 $R2 + 1
  StrCpy $R0 $CMDLINE 1 $R2
  StrCmp $R0 $R1 get
  StrCmp $R2 $R3 get
  Goto loop
  
 get:
  IntOp $R2 $R2 + 1
  StrCpy $R0 $CMDLINE 1 $R2
  StrCmp $R0 " " get
  StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd

;;
;; Check Java installed
;;
Function CheckJava
  Exch $R0
  StrCmp $R0 "" SetDefaultJavaVm
  goto CheckJavaVm
 SetDefaultJavaVm:
  StrCpy $R0 ${DEFAULT_JAVAVM}
 CheckJavaVm:
  Push $R0
; Check JRE installed
  Call GetJRE
  Pop $R0
  StrCmp $R0 "" JreNotFound
  goto JreFound
JreNotFound:
  ExecShell "open" ${MES_JavaUrl}
  MessageBox MB_OK|MB_ICONSTOP|MB_TOPMOST "${MES_JreNotFound}"
  DetailPrint "The installation was canceled.."
  Abort
JreFound:
  Exch $R0
FunctionEnd

;;
;;  Find JRE
;;
;;  param  1 - Java VM command ("javaw.exe" or "java.exe")
;;  return 1 - full path for Java VM
;;
Function GetJRE
;  1 - in .\jre directory (JRE Installed with application)
;  2 - in JAVA_HOME environment variable
;  3 - in the Java Runtime Environment registry
;  4 - in JDK_HOME environment variable
;  5 - in the Java Development Kit registry
;  6 - give up..

  Exch $R0
  Push $R1
  Push $R2

; JreCheck1:
  ClearErrors
  StrCpy $R1 "$EXEDIR\jre\bin\$R0"
  IfFileExists $R1 JreFound

; JreCheck2:
  ClearErrors
  StrCpy $R1 ""
  ReadEnvStr $R1 "JAVA_HOME"
  IfErrors JreCheck3
  StrCpy $R1 "$R1\bin\$R0"
  IfFileExists $R1 JreFound

 JreCheck3:
  ClearErrors
  ReadRegStr $R2 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$R2" "JavaHome"
  IfErrors JreCheck4
  StrCpy $R1 "$R1\bin\$R0"
  IfFileExists $R1 JreFound

 JreCheck4:
  ClearErrors
  StrCpy $R1 ""
  ReadEnvStr $R1 "JDK_HOME"
  IfErrors JreCheck5
  StrCpy $R1 "$R1\bin\$R0"
  IfFileExists $R1 JreFound

 JreCheck5:
  ClearErrors
  ReadRegStr $R2 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R2" "JavaHome"
  IfErrors JreCheck6
  StrCpy $R1 "$R1\jre\bin\$R0"
  IfFileExists $R1 JreFound

 JreCheck6:
  ClearErrors
  StrCpy $R1 ""

 JreFound:
  StrCpy $R0 $R1
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd
