
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

/**
 * An object to manage significant difference symbols.
 * 
 */
public interface SGIFigureElementSignificantDifference extends SGIFigureElement
{

	/**
	 * 
	 */
	public static final String TAG_NAME_SIGNIFICANT_DIFFERENCE
		= "SignificantDifferenceSymbols";

	
	/**
	 * 
	 * @param element
	 */
	public void setAxisElement( final SGIFigureElementAxis element );


	/**
	 * 
	 */
	public boolean addSignificantDifferenceSymbol( final int x, final int y );

	
	/**
	 * 
	 */
	public boolean addSignificantDifferenceSymbol( final SGAxis xAxis, final SGAxis yAxis, final int x, final int y );



	public boolean setAxisXDirectly( final int id, final int value );
	public boolean setAxisYDirectly( final int id, final int value );
	public boolean setLocationHorizontalYDirectly( final int id, final double value );
	public boolean setLocationLeftXDirectly( final int id, final double value );
	public boolean setLocationLeftYDirectly( final int id, final double value );
	public boolean setLocationRightXDirectly( final int id, final double value );
	public boolean setLocationRightYDirectly( final int id, final double value );
	public boolean setLineVisibleDirectly( final int id, final boolean value );
	public boolean setSpaceDirectly( final int id, final float value, final String unit );
	public boolean setLineWidthDirectly( final int id, final float value, final String unit );
	public boolean setTextDirectly( final int id , final String value );
	public boolean setFontNameDirectly( final int id, final String value );
	public boolean setFontStyleDirectly( final int id, final int value );
	public boolean setFontSizeDirectly( final int id, final float value, final String unit );
	public boolean setFontColorDirectly( final int id, final Color value );


}

