
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;

/**
 * Constants for shape objects.
 * 
 */
public interface SGIShapeConstants
{

	//
	// Default vaules
	//

	// X Axis
	public static final String DEFAULT_SHAPE_HORIZONTAL_AXIS = SGIFigureElementAxis.AXIS_BOTTOM;

	// Y Axis
	public static final String DEFAULT_SHAPE_PERPENDICULAR_AXIS = SGIFigureElementAxis.AXIS_LEFT;


	//
	// Line
	//

	// Line Width
	public static final float DEFAULT_SHAPE_LINE_WIDTH = 1.5f;

	// Line Type
	public static final int DEFAULT_SHAPE_LINE_TYPE = SGILineConstants.LINE_TYPE_SOLID;

	// Color
	public static final Color DEFAULT_SHAPE_LINE_COLOR = Color.BLACK;


	//
	// Arrow
	//

	// Line Width
	public static final float DEFAULT_SHAPE_ARROW_LINE_WIDTH = DEFAULT_SHAPE_LINE_WIDTH;

	// Line Type
	public static final int DEFAULT_SHAPE_ARROW_LINE_TYPE = DEFAULT_SHAPE_LINE_TYPE;
	
	// Color
	public static final Color DEFAULT_SHAPE_ARROW_COLOR = DEFAULT_SHAPE_LINE_COLOR;
	
	// Head Size
	public static final float DEFAULT_SHAPE_ARROW_HEAD_SIZE = 0.4f;

	// Start Head Type
	public static final int DEFAULT_SHAPE_ARROW_START_HEAD_TYPE = SGISymbolConstants.SYMBOL_TYPE_VOID;

	// End Head Type
	public static final int DEFAULT_SHAPE_ARROW_END_HEAD_TYPE = SGIArrowConstants.SYMBOL_TYPE_ARROW_HEAD;

	// Open Angle
	public static final float DEFAULT_SHAPE_ARROW_HEAD_OPEN_ANGLE = (float)Math.PI/6.0f;

	// Close Angle
	public static final float DEFAULT_SHAPE_ARROW_HEAD_CLOSE_ANGLE = (float)Math.PI/3.0f;


	//
	// Rectangle
	//

	// Width
	public static final float DEFAULT_SHAPE_RETANGLE_WIDTH = 5.0f;

	// Height
	public static final float DEFAULT_SHAPE_RETANGLE_HEIGHT = 4.0f;

	// Color
	public static final Color DEFAULT_SHAPE_RECTANGLE_INNER_COLOR = Color.WHITE;

	// Edge Line Width
	public static final float DEFAULT_SHAPE_RCTANGLE_EDGE_LINE_WIDTH = DEFAULT_SHAPE_LINE_WIDTH;

	// Edge Line Type
	public static final int DEFAULT_SHAPE_RCTANGLE_EDGE_LINE_TYPE = DEFAULT_SHAPE_LINE_TYPE;

	// Edge Line Color
	public static final Color DEFAULT_SHAPE_RECTANGLE_EDGE_LINE_COLOR = DEFAULT_SHAPE_LINE_COLOR;

	// Transparecy
	public static final boolean DEFAULT_SHAPE_RECTANGLE_TRANSPARENT = false;

}

