#!/bin/sh
SCRIPT_PATH=`dirname $0`

# get absolute directory
CURRENT_PATH=`pwd`
cd $SCRIPT_PATH
SCRIPT_PATH=`pwd`
cd $CURRENT_PATH

# check JDK_HOME environment
JDK_HOME_ENV=`env | grep JDK_HOME`
JAVA_HOME_ENV=`env | grep JAVA_HOME`
JAVAHOME_ENV=`env | grep JAVAHOME`
JAVA_PATH_ENV=`env | grep JAVA_PATH`
if [ -z $JDK_HOME_ENV ]; then
  if [ -z $JAVA_HOME_ENV ]; then
    if [ -z $JAVAHOME_ENV ]; then
      if [ -z $JAVA_PATH_ENV ]; then
        echo "Error : JDK_HOME or JAVA_HOME or JAVAHOME or JAVA_PATH does not defined"
        exit 1
      else
        JDK_HOME=$JAVA_PATH
      fi
    else
      JDK_HOME=$JAVAHOME
    fi
  else
    JDK_HOME=$JAVA_HOME
  fi
fi

# change current directory to top directory of vectorgraphics libraries.
TOOLS_PATH=$SCRIPT_PATH
ANT_HOME=$TOOLS_PATH
ANT_OPTS=

# build depend jar files
ANT_JAR=$ANT_HOME/ant.jar
ANT_OPTIONAL_JAR=$ANT_HOME/ant-optional.jar
JUNIT_JAR=$TOOLS_PATH/junit.jar
JDK_TOOLS_JAR=$JDK_HOME/lib/tools.jar

# class path
CLASSPATH=$CLASSPATH:$JUNIT_JAR:$ANT_JAR:$ANT_OPTIONAL_JAR:$JDK_TOOLS_JAR

# ant command
ANT="java -cp $CLASSPATH -Dant.home=\"$ANT_HOME\" $ANT_OPTS org.apache.tools.ant.Main"

$ANT $*
exit $?
