/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.preview;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.preview.TextLabel;

public class LabelPlacer
extends Component {
    Vector labels = new Vector();
    Random xRandom = new Random();
    Random yRandom = new Random();
    Random locRandom = new Random();
    int border = 50;
    static Label labelCount = new Label("# of Labels: 00");
    static Label conflictCount = new Label("# of Conflicts: 00");
    static Label temperature = new Label("T: 00");
    static Label stageCount = new Label("Stage: 50");

    public LabelPlacer() {
        this.setBackground(Color.black);
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 640);
    }

    public void paint(Graphics g) {
        VectorGraphics g1 = VectorGraphics.create((Graphics)g);
        Rectangle d = this.getBounds();
        g1.setColor(this.getBackground());
        g1.fillRect(d.x, d.y, d.width, d.height);
        g1.setColor(this.getForeground());
        Enumeration e = this.labels.elements();
        while (e.hasMoreElements()) {
            TextLabel label = (TextLabel)e.nextElement();
            int hor = label.getAlignmentX();
            int ver = label.getAlignmentY();
            int x = label.getX();
            int y = label.getY();
            if (label.getConflicts() > 0) {
                g1.setColor(Color.cyan);
            } else {
                g1.setColor(Color.white);
            }
            Rectangle r = label.getBounds();
            g1.drawRect(this.border + r.x, this.border + r.y, r.width, r.height);
            g1.drawString(label.getText(), (double)(this.border + x), (double)(this.border + y), hor, ver);
            g1.setColor(Color.red);
            g1.fillRect(this.border + x - 1, this.border + y - 1, 3, 3);
        }
    }

    private void addLabels(int n) {
        Dimension d = this.getSize();
        while (n > 0) {
            this.labels.addElement(new TextLabel("Point " + this.labels.size(), new Point(this.xRandom.nextInt(d.width - 2 * this.border), this.yRandom.nextInt(d.height - 2 * this.border)), this.locRandom.nextInt(8), this));
            --n;
        }
        this.setConflicts();
        this.keep();
        labelCount.setText("# of Labels: " + this.labels.size());
    }

    private void positionLabels(int algorithm) {
        block1 : switch (algorithm) {
            case 1: {
                int oldConflicts = this.countConflicts();
                for (int i = 0; i < this.labels.size(); ++i) {
                    TextLabel ref = (TextLabel)this.labels.elementAt(i);
                    ref.tmpPosition = this.locRandom.nextInt(8);
                }
                if (this.setConflicts() >= oldConflicts) break;
                this.keep();
                break;
            }
            case 2: {
                int oldConflicts = this.countConflicts();
                for (int i = 0; i < this.labels.size(); ++i) {
                    TextLabel ref = (TextLabel)this.labels.elementAt(i);
                    if (ref.tmpConflicts <= 0) continue;
                    int oldPosition = ref.tmpPosition;
                    int[] pos = LabelPlacer.generateSequence(oldPosition);
                    for (int posIndex = 0; posIndex < 7 && ref.tmpConflicts > 0; ++posIndex) {
                        int newPosition = pos[posIndex];
                        this.moveLabel(i, newPosition);
                    }
                }
                if (this.setConflicts() >= oldConflicts) break;
                this.keep();
                break;
            }
            case 3: {
                int E;
                Random labelPicker = new Random();
                Random undo = new Random();
                Random posPicker = new Random();
                int lowestE = E = this.setConflicts();
                double T = -1.0 / Math.log(0.33333333333333337);
                temperature.setText("T: " + (int)(T * 100.0));
                int moved = 0;
                int maxMoved = this.labels.size() * 20;
                int success = 0;
                int maxSuccess = this.labels.size() * 5;
                int stages = 50;
                stageCount.setText("Stage: " + stages);
                while (E > 0 && stages > 0) {
                    if (moved > maxMoved || success > maxSuccess) {
                        if (success == 0) {
                            System.out.println("No successes at all at tis temp");
                            break block1;
                        }
                        moved = 0;
                        success = 0;
                        temperature.setText("T: " + (int)((T *= 0.9) * 100.0));
                        stageCount.setText("Stage: " + --stages);
                    }
                    int index = labelPicker.nextInt(this.labels.size());
                    TextLabel label = (TextLabel)this.labels.elementAt(index);
                    int newPosition = posPicker.nextInt(8);
                    if (newPosition >= label.tmpPosition) {
                        newPosition = (newPosition + 1) % 8;
                    }
                    int dE = this.getDeltaE(index, newPosition);
                    double P = 1.0;
                    if (dE > 0) {
                        P = 1.0 - Math.exp((double)(-dE) / T);
                        if (undo.nextDouble() > P) {
                            this.moveLabel(index, newPosition);
                            E += dE;
                        }
                    } else {
                        this.moveLabel(index, newPosition);
                        ++success;
                        E += dE;
                    }
                    ++moved;
                    if (E >= lowestE) continue;
                    System.out.println("S=" + stages + ", T=" + T + ", E=" + E + ", dE=" + dE + ", P=" + P + ", m=" + moved + ", s=" + success);
                    lowestE = E;
                    System.out.println(this.keep());
                    this.repaint();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {}
                }
                break;
            }
            default: {
                System.out.println("Algorithm#: " + algorithm + " not implemented");
            }
        }
    }

    private int setConflicts() {
        int conflicts = 0;
        for (int i = 0; i < this.labels.size(); ++i) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i);
            ref.tmpConflicts = 0;
            Rectangle refRect = ref.getBounds(ref.tmpPosition);
            for (int j = 0; j < this.labels.size(); ++j) {
                TextLabel label;
                Rectangle labelRect;
                if (i == j || !(labelRect = (label = (TextLabel)this.labels.elementAt(j)).getBounds(label.tmpPosition)).intersects(refRect)) continue;
                ++ref.tmpConflicts;
                ++conflicts;
            }
        }
        return conflicts;
    }

    private int countConflicts() {
        int conflicts = 0;
        for (int i = 0; i < this.labels.size(); ++i) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i);
            conflicts += ref.getConflicts();
        }
        return conflicts;
    }

    private int keep() {
        int conflicts = 0;
        for (int i = 0; i < this.labels.size(); ++i) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i);
            conflicts += ref.keep();
        }
        conflictCount.setText("# of Conflicts: " + conflicts / 2);
        return conflicts;
    }

    private int getDeltaE(int index, int newPosition) {
        int oldConflicts = 0;
        int newConflicts = 0;
        TextLabel ref = (TextLabel)this.labels.elementAt(index);
        Rectangle oldRect = ref.getBounds(ref.tmpPosition);
        Rectangle newRect = ref.getBounds(newPosition);
        for (int i = 0; i < this.labels.size(); ++i) {
            if (i == index) continue;
            TextLabel label = (TextLabel)this.labels.elementAt(i);
            Rectangle labelRect = label.getBounds(label.tmpPosition);
            boolean oldIntersects = labelRect.intersects(oldRect);
            boolean newIntersects = labelRect.intersects(newRect);
            if (oldIntersects) {
                oldConflicts += 2;
                if (!newIntersects) continue;
                newConflicts += 2;
                continue;
            }
            if (!newIntersects) continue;
            newConflicts += 2;
        }
        return newConflicts - oldConflicts;
    }

    private void moveLabel(int index, int newPosition) {
        TextLabel ref = (TextLabel)this.labels.elementAt(index);
        Rectangle oldRect = ref.getBounds(ref.tmpPosition);
        ref.tmpPosition = newPosition;
        Rectangle newRect = ref.getBounds(ref.tmpPosition);
        for (int i = 0; i < this.labels.size(); ++i) {
            if (i == index) continue;
            TextLabel label = (TextLabel)this.labels.elementAt(i);
            Rectangle labelRect = label.getBounds(label.tmpPosition);
            boolean oldIntersects = labelRect.intersects(oldRect);
            boolean newIntersects = labelRect.intersects(newRect);
            if (oldIntersects) {
                if (newIntersects) continue;
                if (ref.tmpConflicts > 0) {
                    --ref.tmpConflicts;
                } else {
                    System.out.println("Old conflict was not counted in ref: " + index);
                }
                if (label.tmpConflicts > 0) {
                    --label.tmpConflicts;
                    continue;
                }
                System.out.println("Old conflict was not counted in label: " + i);
                continue;
            }
            if (!newIntersects) continue;
            ++ref.tmpConflicts;
            ++label.tmpConflicts;
        }
    }

    private static int[] generateSequence(int avoidPosition) {
        Random sequencer = new Random();
        boolean[] done = new boolean[8];
        done[avoidPosition] = true;
        int[] seq = new int[7];
        for (int i = 0; i < 7; ++i) {
            int index = sequencer.nextInt(7 - i) + 1;
            int r = 0;
            int j = -1;
            while (j < 7 && r < index) {
                if (done[++j]) continue;
                ++r;
            }
            seq[i] = j;
            done[seq[i]] = true;
        }
        return seq;
    }

    public static void main(String[] args) {
        Frame frame;
        Frame content = frame = new Frame();
        content.setLayout(new BorderLayout());
        final LabelPlacer lp = new LabelPlacer();
        content.add((Component)lp, "Center");
        Panel p = new Panel();
        content.add((Component)p, "South");
        p.add(labelCount);
        p.add(conflictCount);
        Button b = new Button("Add 10 more labels");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                lp.addLabels(10);
                lp.repaint();
            }
        });
        b = new Button("Randomize Positions");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                lp.positionLabels(1);
                lp.repaint();
            }
        });
        b = new Button("Greedy Positions");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                lp.positionLabels(2);
                lp.repaint();
            }
        });
        b = new Button("Simulated Annealing Positions");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(){

                    public void run() {
                        lp.positionLabels(3);
                        lp.repaint();
                    }
                };
                t.start();
            }
        });
        p.add(stageCount);
        p.add(temperature);
        frame.pack();
        frame.show();
        lp.addLabels(100);
        lp.repaint();
    }
}

