/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

public class SGArchiveFileExtractor
implements SGIConstants,
SGIArchiveFileConstants {
    private String mCurrentFilePath;
    private String mCurrentFileName;
    protected static final int EOF = -1;
    private ArrayList mFileList = new ArrayList();

    public SGArchiveFileExtractor() {
        this.init();
    }

    private void init() {
        String string = USER_HOME;
        String string2 = "My Documents";
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new Error();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            string = string + FILE_SEPARATOR + string2;
            break;
        }
        this.mCurrentFilePath = string;
        this.mCurrentFileName = "dataset.sga";
    }

    public int extract(SGDrawingWindow sGDrawingWindow, String string, File file) {
        return this.extract(sGDrawingWindow, string, file.getPath());
    }

    public int extract(SGDrawingWindow sGDrawingWindow, String string, String string2) {
        int n = -1;
        try {
            n = this.extract(string, string2);
        }
        catch (IOException iOException) {
            return -2;
        }
        return n;
    }

    public int extract(SGDrawingWindow sGDrawingWindow, String string) {
        File file = this.getArchiveFileFromFileChooser(sGDrawingWindow);
        if (file == null) {
            return -1;
        }
        int n = -1;
        try {
            n = this.extract(string, file.getPath());
        }
        catch (IOException iOException) {
            String string2 = iOException.toString();
            JOptionPane.showMessageDialog(sGDrawingWindow, string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int extract(String string, String string2) throws IOException {
        this.mFileList.clear();
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("Couldn't access dir " + file);
        }
        ZipFile zipFile = new ZipFile(string2);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = new File(file.getAbsolutePath() + FILE_SEPARATOR + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IOException("Couldn't create dir " + file2);
                }
                this.mFileList.add(file2);
                continue;
            }
            BufferedInputStream bufferedInputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException("Couldn't create dir " + file3);
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                int n = -1;
                while ((n = bufferedInputStream.read()) != -1) {
                    bufferedOutputStream.write(n);
                }
                bufferedInputStream.close();
                bufferedOutputStream.close();
                this.mFileList.add(file2);
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedOutputStream == null) continue;
                bufferedInputStream.close();
            }
        }
        return 0;
    }

    private File getArchiveFileFromFileChooser(Component component) {
        SGFileChooser sGFileChooser = new SGFileChooser();
        SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
        sGExtensionFileFilter.setDescription("Samurai Graph Archive File");
        sGExtensionFileFilter.addExtension("sga");
        sGFileChooser.setFileFilter(sGExtensionFileFilter);
        sGFileChooser.setCurrentDirectory(new File(this.mCurrentFilePath));
        String string = this.mCurrentFilePath + FILE_SEPARATOR + this.mCurrentFileName;
        File file = new File(string);
        ((JFileChooser)sGFileChooser).setSelectedFile(file);
        int n = sGFileChooser.showOpenDialog(component);
        File file2 = null;
        if (n == 0) {
            file2 = sGFileChooser.getSelectedFile();
            this.mCurrentFilePath = file2.getParent();
            this.mCurrentFileName = file2.getName();
        }
        return file2;
    }

    public File getSelectedFile() {
        return new File(this.mCurrentFilePath, this.mCurrentFileName);
    }

    public File setFile(String string, String string2) {
        if (string2 != null) {
            this.mCurrentFileName = string2;
        }
        this.mCurrentFilePath = string;
        String string3 = this.mCurrentFilePath + FILE_SEPARATOR + this.mCurrentFileName;
        File file = new File(string3);
        return file;
    }

    public ArrayList getExtractedFileList() {
        return this.mFileList;
    }

    public boolean deleteExtractedFiles() {
        File file;
        int n;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (n = 0; n < this.mFileList.size(); ++n) {
            file = (File)this.mFileList.get(n);
            if (file.isDirectory()) {
                arrayList.add(file);
            }
            file.delete();
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            file = (File)arrayList.get(n);
            file.delete();
        }
        this.mFileList.clear();
        return true;
    }
}

