/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Properties;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComboBox;
import jp.riken.brain.ni.samuraigraph.application.SGPreviewDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGPrintablePanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.freehep.graphicsio.FontConstants;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFExportFileType;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.EPSExportFileType;
import org.freehep.graphicsio.ps.PSExportFileType;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.graphicsio.swf.SWFGraphics2D;
import org.freehep.util.UserProperties;
import org.freehep.util.export.ExportDialog;

public class SGImageExportManager
implements SGIImageExportManager,
SGIConstants {
    public static final String DEFAULT_EXPORT_FILE_NAME = "export";
    public static final String DEFAULT_TITLE_NAME = "Export view as ...";
    private static final String PREFIX = "org.freehep.graphicsio.";
    private static final String BG_SUFFIX = ".Background";
    private static final String BG_COLOR_SUFFIX = ".BackgroundColor";
    private static final String GIF = "gif";
    private static final String JPG = "jpg";
    private static final String PNG = "png";
    private static final String RAW = "raw";
    private static final String PPM = "ppm";
    private static final String[][] BG_KEY_ARRAY = new String[][]{{CGMGraphics2D.BACKGROUND, CGMGraphics2D.BACKGROUND_COLOR}, {PSGraphics2D.BACKGROUND, PSGraphics2D.BACKGROUND_COLOR}, {SWFGraphics2D.BACKGROUND, SWFGraphics2D.BACKGROUND_COLOR}, {PDFGraphics2D.BACKGROUND, PDFGraphics2D.BACKGROUND_COLOR}, {SVGGraphics2D.BACKGROUND, SVGGraphics2D.BACKGROUND_COLOR}, {EMFGraphics2D.BACKGROUND, EMFGraphics2D.BACKGROUND_COLOR}, {"org.freehep.graphicsio.gif.Background", "org.freehep.graphicsio.gif.BackgroundColor"}, {"org.freehep.graphicsio.jpg.Background", "org.freehep.graphicsio.jpg.BackgroundColor"}, {"org.freehep.graphicsio.png.Background", "org.freehep.graphicsio.png.BackgroundColor"}, {"org.freehep.graphicsio.raw.Background", "org.freehep.graphicsio.raw.BackgroundColor"}, {"org.freehep.graphicsio.ppm.Background", "org.freehep.graphicsio.ppm.BackgroundColor"}};
    private final ExportDialog mExportDialog = new ExportDialog();
    private String mBaseDirectoryName = null;
    private String mExportFileName = "export";
    private Component mTarget = null;
    private static final String PREVIEW_DIALOG_TITLE = "Export as Image";
    public static final int OK = 0;
    public static final int CANCEL = 1;

    public SGImageExportManager() {
        ExportDialogActionListener exportDialogActionListener = new ExportDialogActionListener();
        this.mExportDialog.addActionListener((ActionListener)exportDialogActionListener);
    }

    public boolean export(Component component, Frame frame, int n, int n2, boolean bl) {
        Object object;
        String string;
        Object object2;
        this.mTarget = component;
        if (!bl && this.preview(component, frame, n, n2, n, n2, (Rectangle)(object2 = new Rectangle(0, 0, n, n2)), PREVIEW_DIALOG_TITLE, "Next>", "Cancel", bl) == 1) {
            return true;
        }
        if (this.mBaseDirectoryName == null) {
            this.mBaseDirectoryName = System.getProperty("user.dir");
        }
        object2 = this.mExportDialog;
        Color color = component.getBackground();
        Properties properties = object2.getUserProperties();
        String string2 = ExportDialog.SAVE_AS_FILE;
        String string3 = this.mBaseDirectoryName;
        String string4 = object2.getUserProperties().getProperty(string2);
        if (string4 != null) {
            string = string3 + FILE_SEPARATOR + this.mExportFileName;
            object2.setUserProperty(string2, string);
        }
        string = string3 + FILE_SEPARATOR + this.mExportFileName;
        String[][] stringArray = BG_KEY_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            UserProperties.setProperty((Properties)properties, (String)object[0], (boolean)true);
            UserProperties.setProperty((Properties)properties, (String)object[1], (Color)color);
        }
        object2.showExportDialog((Component)frame, DEFAULT_TITLE_NAME, component, string);
        String string5 = properties.getProperty(string2);
        if (string5 != null) {
            object = new File(string5).getParent();
            String string6 = string5.substring(((String)object).length() + 1);
            this.setBaseDirectory((String)object);
            this.mExportFileName = string6;
        }
        return true;
    }

    public static String[] getSizeList() {
        return PageConstants.getSizeList();
    }

    public static String[] getMarginList() {
        return new String[]{"No Margin", "Small", "Medium", "Large"};
    }

    public static String[] getOrientationList() {
        return PageConstants.getOrientationList();
    }

    public static String[] getEmbedFontsAsList() {
        return FontConstants.getEmbedFontsAsList();
    }

    public boolean export(Component component, int n, int n2, String string, String string2, Properties properties) {
        Object object;
        File file = new File(string2);
        String string3 = string.toUpperCase();
        Dimension dimension = new Dimension(n, n2);
        EMFGraphics2D eMFGraphics2D = null;
        boolean bl = true;
        try {
            object = new UserProperties();
            if (string3.equals("EMF")) {
                eMFGraphics2D = new EMFGraphics2D(file, dimension);
                this.setBoolean(properties, "Transparent", (UserProperties)object, EMFGraphics2D.TRANSPARENT);
                this.setBoolean(properties, "Background", (UserProperties)object, EMFGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, EMFGraphics2D.BACKGROUND_COLOR);
            } else if (string3.equals("EPS") | string3.equals("PS")) {
                eMFGraphics2D = new PSGraphics2D(file, dimension);
                bl = false;
                this.setBoolean(properties, "Background", (UserProperties)object, PSGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, PSGraphics2D.BACKGROUND_COLOR);
                this.setString(properties, "PageSize", (UserProperties)object, PSGraphics2D.PAGE_SIZE, SGImageExportManager.getSizeList());
                this.setMargin(properties, "PageMargins", (UserProperties)object, PSGraphics2D.PAGE_MARGINS);
                this.setString(properties, "Orientation", (UserProperties)object, PSGraphics2D.ORIENTATION, SGImageExportManager.getOrientationList());
                this.setBoolean(properties, "FitToPage", (UserProperties)object, PSGraphics2D.FIT_TO_PAGE);
                this.setBoolean(properties, "EmbedFonts", (UserProperties)object, PSGraphics2D.EMBED_FONTS);
                this.setString(properties, "EmbedFontsAs", (UserProperties)object, PSGraphics2D.EMBED_FONTS_AS, SGImageExportManager.getEmbedFontsAsList());
                this.setString(properties, "For", (UserProperties)object, PSGraphics2D.FOR);
                this.setString(properties, "Title", (UserProperties)object, PSGraphics2D.TITLE);
                this.setString(properties, "WriteImagesAs", (UserProperties)object, PSGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"});
                if (string3.equals("EPS")) {
                    this.setBoolean(properties, "Preview", (UserProperties)object, PSGraphics2D.PREVIEW);
                    this.setInteger(properties, "PreviewBits", (UserProperties)object, PSGraphics2D.PREVIEW_BITS);
                }
            } else if (string3.equals("PDF")) {
                eMFGraphics2D = new PDFGraphics2D(file, dimension);
                bl = false;
                this.setBoolean(properties, "Transparent", (UserProperties)object, PDFGraphics2D.TRANSPARENT);
                this.setBoolean(properties, "Background", (UserProperties)object, PDFGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, PDFGraphics2D.BACKGROUND_COLOR);
                this.setString(properties, "Version", (UserProperties)object, PDFGraphics2D.VERSION, new String[]{"Acrobat Reader 4.x", "Acrobat Reader 5.x"});
                String string4 = object.getProperty(PDFGraphics2D.VERSION);
                if (string4 != null) {
                    object.setProperty(PDFGraphics2D.THUMBNAILS, string4.equals("Acrobat Reader 4.x"));
                }
                this.setBoolean(properties, "Compress", (UserProperties)object, PDFGraphics2D.COMPRESS);
                this.setString(properties, "PageSize", (UserProperties)object, PDFGraphics2D.PAGE_SIZE, SGImageExportManager.getSizeList());
                this.setMargin(properties, "PageMargins", (UserProperties)object, PDFGraphics2D.PAGE_MARGINS);
                this.setString(properties, "Orientation", (UserProperties)object, PDFGraphics2D.ORIENTATION, SGImageExportManager.getOrientationList());
                this.setBoolean(properties, "FitToPage", (UserProperties)object, PDFGraphics2D.FIT_TO_PAGE);
                this.setBoolean(properties, "EmbedFonts", (UserProperties)object, PDFGraphics2D.EMBED_FONTS);
                this.setString(properties, "EmbedFontsAs", (UserProperties)object, PDFGraphics2D.EMBED_FONTS_AS, SGImageExportManager.getEmbedFontsAsList());
                this.setString(properties, "WriteImagesAs", (UserProperties)object, PDFGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"});
                this.setString(properties, "Author", (UserProperties)object, PDFGraphics2D.AUTHOR);
                this.setString(properties, "Title", (UserProperties)object, PDFGraphics2D.TITLE);
                this.setString(properties, "Subject", (UserProperties)object, PDFGraphics2D.SUBJECT);
                this.setString(properties, "Keywords", (UserProperties)object, PDFGraphics2D.KEYWORDS);
            } else if (string3.equals("SVG")) {
                eMFGraphics2D = new SVGGraphics2D(file, dimension);
                bl = true;
                this.setBoolean(properties, "Transparent", (UserProperties)object, SVGGraphics2D.TRANSPARENT);
                this.setBoolean(properties, "Background", (UserProperties)object, SVGGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, SVGGraphics2D.BACKGROUND_COLOR);
                this.setString(properties, "Version", (UserProperties)object, SVGGraphics2D.VERSION, new String[]{"Version 1.0 (REC-SVG-20010904)", "Version 1.1 (REC-SVG11-20030114)"});
                this.setBoolean(properties, "Binary", (UserProperties)object, SVGGraphics2D.COMPRESS);
                this.setBoolean(properties, "Stylable", (UserProperties)object, SVGGraphics2D.STYLABLE);
                this.setDimension(properties, "ImageSize", (UserProperties)object, SVGGraphics2D.IMAGE_SIZE);
                this.setBoolean(properties, "ExportImages", (UserProperties)object, SVGGraphics2D.EXPORT_IMAGES);
                this.setString(properties, "ExportImages", (UserProperties)object, SVGGraphics2D.EXPORT_SUFFIX);
                this.setString(properties, "WriteImagesAs", (UserProperties)object, SVGGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "PNG", "JPG"});
                this.setString(properties, "For", (UserProperties)object, SVGGraphics2D.FOR);
                this.setString(properties, "Title", (UserProperties)object, SVGGraphics2D.TITLE);
            } else if (string3.equals("CGM")) {
                eMFGraphics2D = new CGMGraphics2D(file, dimension);
                bl = true;
                this.setBoolean(properties, "Background", (UserProperties)object, CGMGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, CGMGraphics2D.BACKGROUND_COLOR);
                this.setBoolean(properties, "Binary", (UserProperties)object, CGMGraphics2D.BINARY);
                this.setString(properties, "Author", (UserProperties)object, CGMGraphics2D.AUTHOR);
                this.setString(properties, "Title", (UserProperties)object, CGMGraphics2D.TITLE);
                this.setString(properties, "Subject", (UserProperties)object, CGMGraphics2D.SUBJECT);
                this.setString(properties, "Keywords", (UserProperties)object, CGMGraphics2D.KEYWORDS);
            } else if (string3.equals("SWF")) {
                eMFGraphics2D = new SWFGraphics2D(file, dimension);
                bl = true;
                this.setBoolean(properties, "Transparent", (UserProperties)object, SWFGraphics2D.TRANSPARENT);
                this.setBoolean(properties, "Background", (UserProperties)object, SWFGraphics2D.BACKGROUND);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, SWFGraphics2D.BACKGROUND_COLOR);
                this.setString(properties, "WriteImagesAs", (UserProperties)object, SWFGraphics2D.WRITE_IMAGES_AS, new String[]{"Smallest Size", "ZLIB", "JPG"});
            } else if (string3.equals("JPG") | string3.equals("JPEG") | string3.equals("GIF") | string3.equals("PNG") | string3.equals("RAW") | string3.equals("PPM")) {
                eMFGraphics2D = new ImageGraphics2D(file, dimension, string3);
                bl = true;
                String string5 = PREFIX + string3;
                if (ImageGraphics2D.canWriteTransparent((String)string3)) {
                    this.setBoolean(properties, "Transparent", (UserProperties)object, ".Transparent");
                }
                this.setBoolean(properties, "Background", (UserProperties)object, string5 + BG_SUFFIX);
                this.setColor(properties, "BackgroundColor", (UserProperties)object, string5 + BG_COLOR_SUFFIX);
                this.setBoolean(properties, "Antialias", (UserProperties)object, string5 + ".Antialias");
                this.setBoolean(properties, "AntialiasText", (UserProperties)object, string5 + ".AntialiasText");
                ImageWriter imageWriter = ImageGraphics2D.getPreferredImageWriter((String)string3);
                if (imageWriter != null) {
                    ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                    if (imageWriteParam.canWriteProgressive()) {
                        object.setProperty(string5 + ".Progressive", imageWriteParam.getProgressiveMode() != 0);
                    } else {
                        this.setBoolean(properties, "Progressive", (UserProperties)object, string5 + ".Progressive");
                    }
                }
            } else {
                return false;
            }
            eMFGraphics2D.setProperties((Properties)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (component instanceof SGDrawingWindow.ExportPanel) {
            object = (SGDrawingWindow.ExportPanel)component;
            ((SGDrawingWindow.ExportPanel)object).setClipFlag(bl);
        }
        eMFGraphics2D.startExport();
        component.print((Graphics)eMFGraphics2D);
        eMFGraphics2D.endExport();
        return true;
    }

    private boolean setString(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            return false;
        }
        userProperties.setProperty(string2, string3);
        return true;
    }

    private boolean setString(Properties properties, String string, UserProperties userProperties, String string2, String[] stringArray) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                userProperties.setProperty(string2, string3);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean setBoolean(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            Boolean bl = SGUtilityText.getBoolean(string3);
            if (bl == null) {
                return false;
            }
            userProperties.setProperty(string2, bl.booleanValue());
        }
        return true;
    }

    private boolean setInteger(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            Integer n = SGUtilityText.getInteger(string3);
            if (n == null) {
                return false;
            }
            userProperties.setProperty(string2, n.intValue());
        }
        return true;
    }

    private boolean setColor(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            Color color = SGUtilityText.getColor(string3);
            if (color == null) {
                return false;
            }
            userProperties.setProperty(string2, color);
        }
        return true;
    }

    private boolean setDimension(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            Dimension dimension = SGUtilityText.getDimension(string3);
            if (dimension == null) {
                return false;
            }
            userProperties.setProperty(string2, dimension);
        }
        return true;
    }

    private boolean setMargin(Properties properties, String string, UserProperties userProperties, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            Insets insets = PageConstants.getMargins((String)string3);
            if (insets == null) {
                return false;
            }
            userProperties.setProperty(string2, insets);
        }
        return true;
    }

    public void setBaseDirectory(String string) {
        this.mBaseDirectoryName = new String(string);
    }

    public String getBaseDirectory() {
        return this.mBaseDirectoryName;
    }

    private int preview(Component component, Frame frame, int n, int n2, int n3, int n4, Rectangle rectangle, String string, String string2, String string3, boolean bl) {
        SGPreviewDialog sGPreviewDialog = this.createPreviewDialog(component, frame, n, n2, n3, n4, rectangle, string, !bl);
        sGPreviewDialog.setOKButtonText(string2);
        sGPreviewDialog.setCancelButtonText(string3);
        if (!bl) {
            sGPreviewDialog.setVisible(true);
        }
        int n5 = sGPreviewDialog.getCloseOption();
        sGPreviewDialog.dispose();
        if (n5 == 1) {
            return 1;
        }
        return 0;
    }

    public boolean print(Component component, Frame frame, int n, int n2, boolean bl) {
        SGPrintablePanel sGPrintablePanel = new SGPrintablePanel(component, n, n2);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName("Samurai Graph Printning", null));
        printerJob.setPrintable(sGPrintablePanel);
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length <= 0) {
            if (!bl) {
                SGUtility.showMessageDialog(frame, "No printer is available.", "Error", 0);
            }
            return false;
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat = printerJob.defaultPage(pageFormat);
        Rectangle rectangle = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Dimension dimension = new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        String string = "Print as Image";
        int n3 = this.preview(sGPrintablePanel, frame, n, n2, dimension.width, dimension.height, rectangle, string, "Print", "Cancel", bl);
        if (n3 == 1) {
            return true;
        }
        if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
        return true;
    }

    private SGPreviewDialog createPreviewDialog(Component component, Frame frame, int n, int n2, int n3, int n4, Rectangle rectangle, String string, boolean bl) {
        SGPreviewDialog sGPreviewDialog = new SGPreviewDialog(frame, string, bl);
        sGPreviewDialog.pack();
        sGPreviewDialog.setLocation(frame.getLocation());
        sGPreviewDialog.setTargetObject(component, n, n2, n3, n4, rectangle, component.getBackground());
        return sGPreviewDialog;
    }

    private class ExportDialogActionListener
    implements ActionListener {
        private ExportDialogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)object;
                Object object2 = jComboBox.getSelectedItem();
                Component component = SGImageExportManager.this.mTarget;
                if (component instanceof SGDrawingWindow.ExportPanel) {
                    SGDrawingWindow.ExportPanel exportPanel = (SGDrawingWindow.ExportPanel)component;
                    boolean bl = object2 instanceof EPSExportFileType | object2 instanceof PSExportFileType | object2 instanceof PDFExportFileType;
                    exportPanel.setClipFlag(!bl);
                }
            }
        }
    }
}

