/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementAxisBreak
extends SGDrawingElement
implements SGIAxisBreakConstants,
SGIDrawingElementConstants {
    private SGTuple2f mLocation = new SGTuple2f();
    private float mLength;
    private float mInterval;
    private float mLineWidth;
    private float mAngle;
    private float mDistortion;
    private Color mLineColor;
    private boolean mForHorizontalAxisFlag;

    public SGDrawingElementAxisBreak() {
    }

    protected SGDrawingElementAxisBreak(float f, String string, float f2, String string2, float f3, float f4, boolean bl) {
        this.setLength(f, string);
        this.setInterval(f2, string2);
        this.setDistortion(f3);
        this.setAngle(f4);
        this.setForHorizontalAxisFlag(bl);
    }

    public void dispose() {
        super.dispose();
        this.mLineColor = null;
        this.mLocation = null;
    }

    public SGTuple2f getLocation() {
        return this.mLocation;
    }

    public float getX() {
        return this.mLocation.x;
    }

    public float getY() {
        return this.mLocation.y;
    }

    public final float getLength() {
        return this.mLength;
    }

    public final float getInterval() {
        return this.mInterval;
    }

    public final float getLineWidth() {
        return this.mLineWidth;
    }

    public final float getAngle() {
        return this.mAngle;
    }

    public final float getDistortion() {
        return this.mDistortion;
    }

    public final Color getLineColor() {
        return this.mLineColor;
    }

    public boolean isForHorizontalAxis() {
        return this.mForHorizontalAxisFlag;
    }

    public boolean setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
        return true;
    }

    public boolean setLength(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLength = f;
        return true;
    }

    public boolean setInterval(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mInterval = f;
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            new IllegalArgumentException("value<0.0f");
        }
        this.mLineWidth = f;
        return true;
    }

    public boolean setAngle(float f) {
        if ((double)f < -60.000000464782005 | 60.000000464782005 < (double)f) {
            return false;
        }
        this.mAngle = f;
        return true;
    }

    public boolean setDistortion(float f) {
        this.mDistortion = f;
        return true;
    }

    public boolean setLineColor(Color color) {
        if (color == null) {
            new IllegalArgumentException("color==null");
        }
        this.mLineColor = color;
        return true;
    }

    public boolean setForHorizontalAxisFlag(boolean bl) {
        this.mForHorizontalAxisFlag = bl;
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setLength(float f, String string) {
        return this.setLength((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setInterval(float f, String string) {
        return this.setInterval((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        Float f = axisBreakSymbolProperties.getLength();
        if (f == null) {
            return false;
        }
        this.mLength = f.floatValue();
        Float f2 = axisBreakSymbolProperties.getInterval();
        if (f2 == null) {
            return false;
        }
        this.mInterval = f2.floatValue();
        Float f3 = axisBreakSymbolProperties.getDistortion();
        if (f3 == null) {
            return false;
        }
        this.mDistortion = f3.floatValue();
        Float f4 = axisBreakSymbolProperties.getAngle();
        if (f4 == null) {
            return false;
        }
        this.mAngle = f4.floatValue();
        Boolean bl = axisBreakSymbolProperties.isHorizontal();
        if (bl == null) {
            return false;
        }
        this.mForHorizontalAxisFlag = bl;
        Float f5 = axisBreakSymbolProperties.getLineWidth();
        if (f5 == null) {
            return false;
        }
        this.mLineWidth = f5.floatValue();
        Color color = axisBreakSymbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.mLineColor = color;
        return true;
    }

    public SGProperties getProperties() {
        AxisBreakSymbolProperties axisBreakSymbolProperties = new AxisBreakSymbolProperties();
        if (!this.getProperties(axisBreakSymbolProperties)) {
            return null;
        }
        return axisBreakSymbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisBreakSymbolProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)sGProperties;
        axisBreakSymbolProperties.setLength(this.mLength);
        axisBreakSymbolProperties.setInterval(this.mInterval);
        axisBreakSymbolProperties.setDistortion(this.mDistortion);
        axisBreakSymbolProperties.setAngle(this.mAngle);
        axisBreakSymbolProperties.setHorizontal(this.mForHorizontalAxisFlag);
        axisBreakSymbolProperties.setLineWidth(this.mLineWidth);
        axisBreakSymbolProperties.setLineColor(this.mLineColor);
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Length", Float.toString(this.mLength * 0.035277776f) + "cm");
        element.setAttribute("Interval", Float.toString(this.mInterval * 0.035277776f) + "cm");
        element.setAttribute("Distortion", Float.toString(this.mDistortion));
        element.setAttribute("Angle", Float.toString(this.mAngle / ((float)Math.PI / 180)) + SGIConstants.degree);
        element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + "pt");
        element.setAttribute("Horizontal", Boolean.toString(this.mForHorizontalAxisFlag));
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.getColorList()));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        List list = null;
        string = element.getAttribute("Length");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLength(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Interval")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setInterval(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Distortion")).length() != 0) {
            number = SGUtilityText.getFloat(string);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue();
            if (!this.setDistortion(f2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Angle")).length() != 0) {
            number = SGUtilityText.getFloat(string, degree);
            if (number == null) {
                return false;
            }
            float f3 = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setAngle(f3)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineWidth")).length() != 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer2);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer2.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Horizontal")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.setForHorizontalAxisFlag(bl2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            Color color2 = color;
            if (!this.setLineColor(color2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerColor")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            Color color3 = (Color)list.get(0);
            if (!this.setColor(color3)) {
                return false;
            }
        }
        return true;
    }

    public static class AxisBreakSymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mX = 0.0f;
        private float mY = 0.0f;
        private float mLength = 0.0f;
        private float mInterval = 0.0f;
        private float mDistortion = 0.0f;
        private float mAngle = 0.0f;
        private float mLineWidth = 0.0f;
        private Color mLineColor = null;
        private boolean mHorizontal = true;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolProperties axisBreakSymbolProperties = (AxisBreakSymbolProperties)object;
            if (this.mX != axisBreakSymbolProperties.mX) {
                return false;
            }
            if (this.mY != axisBreakSymbolProperties.mY) {
                return false;
            }
            if (this.mLength != axisBreakSymbolProperties.mLength) {
                return false;
            }
            if (this.mInterval != axisBreakSymbolProperties.mInterval) {
                return false;
            }
            if (this.mDistortion != axisBreakSymbolProperties.mDistortion) {
                return false;
            }
            if (this.mAngle != axisBreakSymbolProperties.mAngle) {
                return false;
            }
            if (this.mLineWidth != axisBreakSymbolProperties.mLineWidth) {
                return false;
            }
            if (!this.mLineColor.equals(axisBreakSymbolProperties.mLineColor)) {
                return false;
            }
            return this.mHorizontal == axisBreakSymbolProperties.mHorizontal;
        }

        public Float getX() {
            return new Float(this.mX);
        }

        public Float getY() {
            return new Float(this.mY);
        }

        public Float getLength() {
            return new Float(this.mLength);
        }

        public Float getInterval() {
            return new Float(this.mInterval);
        }

        public Float getDistortion() {
            return new Float(this.mDistortion);
        }

        public Float getAngle() {
            return new Float(this.mAngle);
        }

        public Boolean isHorizontal() {
            return this.mHorizontal;
        }

        public Float getLineWidth() {
            return new Float(this.mLineWidth);
        }

        public Color getLineColor() {
            return this.mLineColor;
        }

        public boolean setX(float f) {
            this.mX = f;
            return true;
        }

        public boolean setY(float f) {
            this.mY = f;
            return true;
        }

        public boolean setLength(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mLength = f;
            return true;
        }

        public boolean setInterval(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mInterval = f;
            return true;
        }

        public boolean setDistortion(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mDistortion = f;
            return true;
        }

        public boolean setAngle(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mAngle = f;
            return true;
        }

        public boolean setHorizontal(boolean bl) {
            this.mHorizontal = bl;
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                new IllegalArgumentException("value<0.0f");
            }
            this.mLineWidth = f;
            return true;
        }

        public boolean setLineColor(Color color) {
            String string;
            if (color == null) {
                new IllegalArgumentException("cl==null");
            }
            if ((string = SGUtilityText.getColorString(color)) == null) {
                new IllegalArgumentException("str==null");
            }
            this.mLineColor = color;
            return true;
        }
    }
}

