/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisPanelObserver;

public class SGAxisDialog
extends SGPropertyDialog
implements SGIAxisConstants {
    private static final long serialVersionUID = 7038049338687502580L;
    public static final String TITLE = "Axis Properties";
    private JPanel mAxisCommonPanel;
    private JLabel mAxisLineLeftSpaceLabel;
    private JPanel mAxisLinePanel;
    private JLabel mAxisLineRightSpaceLabel;
    private JSeparator mAxisLineSeparator;
    private SGSpinner mAxisLineWidthSpinner;
    private JLabel mAxisWidthLabel1;
    private JLabel mAxisWidthLabel2;
    private JPanel mBottomPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private SGColorSelectionButton mFontColorButton;
    private JLabel mFontColorLabel;
    private JLabel mFontFamilyLabel;
    private JLabel mFontLabel;
    private JComboBox mFontNameComboBox;
    private JSeparator mFontSeparator;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JLabel mFontStyleLabel;
    private JComboBox mFontTypeComboBox;
    private SGColorSelectionButton mFrameColorButton;
    private JLabel mFrameLabel;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private SGCheckBox mFrameVisibleCheckBox;
    private JPanel mLeftPanel;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JPanel mRightPanel;
    private JLabel mScaleLengthLabel1;
    private JLabel mScaleLengthLabel2;
    private SGSpinner mScaleLineLengthSpinner;
    private SGSpinner mScaleLineWidthSpinner;
    private JLabel mScaleWidthLabel1;
    private JLabel mScaleWidthLabel2;
    private JTabbedPane mTabbedPane;
    private JPanel mTopPanel;
    public static final double AXIS_TICK_LENGTH_STEP = 0.05;

    public SGAxisDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.mBottomPanel.add(new SGAxisPanel("Bottom"));
        this.mTopPanel.add(new SGAxisPanel("Top"));
        this.mLeftPanel.add(new SGAxisPanel("Left"));
        this.mRightPanel.add(new SGAxisPanel("Right"));
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mTabbedPane = new JTabbedPane();
        this.mBottomPanel = new JPanel();
        this.mTopPanel = new JPanel();
        this.mLeftPanel = new JPanel();
        this.mRightPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mAxisCommonPanel = new JPanel();
        this.mAxisLinePanel = new JPanel();
        this.mAxisLineSeparator = new JSeparator();
        this.mAxisWidthLabel1 = new JLabel();
        this.mAxisWidthLabel2 = new JLabel();
        this.mScaleWidthLabel1 = new JLabel();
        this.mScaleWidthLabel2 = new JLabel();
        this.mScaleLengthLabel1 = new JLabel();
        this.mScaleLengthLabel2 = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mAxisLineWidthSpinner = new SGSpinner();
        this.mScaleLineWidthSpinner = new SGSpinner();
        this.mScaleLineLengthSpinner = new SGSpinner();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mAxisLineLeftSpaceLabel = new JLabel();
        this.mAxisLineRightSpaceLabel = new JLabel();
        this.mFontSeparator = new JSeparator();
        this.mFontLabel = new JLabel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mFontColorLabel = new JLabel();
        this.mFontTypeComboBox = new JComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new JComboBox();
        this.mFontColorButton = new SGColorSelectionButton();
        this.mFrameLabel = new JLabel();
        this.mFrameVisibleCheckBox = new SGCheckBox();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameColorButton = new SGColorSelectionButton();
        this.mFontStyleLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mBottomPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Bottom", this.mBottomPanel);
        this.mTopPanel.setLayout(new GridBagLayout());
        this.mTopPanel.setFont(new Font("Dialog", 1, 14));
        this.mTabbedPane.addTab("Top", this.mTopPanel);
        this.mLeftPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Left", this.mLeftPanel);
        this.mRightPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Right", this.mRightPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mTabbedPane, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mAxisCommonPanel.setLayout(new GridBagLayout());
        this.mAxisLinePanel.setLayout(new GridBagLayout());
        this.mAxisLinePanel.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mAxisLineSeparator, gridBagConstraints);
        this.mAxisWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel1.setText("Axis Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel1, gridBagConstraints);
        this.mAxisWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel2, gridBagConstraints);
        this.mScaleWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel1, gridBagConstraints);
        this.mScaleWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel2, gridBagConstraints);
        this.mScaleLengthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel1, gridBagConstraints);
        this.mScaleLengthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel2.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel2, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mAxisLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mAxisLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mAxisLineWidthSpinner, gridBagConstraints);
        this.mScaleLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mScaleLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineWidthSpinner, gridBagConstraints);
        this.mScaleLineLengthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mScaleLineLengthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineLengthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAxisLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineLeftSpaceLabel, gridBagConstraints);
        this.mAxisLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSeparator, gridBagConstraints);
        this.mFontLabel.setFont(new Font("Dialog", 3, 12));
        this.mFontLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontLabel, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mFontColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorLabel, gridBagConstraints);
        this.mFontTypeComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontTypeComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorButton, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameColorButton, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.mAxisCommonPanel.add((Component)this.mAxisLinePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mAxisLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mScaleLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mScaleLineLengthSpinner.initProperties(new SpinnerNumberModel(0.1, 0.0, 0.5, 0.05), "cm", 1, 2);
        this.mFontSizeSpinner.initProperties(SGAxisDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mFrameLineWidthSpinner.initProperties(SGAxisDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontTypeComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        this.mFontSizeSpinner.setDescription("Font-> Size");
        this.mFrameLineWidthSpinner.setDescription("Frame-> Width");
        this.mAxisLineWidthSpinner.setDescription("Axis Line Width");
        this.mScaleLineWidthSpinner.setDescription("Tick Mark Width");
        this.mScaleLineLengthSpinner.setDescription("Tick Mark Length");
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameLineComponentsEnabled(this.mFrameVisibleCheckBox.isSelected());
        }
    }

    private SGAxisPanel getBottomPanel() {
        return (SGAxisPanel)this.mBottomPanel.getComponent(0);
    }

    private SGAxisPanel getTopPanel() {
        return (SGAxisPanel)this.mTopPanel.getComponent(0);
    }

    private SGAxisPanel getLeftPanel() {
        return (SGAxisPanel)this.mLeftPanel.getComponent(0);
    }

    private SGAxisPanel getRightPanel() {
        return (SGAxisPanel)this.mRightPanel.getComponent(0);
    }

    private boolean setFrameLineComponentsEnabled(boolean bl) {
        this.mFrameLineWidthLabel.setEnabled(bl);
        this.mFrameLineWidthSpinner.setEnabled(bl);
        this.mFrameLineColorLabel.setEnabled(bl);
        this.mFrameColorButton.setEnabled(bl);
        return true;
    }

    public Number getAxisLineWidth() {
        return this.mAxisLineWidthSpinner.getNumber();
    }

    public Number getScaleLineWidth() {
        return this.mScaleLineWidthSpinner.getNumber();
    }

    public Number getScaleLineLength() {
        return this.mScaleLineLengthSpinner.getNumber();
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public String getFontName() {
        return this.mFontNameComboBox.getSelectedItem().toString();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public int getFontStyle() {
        String string = (String)this.mFontTypeComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getStringColor() {
        return this.mFontColorButton.getColor();
    }

    public Boolean isFrameLinesVisible() {
        return this.mFrameVisibleCheckBox.getSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameColorButton.getColor();
    }

    public boolean setAxisLineWidth(Object object) {
        return this.setValue(this.mAxisLineWidthSpinner, object);
    }

    public boolean setScaleLineWidth(Object object) {
        return this.setValue(this.mScaleLineWidthSpinner, object);
    }

    public boolean setScaleLineLength(Object object) {
        return this.setValue(this.mScaleLineLengthSpinner, object);
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setStringColor(Color color) {
        this.mFontColorButton.setColor(color);
        return true;
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontTypeComboBox.setSelectedItem(string);
        return true;
    }

    public void setFrameVisible(Boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setFrameLineComponentsEnabled(bl2);
    }

    public boolean setFrameLineWidth(Object object) {
        return this.setValue(this.mFrameLineWidthSpinner, object);
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameColorButton.setColor(color);
        return true;
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mFontColorButton);
        arrayList.add(this.mFrameColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getBottomPanel().getTextFieldComponentsList());
        list.addAll(this.getTopPanel().getTextFieldComponentsList());
        list.addAll(this.getLeftPanel().getTextFieldComponentsList());
        list.addAll(this.getRightPanel().getTextFieldComponentsList());
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getBottomPanel().getNumberTextFieldList());
        arrayList.addAll(this.getTopPanel().getNumberTextFieldList());
        arrayList.addAll(this.getLeftPanel().getNumberTextFieldList());
        arrayList.addAll(this.getRightPanel().getNumberTextFieldList());
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mAxisLineWidthSpinner);
        arrayList.add(this.mScaleLineWidthSpinner);
        arrayList.add(this.mScaleLineLengthSpinner);
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        arrayList.addAll(this.getBottomPanel().getSpinnerList());
        arrayList.addAll(this.getTopPanel().getSpinnerList());
        arrayList.addAll(this.getLeftPanel().getSpinnerList());
        arrayList.addAll(this.getRightPanel().getSpinnerList());
        return arrayList;
    }

    public boolean setSelectedPanel(SGAxisPanel sGAxisPanel) {
        Component[] componentArray = this.mTabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JPanel jPanel = (JPanel)componentArray[i];
            Component component = jPanel.getComponent(0);
            if (!component.equals(sGAxisPanel)) continue;
            this.mTabbedPane.setSelectedComponent(jPanel);
            break;
        }
        return true;
    }

    public boolean setDialogProperty() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List list = this.mPropertyDialogObserverList;
        SGIAxisDialogObserver sGIAxisDialogObserver = (SGIAxisDialogObserver)list.get(0);
        String string = sGIAxisDialogObserver.getFontName();
        float f = sGIAxisDialogObserver.getFontSize("pt");
        int n = sGIAxisDialogObserver.getFontStyle();
        Color color = sGIAxisDialogObserver.getStringColor();
        float f2 = sGIAxisDialogObserver.getFrameLineWidth("pt");
        Color color2 = sGIAxisDialogObserver.getFrameLineColor();
        boolean bl = sGIAxisDialogObserver.isFrameLineVisible();
        float f3 = sGIAxisDialogObserver.getAxisLineWidth("pt");
        float f4 = sGIAxisDialogObserver.getTickMarkWidth("pt");
        float f5 = sGIAxisDialogObserver.getTickMarkLength("cm");
        Color color3 = sGIAxisDialogObserver.getLineColor();
        String string2 = new String(string);
        Float f6 = new Float(f);
        Integer n2 = new Integer(n);
        Color color4 = color;
        Float f7 = new Float(f2);
        Color color5 = color2;
        Boolean bl2 = bl;
        Float f8 = new Float(f3);
        Float f9 = new Float(f4);
        Float f10 = new Float(f5);
        Color color6 = color3;
        if (list.size() > 1) {
            Object object5;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                object5 = object4.getFontName();
                if (string.equals(object5)) continue;
                string2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                float f11 = object4.getFontSize("pt");
                if (f == f11) continue;
                f6 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                int n4 = object4.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                object5 = object4.getStringColor();
                if (color4.equals(object5)) continue;
                color4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                boolean bl3 = object4.isFrameLineVisible();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                float f12 = object4.getFrameLineWidth("pt");
                if (f2 == f12) continue;
                f7 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                Color color7 = object4.getFrameLineColor();
                if (color5.equals(color7)) continue;
                color5 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                float f13 = object4.getAxisLineWidth("pt");
                if (f3 == f13) continue;
                f8 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                float f14 = object4.getTickMarkWidth("pt");
                if (f4 == f14) continue;
                f9 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                float f15 = object4.getTickMarkLength("cm");
                if (f5 == f15) continue;
                f10 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                object4 = (SGIAxisDialogObserver)list.get(n3);
                Color color8 = object4.getLineColor();
                if (color6.equals(color8)) continue;
                color6 = null;
                break;
            }
        }
        this.setFontName(string2);
        this.setFontSize(f6);
        this.setFontStyle(n2);
        this.setStringColor(color4);
        this.setFrameVisible(bl2);
        this.setFrameLineWidth(f7);
        this.setFrameLineColor(color5);
        this.setAxisLineWidth(f8);
        this.setScaleLineWidth(f9);
        this.setScaleLineLength(f10);
        this.setLineColor(color6);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object4 = new ArrayList();
        ArrayList<SGIAxisPanelObserver> arrayList2 = new ArrayList<SGIAxisPanelObserver>();
        ArrayList<SGIAxisPanelObserver> arrayList3 = new ArrayList<SGIAxisPanelObserver>();
        for (int i = 0; i < list.size(); ++i) {
            object3 = (SGIAxisDialogObserver)list.get(i);
            object2 = object3.getAxisPanelObserverInPlane(0);
            object = object3.getAxisPanelObserverInPlane(1);
            SGIAxisPanelObserver sGIAxisPanelObserver = object3.getAxisPanelObserverInPlane(2);
            SGIAxisPanelObserver sGIAxisPanelObserver2 = object3.getAxisPanelObserverInPlane(3);
            arrayList.add(object2);
            ((ArrayList)object4).add(object);
            arrayList2.add(sGIAxisPanelObserver);
            arrayList3.add(sGIAxisPanelObserver2);
        }
        SGAxisPanel sGAxisPanel = this.getBottomPanel();
        object3 = this.getTopPanel();
        object2 = this.getLeftPanel();
        object = this.getRightPanel();
        sGAxisPanel.setComponentsProperty(arrayList);
        ((SGAxisPanel)object3).setComponentsProperty((ArrayList)object4);
        ((SGAxisPanel)object2).setComponentsProperty(arrayList2);
        ((SGAxisPanel)object).setComponentsProperty(arrayList3);
        int n5 = -1;
        for (int i = 0; i < list.size(); ++i) {
            SGIAxisDialogObserver sGIAxisDialogObserver2 = (SGIAxisDialogObserver)list.get(i);
            int n6 = sGIAxisDialogObserver2.getAxisLocationForSelectedTab();
            if (n6 == -1) continue;
            n5 = n6;
            break;
        }
        if (n5 == -1) {
            n5 = 0;
        }
        JPanel jPanel = null;
        switch (n5) {
            case 0: {
                jPanel = this.mBottomPanel;
                break;
            }
            case 1: {
                jPanel = this.mTopPanel;
                break;
            }
            case 2: {
                jPanel = this.mLeftPanel;
                break;
            }
            case 3: {
                jPanel = this.mRightPanel;
            }
        }
        this.mTabbedPane.setSelectedComponent(jPanel);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Color color;
        Number number;
        Number number2;
        Number number3;
        Color color2;
        Number number4;
        Boolean bl;
        Color color3;
        Number number5;
        int n;
        SGIAxisDialogObserver sGIAxisDialogObserver = (SGIAxisDialogObserver)sGIPropertyDialogObserver;
        String string = this.getFontName();
        if (string != null) {
            sGIAxisDialogObserver.setFontName(string);
        }
        if ((n = this.getFontStyle()) != -1) {
            sGIAxisDialogObserver.setFontStyle(n);
        }
        if ((number5 = this.getFontSize()) != null) {
            sGIAxisDialogObserver.setFontSize(number5.floatValue());
        }
        if ((color3 = this.getStringColor()) != null) {
            sGIAxisDialogObserver.setStringColor(color3);
        }
        if ((bl = this.isFrameLinesVisible()) != null) {
            sGIAxisDialogObserver.setFrameVisible(bl);
        }
        if ((number4 = this.getFrameLineWidth()) != null) {
            sGIAxisDialogObserver.setFrameLineWidth(number4.floatValue(), "pt");
        }
        if ((color2 = this.getFrameLineColor()) != null) {
            sGIAxisDialogObserver.setFrameLineColor(color2);
        }
        if ((number3 = this.getAxisLineWidth()) != null) {
            sGIAxisDialogObserver.setAxisLineWidth(number3.floatValue(), "pt");
        }
        if ((number2 = this.getScaleLineWidth()) != null) {
            sGIAxisDialogObserver.setTickMarkWidth(number2.floatValue(), "pt");
        }
        if ((number = this.getScaleLineLength()) != null) {
            sGIAxisDialogObserver.setTickMarkLength(number.floatValue(), "cm");
        }
        if ((color = this.getLineColor()) != null) {
            sGIAxisDialogObserver.setLineColor(color);
        }
        SGIAxisPanelObserver sGIAxisPanelObserver = sGIAxisDialogObserver.getAxisPanelObserverInPlane(0);
        SGIAxisPanelObserver sGIAxisPanelObserver2 = sGIAxisDialogObserver.getAxisPanelObserverInPlane(1);
        SGIAxisPanelObserver sGIAxisPanelObserver3 = sGIAxisDialogObserver.getAxisPanelObserverInPlane(2);
        SGIAxisPanelObserver sGIAxisPanelObserver4 = sGIAxisDialogObserver.getAxisPanelObserverInPlane(3);
        if (!this.setPropertiesToListeners(sGIAxisPanelObserver, this.getBottomPanel())) {
            return false;
        }
        if (!this.setPropertiesToListeners(sGIAxisPanelObserver2, this.getTopPanel())) {
            return false;
        }
        if (!this.setPropertiesToListeners(sGIAxisPanelObserver3, this.getLeftPanel())) {
            return false;
        }
        return this.setPropertiesToListeners(sGIAxisPanelObserver4, this.getRightPanel());
    }

    private boolean setPropertiesToListeners(SGIAxisPanelObserver sGIAxisPanelObserver, SGAxisPanel sGAxisPanel) {
        if (!sGAxisPanel.setPropertiesToListeners(sGIAxisPanelObserver)) {
            String string = sGAxisPanel.getInputErrorMessage();
            if (string != null) {
                this.setInputErrorMessage(string);
            }
            return false;
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        if (!super.hasValidInputValues()) {
            return false;
        }
        if (!this.getBottomPanel().hasValidInputValues()) {
            return false;
        }
        if (!this.getTopPanel().hasValidInputValues()) {
            return false;
        }
        if (!this.getLeftPanel().hasValidInputValues()) {
            return false;
        }
        return this.getRightPanel().hasValidInputValues();
    }
}

