/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILabelDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElementDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGFigureElementString
extends SGFigureElement
implements SGIFigureElementString,
SGIStringConstants,
CaretListener,
ActionListener {
    private SGIFigureElementAxis mAxisElement = null;
    private LabelElement mEditedLabelElement = null;
    private int mFocusedX = 0;
    private int mFocusedY = 0;
    private JTextField mEditField = null;
    public static final int BOUNDARY_LINE_WIDTH = 6;
    private SGStringElementDialog mDialog = null;

    public SGFigureElementString() {
        this.initEditField();
    }

    public void dispose() {
        super.dispose();
        this.mDialog.dispose();
        this.mDialog = null;
        this.mAxisElement = null;
    }

    public String toString() {
        return new String("SGStringElement");
    }

    public String getClassDescription() {
        return "Labels";
    }

    private boolean initEditField() {
        JTextField jTextField = this.mEditField = new JTextField(10);
        jTextField.setVisible(false);
        jTextField.addActionListener(this);
        jTextField.addCaretListener(this);
        return true;
    }

    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mEditField);
    }

    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    public boolean addString(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        this.clearFocusedObjects();
        this.mFocusedX = n;
        this.mFocusedY = n2;
        JTextField jTextField = this.mEditField;
        jTextField.setVisible(true);
        float f = 16.0f * this.mMagnification;
        Font font = new Font("Serif", 0, (int)f);
        jTextField.setFont(font);
        Rectangle2D rectangle2D = font.getStringBounds("   ", new FontRenderContext(null, false, false));
        int n3 = this.mFocusedX - this.mEditField.getInsets().left;
        int n4 = this.mFocusedY - (int)(f / 2.0f);
        int n5 = (int)(rectangle2D.getWidth() + (double)f);
        int n6 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n3, n4);
        jTextField.setSize(n5, n6);
        jTextField.setText("");
        jTextField.requestFocus();
        this.repaint();
        return true;
    }

    public boolean addString(int n, int n2, String string) {
        LabelElement labelElement = new LabelElement(string);
        labelElement.setMagnification(this.mMagnification);
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        labelElement.mXAxis = sGAxis;
        labelElement.mYAxis = sGAxis2;
        labelElement.setLocation(n, n2);
        this.addToList(labelElement);
        labelElement.initPropertiesHistory();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        JTextField jTextField;
        Object object;
        LabelElement labelElement;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleChildList();
        for (n = 0; n < arrayList.size(); ++n) {
            labelElement = (LabelElement)arrayList.get(n);
            labelElement.paintElement(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                labelElement = (LabelElement)arrayList.get(n);
                object = labelElement.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (LabelElement)arrayList2.get(i);
                ArrayList arrayList3 = ((LabelElement)object).getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
        if ((jTextField = this.mEditField).isVisible()) {
            graphics2D.setPaint(Color.GRAY);
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.draw(jTextField.getBounds());
            graphics2D.setStroke(new BasicStroke(2.0f));
            jTextField.repaint();
        }
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
                bl = this.synchronizedToAxisElement(sGIFigureElementAxis, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizedToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    public boolean zoom(float f) {
        if (!this.terminateEditField()) {
            return false;
        }
        if (!super.zoom(f)) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            labelElement.zoom(f);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        if (this.mEditField.isVisible() && !this.terminateEditField()) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            LabelElement labelElement = (LabelElement)list.get(i);
            labelElement.requestUpdateLocation();
        }
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Object object;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        ArrayList arrayList = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (LabelElement)arrayList.get(i);
            arrayList2.add(((SGDrawingElementString2DExtended)object).getElementBounds());
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList2);
        object = new ArrayList();
        ((ArrayList)object).add(rectangle2D);
        ((ArrayList)object).add(rectangle2D2);
        Rectangle2D rectangle2D3 = SGUtility.createUnion((ArrayList)object);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiersEx();
        boolean bl2 = (n2 & 0x40) != 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 38: {
                if (bl2) {
                    n4 = -1;
                    break;
                }
                n4 = -10;
                break;
            }
            case 40: {
                if (bl2) {
                    n4 = 1;
                    break;
                }
                n4 = 10;
                break;
            }
            case 37: {
                if (bl2) {
                    n3 = -1;
                    break;
                }
                n3 = -10;
                break;
            }
            case 39: {
                n3 = bl2 ? 1 : 10;
            }
        }
        if (n3 != 0 || n4 != 0) {
            ArrayList arrayList = this.getVisibleChildList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                LabelElement labelElement = (LabelElement)arrayList.get(i);
                if (!labelElement.isSelected()) continue;
                if (!this.setDirectlyBefore(labelElement)) {
                    return false;
                }
                labelElement.translate(n3, n4);
                if (!this.setDirectlyAfter(labelElement)) {
                    return false;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getModifiers();
        int n4 = mouseEvent.getClickCount();
        boolean bl = this.onEdge(n, n2);
        boolean bl2 = (n3 & 2) != 0;
        boolean bl3 = (n3 & 1) != 0;
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            if (bl && labelElement.equals(this.mEditedLabelElement)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n4 == 2) {
                    this.setPropertiesOfSelectedObjects();
                    this.hideEditField();
                }
                return true;
            }
            if (!labelElement.contains(n, n2)) continue;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n4 == 1) {
                    if (labelElement.isSelected() & !bl2 & !bl3) {
                        this.mEditedLabelElement = labelElement;
                        this.mFocusedX = (int)labelElement.getX();
                        this.mFocusedY = (int)labelElement.getY();
                        this.showEditField(labelElement);
                    } else {
                        this.updateFocusedObjectsList((SGISelectable)labelElement, mouseEvent);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n4 == 1) {
                this.updateFocusedObjectsList((SGISelectable)labelElement, mouseEvent);
                labelElement.getPopupMenu().show(this.getComponent(), n, n2);
            }
            return true;
        }
        return false;
    }

    private boolean terminateEditField() {
        return !(this.mEditedLabelElement == null ? !this.addStringElementFromTextField() : !this.commitEdit());
    }

    private boolean commitEdit() {
        String string = this.mEditedLabelElement.getString();
        String string2 = this.mEditField.getText();
        if (SGUtilityText.isValidString(string2)) {
            this.mEditedLabelElement.setString(string2);
            if (!string.equals(string2)) {
                this.mEditedLabelElement.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mEditedLabelElement = null;
        this.hideEditField();
        this.repaint();
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean showEditField(LabelElement labelElement) {
        JTextField jTextField = this.mEditField;
        Rectangle2D rectangle2D = labelElement.getElementBounds();
        Rectangle2D rectangle2D2 = labelElement.getStringRect();
        float f = labelElement.getMagnification() * labelElement.getFontSize();
        int n = (int)(rectangle2D.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D2.getWidth() + (double)f);
        int n4 = (int)(rectangle2D2.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        jTextField.setFont(new Font(labelElement.getFontName(), labelElement.getFontStyle(), (int)f));
        jTextField.setForeground(labelElement.getColor(0));
        jTextField.setText(labelElement.getString());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList arrayList2 = this.getVisibleChildList();
        boolean bl = false;
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            LabelElement labelElement = (LabelElement)arrayList2.get(n);
            if (!labelElement.contains(n2, n3)) continue;
            if (arrayList.contains(labelElement)) {
                this.mPressedPoint = mouseEvent.getPoint();
                labelElement.mTemporaryProperties = labelElement.getProperties();
                this.mDraggableFlag = true;
            }
            bl = true;
            break;
        }
        if (bl) {
            this.setMouseCursor(13);
        } else {
            n = this.onEdge(n2, n3) ? 1 : 0;
            if (this.mEditedLabelElement != null && n != 0) {
                bl = true;
            } else if (this.mEditField.isVisible()) {
                this.terminateEditField();
            }
        }
        return bl;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        this.hideEditField();
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getFocusedObjectsList();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            Rectangle2D rectangle2D = labelElement.getElementBounds();
            bl |= rectangle2D.contains(mouseEvent.getPoint());
        }
        if (bl) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.mTemporaryProperties = labelElement.getProperties();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            SGProperties sGProperties2 = labelElement.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = labelElement.getProperties()).equals(sGProperties2)) continue;
            labelElement.setChanged(true);
        }
        return true;
    }

    public boolean onEdge(int n, int n2) {
        if (!this.mEditField.isVisible()) {
            return false;
        }
        Rectangle rectangle = this.mEditField.getBounds();
        int n3 = rectangle.x - 6;
        int n4 = rectangle.y - 6;
        int n5 = rectangle.width + 12;
        int n6 = rectangle.height + 12;
        Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
        boolean bl = rectangle.contains(n, n2);
        boolean bl2 = rectangle2.contains(n, n2);
        boolean bl3 = !bl & bl2;
        return bl3;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            boolean bl = labelElement.contains(n, n2);
            if (!bl) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        float f;
        Object object;
        JTextField jTextField = this.mEditField;
        String string = jTextField.getText();
        Font font = null;
        if (this.mEditedLabelElement != null) {
            object = this.mEditedLabelElement;
            f = ((SGDrawingElementString)object).getFontSize();
            font = new Font(((SGDrawingElementString)object).getFontName(), ((SGDrawingElementString)object).getFontStyle(), (int)(((SGDrawingElement)object).getMagnification() * f));
        } else {
            f = 16.0f;
            font = new Font("Serif", 0, (int)(this.mMagnification * f));
        }
        object = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = ((RectangularShape)object).getWidth();
        if (d > (double)jTextField.getWidth()) {
            jTextField.setSize((int)(((RectangularShape)object).getWidth() + (double)(this.mMagnification * f)), jTextField.getHeight());
        }
        this.repaint();
    }

    private boolean addStringElementFromTextField() {
        String string = this.mEditField.getText();
        if (SGUtilityText.isValidString(string)) {
            this.addString(this.mFocusedX, this.mFocusedY, string);
        }
        this.hideEditField();
        this.repaint();
        return true;
    }

    public String getTagName() {
        return "Labels";
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            Element element2 = labelElement.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("Label");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            LabelElement labelElement = new LabelElement();
            Element element2 = (Element)node;
            if (!labelElement.readProperty(element2)) {
                return false;
            }
            labelElement.initPropertiesHistory();
            this.addToList(labelElement);
        }
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    private boolean createDialog() {
        SGStringElementDialog sGStringElementDialog;
        this.mDialog = sGStringElementDialog = new SGStringElementDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.translate(n, n2);
            labelElement.setSelected(true);
            this.addToList(labelElement);
            labelElement.initPropertiesHistory();
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof LabelElement)) continue;
            LabelElement labelElement = (LabelElement)e;
            labelElement.translate(n, n2);
            SGProperties sGProperties = labelElement.getProperties();
            LabelElement labelElement2 = new LabelElement();
            labelElement2.setMagnification(f);
            labelElement2.setProperties(sGProperties);
            labelElement2.mXAxis = this.mAxisElement.getAxisInCube(labelElement.mTempXAxis);
            labelElement2.mYAxis = this.mAxisElement.getAxisInCube(labelElement.mTempYAxis);
            this.addToList(labelElement2);
            labelElement2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            StringElementProperties stringElementProperties = (StringElementProperties)list.get(i);
            hashSet.addAll(stringElementProperties.visibleStringElementList);
        }
        return hashSet;
    }

    private LabelElement getLabel(int n) {
        LabelElement labelElement = (LabelElement)this.getChildObject(n);
        if (labelElement == null) {
            return null;
        }
        if (!labelElement.isVisible()) {
            return null;
        }
        return labelElement;
    }

    public boolean setAxisXDirectly(int n, int n2) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setXAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setAxisYDirectly(int n, int n2) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setYAxisLocation(n2)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setTextDirectly(int n, String string) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setString(string)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setLocationXDirectly(int n, double d) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setXValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setLocationYDirectly(int n, double d) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setYValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setFontNameDirectly(int n, String string) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setFontName(string)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setFontStyleDirectly(int n, int n2) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setFontStyle(n2)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setFontSizeDirectly(int n, float f, String string) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setFontSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setFontColorDirectly(int n, Color color) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    public boolean setAngleDirectly(int n, float f) {
        LabelElement labelElement = this.getLabel(n);
        if (labelElement == null) {
            return false;
        }
        if (!this.setDirectlyBefore(labelElement)) {
            return false;
        }
        if (!labelElement.setAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(labelElement);
    }

    private boolean setDirectlyBefore(LabelElement labelElement) {
        return labelElement.prepare();
    }

    private boolean setDirectlyAfter(LabelElement labelElement) {
        if (!labelElement.commit()) {
            return false;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    public SGProperties getProperties() {
        StringElementProperties stringElementProperties = new StringElementProperties();
        stringElementProperties.visibleStringElementList = this.getVisibleChildList();
        return stringElementProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringElementProperties)) {
            return false;
        }
        StringElementProperties stringElementProperties = (StringElementProperties)sGProperties;
        this.setVisibleChildList(stringElementProperties.visibleStringElementList);
        return true;
    }

    public static class StringElementProperties
    extends SGProperties {
        ArrayList visibleStringElementList = new ArrayList();

        public void dispose() {
            this.visibleStringElementList.clear();
            this.visibleStringElementList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringElementProperties)) {
                return false;
            }
            StringElementProperties stringElementProperties = (StringElementProperties)object;
            return stringElementProperties.visibleStringElementList.equals(this.visibleStringElementList);
        }
    }

    public static class LabelProperties
    extends SGDrawingElementString.StringProperties {
        private float mX = 0.0f;
        private float mY = 0.0f;
        private String mText = null;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof LabelProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)object;
            if (this.mX != labelProperties.mX) {
                return false;
            }
            if (this.mY != labelProperties.mY) {
                return false;
            }
            if (!this.mText.equals(labelProperties.mText)) {
                return false;
            }
            if (!labelProperties.mXAxis.equals(this.mXAxis)) {
                return false;
            }
            return labelProperties.mYAxis.equals(this.mYAxis);
        }

        public Float getX() {
            return new Float(this.mX);
        }

        public Float getY() {
            return new Float(this.mY);
        }

        public String getText() {
            return this.mText;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public void setX(float f) {
            this.mX = f;
        }

        public void setY(float f) {
            this.mY = f;
        }

        public void setText(String string) {
            if (string == null) {
                throw new IllegalArgumentException("text==null");
            }
            this.mText = string;
        }

        public void setXAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mXAxis = sGAxis;
        }

        public void setYAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mYAxis = sGAxis;
        }
    }

    private class LabelElement
    extends SGDrawingElementString2DExtended
    implements ActionListener,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable,
    SGILabelDialogObserver,
    SGINode,
    SGIDisposable,
    SGFigureElement.ChildObject {
        private int mID;
        private boolean mSelectedFlag;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private JPopupMenu mPopupMenu;
        private SGProperties mTemporaryProperties;
        private int mTempXAxis;
        private int mTempYAxis;
        private SGUndoManager mUndoManager;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        LabelElement() {
            this.mSelectedFlag = false;
            this.mXAxis = null;
            this.mYAxis = null;
            this.mPopupMenu = new JPopupMenu();
            this.mTemporaryProperties = null;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mUndoManager = new SGUndoManager(this);
            this.init();
        }

        LabelElement(String string) {
            super(string);
            this.mSelectedFlag = false;
            this.mXAxis = null;
            this.mYAxis = null;
            this.mPopupMenu = new JPopupMenu();
            this.mTemporaryProperties = null;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mUndoManager = new SGUndoManager(this);
            this.init();
        }

        private boolean init() {
            this.setFontSize(16.0f, "pt");
            this.setFontName("Serif");
            this.setFontStyle(0);
            this.setAngle(0.0f);
            this.setColor(DEFAULT_LABEL_FONT_COLOR);
            this.createPopupMenu();
            return true;
        }

        public void finalize() {
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            String string = SGFigureElementString.this.mAxisElement.getLocationName(this.mXAxis);
            String string2 = SGFigureElementString.this.mAxisElement.getLocationName(this.mYAxis);
            String string3 = "";
            string3 = string3 + this.mID + ": " + this.getString() + ", ";
            string3 = string3 + string + ", " + string2 + ", ";
            string3 = string3 + "X=" + this.getXValue() + ", Y=" + this.getYValue();
            return string3;
        }

        public Object copy() {
            LabelElement labelElement = new LabelElement();
            labelElement.setMagnification(this.getMagnification());
            labelElement.setProperties(this.getProperties());
            labelElement.setLocation(this.getX(), this.getY());
            labelElement.mTempXAxis = SGFigureElementString.this.mAxisElement.getLocationInCube(this.mXAxis);
            labelElement.mTempYAxis = SGFigureElementString.this.mAxisElement.getLocationInCube(this.mYAxis);
            return labelElement;
        }

        public double getXValue() {
            SGAxis sGAxis = this.mXAxis;
            double d = SGFigureElementString.this.calcValue(this.getX(), sGAxis, true);
            d = SGFigureElementString.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public double getYValue() {
            SGAxis sGAxis = this.mYAxis;
            double d = SGFigureElementString.this.calcValue(this.getY(), sGAxis, false);
            d = SGFigureElementString.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public boolean setXValue(double d) {
            SGAxis sGAxis = this.mXAxis;
            double d2 = SGFigureElementString.this.calcValue(this.getX(), sGAxis, true);
            float f = d == (d2 = SGFigureElementString.this.getNumberInRangeOrder(d2, sGAxis)) ? this.getX() : SGFigureElementString.this.calcLocation(d, sGAxis, true);
            this.setX(f);
            return true;
        }

        public boolean setYValue(double d) {
            SGAxis sGAxis = this.mYAxis;
            double d2 = SGFigureElementString.this.calcValue(this.getY(), sGAxis, false);
            float f = d == (d2 = SGFigureElementString.this.getNumberInRangeOrder(d2, sGAxis)) ? this.getY() : SGFigureElementString.this.calcLocation(d, sGAxis, false);
            this.setY(f);
            return true;
        }

        public boolean hasValidXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public int getXAxisLocation() {
            return SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementString.this.mAxisElement.getLocationInPlane(this.mYAxis);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.mXAxis = this.getAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.mYAxis = this.getAxis(n);
            return true;
        }

        private SGAxis getAxis(int n) {
            return SGFigureElementString.this.mAxisElement.getAxisInPlane(n);
        }

        public boolean setString(String string) {
            if (string == null) {
                return false;
            }
            if (string.length() == 0) {
                return false;
            }
            return super.setString(string);
        }

        public boolean setStringColor(Color color) {
            return this.setColor(color);
        }

        public Color getStringColor() {
            return this.getColor(0);
        }

        public float getFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
        }

        public boolean setAngle(float f) {
            if ((double)f < -180.0) {
                return false;
            }
            if ((double)f > 180.0) {
                return false;
            }
            return super.setAngle(f);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Rectangle2D rectangle2D = this.getElementBounds();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Label --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        public String getTagName() {
            return "Label";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("XAxisPosition", SGFigureElementString.this.mAxisElement.getLocationName(this.mXAxis));
            element.setAttribute("YAxisPosition", SGFigureElementString.this.mAxisElement.getLocationName(this.mYAxis));
            element.setAttribute("XValue", Double.toString(this.getXValue()));
            element.setAttribute("YValue", Double.toString(this.getYValue()));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxis sGAxis;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                sGAxis = SGFigureElementString.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mXAxis = sGAxis;
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                sGAxis = SGFigureElementString.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mYAxis = sGAxis;
            }
            if ((string = element.getAttribute("XValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d2 = d;
                if (!this.mXAxis.isValidValue(d2)) {
                    return false;
                }
                if (!this.setXValue(d2)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("YValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d3 = d;
                if (!this.mYAxis.isValidValue(d3)) {
                    return false;
                }
                if (!this.setYValue(d3)) {
                    return false;
                }
            }
            return true;
        }

        public boolean setX(float f) {
            return super.setX((f - SGFigureElementString.this.mGraphRectX) / this.getMagnification());
        }

        public boolean setY(float f) {
            return super.setY((f - SGFigureElementString.this.mGraphRectY) / this.getMagnification());
        }

        public float getX() {
            return this.getMagnification() * super.getX() + SGFigureElementString.this.mGraphRectX;
        }

        public float getY() {
            return this.getMagnification() * super.getY() + SGFigureElementString.this.mGraphRectY;
        }

        public SGProperties getProperties() {
            LabelProperties labelProperties = new LabelProperties();
            if (!this.getProperties(labelProperties)) {
                return null;
            }
            return labelProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            labelProperties.setX(super.getX());
            labelProperties.setY(super.getY());
            labelProperties.setXAxis(this.mXAxis);
            labelProperties.setYAxis(this.mYAxis);
            labelProperties.setText(this.getString());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            super.setX(labelProperties.getX().floatValue());
            super.setY(labelProperties.getY().floatValue());
            this.mXAxis = labelProperties.getXAxis();
            this.mYAxis = labelProperties.getYAxis();
            this.setString(labelProperties.getText());
            return true;
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementString.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGFigureElementString.this.notifyToListener(string);
            }
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mUndoManager.setChanged(true);
            }
            SGFigureElementString.this.repaint();
            this.mTemporaryProperties = null;
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public boolean preview() {
            SGFigureElementString.this.repaint();
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            SGFigureElementString.this.repaint();
            SGFigureElementString.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGFigureElementString.this.mDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            return this.mUndoManager.setMementoBackward();
        }

        public boolean setMementoForward() {
            return this.mUndoManager.setMementoForward();
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public void notifyToRoot() {
            SGFigureElementString.this.notifyToRoot();
        }
    }
}

