/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.cgm.CGMTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;
import org.freehep.util.io.TaggedOutputStream;
import org.freehep.util.io.UndefinedTagException;

public class CGMOutputStream
extends TaggedOutputStream {
    private static short COMMAND_PARTITION_SIZE = Short.MAX_VALUE;
    private int version;
    private boolean direct = true;
    private int colorIndexPrecision = 8;
    private int directColorPrecision = 8;
    private int indexPrecision = 16;
    private int integerPrecision = 16;
    private boolean fixedPrecision = true;
    private boolean doublePrecision = false;
    private boolean vdcReal = false;
    private boolean vdcFixedPrecision = true;
    private boolean vdcDoublePrecision = false;
    private int vdcIntegerPrecision = 16;
    private int namePrecision = 16;
    private int lineWidthSpecificationMode = 0;
    private int markerSizeSpecificationMode = 0;
    private int edgeWidthSpecificationMode = 0;
    private int interiorStyleSpecificationMode = 0;

    public CGMOutputStream(OutputStream os, int version) throws IOException {
        super(os, (TagSet)new CGMTagSet(version), null, false);
        this.version = version;
    }

    public CGMOutputStream(OutputStream os) throws IOException {
        this(os, 1);
    }

    void setColorMode(boolean direct) {
        this.direct = direct;
    }

    void setColorIndexPrecision(int precision) {
        this.colorIndexPrecision = precision;
    }

    void setDirectColorPrecision(int precision) {
        this.directColorPrecision = precision;
    }

    void setIndexPrecision(int precision) {
        this.indexPrecision = precision;
    }

    void setIntegerPrecision(int precision) {
        this.integerPrecision = precision;
    }

    void setRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.fixedPrecision = fixedPrecision;
        this.doublePrecision = doublePrecision;
    }

    void setVDCReal(boolean real) {
        this.vdcReal = real;
    }

    void setVDCIntegerPrecision(int precision) {
        this.vdcIntegerPrecision = precision;
    }

    void setVDCRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.vdcFixedPrecision = fixedPrecision;
        this.vdcDoublePrecision = doublePrecision;
    }

    void setNamePrecision(int precision) {
        this.namePrecision = precision;
    }

    void setLineWidthSpecificationMode(int mode) {
        this.lineWidthSpecificationMode = mode;
    }

    int getLineWidthSpecificationMode() {
        return this.lineWidthSpecificationMode;
    }

    void setMarkerSizeSpecificationMode(int mode) {
        this.markerSizeSpecificationMode = mode;
    }

    int getMarkerSizeSpecificationMode() {
        return this.markerSizeSpecificationMode;
    }

    void setEdgeWidthSpecificationMode(int mode) {
        this.edgeWidthSpecificationMode = mode;
    }

    int getEdgeWidthSpecificationMode() {
        return this.edgeWidthSpecificationMode;
    }

    void setInteriorStyleSpecificationMode(int mode) {
        this.interiorStyleSpecificationMode = mode;
    }

    int getInteriorStyleSpecificationMode() {
        return this.interiorStyleSpecificationMode;
    }

    public void writeFixedPoint(double d) throws IOException {
        int whole = (int)Math.floor(d);
        int frac = (int)Math.floor((d - (double)whole) * 65536.0);
        this.writeShort(whole);
        this.writeShort(frac);
    }

    public void writeFloatingPoint(double d) throws IOException {
        if (this.doublePrecision) {
            this.writeDouble(d);
        } else {
            this.writeFloat((float)d);
        }
    }

    public void writeColorIndex(int i) throws IOException {
        switch (this.colorIndexPrecision) {
            case 8: {
                this.writeByte(i);
                break;
            }
            case 16: {
                this.writeShort(i);
                break;
            }
            default: {
                this.writeInt(i);
            }
        }
    }

    public void writeColorComponent(int c) throws IOException {
        switch (this.directColorPrecision) {
            default: 
        }
        this.writeUnsignedByte(c);
    }

    public void writeColorDirect(Color c) throws IOException {
        this.writeColorComponent(c.getRed());
        this.writeColorComponent(c.getGreen());
        this.writeColorComponent(c.getBlue());
    }

    public void writeIntegerIndex(int i) throws IOException {
        switch (this.indexPrecision) {
            case 8: {
                this.writeByte(i);
                break;
            }
            default: {
                this.writeShort(i);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(i);
            }
        }
    }

    public void writeEnumerate(int i) throws IOException {
        this.writeShort(i);
    }

    public void writeInteger(int i) throws IOException {
        switch (this.integerPrecision) {
            case 8: {
                this.writeByte(i);
                break;
            }
            default: {
                this.writeShort(i);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(i);
            }
        }
    }

    public void writeReal(double r) throws IOException {
        if (this.fixedPrecision) {
            this.writeFixedPoint(r);
        } else {
            this.writeFloatingPoint(r);
        }
    }

    public void writeString(String s) throws IOException {
        int len = s.length();
        if (len < 255) {
            this.writeUnsignedByte(len);
        } else {
            this.writeUnsignedByte(255);
            this.writeUnsignedShort(len & Short.MAX_VALUE);
        }
        this.writeBytes(s);
    }

    public void writeData(byte[] data) throws IOException {
        this.writeString(new String(data));
    }

    public void writeVDC(double d) throws IOException {
        if (this.vdcReal) {
            if (this.vdcFixedPrecision) {
                this.writeFixedPoint(d);
            } else if (this.vdcDoublePrecision) {
                this.writeDouble(d);
            } else {
                this.writeFloat((float)d);
            }
        } else {
            switch (this.vdcIntegerPrecision) {
                default: {
                    this.writeShort((int)d);
                    break;
                }
                case 24: 
                case 32: {
                    this.writeInt((int)d);
                }
            }
        }
    }

    public void writePoint(Point2D p) throws IOException {
        this.writeVDC(p.getX());
        this.writeVDC(p.getY());
    }

    public void writeColor(Color c) throws IOException {
        if (this.direct) {
            this.writeColorDirect(c);
        } else {
            this.writeColorIndex((c.getRed() << 16) + (c.getGreen() << 8) + c.getBlue());
        }
    }

    public void writeName(int name) throws IOException {
        switch (this.namePrecision) {
            case 8: {
                this.writeByte(name);
                break;
            }
            default: {
                this.writeShort(name);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(name);
            }
        }
    }

    protected void writeTagHeader(TagHeader header) throws IOException {
        this.byteAlign();
        int tagID = header.getTag();
        long length = header.getLength();
        if (length < 31L) {
            this.writeUnsignedShort((tagID << 5) + (int)length);
        } else {
            this.writeUnsignedShort((tagID << 5) + 31);
        }
    }

    public void writeTag(Tag tag) throws IOException {
        int tagID = tag.getTag();
        if (!this.tagSet.exists(tagID)) {
            throw new UndefinedTagException(tagID);
        }
        this.pushBuffer();
        tag.write(tagID, (TaggedOutputStream)this);
        int align = this.getTagAlignment();
        int pad = (align - this.getBufferLength() % align) % align;
        for (int i = 0; i < pad; ++i) {
            this.write(0);
        }
        int len = this.getBufferLength();
        byte[] buffer = this.popBufferBytes();
        TagHeader header = new TagHeader(tagID, (long)len);
        this.writeTagHeader(header);
        if (len <= 30) {
            this.write(buffer, 0, len);
        } else {
            this.writePartitioned(buffer, len);
        }
        if (this.size() % 2 != 0) {
            this.writeUnsignedByte(0);
        }
    }

    private void writePartitioned(byte[] buffer, int len) throws IOException {
        int bufferOffset = 0;
        short partitionSize = COMMAND_PARTITION_SIZE;
        while (len > partitionSize) {
            this.writeUnsignedShort(0x8000 | partitionSize);
            this.write(buffer, bufferOffset, partitionSize);
            bufferOffset += partitionSize;
            len -= partitionSize;
        }
        this.writeUnsignedShort(len);
        this.write(buffer, bufferOffset, len);
    }

    protected void writeActionHeader(ActionHeader header) throws IOException {
    }

    public int getVersion() {
        return this.version;
    }
}

