/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.util.io.IndentPrintWriter;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TaggedOutput;

public class CGMWriter
extends IndentPrintWriter
implements TaggedOutput {
    private int version;
    private boolean direct = true;
    private int colorIndexPrecision = 8;
    private int directColorPrecision = 8;
    private int integerPrecision = 16;
    private boolean fixedPrecision = true;
    private boolean doublePrecision = false;
    private boolean vdcReal = false;
    private boolean vdcFixedPrecision = true;
    private boolean vdcDoublePrecision = false;
    private int vdcIntegerPrecision = 16;
    private int namePrecision = 16;
    private int lineWidthSpecificationMode = 0;
    private int markerSizeSpecificationMode = 0;
    private int edgeWidthSpecificationMode = 0;
    private int interiorStyleSpecificationMode = 0;

    public CGMWriter(Writer writer, int version) throws IOException {
        super(writer);
        this.version = version;
    }

    public CGMWriter(Writer writer) throws IOException {
        this(writer, 1);
    }

    void setColorMode(boolean direct) {
        this.direct = direct;
    }

    void setColorIndexPrecision(int precision) {
        this.colorIndexPrecision = precision;
    }

    void setDirectColorPrecision(int precision) {
        this.directColorPrecision = precision;
    }

    void setIntegerPrecision(int precision) {
        this.integerPrecision = precision;
    }

    void setRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.fixedPrecision = fixedPrecision;
        this.doublePrecision = doublePrecision;
    }

    void setVDCReal(boolean real) {
        this.vdcReal = real;
    }

    void setVDCIntegerPrecision(int precision) {
        this.vdcIntegerPrecision = precision;
    }

    void setVDCRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.vdcFixedPrecision = fixedPrecision;
        this.vdcDoublePrecision = doublePrecision;
    }

    void setNamePrecision(int precision) {
        this.namePrecision = precision;
    }

    void setLineWidthSpecificationMode(int mode) {
        this.lineWidthSpecificationMode = mode;
    }

    int getLineWidthSpecificationMode() {
        return this.lineWidthSpecificationMode;
    }

    void setMarkerSizeSpecificationMode(int mode) {
        this.markerSizeSpecificationMode = mode;
    }

    int getMarkerSizeSpecificationMode() {
        return this.markerSizeSpecificationMode;
    }

    void setEdgeWidthSpecificationMode(int mode) {
        this.edgeWidthSpecificationMode = mode;
    }

    int getEdgeWidthSpecificationMode() {
        return this.edgeWidthSpecificationMode;
    }

    void setInteriorStyleSpecificationMode(int mode) {
        this.interiorStyleSpecificationMode = mode;
    }

    int getInteriorStyleSpecificationMode() {
        return this.interiorStyleSpecificationMode;
    }

    public void writeFixedPoint(double d) throws IOException {
        boolean negative = d < 0.0;
        d = Math.abs(d);
        int whole = (int)Math.floor(d);
        int frac = (int)Math.floor((d - (double)whole) * 10000.0);
        if (negative) {
            this.print("-");
        }
        this.print(whole);
        this.print(".");
        this.print(frac);
    }

    public void writeFloatingPoint(double d) throws IOException {
        if (this.doublePrecision) {
            this.print(d);
        } else {
            this.print((float)d);
        }
    }

    public void writeColorIndex(int i) throws IOException {
        switch (this.colorIndexPrecision) {
            case 8: {
                this.print(Math.max(0, Math.min(255, i)));
                break;
            }
            case 16: {
                this.print(Math.max(0, Math.min(65535, i)));
                break;
            }
            default: {
                this.print(i);
            }
        }
    }

    public void writeColorComponent(int c) throws IOException {
        switch (this.directColorPrecision) {
            default: {
                this.print(Math.max(0, Math.min(255, c)));
                break;
            }
            case 16: {
                this.print(Math.max(0, Math.min(65535, c)));
                break;
            }
            case 24: 
            case 32: {
                this.print(c);
            }
        }
    }

    public void writeColorDirect(Color c) throws IOException {
        this.writeColorComponent(c.getRed());
        this.print(", ");
        this.writeColorComponent(c.getGreen());
        this.print(", ");
        this.writeColorComponent(c.getBlue());
    }

    public void writeInteger(int i) throws IOException {
        switch (this.integerPrecision) {
            case 8: {
                this.print((byte)i);
                break;
            }
            default: {
                this.print((short)i);
                break;
            }
            case 24: 
            case 32: {
                this.print(i);
            }
        }
    }

    public void writeReal(double r) throws IOException {
        if (this.fixedPrecision) {
            this.writeFixedPoint(r);
        } else {
            this.writeFloatingPoint(r);
        }
    }

    public void writeString(String s) throws IOException {
        StringBuffer b = new StringBuffer();
        b.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            b.append(s.charAt(i));
            if (s.charAt(i) != '\"') continue;
            b.append('\"');
        }
        b.append('\"');
        this.print(b.toString());
    }

    public void writeData(byte[] data) throws IOException {
        this.writeString(new String(data));
    }

    public void writeVDC(double d) throws IOException {
        if (this.vdcReal) {
            if (this.vdcFixedPrecision) {
                this.writeFixedPoint(d);
            } else if (this.vdcDoublePrecision) {
                this.print(d);
            } else {
                this.print((float)d);
            }
        } else {
            switch (this.vdcIntegerPrecision) {
                default: {
                    this.print((short)d);
                    break;
                }
                case 24: 
                case 32: {
                    this.print(d);
                }
            }
        }
    }

    public void writePoint(Point2D p) throws IOException {
        this.print("(");
        this.writeVDC(p.getX());
        this.print(", ");
        this.writeVDC(p.getY());
        this.print(")");
    }

    public void writeColor(Color c) throws IOException {
        if (this.direct) {
            this.writeColorDirect(c);
        } else {
            this.writeColorIndex((c.getRed() << 16) + (c.getGreen() << 8) + c.getBlue());
        }
    }

    public void writeName(int name) throws IOException {
        switch (this.namePrecision) {
            case 8: {
                this.print(Math.max(0, Math.min(255, name)));
                break;
            }
            default: {
                this.print(Math.max(0, Math.min(65535, name)));
                break;
            }
            case 24: 
            case 32: {
                this.print(name);
            }
        }
    }

    public void writeTag(Tag tag) throws IOException {
        CGMTag cgm = (CGMTag)tag;
        cgm.write(cgm.getTag(), this);
        this.println(";");
    }

    public int getVersion() {
        return this.version;
    }
}

