/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGUtility
implements SGIConstants {
    public static String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return string2;
    }

    public static Rectangle2D createUnion(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("rectList==null");
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)arrayList.get(i);
            if (rectangle2D2 == null) {
                throw new IllegalArgumentException("rect==null");
            }
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        return rectangle2D;
    }

    public static double getRectStart(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getX();
        }
        return rectangle2D.getY();
    }

    public static double getRectSize(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getHeight();
    }

    public static double getRectEnd(Rectangle2D rectangle2D, boolean bl) {
        return SGUtility.getRectStart(rectangle2D, bl) + SGUtility.getRectSize(rectangle2D, bl);
    }

    public static boolean setRectStart(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectEnd(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectSize(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return true;
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, double d, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), d);
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static double getOverlapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.getOverlap(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static boolean showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
        return true;
    }

    public static boolean showErrorMessageDialog(Component component, String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        SGUtility.showMessageDialog(component, string, string2, 0);
        return true;
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component) {
        return SGUtility.showIllegalInputErrorMessageDialog(component, "The input value is illegal.");
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component, String string) {
        return SGUtility.showErrorMessageDialog(component, string, "Illegal input");
    }

    public static boolean showFileNotFoundMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Failed to open the file denoted by a specified pathname.", "File not found", 0);
        return true;
    }

    public static void setCenter(Window window, Window window2) {
        Dimension dimension = window2.getSize();
        int n = window.getWidth();
        int n2 = window.getHeight();
        int n3 = window2.getX() + (dimension.width - n) / 2;
        int n4 = window2.getY() + (dimension.height - n2) / 2;
        window.setLocation(n3, n4);
    }

    public static boolean copyObjects(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null | arrayList2 == null) {
            throw new IllegalArgumentException("list1==null | list2==null");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGICopiable)) {
                throw new IllegalArgumentException("Not copiable objects are included.");
            }
            SGICopiable sGICopiable = (SGICopiable)e;
            arrayList2.add(sGICopiable.copy());
        }
        return true;
    }

    public static JMenuItem addItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem addCheckBoxItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(actionListener);
        return jCheckBoxMenuItem;
    }

    public static boolean identifyOS(String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix==null");
        }
        return OS_NAME.toLowerCase().startsWith(string);
    }

    public static String getLookAndFeelID() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            return lookAndFeel.getID();
        }
        return null;
    }

    public static String[] copyStringArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static int[] copyIntegerArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static double[] copyDoubleArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static boolean setValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString();
            Double d = SGUtilityText.getDouble(string);
            if (d == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setIntValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString();
            Integer n = SGUtilityText.getInteger(string);
            if (n == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(d);
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static boolean setIntValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString();
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(new Double(n.doubleValue()));
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static int getMouseLocation(Rectangle2D rectangle2D, int n, int n2, float f) {
        boolean bl = Math.abs((double)n - rectangle2D.getMinX()) < (double)f;
        boolean bl2 = Math.abs((double)n - rectangle2D.getCenterX()) < (double)f;
        boolean bl3 = Math.abs((double)n - rectangle2D.getMaxX()) < (double)f;
        boolean bl4 = Math.abs((double)n2 - rectangle2D.getMinY()) < (double)f;
        boolean bl5 = Math.abs((double)n2 - rectangle2D.getCenterY()) < (double)f;
        boolean bl6 = Math.abs((double)n2 - rectangle2D.getMaxY()) < (double)f;
        int n3 = 0;
        if (bl) {
            if (bl4) {
                n3 = 5;
            } else if (bl5) {
                n3 = 3;
            } else if (bl6) {
                n3 = 7;
            }
        } else if (bl3) {
            if (bl4) {
                n3 = 6;
            } else if (bl5) {
                n3 = 4;
            } else if (bl6) {
                n3 = 8;
            }
        } else if (bl2) {
            if (bl4) {
                n3 = 1;
            } else if (bl6) {
                n3 = 2;
            }
        }
        return n3;
    }

    public static void resizeRectangle(Rectangle2D rectangle2D, Point point, MouseEvent mouseEvent, int n) {
        boolean bl = (mouseEvent.getModifiers() & 1) != 0;
        int n2 = mouseEvent.getX() - point.x;
        int n3 = mouseEvent.getY() - point.y;
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float f5 = f3;
        float f6 = f4;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        if (n == 1) {
            point.setLocation(point.getX(), point.getY() + (double)n3);
            f8 = f6 - (float)n3;
            f10 = f2 + f6 - f8;
            f12 = f8;
        } else if (n == 2) {
            point.setLocation(point.getX(), point.getY() + (double)n3);
            f12 = f8 = f6 + (float)n3;
        } else if (n == 3) {
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            f7 = f5 - (float)n2;
            f9 = f + f5 - f7;
            f11 = f7;
        } else if (n == 4) {
            point.setLocation(point.getX() + (double)n2, point.getY());
            f11 = f7 = f5 + (float)n2;
        } else if (n == 5) {
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            f7 = f5 - (float)n2;
            f8 = bl ? f7 * (f6 / f5) : f6 - (float)n3;
            f9 = f + f5 - f7;
            f10 = f2 + f6 - f8;
            f11 = f7;
            f12 = f8;
        } else if (n == 6) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 + (float)n2;
                f8 = f6 - (float)n3;
                f10 = f2 + f6 - f8;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX(), point.getY() + (double)n3);
                f8 = f6 - (float)n3;
                f7 = f8 * (f5 / f6);
                f10 = f2 + f6 - f8;
                f11 = f7;
                f12 = f8;
            }
        } else if (n == 7) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 - (float)n2;
                f8 = f6 + (float)n3;
                f9 = f + f5 - f7;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 - (float)n2;
                f8 = f7 * (f6 / f5);
                f9 = f + f5 - f7;
                f11 = f7;
                f12 = f8;
            }
        } else if (n == 8) {
            if (!bl) {
                point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
                f7 = f5 + (float)n2;
                f8 = f6 + (float)n3;
                f11 = f7;
                f12 = f8;
            } else {
                point.setLocation(point.getX() + (double)n2, point.getY());
                f7 = f5 + (float)n2;
                f8 = f7 * (f6 / f5);
                f11 = f7;
                f12 = f8;
            }
        }
        rectangle2D.setRect(f9, f10, f11, f12);
    }

    public static boolean moveObjectToFront(Object object, ArrayList arrayList) {
        return SGUtility.moveObject(object, arrayList, arrayList.size() - 1);
    }

    public static boolean moveObjectToBack(Object object, ArrayList arrayList) {
        return SGUtility.moveObject(object, arrayList, 0);
    }

    public static boolean moveObject(Object object, List list, int n) {
        if (list == null) {
            throw new IllegalArgumentException("list==null");
        }
        if (n < 0 | n >= list.size()) {
            throw new IllegalArgumentException("index < 0 | index >= list.size()");
        }
        if (!list.contains(object)) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!object.equals(list.get(i))) continue;
            list.remove(i);
            break;
        }
        list.add(n, object);
        return true;
    }

    public static boolean setVisibleList(List list, List list2) {
        int n;
        ArrayList<SGIVisible> arrayList = new ArrayList<SGIVisible>();
        for (n = 0; n < list.size(); ++n) {
            SGIVisible sGIVisible = (SGIVisible)list.get(n);
            boolean bl = list2.contains(sGIVisible);
            sGIVisible.setVisible(bl);
            if (bl) continue;
            arrayList.add(sGIVisible);
        }
        list.clear();
        for (n = 0; n < list2.size(); ++n) {
            list.add(list2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list.add(arrayList.get(n));
        }
        return true;
    }
}

