/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;

public class SGSXYMultipleData
extends SGData
implements SGISXYTypeMultipleData,
Cloneable {
    protected double[] mXValueArray = null;
    protected double[][] mYValueArray = null;

    public SGSXYMultipleData() {
    }

    public SGSXYMultipleData(String[] stringArray, double[] dArray, double[][] dArray2) {
        int n;
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("xArray==null || yArray==null");
        }
        if (dArray2.length == 0) {
            throw new IllegalArgumentException("yArray.length==0");
        }
        int n2 = dArray.length;
        for (n = 0; n < dArray2.length; ++n) {
            if (dArray2[n].length == n2) continue;
            throw new IllegalArgumentException("yArray[ii].length != len");
        }
        this.setTitle(stringArray);
        this.mXValueArray = (double[])dArray.clone();
        this.mYValueArray = new double[dArray2.length][];
        for (n = 0; n < dArray2.length; ++n) {
            this.mYValueArray[n] = (double[])dArray2[n].clone();
        }
    }

    public int getDataNumber() {
        if (this.mYValueArray == null) {
            return -1;
        }
        return this.mYValueArray.length;
    }

    public int getPointsNumber() {
        if (this.mXValueArray == null) {
            return -1;
        }
        return this.mXValueArray.length;
    }

    public String getDataType() {
        return "SXY_MULTIPLE";
    }

    public Double getXValue(int n) {
        double[] dArray = this.getXValueArray();
        if (dArray != null) {
            return new Double(dArray[n]);
        }
        return null;
    }

    public Double getYValue(int n, int n2) {
        double[][] dArray = this.getYValueArray();
        if (dArray != null) {
            return new Double(dArray[n][n2]);
        }
        return null;
    }

    public SGISXYTypeData[] getSXYDataArray() {
        SGISXYTypeData[] sGISXYTypeDataArray = new SGISXYTypeData[this.mYValueArray.length];
        double[] dArray = this.getXValueArray();
        String[] stringArray = this.getTitleArray();
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            sGISXYTypeDataArray[i] = new SGSXYData(stringArray, dArray, this.mYValueArray[i]);
        }
        return sGISXYTypeDataArray;
    }

    public double[] getXValueArray() {
        return SGUtility.copyDoubleArray(this.mXValueArray);
    }

    public double[][] getYValueArray() {
        return this.mYValueArray;
    }

    public double getMinValueX() {
        double d = Double.MAX_VALUE;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.getXValue(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueX() {
        double d = -1.7976931348623157E308;
        int n = this.getPointsNumber();
        for (int i = 0; i < n; ++i) {
            double d2 = this.getXValue(i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinValueY() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.mYValueArray.length; ++i) {
            for (int j = 0; j < this.mYValueArray[i].length; ++j) {
                double d2 = this.mYValueArray[i][j];
                if (!(d2 < d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public double getMaxValueY() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.mYValueArray.length; ++i) {
            for (int j = 0; j < this.mYValueArray[i].length; ++j) {
                double d2 = this.mYValueArray[i][j];
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYMultipleData)) {
            return false;
        }
        SGSXYMultipleData sGSXYMultipleData = (SGSXYMultipleData)sGData;
        this.setTitle(sGSXYMultipleData.getTitleArray());
        this.mXValueArray = sGSXYMultipleData.mXValueArray;
        this.mYValueArray = sGSXYMultipleData.mYValueArray;
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }

    public void dispose() {
        super.dispose();
        this.mXValueArray = null;
        this.mYValueArray = null;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mXValueArray == null || this.mXValueArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this.mXValueArray.length; ++i) {
            String string = "";
            string = string + this.mXValueArray[i];
            for (int j = 0; j < this.mYValueArray.length; ++j) {
                string = string + "," + this.mYValueArray[j][i];
            }
            string = string + "\n";
            writer.write(string);
        }
        return true;
    }
}

