/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGElementGroup
implements SGIElementGroupConstants,
SGIDrawingElementConstants,
SGIVisible,
SGIDisposable {
    protected SGDrawingElement[] mDrawingElementArray = null;
    protected float mMagnification = 1.0f;
    protected ArrayList mColorList = new ArrayList();
    protected boolean mVisibleFlag = true;

    public void dispose() {
        this.mColorList.clear();
        this.mColorList = null;
        if (this.mDrawingElementArray != null) {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                sGDrawingElementArray[i].dispose();
            }
            this.mDrawingElementArray = null;
            sGDrawingElementArray = null;
        }
    }

    public boolean initDrawingElement(int n) {
        SGDrawingElement[] sGDrawingElementArray = new SGDrawingElement[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementArray[i] = this.createDrawingElementInstance();
        }
        this.mDrawingElementArray = sGDrawingElementArray;
        return true;
    }

    protected abstract SGDrawingElement createDrawingElementInstance();

    public SGDrawingElement[] getDrawingElementArray() {
        return this.mDrawingElementArray;
    }

    public boolean setPropertiesOfDrawingElements() {
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f < 0.0) {
            throw new IllegalArgumentException("ratio < 0.0");
        }
        this.mMagnification = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setMagnification(f);
            }
        }
        return true;
    }

    public boolean addColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color==null");
        }
        this.mColorList.add(color);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].addColor(color);
            }
        }
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color==null");
        }
        this.mColorList.clear();
        this.mColorList.add(color);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setColor(color);
            }
        }
        return true;
    }

    public boolean setColorList(List list) {
        if (list == null) {
            throw new IllegalArgumentException("list==null");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("list.size()==0");
        }
        this.mColorList = new ArrayList(list);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setColorList(list);
            }
        }
        return true;
    }

    public Color getColor(int n) {
        if (this.mColorList == null) {
            return null;
        }
        if (n >= this.mColorList.size()) {
            new ArrayIndexOutOfBoundsException("index >= mColorList.size()");
        }
        return (Color)this.mColorList.get(n);
    }

    public ArrayList getColorList() {
        return this.mColorList;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].zoom(f);
            }
        }
        return true;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public boolean contains(int n, int n2) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                if (!this.mDrawingElementArray[i].isVisible() || !this.mDrawingElementArray[i].contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        return this.paintElement(graphics2D, null);
    }

    public abstract boolean paintElement(Graphics2D var1, Rectangle2D var2);

    public abstract SGDrawingElement getDrawingElement();

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        this.setVisible(sGDrawingElement.isVisible());
        this.setColorList(sGDrawingElement.getColorList());
        return true;
    }

    public abstract String getTagName();

    public Element createElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public abstract boolean writeProperty(Element var1);

    public abstract boolean readProperty(Element var1);

    public SGProperties getProperties() {
        ElementGroupProperties elementGroupProperties = new ElementGroupProperties();
        if (!this.getProperties(elementGroupProperties)) {
            return null;
        }
        return elementGroupProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        elementGroupProperties.setVisible(this.isVisible());
        elementGroupProperties.setColor(new ArrayList(this.mColorList));
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        Boolean bl = elementGroupProperties.isVisible();
        if (bl == null) {
            return false;
        }
        ArrayList arrayList = elementGroupProperties.getColorList();
        if (arrayList == null) {
            return false;
        }
        this.setVisible(bl);
        this.setColorList(arrayList);
        return true;
    }

    public static class ElementGroupProperties
    extends SGProperties {
        private boolean mVisible;
        private ArrayList mColorList = new ArrayList();

        public void dispose() {
            this.mColorList.clear();
            this.mColorList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupProperties)) {
                return false;
            }
            ElementGroupProperties elementGroupProperties = (ElementGroupProperties)object;
            if (this.mVisible != elementGroupProperties.mVisible) {
                return false;
            }
            return this.mColorList.equals(elementGroupProperties.mColorList);
        }

        public Boolean isVisible() {
            return this.mVisible;
        }

        public ArrayList getColorList() {
            return new ArrayList(this.mColorList);
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }

        public void setColor(Color color) {
            this.mColorList.clear();
            this.mColorList.add(color);
        }

        public void setColor(ArrayList arrayList) {
            if (arrayList == null) {
                throw new IllegalArgumentException("list==null");
            }
            this.mColorList.clear();
            this.mColorList.addAll(arrayList);
        }
    }
}

