/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementRectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupRectangle
extends SGElementGroupSXY
implements SGIRectangleConstants {
    protected float mRectangleWidth;
    protected float mRectangleHeight;
    protected float mEdgeLineWidth;
    protected Color mEdgeLineColor;

    public void dispose() {
        super.dispose();
        this.mEdgeLineColor = null;
    }

    public float getRectangleWidth() {
        return this.mRectangleWidth;
    }

    public float getRectangleWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getRectangleWidth(), string);
    }

    public float getRectangleHeight() {
        return this.mRectangleHeight;
    }

    public float getRectangleHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getRectangleHeight(), string);
    }

    public float getEdgeLineWidth() {
        return this.mEdgeLineWidth;
    }

    public float getEdgeLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getEdgeLineWidth(), string);
    }

    public Color getEdgeLineColor() {
        return this.mEdgeLineColor;
    }

    public boolean setRectangleWidth(float f) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        this.mRectangleWidth = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setWidth(f);
        }
        return true;
    }

    public boolean setRectangleWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setRectangleWidth((float)d);
    }

    public boolean setRectangleHeight(float f) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        this.mRectangleHeight = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setHeight(f);
        }
        return true;
    }

    public boolean setRectangleHeight(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setRectangleHeight((float)d);
    }

    public boolean setEdgeLineWidth(float f) {
        this.mEdgeLineWidth = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
            }
        }
        return true;
    }

    public boolean setEdgeLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setEdgeLineWidth((float)d);
    }

    public boolean setEdgeLineColor(Color color) {
        this.mEdgeLineColor = color;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
            }
        }
        return true;
    }

    public boolean setEdgeLineColor(String string) {
        Color color = SGUtilityText.getColor(string);
        if (color == null) {
            return false;
        }
        return this.setEdgeLineColor(color);
    }

    public boolean setEdgeLineColor(String string, String string2, String string3) {
        Color color = SGUtilityText.getColor(string, string2, string3);
        if (color == null) {
            return false;
        }
        return this.setEdgeLineColor(color);
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementRectangle sGDrawingElementRectangle = (SGDrawingElementRectangle)this.createDrawingElementInstance();
        sGDrawingElementRectangle.setWidth(this.getRectangleWidth());
        sGDrawingElementRectangle.setHeight(this.getRectangleHeight());
        sGDrawingElementRectangle.setVisible(this.isVisible());
        sGDrawingElementRectangle.setEdgeLineWidth(this.getEdgeLineWidth());
        sGDrawingElementRectangle.setEdgeLineColor(this.getEdgeLineColor());
        sGDrawingElementRectangle.setColorList(this.getColorList());
        return sGDrawingElementRectangle;
    }

    protected SGDrawingElement createDrawingElementInstance() {
        return new SGDrawingElementRectangle2D();
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementRectangle)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
        }
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementRectangle)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementRectangle sGDrawingElementRectangle = (SGDrawingElementRectangle)sGDrawingElement;
        this.setRectangleWidth(sGDrawingElementRectangle.getWidth());
        this.setRectangleHeight(sGDrawingElementRectangle.getHeight());
        this.setEdgeLineWidth(sGDrawingElementRectangle.getEdgeLineWidth());
        this.setEdgeLineColor(sGDrawingElementRectangle.getEdgeLineColor());
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Width", Float.toString(this.mRectangleWidth * 0.035277776f) + "cm");
        element.setAttribute("Height", Float.toString(this.mRectangleHeight * 0.035277776f) + "cm");
        element.setAttribute("EdgeLineWidth", Float.toString(this.mEdgeLineWidth) + "pt");
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        Color color = null;
        List list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            string = element.getAttribute("Width");
            if (string.length() == 0) {
                return false;
            }
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            if (!this.setRectangleWidth(number.floatValue(), ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            if (!this.setColorList(list)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineWidth")).length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            serializable = color;
            if (!this.setEdgeLineColor((Color)serializable)) {
                return false;
            }
        }
        return true;
    }
}

